import type { Transducer } from "./api.js";
export interface WordWrapOpts {
    delim: number;
    always: boolean;
}
/**
 * Returns transducer partitioning words into variable sized arrays
 * based on given `lineLength` (default 80).
 *
 * @remarks
 * The optional `delim` and `always` args can be used to adjust the
 * length and usage of delimiters between each word. If `always` is
 * true, the delimiter length is added to each word, even near line
 * endings. If false (default), the last word on each line can still fit
 * even if there's no space for the delimiter.
 *
 * @param lineLength -
 * @param opts -
 */
export declare function wordWrap(lineLength: number, opts?: Partial<WordWrapOpts>): Transducer<string, string[]>;
export declare function wordWrap(lineLength: number, src: Iterable<string>): IterableIterator<string[]>;
export declare function wordWrap(lineLength: number, opts: Partial<WordWrapOpts>, src: Iterable<string>): IterableIterator<string[]>;
//# sourceMappingURL=word-wrap.d.ts.map