/*
 * Decompiled with CFR 0.152.
 */
package com.macfaq.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public class LittleEndianInputStream
extends FilterInputStream
implements DataInput {
    public LittleEndianInputStream(InputStream in) {
        super(in);
    }

    @Override
    public boolean readBoolean() throws IOException {
        int bool = this.in.read();
        if (bool == -1) {
            throw new EOFException();
        }
        return bool != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int temp = this.in.read();
        if (temp == -1) {
            throw new EOFException();
        }
        return (byte)temp;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int temp = this.in.read();
        if (temp == -1) {
            throw new EOFException();
        }
        return temp;
    }

    @Override
    public String readLine() {
        throw new UnsupportedOperationException("readLine() is currently not supported by LittleEndianInputStream");
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        throw new UnsupportedOperationException("readFully(byte[], int, int) is currently not supported by LittleEndianInputStream");
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        throw new UnsupportedOperationException("readFully(byte[], int, int) is currently not supported by LittleEndianInputStream");
    }

    @Override
    public short readShort() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        if (byte2 == -1) {
            throw new EOFException();
        }
        return (short)((byte2 << 24 >>> 16) + (byte1 << 24) >>> 24);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        if (byte2 == -1) {
            throw new EOFException();
        }
        return (byte2 << 24 >> 16) + (byte1 << 24 >> 24);
    }

    @Override
    public char readChar() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        if (byte2 == -1) {
            throw new EOFException();
        }
        return (char)((byte2 << 24 >>> 16) + (byte1 << 24 >>> 24));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readInt() throws IOException {
        int byte4;
        int byte3;
        int byte2;
        int byte1;
        LittleEndianInputStream littleEndianInputStream = this;
        synchronized (littleEndianInputStream) {
            byte1 = this.in.read();
            byte2 = this.in.read();
            byte3 = this.in.read();
            byte4 = this.in.read();
        }
        if (byte4 == -1) {
            throw new EOFException();
        }
        return (byte4 << 24) + (byte3 << 24 >>> 8) + (byte2 << 24 >>> 16) + (byte1 << 24 >>> 24);
    }

    @Override
    public long readLong() throws IOException {
        long byte1 = this.in.read();
        long byte2 = this.in.read();
        long byte3 = this.in.read();
        long byte4 = this.in.read();
        long byte5 = this.in.read();
        long byte6 = this.in.read();
        long byte7 = this.in.read();
        long byte8 = this.in.read();
        if (byte8 == -1L) {
            throw new EOFException();
        }
        return (byte8 << 56) + (byte7 << 56 >>> 8) + (byte6 << 56 >>> 16) + (byte5 << 56 >>> 24) + (byte4 << 56 >>> 32) + (byte3 << 56 >>> 40) + (byte2 << 56 >>> 48) + (byte1 << 56 >>> 56);
    }

    @Override
    public String readUTF() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        if (byte2 == -1) {
            throw new EOFException();
        }
        int numbytes = (byte1 << 8) + byte2;
        char[] result = new char[numbytes];
        int numread = 0;
        int numchars = 0;
        while (numread < numbytes) {
            int c2;
            int c1 = this.readUnsignedByte();
            int test = c1 >> 4;
            if (test < 8) {
                ++numread;
                result[numchars++] = (char)c1;
                continue;
            }
            if (test == 12 || test == 13) {
                if ((numread += 2) > numbytes) {
                    throw new UTFDataFormatException();
                }
                c2 = this.readUnsignedByte();
                if ((c2 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                result[numchars++] = (char)((c1 & 0x1F) << 6 | c2 & 0x3F);
                continue;
            }
            if (test == 14) {
                if ((numread += 3) > numbytes) {
                    throw new UTFDataFormatException();
                }
                c2 = this.readUnsignedByte();
                int c3 = this.readUnsignedByte();
                if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                result[numchars++] = (char)((c1 & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                continue;
            }
            throw new UTFDataFormatException();
        }
        return new String(result, 0, numchars);
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        for (int i = 0; i < n; i += (int)this.skip(n - i)) {
        }
        return n;
    }
}

