/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Extractor;
import density.Utils;
import density.tools.Stats;
import java.io.IOException;
import java.util.Random;

public class AUC {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: AUC testpoints prediction");
            System.exit(1);
        }
        try {
            new AUC().go(args);
        }
        catch (IOException e) {
            System.out.println("Error in AUC: " + e.toString());
            System.exit(1);
        }
    }

    void go(String[] args) throws IOException {
        String[] stringArray;
        boolean zeroseed = true;
        Utils.generator = new Random(zeroseed ? 0L : System.currentTimeMillis());
        String testpoints = args[0];
        String predfile = args[1];
        if (args.length > 2) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = args[2];
        } else {
            stringArray = null;
        }
        String[] species = stringArray;
        Extractor ext = new Extractor();
        ext.extractSamples(new String[]{predfile}, 10000, testpoints, null, species);
        double[] back = new double[ext.numBackground];
        for (int i = 0; i < back.length; ++i) {
            back[i] = ext.randextract[i].vals[0];
        }
        double[] presence = new double[ext.sampleextract.length];
        for (int i = 0; i < presence.length; ++i) {
            presence[i] = ext.sampleextract[i].vals[0];
        }
        System.out.println(Stats.auc(presence, back));
    }
}

