/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Grid;
import density.GridDimension;
import density.GridSet;
import density.GridWriter;
import density.Layer;
import density.LazyGrid;
import density.Params;
import density.Project;
import density.Utils;
import gnu.getopt.Getopt;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

public class AvgStderr {
    HashMap gridMap = new HashMap();
    double linearPredictorNormalizer;
    double densityNormalizer;
    int numPointsForNormalizer;
    String gridDir;
    GridSet gs = null;
    boolean didClamp;
    boolean wroteLowerci;
    static boolean averagesOnly = false;
    String suffix = "mxe";
    String species = "";
    GridDimension dim;
    double lowercifrac = 0.95;
    Params params;
    Layer[] needLayers;
    boolean hasData;
    double[] vals;
    Grid[] theGrids;

    boolean wroteLowerci() {
        return this.wroteLowerci;
    }

    public AvgStderr(Params params, Layer[] layers) {
        this.params = params;
        this.needLayers = layers;
    }

    public static void main(String[] args) {
        int c;
        String usage = "Usage: density.AvgStderr grid1 grid2 ... outPrefix suffix, or density.AvgStderr -l outdir species n gridDir outPrefix suffix";
        Getopt g = new Getopt("AvgStderr", args, "la");
        boolean lambdas = false;
        block6: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 108: {
                    lambdas = true;
                    continue block6;
                }
                case 97: {
                    averagesOnly = true;
                    continue block6;
                }
            }
            System.out.println(usage);
            System.exit(0);
        }
        int arg0 = g.getOptind();
        int nargs = args.length - arg0;
        if (nargs < 4 || lambdas && nargs < 6) {
            System.out.println(usage);
            System.exit(0);
        }
        try {
            if (lambdas) {
                new AvgStderr(new Params(), null).process(args[arg0], args[arg0 + 1], Integer.parseInt(args[arg0 + 2]), args[arg0 + 3], args[arg0 + 4], args[arg0 + 5]);
            } else {
                int num = nargs - 2;
                String[] gridFiles = new String[num];
                String outPrefix = args[arg0 + num];
                Object suffix = args[arg0 + num + 1];
                if (!((String)suffix).startsWith(".")) {
                    suffix = "." + (String)suffix;
                }
                AvgStderr avgstderr = new AvgStderr(new Params(), null);
                avgstderr.suffix = suffix;
                for (int i = 0; i < num; ++i) {
                    gridFiles[i] = args[arg0 + i];
                }
                avgstderr.go(gridFiles, outPrefix);
            }
        }
        catch (IOException e) {
            System.out.println("Error: " + e.toString());
            System.exit(1);
        }
    }

    void process(String outdir, String species, int n, String gridDir, String outPrefix, String suffix) throws IOException {
        if (!((String)suffix).startsWith(".")) {
            suffix = "." + (String)suffix;
        }
        this.suffix = suffix;
        this.species = species;
        Grid[] grids = new Grid[n];
        Project[] projects = new Project[n];
        for (int i = 0; i < n; ++i) {
            String lambdafile = new File(outdir, species + "_" + i + ".lambdas").getPath();
            projects[i] = new Project(this.params);
            projects[i].needLayers = this.needLayers;
            projects[i].gridMap = projects[0].gridMap;
            grids[i] = projects[i].projectGrid(lambdafile, gridDir)[0];
        }
        this.process(grids, outPrefix, outdir);
        projects[0].close();
    }

    public void go(String[] gridFiles, String outPrefix) throws IOException {
        int numg = gridFiles.length;
        Grid[] grids = new LazyGrid[numg];
        for (int i = 0; i < numg; ++i) {
            grids[i] = new LazyGrid(gridFiles[i]);
        }
        this.process(grids, outPrefix, ".");
    }

    void makevals(int r, int c) {
        this.hasData = true;
        for (int i = 0; i < this.vals.length; ++i) {
            if (!this.theGrids[i].hasData(r, c)) {
                this.hasData = false;
                break;
            }
            this.vals[i] = this.theGrids[i].eval(r, c);
        }
    }

    void process(Grid[] grids, String outPrefix, String outDir) throws IOException {
        Utils.reportDoing("Creating average grid, stddev grid etc.");
        int numg = grids.length;
        this.dim = grids[0].getDimension();
        int nr = this.dim.getnrows();
        int nc = this.dim.getncols();
        this.vals = new double[numg];
        outPrefix = new File(outDir, outPrefix).getPath();
        this.theGrids = grids;
        Grid avg = new Grid(this.dim, this.species + " avg"){

            @Override
            public boolean hasData(int r, int c) {
                AvgStderr.this.makevals(r, c);
                return AvgStderr.this.hasData;
            }

            @Override
            public float eval(int r, int c) {
                return (float)AvgStderr.mean(AvgStderr.this.vals);
            }
        };
        Mygrid stddev = new Mygrid(this.dim, this.species + " stddev"){

            @Override
            public double eval() {
                return AvgStderr.stddev(AvgStderr.this.vals);
            }
        };
        Mygrid min = new Mygrid(this.dim, this.species + " min"){

            @Override
            public double eval() {
                return AvgStderr.min(AvgStderr.this.vals);
            }
        };
        Mygrid max = new Mygrid(this.dim, this.species + " max"){

            @Override
            public double eval() {
                return AvgStderr.max(AvgStderr.this.vals);
            }
        };
        Mygrid median = new Mygrid(this.dim, this.species + " median"){

            @Override
            public double eval() {
                return AvgStderr.median(AvgStderr.this.vals);
            }
        };
        Mygrid lowerci = new Mygrid(this.dim, this.species + " lowerci"){

            @Override
            public double eval() {
                return AvgStderr.this.lowerci(AvgStderr.this.vals);
            }
        };
        Grid[] outgrids = new Grid[]{avg, stddev, min, max, median, lowerci};
        if (averagesOnly) {
            outgrids = new Grid[]{avg};
        }
        this.wroteLowerci = true;
        if ((double)numg < 1.0 / (1.0 - this.lowercifrac)) {
            outgrids = new Grid[]{avg, stddev, min, max, median};
            this.wroteLowerci = false;
        }
        String[] names = new String[]{"avg", "stddev", "min", "max", "median", "lowerci"};
        String[] filenames = new String[outgrids.length];
        for (int i = 0; i < filenames.length; ++i) {
            filenames[i] = outPrefix + "_" + names[i] + this.suffix;
        }
        GridWriter.writeGrids(outgrids, filenames, false);
    }

    public static double mean(double[] x) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += x[i];
        }
        return sum / (double)x.length;
    }

    public static double min(double[] x) {
        double min = x[0];
        for (int i = 1; i < x.length; ++i) {
            if (!(x[i] < min)) continue;
            min = x[i];
        }
        return min;
    }

    public static double max(double[] x) {
        double max = x[0];
        for (int i = 1; i < x.length; ++i) {
            if (!(x[i] > max)) continue;
            max = x[i];
        }
        return max;
    }

    public static double median(double[] x) {
        Arrays.sort(x);
        return x[x.length / 2];
    }

    double lowerci(double[] x) {
        Arrays.sort(x);
        return x[(int)((double)x.length * (1.0 - this.lowercifrac))];
    }

    public static double variance(double[] x) {
        double sum = 0.0;
        double mean = AvgStderr.mean(x);
        for (int i = 0; i < x.length; ++i) {
            sum += x[i] * x[i];
        }
        double var = sum / (double)x.length - mean * mean;
        return var < 0.0 ? 0.0 : var;
    }

    public static double stddev(double[] x) {
        return Math.sqrt(AvgStderr.variance(x));
    }

    public static double stderr(double[] x) {
        double vv = AvgStderr.variance(x) * (double)(x.length / (x.length - 1));
        return Math.sqrt(vv);
    }

    abstract class Mygrid
    extends Grid {
        public Mygrid(GridDimension dim, String name) {
            super(dim, name);
        }

        public abstract double eval();

        @Override
        public boolean hasData(int r, int c) {
            return AvgStderr.this.hasData;
        }

        @Override
        public float eval(int r, int c) {
            return (float)this.eval();
        }
    }
}

