/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Feature;
import density.Sample;

public class ClampedFeature
extends Feature {
    double min;
    double max;
    Feature f;

    public ClampedFeature(Feature f) {
        this(f, 0.0, 1.0);
    }

    public ClampedFeature(Feature f, double min, double max) {
        super(f.n, f.name);
        this.f = f;
        this.min = min;
        this.max = max;
    }

    @Override
    public double eval(int p) {
        double val = this.f.eval(p);
        if (val < this.min) {
            return this.min;
        }
        if (val > this.max) {
            return this.max;
        }
        return val;
    }

    @Override
    public double eval(Sample s) {
        double val = this.f.eval(s);
        if (val < this.min) {
            return this.min;
        }
        if (val > this.max) {
            return this.max;
        }
        return val;
    }

    @Override
    public boolean hasData(Sample s) {
        return this.f.hasData(s);
    }
}

