/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Grid;
import density.GridByte;
import density.GridDimension;
import density.GridIO;
import density.GridInt;
import density.GridShort;
import density.GridUbyte;
import density.GridWriter;
import density.LazyGrid;
import density.Utils;
import gnu.getopt.Getopt;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Locale;

public class Convert {
    static boolean savemem = true;

    public static void main(String[] args) {
        int c;
        double retainFraction = 0.6;
        String usage = "Usage: density.Convert [-t] indir insuffix outdir outsuffix";
        Getopt g = new Getopt("Show", args, "t");
        while ((c = g.getopt()) != -1) {
            switch (c) {
                case 116: {
                    savemem = !savemem;
                }
            }
        }
        if (args.length - g.getOptind() != 4) {
            System.out.println(usage);
            System.exit(0);
        }
        String indir = args[g.getOptind()];
        final String insuff = args[g.getOptind() + 1];
        String outdir = args[g.getOptind() + 2];
        String outsuff = args[g.getOptind() + 3];
        File[] layerFiles = new File(indir).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File indir, String name) {
                return name.endsWith(insuff);
            }
        });
        try {
            if (outsuff.toLowerCase().equals("csv")) {
                Convert.toCsv(layerFiles, outdir, new File(indir).getName());
                return;
            }
            for (int i = 0; i < layerFiles.length; ++i) {
                System.out.println(layerFiles[i]);
                String inFile = layerFiles[i].getPath();
                File outFile = new File(outdir, layerFiles[i].getName().substring(0, layerFiles[i].getName().length() - insuff.length()) + outsuff);
                Grid grid = savemem ? Convert.readEfficient(inFile) : GridIO.readGrid(inFile);
                System.out.println("Data type: " + grid.getTypeName());
                new GridWriter(grid, outFile).writeAll();
            }
        }
        catch (IOException e) {
            Utils.fatalException("Error reading/writing files", e);
        }
    }

    static void toCsv(File[] grids, String outdir, String prefix) throws IOException {
        int ng = grids.length;
        LazyGrid[] g = new LazyGrid[ng];
        PrintWriter out = Utils.writer(new File(outdir, prefix + ".csv"));
        out.print("row,column");
        for (int i = 0; i < ng; ++i) {
            g[i] = new LazyGrid(grids[i].getPath());
            if (i > 0 && !g[i].getDimension().equals(g[0].getDimension())) {
                throw new RuntimeException("Files " + grids[0].getName() + " and " + grids[i].getName() + " have different geographic dimensions");
            }
            out.print("," + g[i].getName());
        }
        out.println();
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setGroupingUsed(false);
        GridDimension dim = g[0].getDimension();
        int nrows = dim.getnrows();
        int ncols = dim.getncols();
        for (int r = 0; r < nrows; ++r) {
            for (int c = 0; c < ncols; ++c) {
                int i;
                boolean hasdata = true;
                for (i = 0; i < ng; ++i) {
                    if (g[i].hasData(r, c)) continue;
                    hasdata = false;
                    break;
                }
                if (!hasdata) continue;
                out.print(r + "," + c);
                for (i = 0; i < ng; ++i) {
                    out.print("," + nf.format(g[i].eval(r, c)));
                }
                out.println();
            }
        }
        out.close();
    }

    public static Grid readEfficient(String inFile) throws IOException {
        final LazyGrid g = new LazyGrid(inFile);
        GridDimension dim = g.getDimension();
        String name = g.getName();
        boolean isfloat = false;
        boolean started = false;
        int min = 0;
        int max = 0;
        Utils.reportDoing("Determining type of file " + new File(inFile).getName());
        block0: for (int r = 0; r < dim.getnrows() && !isfloat; ++r) {
            if (Utils.interrupt) {
                return null;
            }
            Utils.reportProgress(r * 100 / dim.getnrows());
            for (int c = 0; c < dim.getncols(); ++c) {
                if (!g.hasData(r, c)) continue;
                float v = g.eval(r, c);
                if (v != (float)((int)v)) {
                    isfloat = true;
                    continue block0;
                }
                if (!started || (float)min > v) {
                    min = (int)v;
                }
                if (!started || (float)max < v) {
                    max = (int)v;
                }
                started = true;
            }
        }
        g.initialize();
        if (isfloat) {
            return g;
        }
        if (min > -128 && max < 128) {
            return new GridByte(dim, name){
                {
                    super(dim, s);
                    this.NODATA_value = -128.0;
                }

                @Override
                public byte evalByte(int r, int c) {
                    return (byte)g.eval(r, c);
                }

                @Override
                public boolean hasData(int r, int c) {
                    return g.hasData(r, c);
                }
            };
        }
        if (min >= 0 && max < 255) {
            return new GridUbyte(dim, name){
                {
                    super(dim, s);
                    this.NODATA_value = 255.0;
                }

                @Override
                public short evalUbyte(int r, int c) {
                    return (short)g.eval(r, c);
                }

                @Override
                public boolean hasData(int r, int c) {
                    return g.hasData(r, c);
                }
            };
        }
        if (min >= Short.MIN_VALUE && max < Short.MAX_VALUE) {
            return new GridShort(dim, name){
                {
                    super(dim, s);
                    this.NODATA_value = g.NODATA_value == (double)((short)g.NODATA_value) ? (double)((short)g.NODATA_value) : 32767.0;
                }

                @Override
                public short evalShort(int r, int c) {
                    return (short)g.eval(r, c);
                }

                @Override
                public boolean hasData(int r, int c) {
                    return g.hasData(r, c);
                }
            };
        }
        return new GridInt(dim, name){
            {
                super(dim, s);
                this.NODATA_value = g.NODATA_value == (double)((int)g.NODATA_value) ? (double)((int)g.NODATA_value) : 2.147483647E9;
            }

            @Override
            public int evalInt(int r, int c) {
                return (int)g.eval(r, c);
            }

            @Override
            public boolean hasData(int r, int c) {
                return g.hasData(r, c);
            }
        };
    }
}

