/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;

public class Csv {
    String[] headers;
    HashMap headerMap = new HashMap();
    static String fileName = "D:\\maxent\\samples\\bradypus_spatial.csv";
    String[] currentRecord;
    BufferedReader in;
    String separator = ",";
    static boolean allowQuote = true;
    boolean frenchMode = false;
    String lastLine = null;
    int lineNum = 0;
    boolean initialized = false;
    HashMap<String, String> indexmap;
    String mapsep = "__||__";

    void checkEuropean(String line) {
        if (line != null && line.indexOf(this.separator) == -1 && line.indexOf(";") != -1) {
            this.frenchMode = true;
            this.separator = ";";
            Utils.warn("Detected \";\" as separator in " + fileName);
        }
    }

    String[] getTokens(BufferedReader in, String where) throws IOException {
        ArrayList records = new ArrayList();
        Object token = "";
        boolean inQuote = false;
        ArrayList<String> tokens = new ArrayList<String>();
        char quote = '\"';
        char sepchar = this.separator.charAt(0);
        while (true) {
            String s = this.lastLine = in.readLine();
            if (!this.initialized) {
                this.checkEuropean(s);
                this.initialized = true;
            }
            ++this.lineNum;
            if (s == null && tokens.size() == 0) {
                return null;
            }
            if (s == null) {
                throw new IOException("End of file reached while parsing " + where);
            }
            for (int i = 0; i < s.length(); ++i) {
                char tok = s.charAt(i);
                if (tok == quote && allowQuote) {
                    inQuote = !inQuote;
                    continue;
                }
                if (tok == sepchar && !inQuote) {
                    tokens.add(((String)token).trim());
                    token = "";
                    continue;
                }
                token = (String)token + tok;
            }
            if (!inQuote) break;
            token = (String)token + System.getProperty("line.separator");
        }
        tokens.add(((String)token).trim());
        if (tokens.size() == 0 || tokens.size() == 1 && tokens.get(0).equals("")) {
            return null;
        }
        return tokens.toArray(new String[0]);
    }

    public void close() throws IOException {
        this.in.close();
    }

    public Csv(String fileName) throws IOException {
        this(fileName, true);
    }

    public Csv(String fileName, boolean firstLineFieldNames) throws IOException {
        Csv.fileName = fileName;
        if (!(fileName.endsWith(".csv") || fileName.endsWith(".CSV") || new File(fileName).exists())) {
            Csv.fileName = fileName + ".csv";
        }
        this.initialize(new FileReader(Csv.fileName), firstLineFieldNames);
    }

    public Csv(InputStream inputstream) throws IOException {
        this.initialize(new InputStreamReader(inputstream), true);
    }

    void initialize(InputStreamReader reader, boolean firstLineFieldNames) throws IOException {
        this.initialized = false;
        this.in = new BufferedReader(reader);
        if (firstLineFieldNames) {
            this.processHeader(this.getTokens(this.in, fileName));
        }
    }

    void processHeader(String[] headers) {
        if (headers == null) {
            headers = new String[]{};
        }
        this.headers = headers;
        for (int i = 0; i < headers.length; ++i) {
            headers[i] = headers[i];
            this.headerMap.put(headers[i], new Integer(i));
        }
    }

    public String[] getRecord() throws IOException {
        while (true) {
            this.currentRecord = this.getTokens(this.in, fileName);
            if (this.frenchMode && this.currentRecord != null) {
                for (int i = 0; i < this.currentRecord.length; ++i) {
                    this.currentRecord[i] = this.currentRecord[i].replaceAll(",", ".");
                }
            }
            if (this.currentRecord == null || this.currentRecord.length == this.headers.length) {
                return this.currentRecord;
            }
            Utils.warn2((this.currentRecord.length > this.headers.length ? "Extra" : "Missing") + " fields in " + fileName + " line " + this.lineNum + ": skipping... ", "csvmissingfields");
        }
    }

    public String[] getCurrentRecord() {
        return this.currentRecord;
    }

    boolean hasField(String s) {
        return this.headerMap.containsKey(s);
    }

    int fieldIndex(String s) {
        Integer i = (Integer)this.headerMap.get(s);
        if (i == null) {
            System.err.println("Field " + s + " not found in " + fileName);
        }
        return i == null ? -1 : i;
    }

    public String get(int i) {
        return this.currentRecord[i];
    }

    public String get(String field) {
        int i = this.fieldIndex(field);
        return i == -1 ? null : this.currentRecord[i];
    }

    double[] getDoubles(int start) {
        double[] vals = new double[this.headers.length - start];
        for (int i = start; i < this.headers.length; ++i) {
            vals[i - start] = Double.parseDouble(this.currentRecord[i]);
        }
        return vals;
    }

    String[] getAll(int start) {
        return this.getAll(this.currentRecord, start);
    }

    String[] getAll(String[] s, int start) {
        if (start >= this.headers.length) {
            return new String[0];
        }
        String[] vals = new String[this.headers.length - start];
        for (int i = start; i < this.headers.length; ++i) {
            vals[i - start] = s[i];
        }
        return vals;
    }

    public String[] headers() {
        return this.headers;
    }

    public String headerString() {
        return Csv.toCsvFormat(this.headers);
    }

    public static String toCsvFormat(String[] s) {
        if (s.length == 0) {
            return "";
        }
        Object result = s[0];
        for (int i = 1; i < s.length; ++i) {
            boolean quote = s[i].indexOf(44) != -1 && !s[i].startsWith("\"") && !s[i].endsWith("\"");
            result = (String)result + "," + (quote ? "\"" : "") + s[i] + (quote ? "\"" : "");
        }
        return result;
    }

    public void apply(Applier applier) throws IOException {
        while (this.getRecord() != null) {
            applier.process();
        }
        this.close();
    }

    public void indexAll() throws IOException {
        this.indexAll(this.headers[0]);
    }

    public void indexAll(final String indexVar) throws IOException {
        this.indexmap = new HashMap();
        this.apply(new Applier(){

            @Override
            public void process() {
                for (String f : Csv.this.headers) {
                    Csv.this.indexmap.put(this.get(indexVar) + Csv.this.mapsep + f, this.get(f));
                }
            }
        });
    }

    public String getVal(String key, String var) {
        return this.indexmap.get(key + this.mapsep + var);
    }

    public double getDoubleVal(String key, String var) {
        return Double.parseDouble(this.getVal(key, var));
    }

    public static void getCol(String filename, String field, final ArrayList a) throws IOException {
        Csv csv = new Csv(filename);
        final int index = csv.fieldIndex(field);
        if (index == -1) {
            return;
        }
        Csv csv2 = csv;
        Objects.requireNonNull(csv2);
        csv.apply(new Applier(csv2){

            @Override
            public void process() {
                a.add(this.get(index));
            }
        });
    }

    public static String[] getCol(String filename, String field) throws IOException {
        ArrayList a = new ArrayList();
        Csv.getCol(filename, field, a);
        return a.toArray(new String[0]);
    }

    public static double[] getDoubleCol(String filename, String field) throws IOException {
        ArrayList a = new ArrayList();
        Csv.getCol(filename, field, a);
        return Csv.aToDoubles(a);
    }

    static double[] aToDoubles(ArrayList a) {
        double[] result = new double[a.size()];
        for (int i = 0; i < a.size(); ++i) {
            result[i] = Double.parseDouble((String)a.get(i));
        }
        return result;
    }

    public double[][] getDoubleAllCols() throws IOException {
        return this.getDoubleAllCols(0);
    }

    public double[][] getDoubleAllCols(final int start) throws IOException {
        final int nh = this.headers.length;
        final ArrayList[] a = new ArrayList[nh - start];
        for (int i = start; i < nh; ++i) {
            a[i - start] = new ArrayList();
        }
        this.apply(new Applier(this){

            @Override
            public void process() {
                for (int i = start; i < nh; ++i) {
                    double v = -1.0;
                    try {
                        v = Double.parseDouble(this.get(i));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    a[i - start].add(v);
                }
            }
        });
        double[][] result = new double[a[0].size()][nh - start];
        for (int i = 0; i < result.length; ++i) {
            for (int j = start; j < nh; ++j) {
                result[i][j - start] = (Double)a[j - start].get(i);
            }
        }
        return result;
    }

    public abstract class Applier {
        public String get(String field) {
            return Csv.this.get(field);
        }

        public String get(int i) {
            return Csv.this.get(i);
        }

        public double getDouble(int i) {
            return Double.parseDouble(Csv.this.get(i));
        }

        public abstract void process();
    }
}

