/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Csv;
import density.Extractor;
import density.GUI;
import density.Grid;
import density.GridDimension;
import density.GridIO;
import density.GridZoom;
import density.Params;
import density.Project;
import density.Utils;
import gnu.getopt.Getopt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class Explain
extends JFrame
implements ActionListener {
    GridZoom zoom;
    Grid[] predictors = new Grid[0];
    Grid pred;
    Grid projgrid;
    Grid proj2grid;
    String predfile;
    String responsedir;
    String species;
    double[] mean;
    double[] contribs;
    float[][] minmax;
    boolean[] isCategorical;
    boolean cloglog;
    HashMap map;
    int nvars = 0;
    NumberFormat nf;
    JLabel pointval;
    Project proj;
    Project proj2;
    Csv meancsv;
    JDialog helpFrame = null;
    private static final String HELP = "help";
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final String UP = "up";
    private static final String DOWN = "down";
    private static final String IN = "in";
    private static final String OUT = "out";
    private static final String CENTER = "center";
    private static final String MODEL = "model";

    public Explain(String[] args) throws IOException {
        int gg;
        String usage = "Usage: density.Explain [-c] [-l lambdafile] predictionFile predictorsDirectory";
        Getopt g = new Getopt("Show", args, "cl:");
        Object lambdafile = null;
        block6: while ((gg = g.getopt()) != -1) {
            switch (gg) {
                case 108: {
                    lambdafile = g.getOptarg();
                    continue block6;
                }
                case 99: {
                    this.cloglog = true;
                    continue block6;
                }
            }
            System.out.println(usage);
            System.exit(0);
        }
        if (args.length - g.getOptind() < 2) {
            System.out.println(usage);
            System.exit(0);
        }
        this.predfile = args[g.getOptind()];
        String griddir = args[g.getOptind() + 1];
        Utils.topLevelFrame = this;
        this.nf = NumberFormat.getNumberInstance(Locale.US);
        this.nf.setGroupingUsed(false);
        try {
            this.pred = GridIO.readGrid(this.predfile);
            String root = this.predfile.substring(0, this.predfile.length() - 4);
            if (lambdafile == null) {
                lambdafile = root + ".lambdas";
            } else {
                root = ((String)lambdafile).replaceAll(".lambdas$", "");
            }
            this.meancsv = new Csv(root + "_sampleAverages.csv");
            this.meancsv.indexAll();
            if (args.length > 1) {
                System.out.println("Loading " + (String)lambdafile);
                this.map = new HashMap();
                Params params = new Params();
                if (this.cloglog) {
                    params.setOutputformat("Cloglog");
                }
                this.proj = new Project(params);
                this.proj.mapping = true;
                this.proj.varmap = this.map;
                this.projgrid = this.proj.projectGrid((String)lambdafile, null)[0];
                String[] files = Utils.gridFileNames(griddir, this.proj.gridNames());
                this.nvars = files.length;
                this.predictors = new Grid[this.nvars];
                this.minmax = new float[this.nvars][];
                for (int i = 0; i < this.nvars; ++i) {
                    String f = Extractor.CachedGridFilename(files[i], false);
                    System.out.println("Loading " + f);
                    this.predictors[i] = GridIO.readGrid(f);
                    this.minmax[i] = this.predictors[i].minmax();
                }
                this.initIsCategorical();
                this.proj2 = new Project(params);
                this.proj2.mapping = true;
                this.proj2.varmap = this.map;
                this.proj2grid = this.proj2.projectGrid((String)lambdafile, null)[0];
                for (Project.Pfeature pf : this.proj.allFeatures) {
                    if (!(pf instanceof Project.ScaledGrid) || !(((Project.ScaledGrid)pf).g0 instanceof Project.ProductGrid)) continue;
                    Utils.warn2("Model in " + (String)lambdafile + " is not additive.  This tool requires a model made without product features", "notadditive");
                }
                this.responsedir = new File(new File(root).getParent(), "plots").getPath();
                this.species = new File(root).getName();
                this.setTitle("Explain predictions for " + this.species);
            }
        }
        catch (IOException e) {
            System.out.println(e.toString());
            System.exit(1);
        }
        this.zoom = new GridZoom(this.pred){

            @Override
            public void mouseClicked(int r, int c) {
            }

            @Override
            public void mousePointAt(int r, int c) {
                GridDimension dim = Explain.this.zoom.grid.getDimension();
                Explain.this.nf.setMaximumFractionDigits(8);
                Explain.this.pointval.setText("(" + Explain.this.nf.format(dim.toX(c)) + ", " + Explain.this.nf.format(dim.toY(r)) + "): " + (Explain.this.zoom.grid.hasData(r, c) ? Explain.this.nf.format(Explain.this.zoom.grid.eval(r, c)) : "<no data>"));
            }
        };
        JToolBar toolBar = this.makeToolBar();
        JPanel displayPane = new JPanel();
        displayPane.setPreferredSize(new Dimension(800, 800));
        displayPane.setLayout(new BorderLayout());
        displayPane.add((Component)toolBar, "First");
        displayPane.add((Component)this.zoom, "Center");
        this.pointval = new JLabel(" ");
        displayPane.add((Component)this.pointval, "Last");
        Container contentPane = this.getContentPane();
        contentPane.add((Component)displayPane, "Center");
        this.pack();
        this.addWindowListener(new WindowAdapter(this){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.setVisible(true);
    }

    void initIsCategorical() {
        this.isCategorical = new boolean[this.nvars];
        for (int j = 0; j < this.nvars; ++j) {
            this.isCategorical[j] = "true".equals(this.meancsv.getVal(this.predictors[j].getName(), "Categorical"));
        }
    }

    void initProjGrid() {
        for (int j = 0; j < this.nvars; ++j) {
            String var = this.predictors[j].getName();
            this.map.put(var, this.meancsv.getDoubleVal(var, "Sample average"));
        }
    }

    double contribution(int i, double v) {
        this.initProjGrid();
        String varname = this.predictors[i].getName();
        this.proj.exponent = true;
        double before = this.projgrid.eval(0, 0);
        this.map.put(varname, v);
        double after = this.projgrid.eval(0, 0);
        double offset = (before - Math.log(this.proj.densityNormalizer) + this.proj.entropy) / (double)this.nvars;
        return after - before + offset;
    }

    double[] categories(int i) {
        Grid g = this.predictors[i];
        final HashSet set = new HashSet();
        Grid grid = g;
        Objects.requireNonNull(grid);
        g.apply(new Grid.Applier(this, grid){

            @Override
            public void process(int r, int c, float v) {
                set.add(Double.valueOf(v));
            }
        });
        double[] result = new double[set.size()];
        int cnt = 0;
        for (Double d : set) {
            result[cnt++] = d;
        }
        return result;
    }

    JToolBar makeToolBar() {
        JToolBar toolBar = new JToolBar("Navigation buttons");
        this.addButton(toolBar, "Help", HELP, "Help", "Help");
        this.addButton(toolBar, "Back24", LEFT, "Shift left", "<");
        this.addButton(toolBar, "Up24", UP, "Shift up", "^");
        this.addButton(toolBar, "Down24", DOWN, "Shift down", "v");
        this.addButton(toolBar, "Forward24", RIGHT, "Shift right", ">");
        this.addButton(toolBar, "Plus", IN, "Zoom in", "+");
        this.addButton(toolBar, "Minus", OUT, "Zoom out", "-");
        this.addButton(toolBar, "Dot", CENTER, "Recenter", "@");
        if (this.nvars > 0) {
            String[] varnames = new String[this.nvars + 1];
            varnames[0] = "Model for " + this.species;
            for (int i = 0; i < this.nvars; ++i) {
                varnames[i + 1] = this.predictors[i].getName();
            }
            final JComboBox<String> showList = new JComboBox<String>(varnames);
            showList.setMaximumRowCount(25);
            showList.setSelectedIndex(0);
            showList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int sel = showList.getSelectedIndex();
                    if (sel == 0) {
                        Explain.this.zoom.setGrid(Explain.this.pred);
                    } else {
                        Explain.this.zoom.setGrid(Explain.this.predictors[sel - 1]);
                    }
                    Explain.this.zoom.makeImage();
                }
            });
            toolBar.addSeparator();
            toolBar.add(showList);
        }
        return toolBar;
    }

    protected void addButton(JToolBar toolBar, String imageName, String actionCommand, String toolTipText, String altText) {
        JButton button = new JButton();
        button.setActionCommand(actionCommand);
        button.setToolTipText(toolTipText);
        button.addActionListener(this);
        button.setText(altText);
        toolBar.add(button);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (LEFT.equals(cmd)) {
            this.zoom.right(0.5);
        } else if (RIGHT.equals(cmd)) {
            this.zoom.right(-0.5);
        } else if (UP.equals(cmd)) {
            this.zoom.down(0.5);
        } else if (DOWN.equals(cmd)) {
            this.zoom.down(-0.5);
        } else if (IN.equals(cmd)) {
            this.zoom.adjustZoom(2.0);
        } else if (OUT.equals(cmd)) {
            this.zoom.adjustZoom(0.5);
        } else if (CENTER.equals(cmd)) {
            this.zoom.recenter(true);
        } else if (HELP.equals(cmd)) {
            if (this.helpFrame == null) {
                this.createHelpPane();
            } else {
                this.helpFrame.setVisible(true);
                this.helpFrame.toFront();
            }
        }
    }

    private void createHelpPane() {
        this.helpFrame = new JDialog((Frame)this, "Help for Explain tool for Maxent");
        JEditorPane text = new JEditorPane();
        try {
            text.setPage(GUI.class.getResource("helpExplain.html"));
        }
        catch (Exception e) {
            Utils.popupError("Error opening help window", e);
        }
        JScrollPane pane = new JScrollPane(text);
        pane.setPreferredSize(new Dimension(600, 400));
        this.helpFrame.getContentPane().add(pane);
        this.helpFrame.pack();
        this.helpFrame.setVisible(true);
    }
}

