/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Grid;
import density.GridDimension;
import density.GridIO;
import density.GridZoom;
import density.Params;
import density.Project;
import density.Utils;
import gnu.getopt.Getopt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class Explainold
extends JFrame
implements ActionListener {
    GridZoom zoom;
    Grid[] predictors = new Grid[0];
    Grid pred;
    Grid projgrid;
    Grid proj2grid;
    String predfile;
    String lambdafile = null;
    String responsedir;
    String species;
    double[] mean;
    double[] contribs;
    boolean[] isCategorical;
    HashMap map;
    int nvars = 0;
    NumberFormat nf;
    JLabel pointval;
    Project proj;
    Project proj2;
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final String UP = "up";
    private static final String DOWN = "down";
    private static final String IN = "in";
    private static final String OUT = "out";
    private static final String CENTER = "center";
    private static final String MODEL = "model";

    public Explainold(String[] args) throws IOException {
        int gg;
        String usage = "Usage: density.Explainold [-l lambdafile] predictionFile predictorsDirectory";
        Getopt g = new Getopt("Show", args, "l:");
        block5: while ((gg = g.getopt()) != -1) {
            switch (gg) {
                case 108: {
                    this.lambdafile = g.getOptarg();
                    continue block5;
                }
            }
            System.out.println(usage);
            System.exit(0);
        }
        if (args.length - g.getOptind() < 2) {
            System.out.println(usage);
            System.exit(0);
        }
        this.predfile = args[g.getOptind()];
        String griddir = args[g.getOptind() + 1];
        Utils.topLevelFrame = this;
        this.nf = NumberFormat.getNumberInstance(Locale.US);
        this.nf.setGroupingUsed(false);
        try {
            this.pred = GridIO.readGrid(this.predfile);
            if (args.length > 1) {
                String root = this.predfile.substring(0, this.predfile.length() - 4);
                if (this.lambdafile == null) {
                    this.lambdafile = root + ".lambdas";
                } else {
                    root = this.lambdafile.replaceAll(".lambdas$", "");
                }
                System.out.println("Loading " + this.lambdafile);
                this.map = new HashMap();
                this.proj = new Project(new Params());
                this.proj.mapping = true;
                this.proj.exponent = true;
                this.proj.varmap = this.map;
                this.projgrid = this.proj.projectGrid(this.lambdafile, null)[0];
                HashSet usedGrids = this.proj.gridNames();
                String[] files1 = Utils.gridFileNames(griddir);
                ArrayList<String> keep = new ArrayList<String>();
                for (String s : files1) {
                    if (!usedGrids.contains(Utils.fileToLayer(s))) continue;
                    keep.add(s);
                }
                String[] files = keep.toArray(new String[0]);
                this.nvars = files.length;
                this.predictors = new Grid[this.nvars];
                this.mean = new double[this.nvars];
                int i = 0;
                while (i < this.nvars) {
                    System.out.println("Loading " + files[i]);
                    this.predictors[i] = GridIO.readGrid(files[i]);
                    double sum = 0.0;
                    for (int r = 0; r < this.pred.getDimension().getnrows(); ++r) {
                        for (int c = 0; c < this.pred.getDimension().getncols(); ++c) {
                            if (!this.pred.hasData(r, c) || !this.predictors[i].hasData(r, c)) continue;
                            int n = i;
                            this.mean[n] = this.mean[n] + (double)(this.pred.eval(r, c) * this.predictors[i].eval(r, c));
                            sum += (double)this.pred.eval(r, c);
                        }
                    }
                    int n = i++;
                    this.mean[n] = this.mean[n] / sum;
                }
                this.proj2 = new Project(new Params());
                this.proj2.mapping = true;
                this.proj2.varmap = this.map;
                this.proj2grid = this.proj2.projectGrid(this.lambdafile, null)[0];
                for (Project.Pfeature pf : this.proj.allFeatures) {
                    if (!(pf instanceof Project.ScaledGrid) || !(((Project.ScaledGrid)pf).g0 instanceof Project.ProductGrid)) continue;
                    Utils.warn2("Model in " + this.lambdafile + " is not additive.  This tool requires a model made without product features", "notadditive");
                }
                this.responsedir = new File(new File(root).getParent(), "plots").getPath();
                this.species = new File(root).getName();
                this.setTitle("Explainold predictions for " + this.species);
            }
        }
        catch (IOException e) {
            System.out.println(e.toString());
            System.exit(0);
        }
        this.zoom = new GridZoom(this.pred){

            @Override
            public void mouseClicked(int r, int c) {
            }

            @Override
            public void mousePointAt(int r, int c) {
                GridDimension dim = Explainold.this.zoom.grid.getDimension();
                Explainold.this.nf.setMaximumFractionDigits(8);
                Explainold.this.pointval.setText("(" + Explainold.this.nf.format(dim.toX(c)) + ", " + Explainold.this.nf.format(dim.toY(r)) + "): " + (Explainold.this.zoom.grid.hasData(r, c) ? Explainold.this.nf.format(Explainold.this.zoom.grid.eval(r, c)) : "<no data>"));
            }
        };
        JToolBar toolBar = this.makeToolBar();
        JPanel displayPane = new JPanel();
        displayPane.setPreferredSize(new Dimension(800, 800));
        displayPane.setLayout(new BorderLayout());
        displayPane.add((Component)toolBar, "First");
        displayPane.add((Component)this.zoom, "Center");
        this.pointval = new JLabel(" ");
        displayPane.add((Component)this.pointval, "Last");
        Container contentPane = this.getContentPane();
        contentPane.add((Component)displayPane, "Center");
        this.pack();
        this.addWindowListener(new WindowAdapter(this){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.setVisible(true);
    }

    double contribution(int i, double v) {
        for (int j = 0; j < this.nvars; ++j) {
            this.map.put(this.predictors[j].getName(), new Double(this.mean[j]));
        }
        double before = this.projgrid.eval(0, 0);
        this.map.put(this.predictors[i].getName(), v);
        double after = this.projgrid.eval(0, 0);
        double offset = (before - Math.log(this.proj.densityNormalizer) + this.proj.entropy) / (double)this.nvars;
        return after - before + offset;
    }

    JToolBar makeToolBar() {
        JToolBar toolBar = new JToolBar("Navigation buttons");
        this.addButton(toolBar, "Back24", LEFT, "Shift left", "<");
        this.addButton(toolBar, "Up24", UP, "Shift up", "^");
        this.addButton(toolBar, "Down24", DOWN, "Shift down", "v");
        this.addButton(toolBar, "Forward24", RIGHT, "Shift right", ">");
        this.addButton(toolBar, "Plus", IN, "Zoom in", "+");
        this.addButton(toolBar, "Minus", OUT, "Zoom out", "-");
        this.addButton(toolBar, "Dot", CENTER, "Recenter", "@");
        if (this.nvars > 0) {
            String[] varnames = new String[this.nvars + 1];
            varnames[0] = "Model for " + this.species;
            for (int i = 0; i < this.nvars; ++i) {
                varnames[i + 1] = this.predictors[i].getName();
            }
            final JComboBox<String> showList = new JComboBox<String>(varnames);
            showList.setMaximumRowCount(25);
            showList.setSelectedIndex(0);
            showList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int sel = showList.getSelectedIndex();
                    if (sel == 0) {
                        Explainold.this.zoom.setGrid(Explainold.this.pred);
                    } else {
                        Explainold.this.zoom.setGrid(Explainold.this.predictors[sel - 1]);
                    }
                    Explainold.this.zoom.makeImage();
                }
            });
            toolBar.addSeparator();
            toolBar.add(showList);
        }
        return toolBar;
    }

    protected void addButton(JToolBar toolBar, String imageName, String actionCommand, String toolTipText, String altText) {
        JButton button = new JButton();
        button.setActionCommand(actionCommand);
        button.setToolTipText(toolTipText);
        button.addActionListener(this);
        button.setText(altText);
        toolBar.add(button);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (LEFT.equals(cmd)) {
            this.zoom.right(0.5);
        } else if (RIGHT.equals(cmd)) {
            this.zoom.right(-0.5);
        } else if (UP.equals(cmd)) {
            this.zoom.down(0.5);
        } else if (DOWN.equals(cmd)) {
            this.zoom.down(-0.5);
        } else if (IN.equals(cmd)) {
            this.zoom.adjustZoom(2.0);
        } else if (OUT.equals(cmd)) {
            this.zoom.adjustZoom(0.5);
        } else if (CENTER.equals(cmd)) {
            this.zoom.recenter(true);
        }
    }
}

