/*
 * Decompiled with CFR 0.152.
 */
package density;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

class FileEntry
extends JPanel {
    final JTextField text = new JTextField(20);
    static final JFileChooser fc = new JFileChooser();
    JLabel label;
    JButton browse = new JButton("Browse");
    int fileSelectionMode = 2;
    FileFilter filter;
    ActionListener listener;

    void setDirOnly() {
        this.fileSelectionMode = 1;
    }

    void setFilesOnly() {
        this.fileSelectionMode = 0;
    }

    public FileEntry(String title) {
        this(title, (ActionListener)null);
    }

    public FileEntry(String title, String suffix) {
        this(title, null, suffix);
    }

    public FileEntry(String title, ActionListener ll) {
        this(title, ll, fc.getAcceptAllFileFilter());
    }

    public FileEntry(String title, ActionListener ll, final String suffix) {
        this(title, ll, (FileFilter)null);
        this.filter = suffix == null ? new FileFilter(this){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "directories";
            }
        } : new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().toLowerCase().endsWith(suffix);
            }

            @Override
            public String getDescription() {
                return (FileEntry.this.fileSelectionMode == 2 ? "directories and " : "") + suffix + " files";
            }
        };
    }

    public FileEntry(String title, ActionListener ll, FileFilter ff) {
        this.listener = ll;
        this.filter = ff;
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fc.setFileSelectionMode(FileEntry.this.fileSelectionMode);
                fc.resetChoosableFileFilters();
                fc.setFileFilter(FileEntry.this.filter);
                int returnVal = fc.showOpenDialog(FileEntry.this);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    if (!file.exists() && file.getParentFile().exists()) {
                        file = file.getParentFile();
                    }
                    FileEntry.this.text.setText(file.getAbsolutePath());
                    FileEntry.this.passFileName(FileEntry.this.listener);
                }
            }
        });
        this.text.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileEntry.this.passFileName(FileEntry.this.listener);
            }
        });
        this.setLayout(new BorderLayout());
        this.label = new JLabel(title + " ");
        this.add((Component)this.label, "West");
        this.add((Component)this.text, "Center");
        this.add((Component)this.browse, "East");
    }

    void passFileName(ActionListener listener) {
        if (listener != null) {
            listener.actionPerformed(new ActionEvent(this, 0, this.text.getText()));
        }
    }

    String getText() {
        return this.text.getText().trim();
    }

    void setText(String s) {
        this.text.setText(s);
        this.passFileName(this.listener);
    }

    void disable(String s) {
        this.text.setText(s);
        this.text.setEnabled(false);
        this.browse.setEnabled(false);
    }

    @Override
    public void enable() {
        this.text.setEnabled(true);
        this.text.setText("");
        this.browse.setEnabled(true);
    }
}

