/*
 * Decompiled with CFR 0.152.
 */
package density;

public class FloatIndexSort {
    public static int[] sort(float[] vals) {
        int[] a = new int[vals.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = i;
            if (Float.isNaN(vals[i])) {
                throw new RuntimeException("NaN encountered in FloatIndexSort");
            }
            if (vals[i] != Float.NEGATIVE_INFINITY) continue;
            throw new RuntimeException("-0.0 encountered in FloatIndexSort");
        }
        FloatIndexSort.sort1(a, 0, a.length, vals);
        return a;
    }

    static void sort1(int[] x, int off, int len, float[] vals) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && vals[x[j - 1]] > vals[x[j]]; --j) {
                    FloatIndexSort.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = FloatIndexSort.med3(x, l, l + s, l + 2 * s, vals);
                m = FloatIndexSort.med3(x, m - s, m, m + s, vals);
                n = FloatIndexSort.med3(x, n - 2 * s, n - s, n, vals);
            }
            m = FloatIndexSort.med3(x, l, m, n, vals);
        }
        float v = vals[x[m]];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && vals[x[b]] <= v) {
                if (vals[x[b]] == v) {
                    FloatIndexSort.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && vals[x[c]] >= v) {
                if (vals[x[c]] == v) {
                    FloatIndexSort.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            FloatIndexSort.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        FloatIndexSort.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        FloatIndexSort.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            FloatIndexSort.sort1(x, off, s, vals);
        }
        if ((s = d - c) > 1) {
            FloatIndexSort.sort1(x, n - s, s, vals);
        }
    }

    private static void swap(int[] x, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(int[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            FloatIndexSort.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(int[] x, int a, int b, int c, float[] vals) {
        return vals[x[a]] < vals[x[b]] ? (vals[x[b]] < vals[x[c]] ? b : (vals[x[a]] < vals[x[c]] ? c : a)) : (vals[x[b]] > vals[x[c]] ? b : (vals[x[a]] > vals[x[c]] ? c : a));
    }
}

