/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.DirectorySelect;
import density.DoubleNumberField;
import density.FileEntry;
import density.FileSelect;
import density.MyProgressMonitor;
import density.Parameter;
import density.Params;
import density.Runner;
import density.SwingWorker;
import density.Utils;
import density.WholeNumberField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.text.DefaultFormatter;

public class GUI {
    FileSelect samplesSelect;
    DirectorySelect layersSelect;
    String[] featureTypes = new String[]{"Linear", "Quadratic", "Product", "Threshold", "Hinge", "Auto"};
    FileEntry outputDirEntry;
    FileEntry projectDirEntry;
    JCheckBox[] featureButtons;
    JButton runButton;
    JDialog helpFrame = null;
    JFrame paramsFrame = null;
    static JFrame topLevelFrame = null;
    static ActionListener listener;
    Params params;
    Runner runner;
    HashMap tooltips = new HashMap();
    HashMap<String, JComponent> paneParams = new HashMap();
    static MyProgressMonitor progressMonitor;

    public GUI(Params p) {
        this.params = p;
    }

    void myAdd(JPanel p, GridBagLayout gridbag, GridBagConstraints c, Component o) {
        gridbag.setConstraints(o, c);
        p.add(o);
    }

    void setToolTipText(JComponent c, String s) {
        this.tooltips.put(c, s);
    }

    void setToolTipText(JComponent c, Parameter p) {
        this.tooltips.put(c, p.getToolTip());
    }

    void showToolTips(boolean show) {
        JComponent[] c = this.tooltips.keySet().toArray(new JComponent[0]);
        for (int i = 0; i < c.length; ++i) {
            c[i].setToolTipText(show ? (String)this.tooltips.get(c[i]) : null);
        }
    }

    Container createContentPane() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel p = new JPanel(gridbag);
        p.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.samplesSelect = new FileSelect("Samples", ".csv", null);
        this.myAdd(p, gridbag, c, this.samplesSelect);
        String s = "Please enter the name of a file containing presence locations for one or more species.";
        this.setToolTipText((JComponent)this.samplesSelect, s);
        this.setToolTipText((JComponent)this.samplesSelect.dirLine.text, s);
        c.gridwidth = 0;
        String[] types = new String[]{"Continuous", "Categorical"};
        this.layersSelect = new DirectorySelect("Environmental layers", Utils.inputFileTypes, types);
        this.myAdd(p, gridbag, c, this.layersSelect);
        s = "<html>Environmental variables can be in a directory containing one file per variable, <br>or all together in a .csv file in SWD format.  Please enter a directory name or file name.";
        this.setToolTipText((JComponent)this.layersSelect, s);
        this.setToolTipText((JComponent)this.layersSelect.dirLine.text, s);
        c.weighty = 0.0;
        this.myAdd(p, gridbag, c, this.controls());
        this.paneParams.put("samplesfile", this.samplesSelect);
        this.paneParams.put("environmentallayers", this.layersSelect);
        return p;
    }

    JPanel controls() {
        JPanel checks = new JPanel();
        checks.setLayout(new GridLayout(0, 1));
        ButtonGroup group = new ButtonGroup();
        this.featureButtons = new JCheckBox[this.featureTypes.length];
        for (int i = 0; i < this.featureTypes.length; ++i) {
            JCheckBox button;
            this.featureButtons[i] = button = new JCheckBox(this.featureTypes[i] + " features");
            this.setToolTipText((JComponent)this.featureButtons[i], "Feature types to be used during training.  See Help for details.");
            checks.add(button);
            if (this.featureTypes[i].equals("Auto")) {
                this.setToolTipText((JComponent)this.featureButtons[i], "<html>Allow automatic limiting of feature types for small sample sizes,<br>with feature types being a subset of those selected above.");
                button.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        boolean sel = e.getStateChange() == 1;
                        for (int i = 0; i < GUI.this.featureButtons.length - 1; ++i) {
                            GUI.this.featureButtons[i].setEnabled(!sel);
                        }
                    }
                });
                button.setSelected(this.params.getboolean("autofeature"));
                continue;
            }
            button.setSelected(this.params.getboolean(this.featureTypes[i]));
        }
        checks.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        this.runButton = new JButton("Run");
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI.this.doRun();
            }
        });
        JButton paramsButton = new JButton("Settings");
        paramsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI.this.paramsFrame.setVisible(true);
                GUI.this.paramsFrame.toFront();
            }
        });
        JButton helpButton = new JButton("Help");
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GUI.this.helpFrame == null) {
                    GUI.this.createHelpPane();
                } else {
                    GUI.this.helpFrame.setVisible(true);
                    GUI.this.helpFrame.toFront();
                }
            }
        });
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(1, 0));
        buttons.add(this.runButton);
        buttons.add(paramsButton);
        buttons.add(helpButton);
        JPanel all = new JPanel();
        all.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        all.setLayout(new BorderLayout());
        all.add((Component)this.createParamsPanes(), "East");
        all.add((Component)checks, "West");
        all.add((Component)buttons, "South");
        ((JCheckBox)this.paneParams.get("tooltips")).addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GUI.this.showToolTips(e.getStateChange() == 1);
            }
        });
        return all;
    }

    void setFeatureTypes(String s) {
        for (int i = 0; i < this.featureTypes.length; ++i) {
            if (s.equals(this.featureTypes[i])) {
                this.featureButtons[i].setSelected(true);
            }
            if (s.equals("Auto") || !this.featureTypes[i].equals("Auto")) continue;
            this.featureButtons[i].setSelected(false);
        }
    }

    boolean getBooleanPaneParam(String name) {
        JCheckBox b = (JCheckBox)this.paneParams.get(name);
        return b.isSelected();
    }

    int getIntPaneParam(String name) {
        JFormattedTextField f = (JFormattedTextField)this.paneParams.get(name);
        return (Integer)f.getValue();
    }

    double getDoublePaneParam(String name) {
        JFormattedTextField f = (JFormattedTextField)this.paneParams.get(name);
        return ((Number)f.getValue()).doubleValue();
    }

    String getStringPaneParam(String name) {
        JComponent pp = this.paneParams.get(name);
        if (pp instanceof JFormattedTextField) {
            JFormattedTextField f = (JFormattedTextField)pp;
            return ((String)f.getValue()).trim();
        }
        FileEntry fe = (FileEntry)pp;
        return fe.getText();
    }

    void dumpPaneParams() {
        for (String s : this.paneParams.keySet()) {
            System.out.println(s + " " + this.paneParams.get(s));
        }
    }

    void addPaneParam(JComponent c, Parameter p) {
        this.addPaneParam(new JComponent[]{c}, p);
    }

    void addPaneParam(JComponent[] c, Parameter p) {
        this.paneParams.put(p.getName(), c[0]);
        for (JComponent cc : c) {
            this.setToolTipText(cc, p.getToolTip());
        }
    }

    JPanel createParamsPanes() {
        this.paramsFrame = new JFrame("Maximum Entropy Parameters");
        JTabbedPane tabs = new JTabbedPane();
        this.paramsFrame.setContentPane(tabs);
        for (Parameter.Level level : new Parameter.Level[]{Parameter.Level.BASIC, Parameter.Level.ADVANCED, Parameter.Level.EXPERIMENTAL, Parameter.Level.SPATIAL, Parameter.Level.CORE}) {
            JPanel checks = new JPanel(new GridLayout(0, 1));
            JPanel labels = new JPanel(new GridLayout(0, 1));
            JPanel entries = new JPanel(new GridLayout(0, 1));
            JPanel browsers = new JPanel(new GridLayout(0, 1));
            if (level == Parameter.Level.CORE) {
                labels.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            }
            for (Parameter param : this.params.allParams()) {
                JComponent c;
                if (param.getLevel() != level) continue;
                if (param.isBoolean()) {
                    JCheckBox c2 = new JCheckBox(param.getDisplayText());
                    if (level == Parameter.Level.CORE) {
                        c2.setHorizontalAlignment(4);
                        c2.setHorizontalTextPosition(2);
                    }
                    checks.add(c2);
                    this.addPaneParam(c2, param);
                    continue;
                }
                if (param.isFileOrDirectory()) {
                    FileEntry fe;
                    FileEntry fileEntry = fe = param.filetype == null ? new FileEntry(param.getDisplayText(), null, Utils.fileFilter) : new FileEntry(param.getDisplayText(), null, "." + param.filetype);
                    if (param.isFile()) {
                        fe.setFilesOnly();
                    }
                    if (param.isDirectory()) {
                        fe.setDirOnly();
                    }
                    browsers.add(fe);
                    this.addPaneParam(new JComponent[]{fe, fe.text}, param);
                    continue;
                }
                DefaultFormatter df = new DefaultFormatter();
                df.setOverwriteMode(false);
                JLabel l = new JLabel(param.getDisplayText());
                if (level == Parameter.Level.CORE) {
                    l.setHorizontalAlignment(4);
                }
                JComponent jComponent = param.isInteger() ? new WholeNumberField((Integer)param.getDefaultValue(), param.minint, param.maxint) : (param.isDouble() ? new DoubleNumberField((double)((Double)param.getDefaultValue())) : (c = param.isSelection() ? new JComboBox<String>(param.allowedValues()) : new JFormattedTextField(df)));
                if (c instanceof JFormattedTextField) {
                    ((JFormattedTextField)c).setHorizontalAlignment(4);
                }
                labels.add(l);
                entries.add(c);
                this.addPaneParam(new JComponent[]{c, l}, param);
            }
            JPanel paramspanel = new JPanel();
            boolean isCore = level == Parameter.Level.CORE;
            int b = isCore ? 2 : 5;
            paramspanel.setBorder(BorderFactory.createEmptyBorder(b, b, b, b));
            GridBagLayout gbl = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridwidth = 0;
            constraints.fill = 1;
            paramspanel.setLayout(gbl);
            this.myAdd(paramspanel, gbl, constraints, checks);
            constraints.gridwidth = -1;
            constraints.weightx = isCore ? 1.0 : 0.0;
            this.myAdd(paramspanel, gbl, constraints, labels);
            constraints.gridwidth = 0;
            constraints.weightx = isCore ? 0.0 : 1.0;
            this.myAdd(paramspanel, gbl, constraints, entries);
            this.myAdd(paramspanel, gbl, constraints, browsers);
            if (level == Parameter.Level.CORE) {
                this.paramsFrame.pack();
                return paramspanel;
            }
            tabs.add(Utils.capitalize(level.toString()), paramspanel);
        }
        return null;
    }

    private void createHelpPane() {
        this.helpFrame = new JDialog((Frame)topLevelFrame, "Help for Maximum Entropy Species Distribution Modeling");
        JEditorPane text = new JEditorPane();
        try {
            text.setPage(GUI.class.getResource("help.html"));
        }
        catch (Exception e) {
            this.popupError("Error opening help window", e);
        }
        JScrollPane pane = new JScrollPane(text);
        pane.setPreferredSize(new Dimension(1000, 700));
        this.helpFrame.getContentPane().add(pane);
        this.helpFrame.pack();
        this.helpFrame.setVisible(true);
    }

    void mkProgressMonitor() {
        progressMonitor = new MyProgressMonitor((Frame)topLevelFrame, "Maximum Entropy Species Distribution Modeling", "________________________________________________________________", 100);
        progressMonitor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI.this.runner.stop();
            }
        });
        if (this.params.getBoolean("visible").booleanValue()) {
            progressMonitor.pack();
            progressMonitor.setLocationRelativeTo(topLevelFrame);
            progressMonitor.setVisible(true);
        }
        progressMonitor.setNote("Reading files");
    }

    void doRun() {
        this.doRun(false);
    }

    void doRun(final boolean terminate) {
        if (this.paramsFromInterface()) {
            this.runButton.setEnabled(false);
            this.mkProgressMonitor();
            while (progressMonitor == null) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            Utils.progressMonitor = progressMonitor;
            Utils.topLevelFrame = topLevelFrame;
            SwingWorker worker = new SwingWorker(){

                @Override
                public Object construct() {
                    GUI.this.runner = new Runner(GUI.this.params);
                    try {
                        GUI.this.runner.runSpatial();
                    }
                    catch (OutOfMemoryError e) {
                        Utils.fatalException("Please refer to help button", e);
                    }
                    catch (Exception e) {
                        Utils.fatalException("Fatal Error", e);
                    }
                    return null;
                }

                @Override
                public void finished() {
                    GUI.this.runner.end();
                    if (terminate) {
                        System.exit(0);
                    }
                    GUI.this.runButton.setEnabled(true);
                }
            };
            worker.start();
        } else if (terminate) {
            System.exit(0);
        }
    }

    void setCombo(JComboBox c, String s) {
        for (int i = 0; i < c.getItemCount(); ++i) {
            if (!((String)c.getItemAt(i)).toLowerCase().equals(s)) continue;
            c.setSelectedIndex(i);
        }
    }

    void applyParams() {
        int i;
        for (String s : this.paneParams.keySet()) {
            JComponent comp = this.paneParams.get(s);
            if (comp instanceof JCheckBox) {
                ((JCheckBox)comp).setSelected(this.params.getBoolean(s));
                continue;
            }
            if (comp instanceof DirectorySelect) {
                ((DirectorySelect)comp).setText(this.params.getString(s));
                continue;
            }
            if (comp instanceof WholeNumberField) {
                ((WholeNumberField)comp).setValue(this.params.getInteger(s));
                continue;
            }
            if (comp instanceof DoubleNumberField) {
                ((DoubleNumberField)comp).setValue(this.params.getDouble(s));
                continue;
            }
            if (comp instanceof JFormattedTextField) {
                ((JFormattedTextField)comp).setValue(this.params.getString(s));
                continue;
            }
            if (comp instanceof FileEntry) {
                ((FileEntry)comp).setText(this.params.getString(s));
                continue;
            }
            if (comp instanceof JComboBox) {
                this.setCombo((JComboBox)comp, this.params.getString(s));
                continue;
            }
            System.out.println("Error: unknown component " + s + " " + comp);
        }
        DirectorySelect.prefixes = this.params.getboolean("prefixes");
        for (i = 0; i < this.params.toggleType.size(); ++i) {
            this.layersSelect.toggleType((String)this.params.toggleType.get(i));
        }
        for (i = 0; i < this.params.toggleSelectedSamples.size(); ++i) {
            this.samplesSelect.toggleSelected((String)this.params.toggleSelectedSamples.get(i));
        }
        for (i = 0; i < this.params.toggleSelectedLayers.size(); ++i) {
            this.layersSelect.toggleSelected((String)this.params.toggleSelectedLayers.get(i));
        }
    }

    boolean paramsFromInterface() {
        for (JComponent c : this.paneParams.values()) {
            if (!(c instanceof JFormattedTextField)) continue;
            try {
                ((JFormattedTextField)c).commitEdit();
            }
            catch (ParseException e) {
                Utils.echoln(e.toString());
            }
        }
        for (String s : this.paneParams.keySet()) {
            Parameter param = this.params.getParameter(s);
            JComponent comp = this.paneParams.get(s);
            if (comp instanceof JCheckBox) {
                param.setValue(Boolean.toString(((JCheckBox)this.paneParams.get(s)).isSelected()));
                continue;
            }
            if (comp instanceof WholeNumberField) {
                param.setValue(((WholeNumberField)comp).getValue().toString());
                continue;
            }
            if (comp instanceof DoubleNumberField) {
                param.setValue(((DoubleNumberField)comp).getValue().toString());
                continue;
            }
            if (comp instanceof JFormattedTextField) {
                param.setValue((String)((JFormattedTextField)comp).getValue());
                continue;
            }
            if (comp instanceof FileEntry) {
                param.setValue(((FileEntry)comp).getText().trim());
                continue;
            }
            if (comp instanceof DirectorySelect) {
                param.setValue(((DirectorySelect)comp).getText().trim());
                continue;
            }
            if (comp instanceof JComboBox) {
                param.setValue((String)((JComboBox)comp).getSelectedItem());
                continue;
            }
            System.out.println("Error: unknown component");
        }
        this.params.species = this.samplesSelect.getSelected();
        this.params.layers = this.layersSelect.getSelected();
        this.params.unusedLayers = this.layersSelect.getSelected(false);
        this.params.layerTypes = this.layersSelect.getTypes();
        this.getFeatureTypes();
        if (!this.params.getString("biasFile").equals("")) {
            this.params.setValue("biasType", 3);
        } else {
            this.params.setValue("biasType", 0);
        }
        return true;
    }

    void getFeatureTypes() {
        for (int i = 0; i < this.featureTypes.length; ++i) {
            String type = this.featureTypes[i];
            boolean selected = this.featureButtons[i].isSelected();
            if (type.equals("Auto")) {
                this.params.setValue("autofeature", selected);
                continue;
            }
            this.params.setValue(type, selected);
        }
    }

    void popupError(String s, Throwable e) {
        Utils.popupError(s, e);
    }

    static {
        progressMonitor = null;
    }
}

