/*
 * Decompiled with CFR 0.152.
 */
package density;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;

public class GetIniValueParser {
    protected Vector lines;
    protected Vector subjects;
    protected Vector variables;
    protected Vector values;
    protected String fileName;
    protected boolean saveOnChange = false;

    public GetIniValueParser(String name) throws IOException {
        this(name, false);
    }

    public GetIniValueParser(String name, boolean save) throws IOException {
        this.saveOnChange = save;
        this.fileName = name;
        if (!new File(name).exists() && !this.createFile()) {
            return;
        }
        this.loadFile();
        this.parseLines();
    }

    public void loadFile() throws IOException {
        this.lines = new Vector();
        this.subjects = new Vector();
        this.variables = new Vector();
        this.values = new Vector();
        try {
            DataInputStream ini = new DataInputStream(new BufferedInputStream(new FileInputStream(this.fileName)));
            String line = "";
            while ((line = ini.readLine()) != null) {
                this.lines.addElement(line.trim());
            }
            ini.close();
        }
        catch (IOException e) {
            throw new IOException("IniFile load failed: " + e.getMessage());
        }
    }

    protected boolean createFile() throws IOException {
        try {
            DataOutputStream newFile = new DataOutputStream(new FileOutputStream(this.fileName));
            newFile.writeBytes(";INI File: " + this.fileName + System.getProperty("line.separator"));
            newFile.close();
            return true;
        }
        catch (IOException e) {
            throw new IOException("IniFile create failed: " + e.getMessage());
        }
    }

    protected void parseLines() throws IOException {
        String currentLine = null;
        String currentSubject = null;
        for (int i = 0; i < this.lines.size(); ++i) {
            currentLine = (String)this.lines.elementAt(i);
            if (this.isaSubject(currentLine)) {
                currentSubject = currentLine.substring(1, currentLine.length() - 1).toLowerCase();
                continue;
            }
            if (!this.isanAssignment(currentLine)) continue;
            String assignment = currentLine;
            this.addAssignment(currentSubject, assignment);
        }
    }

    protected boolean addAssignment(String subject, String assignment) throws IOException {
        int index = assignment.indexOf("=");
        String variable = assignment.substring(0, index).toLowerCase();
        String value = assignment.substring(index + 1, assignment.length());
        if (value.length() == 0 || variable.length() == 0) {
            return false;
        }
        return this.addValue(subject, variable, value, false);
    }

    public boolean setValue(String subject, String variable, String value) throws IOException {
        boolean result = this.addValue(subject, variable, value, true);
        if (this.saveOnChange) {
            this.saveFile();
        }
        return result;
    }

    protected boolean addValue(String subject, String variable, String value, boolean addToLines) throws IOException {
        if (subject == null || subject.length() == 0) {
            return false;
        }
        if (variable == null || variable.length() == 0) {
            return false;
        }
        if (!this.subjects.contains(subject)) {
            this.subjects.addElement(subject);
            this.variables.addElement(new Vector());
            this.values.addElement(new Vector());
        }
        int subjectIndex = this.subjects.indexOf(subject);
        Vector subjectVariables = (Vector)this.variables.elementAt(subjectIndex);
        Vector subjectValues = (Vector)this.values.elementAt(subjectIndex);
        if (!subjectVariables.contains(variable)) {
            subjectVariables.addElement(variable);
            subjectValues.addElement(value);
        }
        int variableIndex = subjectVariables.indexOf(variable);
        subjectValues.setElementAt(value, variableIndex);
        if (addToLines) {
            this.setLine(subject, variable, value);
        }
        return true;
    }

    protected boolean isaSubject(String line) {
        return line.startsWith("[") && line.endsWith("]");
    }

    protected void setLine(String subject, String variable, String value) {
        int endOfSubject;
        int lineNumber;
        int subjectLine = this.findSubjectLine(subject);
        if (subjectLine == -1) {
            this.addSubjectLine(subject);
            subjectLine = this.lines.size() - 1;
        }
        if ((lineNumber = this.findAssignmentBetween(variable, subjectLine, endOfSubject = this.endOfSubject(subjectLine))) == -1) {
            this.lines.insertElementAt(variable + "=" + value, endOfSubject);
        } else {
            this.lines.setElementAt(variable + "=" + value, lineNumber);
        }
    }

    protected int findAssignmentLine(String subject, String variable) {
        int start = this.findSubjectLine(subject);
        int end = this.endOfSubject(start);
        return this.findAssignmentBetween(variable, start, end);
    }

    protected int findAssignmentBetween(String variable, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (!((String)this.lines.elementAt(i)).startsWith(variable + "=")) continue;
            return i;
        }
        return -1;
    }

    protected void addSubjectLine(String subject) {
        this.lines.addElement("[" + subject + "]");
    }

    protected int findSubjectLine(String subject) {
        String formattedSubject = "[" + subject + "]";
        for (int i = 0; i < this.lines.size(); ++i) {
            String line = (String)this.lines.elementAt(i);
            if (!formattedSubject.equals(line)) continue;
            return i;
        }
        return -1;
    }

    protected int endOfSubject(int start) {
        int endIndex = start + 1;
        if (start >= this.lines.size()) {
            return this.lines.size();
        }
        for (int i = start + 1; i < this.lines.size(); ++i) {
            if (this.isanAssignment((String)this.lines.elementAt(i))) {
                endIndex = i + 1;
            }
            if (!this.isaSubject((String)this.lines.elementAt(i))) continue;
            return endIndex;
        }
        return endIndex;
    }

    protected boolean isanAssignment(String line) {
        return line.indexOf("=") != -1 && !line.startsWith(";");
    }

    public Vector getLines() {
        return (Vector)this.lines.clone();
    }

    public String[] getVariables(String subject) {
        int index = this.subjects.indexOf(subject);
        if (index != -1) {
            Vector vars = (Vector)this.variables.elementAt(index);
            Object[] v = new String[vars.size()];
            vars.copyInto(v);
            return v;
        }
        String[] v = new String[]{};
        return v;
    }

    public String[] getSubjects() {
        Object[] s = new String[this.subjects.size()];
        this.subjects.copyInto(s);
        return s;
    }

    public String getValue(String subject, String variable) {
        subject = subject.toLowerCase();
        variable = variable.toLowerCase();
        int subjectIndex = this.subjects.indexOf(subject);
        if (subjectIndex == -1) {
            return "";
        }
        Vector valVector = (Vector)this.values.elementAt(subjectIndex);
        Vector varVector = (Vector)this.variables.elementAt(subjectIndex);
        int valueIndex = varVector.indexOf(variable);
        if (valueIndex != -1) {
            return ((String)valVector.elementAt(valueIndex)).trim();
        }
        return "";
    }

    public void deleteValue(String subject, String variable) throws IOException {
        int subjectIndex = this.subjects.indexOf(subject);
        if (subjectIndex == -1) {
            return;
        }
        Vector valVector = (Vector)this.values.elementAt(subjectIndex);
        Vector varVector = (Vector)this.variables.elementAt(subjectIndex);
        int valueIndex = varVector.indexOf(variable);
        if (valueIndex != -1) {
            valVector.removeElementAt(valueIndex);
            varVector.removeElementAt(valueIndex);
            int assignmentLine = this.findAssignmentLine(subject, variable);
            if (assignmentLine != -1) {
                this.lines.removeElementAt(assignmentLine);
            }
            if (varVector.size() == 0) {
                this.deleteSubject(subject);
            }
            if (this.saveOnChange) {
                this.saveFile();
            }
        }
    }

    public void deleteSubject(String subject) throws IOException {
        int subjectIndex = this.subjects.indexOf(subject);
        if (subjectIndex == -1) {
            return;
        }
        this.values.removeElementAt(subjectIndex);
        this.variables.removeElementAt(subjectIndex);
        this.subjects.removeElementAt(subjectIndex);
        int start = this.findSubjectLine(subject);
        int end = this.endOfSubject(start);
        for (int i = start; i < end; ++i) {
            this.lines.removeElementAt(start);
        }
        if (this.saveOnChange) {
            this.saveFile();
        }
    }

    public void saveFile() throws IOException {
        try {
            DataOutputStream outFile = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.fileName)));
            for (int i = 0; i < this.lines.size(); ++i) {
                outFile.writeBytes((String)this.lines.elementAt(i) + System.getProperty("line.separator"));
            }
            outFile.close();
        }
        catch (IOException e) {
            throw new IOException("IniFile save failed: " + e.getMessage());
        }
    }

    protected void finalize() throws IOException {
        this.saveFile();
    }
}

