/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.GridByte;
import density.GridDimension;
import density.GridDouble;
import density.GridIO;
import density.GridInt;
import density.GridShort;
import density.GridUbyte;
import density.LayerFeature;
import density.RunLengthEncoding;
import density.Sample;
import density.Utils;

public abstract class Grid {
    public static final int SHORT = 0;
    public static final int FLOAT = 1;
    public static final int BYTE = 2;
    public static final int INT = 3;
    public static final int DOUBLE = 4;
    public static final int UBYTE = 5;
    public static final String[] typeName = new String[]{"SHORT", "FLOAT", "SIGNEDBYTE", "INT", "DOUBLE", "BYTE"};
    public static final int[] nbits = new int[]{16, 32, 16, 32, 64, 8};
    static boolean interpolateSamples = false;
    static int defaultNODATA_value = -9999;
    String name;
    private GridDimension dimension;
    double NODATA_value = defaultNODATA_value;

    public Grid() {
    }

    public Grid(GridDimension dim, String s) {
        this.dimension = dim;
        this.name = s;
    }

    public int getType() {
        if (this instanceof GridByte) {
            return 2;
        }
        if (this instanceof GridShort) {
            return 0;
        }
        if (this instanceof GridInt) {
            return 3;
        }
        if (this instanceof GridDouble) {
            return 4;
        }
        if (this instanceof GridUbyte) {
            return 5;
        }
        return 1;
    }

    public String getTypeName() {
        return typeName[this.getType()];
    }

    public int getNbits() {
        return nbits[this.getType()];
    }

    public String getGrdTypeName() {
        return GridIO.grdTypeName[this.getType()];
    }

    public boolean isFloatType() {
        return this.getType() == 1 || this.getType() == 4;
    }

    public String getName() {
        return this.name;
    }

    public GridDimension getDimension() {
        return this.dimension;
    }

    public void setDimension(GridDimension dim) {
        this.dimension = dim;
    }

    public abstract float eval(int var1, int var2);

    public abstract boolean hasData(int var1, int var2);

    public int getNODATA_value() {
        return (int)this.NODATA_value;
    }

    public void setNODATA_value(double ndv) {
        this.NODATA_value = ndv;
    }

    public boolean hasData(double[] xy) {
        int[] rc = this.dimension.toRowCol(xy);
        return this.hasData(rc[0], rc[1]);
    }

    public float eval(double[] xy) {
        int[] rc = this.dimension.toRowCol(xy);
        return this.eval(rc[0], rc[1]);
    }

    public float evalSampleFromGrid(Sample s) {
        if (!this.hasData(s.getRow(), s.getCol())) {
            return (float)this.NODATA_value;
        }
        if (interpolateSamples) {
            return (float)this.interpolate(s.lon, s.lat);
        }
        return this.eval(s.getRow(), s.getCol());
    }

    public int countData() {
        int cnt = 0;
        for (int i = 0; i < this.getDimension().nrows; ++i) {
            for (int j = 0; j < this.getDimension().ncols; ++j) {
                if (!this.hasData(i, j)) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    public double sum() {
        double sum = 0.0;
        for (int i = 0; i < this.getDimension().nrows; ++i) {
            for (int j = 0; j < this.getDimension().ncols; ++j) {
                if (!this.hasData(i, j)) continue;
                sum += (double)this.eval(i, j);
            }
        }
        return sum;
    }

    public float[] getVals() {
        float[] result = new float[this.countData()];
        int cnt = 0;
        for (int i = 0; i < this.getDimension().nrows; ++i) {
            for (int j = 0; j < this.getDimension().ncols; ++j) {
                if (!this.hasData(i, j)) continue;
                result[cnt++] = this.eval(i, j);
            }
        }
        return result;
    }

    LayerFeature toFeature(final float[] point2val, int layerType) {
        return new GridFeature(this, point2val == null ? 0 : point2val.length, this.name, layerType){

            @Override
            public double eval(int p) {
                return point2val[p];
            }
        };
    }

    double interpolate(double lon, double lat) {
        return this.interpolate(lon, lat, 0.0f, false);
    }

    double interpolate(double lon, double lat, float target) {
        return this.interpolate(lon, lat, target, true);
    }

    double interpolate(double lon, double lat, float target, boolean match) {
        int rr = this.dimension.toRow(lat);
        int cc = this.dimension.toCol(lon);
        double pixelLon = this.dimension.toX(cc);
        double pixelLat = this.dimension.toY(rr);
        double xdiff = lon - pixelLon;
        double ydiff = lat - pixelLat;
        int llr = ydiff > 0.0 ? rr - 1 : rr;
        int llc = xdiff < 0.0 ? cc - 1 : cc;
        double val = 0.0;
        for (int r = llr; r < llr + 2; ++r) {
            for (int c = llc; c < llc + 2; ++c) {
                double v;
                double d = v = this.hasData(r, c) ? (double)this.eval(r, c) : (double)this.eval(rr, cc);
                if (match) {
                    v = v == (double)target ? 1.0 : 0.0;
                }
                val += v * (1.0 - Math.abs(this.dimension.toY(r) - lat) / this.dimension.cellsize) * (1.0 - Math.abs(this.dimension.toX(c) - lon) / this.dimension.cellsize);
            }
        }
        return val;
    }

    public float[] minmax() {
        float max = -1.0f;
        float min = -1.0f;
        boolean first = true;
        for (int r = 0; r < this.getDimension().nrows; ++r) {
            for (int c = 0; c < this.getDimension().ncols; ++c) {
                if (!this.hasData(r, c)) continue;
                if (first || this.eval(r, c) > max) {
                    max = this.eval(r, c);
                }
                if (first || this.eval(r, c) < min) {
                    min = this.eval(r, c);
                }
                first = false;
            }
        }
        return new float[]{min, max};
    }

    public static int getbin(double x, double min, double max, int n) {
        int bin = (int)((double)n * (x - min) / (max - min));
        if (bin >= n) {
            bin = n - 1;
        }
        if (bin < 0) {
            bin = 0;
        }
        return bin;
    }

    public double[] histogram(double min, double max, int n) {
        int[] cnts = new int[n];
        int cnt = 0;
        int nr = this.dimension.getnrows();
        int nc = this.dimension.getncols();
        for (int r = 0; r < nr; ++r) {
            for (int c = 0; c < nc; ++c) {
                if (!this.hasData(r, c)) continue;
                ++cnt;
                int n2 = Grid.getbin(this.eval(r, c), min, max, n);
                cnts[n2] = cnts[n2] + 1;
            }
        }
        double[] result = new double[n];
        for (int i = 0; i < n; ++i) {
            result[i] = (double)cnts[i] / (double)cnt;
        }
        return result;
    }

    static Grid vals2Grid(float[][] vals, String name) {
        GridDimension dim = new GridDimension(0.0, 0.0, 1.0, vals.length, vals[0].length);
        return Grid.vals2Grid(dim, vals, name, (double)defaultNODATA_value);
    }

    static Grid compressedGrid(final GridDimension dim, float[][] vals, String name, final double NODATA) {
        int nrows = vals.length;
        final int ncols = vals[0].length;
        final byte[][] counts = new byte[nrows][];
        final float[][] rleVals = new float[nrows][];
        final RunLengthEncoding rle = new RunLengthEncoding();
        byte[] tmpCounts = new byte[ncols];
        float[] tmpRleVals = new float[ncols];
        for (int i = 0; i < nrows; ++i) {
            rle.compress(vals[i], tmpCounts, tmpRleVals);
            if (rle.compressionRatio < 0.9) {
                counts[i] = rle.copyCounts(tmpCounts);
                rleVals[i] = rle.copyVals(tmpRleVals);
            } else {
                counts[i] = null;
                rleVals[i] = vals[i];
            }
            vals[i] = null;
        }
        return new Grid(dim, name){
            int currentRow;
            float[] row;
            {
                super(dim2, s);
                this.currentRow = -1;
                this.row = new float[ncols];
            }

            @Override
            public float eval(int r, int c) {
                if (counts[r] == null) {
                    return rleVals[r][c];
                }
                if (r != this.currentRow) {
                    this.currentRow = r;
                    rle.decompress(counts[r], rleVals[r], this.row);
                }
                return this.row[c];
            }

            @Override
            public boolean hasData(int r, int c) {
                return dim.inBounds(r, c) && this.eval(r, c) != (float)NODATA;
            }
        };
    }

    static Grid compressedGrid(final GridDimension dim, short[][] vals, String name, final double NODATA) {
        int nrows = vals.length;
        final int ncols = vals[0].length;
        final byte[][] counts = new byte[nrows][];
        final short[][] rleVals = new short[nrows][];
        final RunLengthEncoding rle = new RunLengthEncoding();
        byte[] tmpCounts = new byte[ncols];
        short[] tmpRleVals = new short[ncols];
        for (int i = 0; i < nrows; ++i) {
            rle.compress(vals[i], tmpCounts, tmpRleVals);
            if (rle.compressionRatio < 0.9) {
                counts[i] = rle.copyCounts(tmpCounts);
                rleVals[i] = rle.copyVals(tmpRleVals);
            } else {
                counts[i] = null;
                rleVals[i] = vals[i];
            }
            vals[i] = null;
        }
        return new GridShort(dim, name){
            int currentRow;
            short[] row;
            {
                super(dim2, s);
                this.currentRow = -1;
                this.row = new short[ncols];
            }

            @Override
            public short evalShort(int r, int c) {
                if (counts[r] == null) {
                    return rleVals[r][c];
                }
                if (r != this.currentRow) {
                    this.currentRow = r;
                    rle.decompress(counts[r], rleVals[r], this.row);
                }
                return this.row[c];
            }

            @Override
            public boolean hasData(int r, int c) {
                return dim.inBounds(r, c) && (double)this.evalShort(r, c) != NODATA;
            }
        };
    }

    static GridByte compressedGrid(final GridDimension dim, byte[][] vals, String name, final double NODATA) {
        int nrows = vals.length;
        final int ncols = vals[0].length;
        final byte[][] counts = new byte[nrows][];
        final byte[][] rleVals = new byte[nrows][];
        final RunLengthEncoding rle = new RunLengthEncoding();
        byte[] tmpCounts = new byte[ncols];
        byte[] tmpRleVals = new byte[ncols];
        for (int i = 0; i < nrows; ++i) {
            rle.compress(vals[i], tmpCounts, tmpRleVals);
            if (rle.compressionRatio < 0.9) {
                counts[i] = rle.copyCounts(tmpCounts);
                rleVals[i] = rle.copyVals(tmpRleVals);
            } else {
                counts[i] = null;
                rleVals[i] = vals[i];
            }
            vals[i] = null;
        }
        return new GridByte(dim, name){
            int currentRow;
            byte[] row;
            {
                super(dim2, s);
                this.NODATA_value = NODATA;
                this.currentRow = -1;
                this.row = new byte[ncols];
            }

            @Override
            public byte evalByte(int r, int c) {
                if (counts[r] == null) {
                    return rleVals[r][c];
                }
                if (r != this.currentRow) {
                    this.currentRow = r;
                    rle.decompress(counts[r], rleVals[r], this.row);
                }
                return this.row[c];
            }

            @Override
            public boolean hasData(int r, int c) {
                return dim.inBounds(r, c) && (double)this.evalByte(r, c) != NODATA;
            }
        };
    }

    public static Grid vals2Grid(GridDimension dim, float[][] vals, String name, double NODATA) {
        return Grid.vals2Grid(dim, vals, name, NODATA, false);
    }

    static Grid vals2Grid(final GridDimension dim, float[][] vals, String name, final double NODATA, boolean compress) {
        if (compress) {
            return Grid.compressedGrid(dim, vals, name, NODATA);
        }
        final int[] fD = Grid.firstDatas(vals, NODATA);
        final float[][] nv = Grid.getDatas(vals, NODATA, fD);
        return new Grid(dim, name){
            int[] firstDatas;
            float[][] newvals;
            {
                super(dim2, s);
                this.firstDatas = fD;
                this.newvals = nv;
                this.NODATA_value = NODATA;
            }

            @Override
            public float eval(int r, int c) {
                return this.newvals[r][c - this.firstDatas[r]];
            }

            @Override
            public boolean hasData(int r, int c) {
                return dim.inBounds(r, c) && c >= this.firstDatas[r] && c - this.firstDatas[r] < this.newvals[r].length && this.newvals[r][c - this.firstDatas[r]] != (float)NODATA;
            }
        };
    }

    static Grid vals2Grid(GridDimension dim, short[][] vals, String name, double NODATA) {
        return Grid.vals2Grid(dim, vals, name, NODATA, false);
    }

    static Grid vals2Grid(final GridDimension dim, short[][] vals, String name, final double NODATA, boolean compress) {
        if (compress) {
            return Grid.compressedGrid(dim, vals, name, NODATA);
        }
        final int[] fD = Grid.firstDatas(vals, NODATA);
        final short[][] nv = Grid.getDatas(vals, NODATA, fD);
        return new GridShort(dim, name){
            int[] firstDatas;
            short[][] newvals;
            {
                super(dim2, s);
                this.firstDatas = fD;
                this.newvals = nv;
                this.NODATA_value = NODATA;
            }

            @Override
            public short evalShort(int r, int c) {
                return this.newvals[r][c - this.firstDatas[r]];
            }

            @Override
            public boolean hasData(int r, int c) {
                return dim.inBounds(r, c) && c >= this.firstDatas[r] && c - this.firstDatas[r] < this.newvals[r].length && (double)this.newvals[r][c - this.firstDatas[r]] != NODATA;
            }
        };
    }

    static Grid vals2Grid(GridDimension dim, int[][] vals, String name, double NODATA) {
        return Grid.vals2Grid(dim, vals, name, NODATA, false);
    }

    static Grid vals2Grid(final GridDimension dim, int[][] vals, String name, final double NODATA, boolean compress) {
        if (compress) {
            Utils.warn("compressed int grid not yet implemented");
        }
        final int[] fD = Grid.firstDatas(vals, NODATA);
        final int[][] nv = Grid.getDatas(vals, NODATA, fD);
        return new GridInt(dim, name){
            int[] firstDatas;
            int[][] newvals;
            {
                super(dim2, s);
                this.firstDatas = fD;
                this.newvals = nv;
                this.NODATA_value = NODATA;
            }

            @Override
            public int evalInt(int r, int c) {
                return this.newvals[r][c - this.firstDatas[r]];
            }

            @Override
            public boolean hasData(int r, int c) {
                return dim.inBounds(r, c) && c >= this.firstDatas[r] && c - this.firstDatas[r] < this.newvals[r].length && (double)this.newvals[r][c - this.firstDatas[r]] != NODATA;
            }
        };
    }

    static Grid vals2Grid(GridDimension dim, double[][] vals, String name, double NODATA) {
        return Grid.vals2Grid(dim, vals, name, NODATA, false);
    }

    static Grid vals2Grid(final GridDimension dim, double[][] vals, String name, final double NODATA, boolean compress) {
        if (compress) {
            Utils.warn("Warning: compressed double grid not yet implemented");
        }
        final int[] fD = Grid.firstDatas(vals, NODATA);
        final double[][] nv = Grid.getDatas(vals, NODATA, fD);
        return new GridDouble(dim, name){
            int[] firstDatas;
            double[][] newvals;
            {
                super(dim2, s);
                this.firstDatas = fD;
                this.newvals = nv;
                this.NODATA_value = NODATA;
            }

            @Override
            public double evalDouble(int r, int c) {
                return this.newvals[r][c - this.firstDatas[r]];
            }

            @Override
            public boolean hasData(int r, int c) {
                return dim.inBounds(r, c) && c >= this.firstDatas[r] && c - this.firstDatas[r] < this.newvals[r].length && this.newvals[r][c - this.firstDatas[r]] != NODATA;
            }
        };
    }

    static Grid vals2Grid(GridDimension dim, byte[][] vals, String name, double NODATA, boolean isUbyte) {
        return Grid.vals2Grid(dim, vals, name, NODATA, false, isUbyte);
    }

    static Grid vals2Grid(final GridDimension dim, byte[][] vals, String name, final double NODATA, boolean compress, boolean isUbyte) {
        if (compress) {
            GridByte g = Grid.compressedGrid(dim, vals, name, NODATA);
            return isUbyte ? Grid.gridByte2gridUbyte(g) : g;
        }
        final int[] fD = Grid.firstDatas(vals, NODATA);
        final byte[][] nv = Grid.getDatas(vals, NODATA, fD);
        GridByte g = new GridByte(dim, name){
            int[] firstDatas;
            byte[][] newvals;
            {
                super(dim2, s);
                this.firstDatas = fD;
                this.newvals = nv;
                this.NODATA_value = NODATA;
            }

            @Override
            public byte evalByte(int r, int c) {
                return this.newvals[r][c - this.firstDatas[r]];
            }

            @Override
            public boolean hasData(int r, int c) {
                return dim.inBounds(r, c) && c >= this.firstDatas[r] && c - this.firstDatas[r] < this.newvals[r].length && (double)this.newvals[r][c - this.firstDatas[r]] != NODATA;
            }
        };
        return isUbyte ? Grid.gridByte2gridUbyte(g) : g;
    }

    static GridUbyte gridByte2gridUbyte(final GridByte g) {
        return new GridUbyte(g.getDimension(), g.getName()){
            {
                super(dim, s);
                this.NODATA_value = g.getNODATA_value();
            }

            @Override
            public boolean hasData(int r, int c) {
                return this.getDimension().inBounds(r, c) && (double)this.evalUbyte(r, c) != this.NODATA_value;
            }

            @Override
            public short evalUbyte(int r, int c) {
                short s = g.evalByte(r, c);
                return s >= 0 ? s : (short)(s + 256);
            }
        };
    }

    static int firstData(float[] vals, double NODATA) {
        for (int i = 0; i < vals.length; ++i) {
            if ((double)vals[i] == NODATA) continue;
            return i;
        }
        return vals.length;
    }

    static int lastData(float[] vals, double NODATA) {
        for (int i = vals.length - 1; i >= 0; --i) {
            if ((double)vals[i] == NODATA) continue;
            return i;
        }
        return -1;
    }

    static int[] firstDatas(float[][] vals, double NODATA) {
        int[] result = new int[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            result[i] = Grid.firstData(vals[i], NODATA);
        }
        return result;
    }

    static float[] getData(float[] vals, double NODATA, int first, int last) {
        if (first == -1 || last == -1) {
            return new float[0];
        }
        float[] result = new float[last - first + 1];
        for (int i = first; i <= last; ++i) {
            result[i - first] = vals[i];
        }
        return result;
    }

    static float[][] getDatas(float[][] vals, double NODATA, int[] firsts) {
        float[][] result = new float[vals.length][];
        for (int i = 0; i < vals.length; ++i) {
            result[i] = Grid.getData(vals[i], NODATA, firsts[i], Grid.lastData(vals[i], NODATA));
        }
        return result;
    }

    static int firstData(short[] vals, double NODATA) {
        for (int i = 0; i < vals.length; ++i) {
            if ((double)vals[i] == NODATA) continue;
            return i;
        }
        return vals.length;
    }

    static int lastData(short[] vals, double NODATA) {
        for (int i = vals.length - 1; i >= 0; --i) {
            if ((double)vals[i] == NODATA) continue;
            return i;
        }
        return -1;
    }

    static int[] firstDatas(short[][] vals, double NODATA) {
        int[] result = new int[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            result[i] = Grid.firstData(vals[i], NODATA);
        }
        return result;
    }

    static short[] getData(short[] vals, double NODATA, int first, int last) {
        if (first == -1 || last == -1) {
            return new short[0];
        }
        short[] result = new short[last - first + 1];
        for (int i = first; i <= last; ++i) {
            result[i - first] = vals[i];
        }
        return result;
    }

    static short[][] getDatas(short[][] vals, double NODATA, int[] firsts) {
        short[][] result = new short[vals.length][];
        for (int i = 0; i < vals.length; ++i) {
            result[i] = Grid.getData(vals[i], NODATA, firsts[i], Grid.lastData(vals[i], NODATA));
        }
        return result;
    }

    static int firstData(int[] vals, double NODATA) {
        for (int i = 0; i < vals.length; ++i) {
            if ((double)vals[i] == NODATA) continue;
            return i;
        }
        return vals.length;
    }

    static int lastData(int[] vals, double NODATA) {
        for (int i = vals.length - 1; i >= 0; --i) {
            if ((double)vals[i] == NODATA) continue;
            return i;
        }
        return -1;
    }

    static int[] firstDatas(int[][] vals, double NODATA) {
        int[] result = new int[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            result[i] = Grid.firstData(vals[i], NODATA);
        }
        return result;
    }

    static int[] getData(int[] vals, double NODATA, int first, int last) {
        if (first == -1 || last == -1) {
            return new int[0];
        }
        int[] result = new int[last - first + 1];
        for (int i = first; i <= last; ++i) {
            result[i - first] = vals[i];
        }
        return result;
    }

    static int[][] getDatas(int[][] vals, double NODATA, int[] firsts) {
        int[][] result = new int[vals.length][];
        for (int i = 0; i < vals.length; ++i) {
            result[i] = Grid.getData(vals[i], NODATA, firsts[i], Grid.lastData(vals[i], NODATA));
        }
        return result;
    }

    static int firstData(byte[] vals, double NODATA) {
        for (int i = 0; i < vals.length; ++i) {
            if ((double)vals[i] == NODATA) continue;
            return i;
        }
        return vals.length;
    }

    static int lastData(byte[] vals, double NODATA) {
        for (int i = vals.length - 1; i >= 0; --i) {
            if ((double)vals[i] == NODATA) continue;
            return i;
        }
        return -1;
    }

    static int[] firstDatas(byte[][] vals, double NODATA) {
        int[] result = new int[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            result[i] = Grid.firstData(vals[i], NODATA);
        }
        return result;
    }

    static byte[] getData(byte[] vals, double NODATA, int first, int last) {
        if (first == -1 || last == -1) {
            return new byte[0];
        }
        byte[] result = new byte[last - first + 1];
        for (int i = first; i <= last; ++i) {
            result[i - first] = vals[i];
        }
        return result;
    }

    static byte[][] getDatas(byte[][] vals, double NODATA, int[] firsts) {
        byte[][] result = new byte[vals.length][];
        for (int i = 0; i < vals.length; ++i) {
            result[i] = Grid.getData(vals[i], NODATA, firsts[i], Grid.lastData(vals[i], NODATA));
        }
        return result;
    }

    static int firstData(double[] vals, double NODATA) {
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] == NODATA) continue;
            return i;
        }
        return vals.length;
    }

    static int lastData(double[] vals, double NODATA) {
        for (int i = vals.length - 1; i >= 0; --i) {
            if (vals[i] == NODATA) continue;
            return i;
        }
        return -1;
    }

    static int[] firstDatas(double[][] vals, double NODATA) {
        int[] result = new int[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            result[i] = Grid.firstData(vals[i], NODATA);
        }
        return result;
    }

    static double[] getData(double[] vals, double NODATA, int first, int last) {
        if (first == -1 || last == -1) {
            return new double[0];
        }
        double[] result = new double[last - first + 1];
        for (int i = first; i <= last; ++i) {
            result[i - first] = vals[i];
        }
        return result;
    }

    static double[][] getDatas(double[][] vals, double NODATA, int[] firsts) {
        double[][] result = new double[vals.length][];
        for (int i = 0; i < vals.length; ++i) {
            result[i] = Grid.getData(vals[i], NODATA, firsts[i], Grid.lastData(vals[i], NODATA));
        }
        return result;
    }

    public void apply(Applier applier) {
        GridDimension dim = this.getDimension();
        for (int r = 0; r < dim.getnrows(); ++r) {
            for (int c = 0; c < dim.getncols(); ++c) {
                if (!this.hasData(r, c)) continue;
                applier.process(r, c, this.eval(r, c));
            }
        }
    }

    public abstract class Applier {
        public Applier(Grid this$0) {
        }

        public abstract void process(int var1, int var2, float var3);
    }

    abstract class GridFeature
    extends LayerFeature {
        GridFeature(int n, String s, int t) {
            super(n, s, t);
        }

        @Override
        public double eval(Sample s) {
            if (!this.hasData(s)) {
                throw new RuntimeException("Attempt to evaluate " + this.name + " at sample with no value");
            }
            if (s.featureMap != null) {
                return (Double)s.featureMap.get(this.name);
            }
            if (interpolateSamples) {
                return Grid.this.interpolate(s.lon, s.lat);
            }
            return Grid.this.eval(s.getRow(), s.getCol());
        }

        @Override
        public double eval(Sample s, float val) {
            if (interpolateSamples) {
                return Grid.this.interpolate(s.lon, s.lat, val);
            }
            return this.eval(s) == (double)val ? 1.0 : 0.0;
        }

        @Override
        public boolean hasData(Sample s) {
            if (s.featureMap != null) {
                if (!s.featureMap.containsKey(this.name)) {
                    Utils.fatalException("Sample missing data for variable " + this.name, null);
                }
                return s.featureMap.get(this.name) != null;
            }
            return Grid.this.hasData(s.getRow(), s.getCol());
        }
    }
}

