/*
 * Decompiled with CFR 0.152.
 */
package density;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class GridDimension {
    double xllcorner;
    double yllcorner;
    double cellsize;
    int nrows;
    int ncols;
    String[] coordNames = null;
    double[][] coords = null;

    public int getncols() {
        return this.ncols;
    }

    public int getnrows() {
        return this.nrows;
    }

    public double getxllcorner() {
        return this.xllcorner;
    }

    public double getyllcorner() {
        return this.yllcorner;
    }

    public double getcellsize() {
        return this.cellsize;
    }

    public void write(ObjectOutputStream out) throws IOException {
        out.writeDouble(this.xllcorner);
        out.writeDouble(this.yllcorner);
        out.writeDouble(this.cellsize);
        out.writeInt(this.nrows);
        out.writeInt(this.ncols);
    }

    public GridDimension(ObjectInputStream in) throws IOException {
        this.xllcorner = in.readDouble();
        this.yllcorner = in.readDouble();
        this.cellsize = in.readDouble();
        this.nrows = in.readInt();
        this.ncols = in.readInt();
    }

    public GridDimension(double xll, double yll, double cs, int nr, int nc) {
        this.xllcorner = xll;
        this.yllcorner = yll;
        this.cellsize = cs;
        this.nrows = nr;
        this.ncols = nc;
    }

    public boolean equals(Object o) {
        GridDimension gd = (GridDimension)o;
        if (gd.xllcorner != this.xllcorner) {
            return false;
        }
        if (gd.yllcorner != this.yllcorner) {
            return false;
        }
        if (gd.cellsize != this.cellsize) {
            return false;
        }
        if (gd.nrows != this.nrows) {
            return false;
        }
        return gd.ncols == this.ncols;
    }

    public int toRow(double y) {
        return this.nrows - 1 - (int)Math.floor((y - this.yllcorner) / this.cellsize);
    }

    public int toCol(double x) {
        return (int)Math.floor((x - this.xllcorner) / this.cellsize);
    }

    public int[] toRowCol(double[] xy) {
        return new int[]{this.toRow(xy[1]), this.toCol(xy[0])};
    }

    public double toX(int c) {
        return this.xllcorner + ((double)c + 0.5) * this.cellsize;
    }

    public double toY(int r) {
        return this.yllcorner + ((double)(this.nrows - r) - 0.5) * this.cellsize;
    }

    public double toYMax(int r) {
        return this.yllcorner + (double)(this.nrows - r) * this.cellsize;
    }

    public double toYMin(int r) {
        return this.yllcorner + (double)(this.nrows - r - 1) * this.cellsize;
    }

    public double[] toXY(int[] rc) {
        return new double[]{this.toX(rc[1]), this.toY(rc[0])};
    }

    public double[] toXY(int r, int c) {
        return new double[]{this.toX(c), this.toY(r)};
    }

    public boolean inBounds(int r, int c) {
        return r >= 0 && c >= 0 && r < this.nrows && c < this.ncols;
    }

    public boolean inBounds(double x, double y) {
        int r = this.toRow(y);
        int c = this.toCol(x);
        return r >= 0 && c >= 0 && r < this.nrows && c < this.ncols;
    }
}

