/*
 * Decompiled with CFR 0.152.
 */
package density;

import com.macfaq.io.LittleEndianInputStream;
import density.GetIniValueParser;
import density.Grid;
import density.GridDimension;
import density.MyScanner;
import density.Utils;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;

public class GridIO {
    public static boolean compressGrids = true;
    static int keepEvery = 1;
    public static int maxRowsAndCols = -1;
    public static HashMap GRDTypeNames = new HashMap();
    public static final String[] grdTypeName;

    public static Grid readGrid(File file) throws IOException {
        return GridIO.readGrid(file.getPath());
    }

    public static Grid readGrid(String fileName) throws IOException {
        Utils.reportDoing("Reading file " + new File(fileName).getName());
        Grid g = null;
        String lower = fileName.toLowerCase();
        try {
            if (lower.endsWith(".asc")) {
                g = GridIO.readASC(fileName);
            } else if (lower.endsWith(".mxe")) {
                g = GridIO.readMXE(fileName);
            } else if (lower.endsWith(".grd") || lower.endsWith(".gri") || lower.endsWith(".bil")) {
                g = GridIO.readGRD(fileName);
            }
        }
        catch (Exception e) {
            Utils.fatalException("Error in file " + fileName, e);
        }
        if (g == null) {
            throw new IOException("File " + fileName + ": suffix not recognized");
        }
        if (Utils.interrupt) {
            return null;
        }
        Utils.echoln(g.getTypeName() + ", " + g.countData() + " pixels with data");
        Utils.reportMemory("readGrid");
        return g;
    }

    static String root(String fileName) {
        return fileName.indexOf(".") == -1 ? fileName : fileName.substring(0, fileName.lastIndexOf("."));
    }

    static String griFile(String fileName) throws IOException {
        String root = GridIO.root(fileName);
        if (fileName.toLowerCase().endsWith(".bil")) {
            if (new File(fileName).exists()) {
                return fileName;
            }
            return GridIO.missingFile("data", fileName, null);
        }
        if (new File(root + ".GRI").exists()) {
            return root + ".GRI";
        }
        if (new File(root + ".gri").exists()) {
            return root + ".gri";
        }
        return GridIO.missingFile("data", root + ".gri", null);
    }

    static String grdFile(String fileName) throws IOException {
        String root = GridIO.root(fileName);
        if (fileName.toLowerCase().endsWith(".bil")) {
            if (new File(root + ".HDR").exists()) {
                return root + ".HDR";
            }
            if (new File(root + ".hdr").exists()) {
                return root + ".hdr";
            }
            return GridIO.missingFile("header", root + ".hdr", null);
        }
        if (new File(root + ".GRD").exists()) {
            return root + ".GRD";
        }
        if (new File(root + ".grd").exists()) {
            return root + ".grd";
        }
        return GridIO.missingFile("header", root + ".grd", null);
    }

    static String missingFile(String type, String missing, String forfile) throws IOException {
        throw new IOException("Missing " + (String)(type == null ? "" : type + " ") + "file " + (String)(missing == null ? "" : missing + " ") + (String)(forfile == null ? "" : "for " + forfile));
    }

    static Grid readGRD(String fileName) throws IOException {
        String grd = GridIO.grdFile(fileName);
        String gri = GridIO.griFile(fileName);
        if (Utils.interrupt) {
            return null;
        }
        GRDHeader grdh = new GRDHeader(grd);
        LittleEndianInputStream objin = new LittleEndianInputStream(new FileInputStream(gri));
        Grid result = GridIO.readBinary(grdh.name, grdh.dim, grdh.NODATA_value, grdh.nativetype, objin);
        objin.close();
        return result;
    }

    static Grid readMXE(String fileName) throws IOException {
        ObjectInputStream objin = new ObjectInputStream(new GZIPInputStream(new FileInputStream(fileName)));
        GridDimension dimension = new GridDimension(objin);
        int NODATA_value = objin.readInt();
        int nativeType = objin.readInt();
        String name = new File(fileName).getName();
        name = name.substring(0, name.length() - 4);
        Grid result = GridIO.readBinary(name, dimension, NODATA_value, nativeType, objin);
        objin.close();
        return result;
    }

    static Grid readBinary(String name, GridDimension dimension, double NODATA_value, int nativeType, DataInput objin) throws IOException {
        GridDimension dim = GridIO.shrink(dimension);
        int k = keepEvery;
        switch (nativeType) {
            case 0: {
                short[][] vals = new short[dim.nrows][dim.ncols];
                for (int i = 0; i < dimension.nrows; ++i) {
                    Utils.reportProgress((double)(i * 100) / (double)dimension.nrows);
                    for (int j = 0; j < dimension.ncols; ++j) {
                        vals[i / k][j / k] = objin.readShort();
                    }
                }
                return Grid.vals2Grid(dim, vals, name, NODATA_value, compressGrids);
            }
            case 2: 
            case 5: {
                byte[][] vals = new byte[dim.nrows][dim.ncols];
                for (int i = 0; i < dimension.nrows; ++i) {
                    Utils.reportProgress((double)(i * 100) / (double)dimension.nrows);
                    for (int j = 0; j < dimension.ncols; ++j) {
                        vals[i / k][j / k] = objin.readByte();
                    }
                }
                return Grid.vals2Grid(dim, vals, name, NODATA_value, compressGrids, nativeType == 5);
            }
            case 3: {
                int[][] vals = new int[dim.nrows][dim.ncols];
                for (int i = 0; i < dimension.nrows; ++i) {
                    Utils.reportProgress((double)(i * 100) / (double)dimension.nrows);
                    for (int j = 0; j < dimension.ncols; ++j) {
                        vals[i / k][j / k] = objin.readInt();
                    }
                }
                return Grid.vals2Grid(dim, vals, name, NODATA_value, compressGrids);
            }
            case 4: {
                double[][] vals = new double[dim.nrows][dim.ncols];
                for (int i = 0; i < dimension.nrows; ++i) {
                    Utils.reportProgress((double)(i * 100) / (double)dimension.nrows);
                    for (int j = 0; j < dimension.ncols; ++j) {
                        vals[i / k][j / k] = objin.readDouble();
                        if (!Double.isNaN(vals[i / k][j / k])) continue;
                        vals[i / k][j / k] = NODATA_value;
                    }
                }
                return Grid.vals2Grid(dim, vals, name, NODATA_value, compressGrids);
            }
        }
        float[][] vals = new float[dim.nrows][dim.ncols];
        for (int i = 0; i < dimension.nrows; ++i) {
            Utils.reportProgress((double)(i * 100) / (double)dimension.nrows);
            for (int j = 0; j < dimension.ncols; ++j) {
                vals[i / k][j / k] = objin.readFloat();
                if (!Float.isNaN(vals[i / k][j / k])) continue;
                vals[i / k][j / k] = (float)NODATA_value;
            }
        }
        return Grid.vals2Grid(dim, vals, name, NODATA_value, compressGrids);
    }

    static GridDimension shrink(GridDimension dim) {
        if (maxRowsAndCols == -1 || dim.ncols <= maxRowsAndCols || dim.nrows <= maxRowsAndCols) {
            return dim;
        }
        double mr = (double)dim.nrows / (double)maxRowsAndCols;
        double mc = (double)dim.ncols / (double)maxRowsAndCols;
        keepEvery = (int)(mr < mc ? Math.ceil(mr) : Math.ceil(mc));
        return new GridDimension(dim.xllcorner, dim.yllcorner, dim.cellsize * (double)keepEvery, (int)Math.ceil((double)dim.nrows / (double)keepEvery), (int)Math.ceil((double)dim.ncols / (double)keepEvery));
    }

    static double getDouble(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return Double.parseDouble(s.replace(',', '.'));
        }
    }

    static GridDimension getDimension(BufferedReader in) throws IOException {
        int ncols = Integer.parseInt(GridIO.nextHeaderVal(in));
        if (ncols > 1000000) {
            Utils.warn("Warning: ascii file has more than a million columns");
        }
        int nrows = Integer.parseInt(GridIO.nextHeaderVal(in));
        double xllcorner = GridIO.getDouble(GridIO.nextHeaderVal(in));
        double yllcorner = GridIO.getDouble(GridIO.nextHeaderVal(in));
        double cellsize = GridIO.getDouble(GridIO.nextHeaderVal(in));
        return new GridDimension(xllcorner, yllcorner, cellsize, nrows, ncols);
    }

    static double getNODATA_value(BufferedReader in) throws IOException {
        return (float)GridIO.getDouble(GridIO.nextHeaderVal(in));
    }

    static Grid readASC(String fileName) throws IOException {
        int r;
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        GridDimension dim = GridIO.getDimension(in);
        GridDimension dim2 = GridIO.shrink(dim);
        double NODATA_value = GridIO.getNODATA_value(in);
        short[][] vals = null;
        float[][] floatvals = null;
        boolean isShort = true;
        if (NODATA_value == (double)((short)NODATA_value)) {
            vals = new short[dim2.nrows][];
        } else {
            isShort = false;
            floatvals = new float[dim2.nrows][dim2.ncols];
        }
        short min = Short.MAX_VALUE;
        short max = Short.MIN_VALUE;
        MyScanner scanner = new MyScanner(in);
        for (int i = 0; i < dim.nrows; ++i) {
            int ii;
            int n = ii = keepEvery == 1 ? i : i / keepEvery;
            if (isShort && (keepEvery == 1 || i % keepEvery == 0)) {
                vals[ii] = new short[dim2.ncols];
            }
            if (Utils.interrupt) {
                in.close();
                return null;
            }
            Utils.reportProgress(i * 100 / dim.nrows);
            for (int j = 0; j < dim.ncols; ++j) {
                int jj;
                String s = scanner.next();
                if (keepEvery != 1 && (i % keepEvery != 0 || j % keepEvery != 0)) continue;
                int n2 = jj = keepEvery == 1 ? j : j / keepEvery;
                if (isShort) {
                    try {
                        vals[ii][jj] = Short.parseShort(s);
                        if ((double)vals[ii][jj] != NODATA_value && vals[ii][jj] < min) {
                            min = vals[ii][jj];
                        }
                        if ((double)vals[ii][jj] != NODATA_value && vals[ii][jj] > max) {
                            max = vals[ii][jj];
                        }
                    }
                    catch (NumberFormatException e) {
                        isShort = false;
                        floatvals = new float[dim2.nrows][dim2.ncols];
                        for (int iii = 0; iii < ii; ++iii) {
                            for (int jjj = 0; jjj < dim2.ncols; ++jjj) {
                                floatvals[iii][jjj] = vals[iii][jjj];
                            }
                        }
                        for (int jjj = 0; jjj < jj; ++jjj) {
                            floatvals[ii][jjj] = vals[ii][jjj];
                        }
                        vals = null;
                    }
                }
                if (isShort) continue;
                try {
                    floatvals[ii][jj] = Float.parseFloat(s);
                }
                catch (NumberFormatException e) {
                    floatvals[ii][jj] = Float.parseFloat(s.replace(',', '.'));
                }
                if (!Double.isNaN(floatvals[ii][jj])) continue;
                floatvals[ii][jj] = (float)NODATA_value;
            }
        }
        in.close();
        String name = new File(fileName).getName();
        name = name.substring(0, name.length() - 4);
        if (isShort && min > -128 && max < 128) {
            byte[][] byteVals = new byte[dim2.nrows][];
            for (r = 0; r < dim2.nrows; ++r) {
                byteVals[r] = new byte[dim2.ncols];
                for (int c = 0; c < dim2.ncols; ++c) {
                    byteVals[r][c] = (byte)((double)vals[r][c] == NODATA_value ? -128 : (byte)vals[r][c]);
                }
                vals[r] = null;
            }
            Grid result = Grid.vals2Grid(dim2, byteVals, name, -128.0, compressGrids, false);
            return result;
        }
        if (isShort && min >= 0 && max < 255) {
            byte[][] byteVals = new byte[dim2.nrows][];
            for (r = 0; r < dim2.nrows; ++r) {
                byteVals[r] = new byte[dim2.ncols];
                for (int c = 0; c < dim2.ncols; ++c) {
                    byteVals[r][c] = (byte)((double)vals[r][c] == NODATA_value ? -1 : (byte)vals[r][c]);
                }
                vals[r] = null;
            }
            Grid result = Grid.vals2Grid(dim2, byteVals, name, 255.0, compressGrids, true);
            return result;
        }
        Grid result = isShort ? Grid.vals2Grid(dim2, vals, name, NODATA_value, compressGrids) : Grid.vals2Grid(dim2, floatvals, name, NODATA_value, compressGrids);
        return result;
    }

    static String nextHeaderVal(BufferedReader in) throws IOException {
        String s = in.readLine();
        StringTokenizer st = new StringTokenizer(s);
        st.nextToken();
        return st.nextToken();
    }

    static {
        GRDTypeNames.put("SMALLINT", "SHORT");
        GRDTypeNames.put("SINGLE", "FLOAT");
        GRDTypeNames.put("LONGINT", "INT");
        GRDTypeNames.put("INTEGER", "INT");
        GRDTypeNames.put("INT2BYTES", "SHORT");
        GRDTypeNames.put("FLT4BYTES", "FLOAT");
        GRDTypeNames.put("INT4BYTES", "INT");
        GRDTypeNames.put("FLT8BYTES", "DOUBLE");
        GRDTypeNames.put("INT2B", "SHORT");
        GRDTypeNames.put("FLT4B", "FLOAT");
        GRDTypeNames.put("INT4B", "INT");
        GRDTypeNames.put("FLT8B", "DOUBLE");
        GRDTypeNames.put("INT1B", "BYTE");
        GRDTypeNames.put("INT1S", "BYTE");
        GRDTypeNames.put("INT2S", "SHORT");
        GRDTypeNames.put("INT4S", "INT");
        GRDTypeNames.put("FLT4S", "FLOAT");
        GRDTypeNames.put("FLT8S", "DOUBLE");
        grdTypeName = new String[]{"INT2BYTES", "FLT4BYTES", "INT2BYTES", "INT4BYTES", "FLT8BYTES", "INT2BYTES"};
    }

    static class GRDHeader {
        GridDimension dim;
        int nativetype;
        double NODATA_value;
        String name;

        String getHdr(String field, HashMap map, String filename) {
            if (!map.containsKey(field)) {
                Utils.fatalException("File " + filename + " missing field " + field, null);
            }
            return (String)map.get(field);
        }

        void BILHeader(String fileName) throws IOException {
            boolean isfloat;
            String line;
            HashMap<String, String> map = new HashMap<String, String>();
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            while ((line = in.readLine()) != null) {
                String[] fields = line.replaceAll("\\s+", " ").split(" ");
                if (fields.length <= 1) continue;
                map.put(fields[0].toUpperCase(Locale.US), fields[1]);
            }
            int nr = Integer.parseInt(this.getHdr("NROWS", map, fileName));
            int nc = Integer.parseInt(this.getHdr("NCOLS", map, fileName));
            int nbands = Integer.parseInt(this.getHdr("NBANDS", map, fileName));
            int nbits = Integer.parseInt(this.getHdr("NBITS", map, fileName));
            double minx = Double.parseDouble(this.getHdr("ULXMAP", map, fileName));
            double maxy = Double.parseDouble(this.getHdr("ULYMAP", map, fileName));
            double xdim = Double.parseDouble(this.getHdr("XDIM", map, fileName));
            double ydim = Double.parseDouble(this.getHdr("YDIM", map, fileName));
            this.NODATA_value = Double.parseDouble(this.getHdr("NODATA", map, fileName));
            if (nbands != 1) {
                Utils.fatalException("File " + fileName + ": multiple bands not supported", null);
            }
            if (xdim != ydim) {
                Utils.fatalException("File " + fileName + ": different x and y resolution not supported", null);
            }
            this.dim = new GridDimension(minx - xdim / 2.0, maxy - ydim * ((double)nr - 0.5), xdim, nr, nc);
            this.name = new File(fileName).getName().replaceAll(".hdr", "");
            boolean bl = isfloat = map.containsKey("PIXELTYPE") && map.get("PIXELTYPE").equals("FLOAT");
            if (nbits == 8) {
                this.nativetype = 2;
            } else if (nbits == 16) {
                this.nativetype = 0;
            } else if (nbits == 32) {
                this.nativetype = isfloat ? 1 : 3;
            } else if (nbits == 64) {
                this.nativetype = 4;
            } else {
                Utils.fatalException("File " + fileName + ": unsupported data type " + nbits + " bits", null);
            }
        }

        double get2d(GetIniValueParser parser, String f1, String f2) {
            return Double.parseDouble(this.get2(parser, f1, f2));
        }

        int get2i(GetIniValueParser parser, String f1, String f2) {
            return Integer.parseInt(this.get2(parser, f1, f2));
        }

        String get2(GetIniValueParser parser, String f1, String f2) {
            String s = parser.getValue("GeoReference", f1);
            if (s.equals("")) {
                s = parser.getValue("GeoReference", f2);
            }
            return s;
        }

        public GRDHeader(String fileName) throws IOException {
            if (fileName.toLowerCase().endsWith(".hdr")) {
                this.BILHeader(fileName);
                return;
            }
            GetIniValueParser parser = new GetIniValueParser(fileName);
            int ncols = this.get2i(parser, "Columns", "ncols");
            int nrows = this.get2i(parser, "Rows", "nrows");
            double minx = this.get2d(parser, "MinX", "xmin");
            double maxx = this.get2d(parser, "MaxX", "xmax");
            double miny = this.get2d(parser, "MinY", "ymin");
            double cellsizex = (maxx - minx) / (double)ncols;
            double maxy = this.get2d(parser, "MaxY", "ymax");
            double cellsizey = (maxy - miny) / (double)nrows;
            if (cellsizex - cellsizey > cellsizex * 1.0E-6) {
                Utils.fatalException("Grid file " + fileName + ": different x and y resolution not supported", null);
            }
            String datatype = parser.getValue("Data", "DataType").toUpperCase(Locale.US);
            this.nativetype = -1;
            if (GRDTypeNames.containsKey(datatype)) {
                datatype = (String)GRDTypeNames.get(datatype);
            }
            for (int i = 0; i < Grid.typeName.length; ++i) {
                if (!Grid.typeName[i].equals(datatype)) continue;
                this.nativetype = i;
            }
            if (this.nativetype == -1) {
                Utils.fatalException("Grid file " + fileName + ": unsupported data type " + datatype, null);
            }
            this.NODATA_value = Double.parseDouble(parser.getValue("Data", "NoDataValue"));
            this.name = parser.getValue("General", "Title");
            this.dim = new GridDimension(minx, miny, cellsizex, nrows, ncols);
        }
    }
}

