/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Csv;
import density.Feature;
import density.Grid;
import density.GridDimension;
import density.GridSet;
import density.Layer;
import density.LayerFeature;
import density.Sample;
import density.SampleSet;
import density.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;

public class GridSetFromFile
extends GridSet {
    int nvars;
    double[][] allvals;
    String[] varnames;
    String fileName;

    public GridSetFromFile(String filename, Layer[] layers) throws IOException {
        this.fileName = filename;
        this.layers = layers;
        Utils.reportDoing("Reading file " + new File(this.fileName).getName());
        Utils.reportMemory("readGrid");
        final Csv csv = new Csv(this.fileName);
        if (layers != null) {
            for (int i = 0; i < layers.length; ++i) {
                if (csv.hasField(layers[i].getName()) && csv.fieldIndex(layers[i].getName()) >= SampleSet.firstEnvVar) continue;
                throw new IOException("File " + this.fileName + " missing variable " + layers[i].getName());
            }
        }
        this.nvars = layers == null ? csv.headers().length - SampleSet.firstEnvVar : layers.length;
        final int[] varindex = new int[this.nvars];
        this.varnames = new String[this.nvars];
        for (int i = 0; i < this.nvars; ++i) {
            if (layers == null) {
                this.varnames[i] = csv.headers()[i + SampleSet.firstEnvVar];
                varindex[i] = i + SampleSet.firstEnvVar;
                continue;
            }
            this.varnames[i] = layers[i].getName();
            varindex[i] = csv.fieldIndex(this.varnames[i]);
        }
        if (this.nvars < 1) {
            throw new IOException("File " + this.fileName + " missing environmental variable columns");
        }
        final ArrayList valsa = new ArrayList();
        final ArrayList coordsa = new ArrayList();
        try {
            Csv csv2 = csv;
            Objects.requireNonNull(csv2);
            csv.apply(new Csv.Applier(csv2){
                boolean warnedNodata = false;

                @Override
                public void process() {
                    double[] vals = new double[GridSetFromFile.this.nvars];
                    double[] coords = new double[]{Double.parseDouble(csv.get(SampleSet.xIndex)), Double.parseDouble(csv.get(SampleSet.yIndex))};
                    boolean skip = false;
                    for (int i = 0; i < vals.length; ++i) {
                        vals[i] = Double.parseDouble(csv.get(varindex[i]));
                        if (vals[i] != (double)SampleSet.NODATA_value) continue;
                        if (!this.warnedNodata) {
                            Utils.warn2("File " + new File(GridSetFromFile.this.fileName).getName() + " has value " + SampleSet.NODATA_value + ", treating as no-data value", "nodataInBackground");
                        }
                        this.warnedNodata = true;
                        skip = true;
                    }
                    if (!skip) {
                        valsa.add(vals);
                        coordsa.add(coords);
                    }
                }
            });
        }
        catch (NumberFormatException e) {
            throw new IOException("File " + this.fileName + ": " + e.getMessage());
        }
        this.allvals = (double[][])valsa.toArray((T[])new double[0][]);
        this.dimension = new GridDimension(0.0, 0.0, 1.0, 1, this.allvals.length);
        this.dimension.coords = (double[][])coordsa.toArray((T[])new double[0][]);
        this.dimension.coordNames = new String[]{csv.headers()[SampleSet.xIndex], csv.headers()[SampleSet.yIndex]};
    }

    Grid getGrid(String name) {
        int i;
        for (i = 0; i < this.varnames.length && !this.varnames[i].equals(name); ++i) {
        }
        if (i == this.varnames.length) {
            throw new RuntimeException("Can't find grid named " + name);
        }
        final int index = i;
        return new Grid(this.dimension, name){

            @Override
            public float eval(int r, int c) {
                return (float)GridSetFromFile.this.allvals[c][index];
            }

            @Override
            public boolean hasData(int r, int c) {
                return true;
            }
        };
    }

    @Override
    public Feature[] toFeatures() {
        if (this.features != null) {
            return this.features;
        }
        this.features = new Feature[this.nvars];
        for (int i = 0; i < this.nvars; ++i) {
            final int index = i;
            this.features[i] = new LayerFeature(this.getNumPoints(), this.varnames[i], this.layers == null ? 0 : this.layers[i].getType()){

                @Override
                public double eval(int p) {
                    return GridSetFromFile.this.allvals[p][index];
                }

                @Override
                public double eval(Sample s) {
                    if (!this.hasData(s)) {
                        throw new RuntimeException("Attempt to evaluate " + this.name + " at sample with no value");
                    }
                    return (Double)s.featureMap.get(this.name);
                }

                @Override
                public boolean hasData(Sample s) {
                    if (s.featureMap == null || !s.featureMap.containsKey(this.name)) {
                        Utils.fatalException("Sample missing data for variable " + this.name, null);
                    }
                    return s.featureMap.get(this.name) != null;
                }
            };
            this.featureNameMap.put(this.features[i].name, this.features[i]);
        }
        return this.features;
    }

    @Override
    public int getNumPoints() {
        return this.allvals.length;
    }
}

