/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.GUI;
import density.Params;
import density.Runner;
import density.Utils;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class MaxEnt {
    static void checkVersion() {
        String version = System.getProperties().getProperty("java.version");
        double v = Double.parseDouble(version);
        if (v < 8.0) {
            JOptionPane.showMessageDialog(null, "Java version is " + version + ", but Maxent needs 8.", "Error", 0);
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        final Params params = new Params();
        params.readFromArgs(args);
        Utils.applyStaticParams(params);
        if (params.getboolean("visible")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MaxEnt.createAndShowGUI(params);
                }
            });
        } else {
            params.setSelections();
            Runner runner = new Runner(params);
            runner.runSpatial();
        }
    }

    private static void createAndShowGUI(Params params) {
        JFrame f = Utils.topLevelFrame = new JFrame("Maximum Entropy Species Distribution Modeling, Version " + Utils.version + " | spatialMaxent extension, Version 1.0.0");
        f.setDefaultCloseOperation(3);
        GUI gui = new GUI(params);
        f.setContentPane(gui.createContentPane());
        GUI.topLevelFrame = f;
        gui.applyParams();
        f.pack();
        f.setVisible(true);
        if (params.getboolean("autoRun")) {
            gui.doRun(true);
        }
    }
}

