/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Csv;
import density.FeaturedSpace;
import density.GridSetDummy;
import density.Project;
import density.Runner;
import density.Sample;
import density.Utils;
import gnu.getopt.Getopt;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;

public class NceasApply {
    static String[] headers;
    static String outputformat;

    static Sample[] readSamples(String sampleFile) throws IOException {
        int i;
        final Csv csv = new Csv(sampleFile);
        headers = csv.headers();
        for (i = 0; i < headers.length && !headers[i].equals(""); ++i) {
        }
        final int last = i;
        final ArrayList samples = new ArrayList();
        Csv csv2 = csv;
        Objects.requireNonNull(csv2);
        csv.apply(new Csv.Applier(csv2){

            @Override
            public void process() {
                int j;
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                for (j = 0; j < 5; ++j) {
                    map.put(headers[j], csv.get(j));
                }
                for (j = 5; j < last; ++j) {
                    Double val = new Double(Double.parseDouble(csv.get(j)));
                    map.put(headers[j], val);
                    map.put(headers[j] + "a", val);
                }
                samples.add(new Sample(0, 0, 0, 0, 0, "", "", map));
            }
        });
        return samples.toArray(new Sample[0]);
    }

    public static void main(String[] args) {
        int c;
        String usage = "Usage: NceasApply [-c] [-l] lambdaFile [lambdaFile2...] sampleFile outPrefix";
        if (args.length < 3) {
            System.out.println(usage);
            System.exit(0);
        }
        Getopt g = new Getopt("NceasApply", args, "lrc");
        block17: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 99: {
                    outputformat = "cumulative";
                    continue block17;
                }
                case 108: {
                    outputformat = "logistic";
                    continue block17;
                }
                case 114: {
                    outputformat = "raw";
                    continue block17;
                }
            }
            System.out.println(usage);
            System.exit(0);
        }
        try {
            String sampleFile = args[args.length - 2];
            String outPrefix = args[args.length - 1];
            Sample[] samples = NceasApply.readSamples(sampleFile);
            for (int i = g.getOptind(); i < args.length - 2; ++i) {
                String lambdaFile = args[i];
                System.out.println(lambdaFile);
                String species = new File(lambdaFile).getName().replaceAll(".lambdas", "").toLowerCase();
                GridSetDummy gs = new GridSetDummy();
                FeaturedSpace X = new FeaturedSpace(gs, lambdaFile, true);
                PrintWriter out = Utils.writer(outPrefix + species + ".csv");
                double[][] raw2cum = null;
                raw2cum = Project.readCumulativeIndex(Runner.raw2cumfile(lambdaFile));
                out.println("dataset,siteid,pred");
                double entropy = X.entropy;
                for (int j = 0; j < samples.length; ++j) {
                    double val = Math.exp(X.linearPredictor(samples[j]) - X.getLinearPredictorNormalizer()) / X.getDensityNormalizer();
                    switch (outputformat) {
                        case "cloglog": {
                            val = Project.cloglog(val, entropy);
                            break;
                        }
                        case "logistic": {
                            val = Project.logistic(val, entropy, 0.5);
                            break;
                        }
                        case "cumulative": {
                            val = Project.interpolateCumulative(raw2cum, val);
                            break;
                        }
                        default: {
                            double max = raw2cum[0][raw2cum[0].length - 1];
                            if (!(val > max)) break;
                            val = max;
                        }
                    }
                    out.println(samples[j].featureMap.get("dataset") + "," + samples[j].featureMap.get("siteid") + "," + val);
                }
                out.close();
            }
        }
        catch (IOException e) {
            System.out.println("Error: " + e.toString());
            System.exit(1);
        }
    }

    static {
        outputformat = "cloglog";
    }
}

