/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ParallelRun {
    ExecutorService threadPool;
    Collection<Callable<Object>> tasks;
    boolean verbose = false;

    public ParallelRun(int nthreads) {
        this.threadPool = Executors.newFixedThreadPool(nthreads);
        this.tasks = new ArrayList<Callable<Object>>();
    }

    public void clear() {
        this.tasks.clear();
    }

    public void add(final Runnable task, final String name) {
        Runnable vtask = new Runnable(){

            @Override
            public void run() {
                if (ParallelRun.this.verbose) {
                    System.out.println("Starting " + name);
                }
                task.run();
                if (ParallelRun.this.verbose) {
                    System.out.println("Ending " + name);
                }
            }
        };
        this.tasks.add(Executors.callable(vtask));
    }

    public void runall(String runtype, boolean verbose) {
        this.verbose = verbose;
        List<Future<Object>> futures = null;
        try {
            futures = this.threadPool.invokeAll(this.tasks);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (futures != null) {
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException ex) {
                    Utils.fatalException("Error in parallel " + runtype, ex);
                }
            }
        }
    }

    public void close() {
        this.threadPool.shutdown();
    }
}

