/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Csv;
import density.DoubleIndexSort;
import density.Evaluate;
import density.Feature;
import density.Sample;
import density.tools.Stats;
import java.io.IOException;
import java.util.Random;

public class PermutationImportance {
    int np;
    int nb;
    int nv;
    String[] vars;
    Evaluate eval;
    Random generator = new Random(11111L);

    public static void main(String[] args) {
        try {
            new PermutationImportance().go(args);
        }
        catch (IOException e) {
            System.out.println("Error: " + e);
            System.exit(0);
        }
    }

    void error(String s) {
        System.out.println(s);
        System.exit(1);
    }

    void go(String[] args) throws IOException {
        String usage = "Usage: PermutationImportance swdPresence swdBackground lmbdafile";
        if (args.length < 3) {
            System.out.println(usage);
            System.exit(0);
        }
        String pres = args[0];
        String back = args[1];
        String lambdas = args[2];
        Csv prescsv = new Csv(pres);
        Csv backcsv = new Csv(back);
        this.nv = prescsv.headers().length - 3;
        this.vars = new String[this.nv];
        if (backcsv.headers().length - 3 != this.nv) {
            this.error(back + " and " + pres + " have different numbers of fields");
        }
        for (int i = 0; i < this.nv; ++i) {
            this.vars[i] = prescsv.headers()[i + 3];
            if (backcsv.headers()[i + 3].equals(this.vars[i])) continue;
            this.error("Variable names in " + back + " and " + pres + " differ:" + backcsv.headers()[i + 3] + " " + this.vars[i]);
        }
        double[][] pvals = prescsv.getDoubleAllCols(3);
        double[][] bvals = backcsv.getDoubleAllCols(3);
        double[] aucdiffs = this.importance(pvals, bvals, lambdas);
        for (int i = 0; i < this.nv; ++i) {
            System.out.println(this.vars[i] + " " + aucdiffs[i]);
        }
    }

    public double[] go(Feature[] features, Sample[] samples, String lambdafile) throws IOException {
        this.nv = features.length;
        this.np = samples.length;
        this.nb = features[0].getN();
        double[][] pvals = new double[this.np][this.nv];
        double[][] bvals = new double[this.nb][this.nv];
        this.vars = new String[this.nv];
        for (int v = 0; v < this.nv; ++v) {
            this.vars[v] = features[v].name;
            for (int p = 0; p < this.np; ++p) {
                pvals[p][v] = features[v].eval(samples[p]);
            }
            for (int b = 0; b < this.nb; ++b) {
                bvals[b][v] = features[v].eval(b);
            }
        }
        return this.importance(pvals, bvals, lambdafile);
    }

    double[] importance(double[][] pvals, double[][] bvals, String lambdas) throws IOException {
        int i;
        int j;
        int i2;
        this.eval = new Evaluate(lambdas);
        this.np = pvals.length;
        this.nb = bvals.length;
        double[][] allvals = new double[this.np + this.nb][this.nv];
        for (i2 = 0; i2 < this.np; ++i2) {
            for (j = 0; j < this.nv; ++j) {
                allvals[i2][j] = pvals[i2][j];
            }
        }
        for (i2 = 0; i2 < this.nb; ++i2) {
            for (j = 0; j < this.nv; ++j) {
                allvals[i2 + this.np][j] = bvals[i2][j];
            }
        }
        double originalAUC = this.auc(allvals);
        double[] aucdiffs = new double[this.nv];
        for (int i3 = 0; i3 < this.nv; ++i3) {
            aucdiffs[i3] = originalAUC - this.auc(allvals, i3, this.permutation(this.np + this.nb));
            if (!(aucdiffs[i3] < 0.0)) continue;
            aucdiffs[i3] = 0.0;
        }
        double tot = 0.0;
        for (i = 0; i < this.nv; ++i) {
            tot += aucdiffs[i];
        }
        for (i = 0; i < this.nv; ++i) {
            int n = i;
            aucdiffs[n] = aucdiffs[n] * (tot <= 0.0 ? 0.0 : 100.0 / tot);
        }
        return aucdiffs;
    }

    void dump(double[] x) {
        for (double xx : x) {
            System.out.print(xx + "  ");
        }
        System.out.println();
    }

    int[] permutation(int n) {
        double[] x = new double[n];
        for (int i = 0; i < n; ++i) {
            x[i] = this.generator.nextDouble();
        }
        return DoubleIndexSort.sort(x);
    }

    double eval(double[] v) {
        for (int i = 0; i < this.nv; ++i) {
            this.eval.setValue(this.vars[i], v[i]);
        }
        return this.eval.evaluate();
    }

    double[] eval(double[][] v, int index, int[] permutation) {
        double[] result = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            double[] vv = (double[])v[i].clone();
            if (permutation != null) {
                vv[index] = v[permutation[i]][index];
            }
            result[i] = this.eval(vv);
        }
        return result;
    }

    double auc(double[][] a) {
        return this.auc(a, 0, null);
    }

    double auc(double[][] a, int index, int[] permutation) {
        int i;
        double[] pred = this.eval(a, index, permutation);
        double[] ppred = new double[this.np];
        double[] bpred = new double[this.nb];
        for (i = 0; i < this.np; ++i) {
            ppred[i] = pred[i];
        }
        for (i = 0; i < this.nb; ++i) {
            bpred[i] = pred[i + this.np];
        }
        return Stats.auc(ppred, bpred);
    }
}

