/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Csv;
import density.Extractor;
import density.Grid;
import density.GridDimension;
import density.GridSetFromFile;
import density.GridWriter;
import density.Layer;
import density.LazyGrid;
import density.Params;
import density.Runner;
import density.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.StringTokenizer;

public class Project {
    HashMap gridMap = new HashMap();
    HashMap clampedGridMap = new HashMap();
    double linearPredictorNormalizer;
    double densityNormalizer;
    int numPointsForNormalizer;
    String gridDir;
    GridSetFromFile gs = null;
    boolean doClamp;
    Grid priorDistribution = null;
    Layer[] needLayers;
    double entropy = -1.0;
    double prednoclamp;
    double predclamp;
    boolean outGridHasData;
    Params params;
    double[][] raw2cum = null;
    ArrayList<Pfeature> allFeatures;
    public boolean mapping = false;
    public boolean exponent = false;
    public HashMap varmap;

    public Project(Params params) {
        this.params = params;
        this.doClamp = this.is("doClamp");
    }

    boolean is(String s) {
        return this.params.getboolean(s);
    }

    boolean cumulative() {
        return this.params.cumulative();
    }

    Grid[] allGrids() {
        ArrayList result = new ArrayList();
        Iterator it = this.gridMap.keySet().iterator();
        while (it.hasNext()) {
            result.add(this.gridMap.get(it.next()));
        }
        return result.toArray(new Grid[0]);
    }

    ClampedGrid[] allClampedGrids() {
        return this.clampedGridMap.values().toArray(new ClampedGrid[0]);
    }

    Grid getGrid(String s) throws IOException {
        if (!this.gridMap.containsKey(s)) {
            this.gridMap.put(s, this.newGrid(s));
        }
        return (Grid)this.gridMap.get(s);
    }

    Grid getClampedGrid(String s) throws IOException {
        if (!this.clampedGridMap.containsKey(s)) {
            return this.getGrid(s);
        }
        return (Grid)this.clampedGridMap.get(s);
    }

    Grid revGrid(final Grid g) {
        return new Grid(this, g.getDimension(), g.name){

            @Override
            public float eval(int r, int c) {
                return -g.eval(r, c);
            }

            @Override
            public boolean hasData(int r, int c) {
                return g.hasData(r, c);
            }
        };
    }

    Grid mapGrid(final String filename) {
        return new Grid(new GridDimension(0.0, 0.0, 1.0, 0, 0), filename){

            @Override
            public float eval(int r, int c) {
                return (float)((Double)Project.this.varmap.get(filename)).doubleValue();
            }

            @Override
            public boolean hasData(int r, int c) {
                return true;
            }
        };
    }

    Grid newGrid(String filename) throws IOException {
        if (this.mapping) {
            return this.mapGrid(filename);
        }
        if (this.gs != null) {
            return this.gs.getGrid(filename);
        }
        String path = Utils.getGridAbsolutePath(this.gridDir, filename);
        if (path == null) {
            Utils.interrupt = true;
        }
        if (Utils.interrupt) {
            return null;
        }
        String cfilename = Extractor.CachedGridFilename(path, true);
        return new LazyGrid(cfilename);
    }

    public void doProject(String lambdaFile, String gridDir, String outFile) throws IOException {
        this.doProject(lambdaFile, gridDir, outFile, null);
    }

    public void doProject(String lambdaFile, GridSetFromFile gs, String outFile) throws IOException {
        this.gs = gs;
        this.doProject(lambdaFile, null, outFile, null);
    }

    public void doProject(String lambdaFile, String gridDir, String outFile, String clampedFileName) throws IOException {
        Utils.reportDoing("Projecting...");
        Grid[] outGrids = this.projectGrid(lambdaFile, gridDir);
        if (clampedFileName == null) {
            outGrids = new Grid[]{outGrids[0]};
        }
        if (!Utils.interrupt) {
            outGrids[0].name = outGrids[0].name + " " + this.params.getString("outputformat") + " values";
            String[] filenames = new String[]{outFile, clampedFileName};
            GridWriter.writeGrids(outGrids, filenames, this.cumulative());
        }
        this.close();
    }

    public HashSet gridNames() {
        HashSet<String> result = new HashSet<String>();
        for (Grid g : this.allGrids()) {
            result.add(g.getName());
        }
        return result;
    }

    void close() throws IOException {
        Grid[] grids = this.allGrids();
        for (int i = 0; i < grids.length; ++i) {
            if (!(grids[i] instanceof LazyGrid)) continue;
            ((LazyGrid)grids[i]).close();
        }
    }

    public Grid[] projectGrid(final String lambdaFile, String gridDir) throws IOException {
        String line;
        if (gridDir != null && new File(gridDir).isFile()) {
            this.gs = new GridSetFromFile(gridDir, this.needLayers);
        }
        this.gridDir = gridDir;
        BufferedReader in = new BufferedReader(new File(lambdaFile).exists() ? new FileReader(lambdaFile) : new StringReader(lambdaFile));
        String gridname = new File(lambdaFile).getName().replaceAll(".lambdas", "");
        this.allFeatures = new ArrayList();
        ArrayList<Double> allLambdas = new ArrayList<Double>();
        ArrayList allGrids = new ArrayList();
        while ((line = in.readLine()) != null) {
            Object gg;
            StringTokenizer st = new StringTokenizer(line, ",");
            String descr = st.nextToken();
            double lambda = Double.parseDouble(st.nextToken());
            double min = 0.0;
            double max = 1.0;
            if (st.hasMoreTokens()) {
                min = Double.parseDouble(st.nextToken());
                max = Double.parseDouble(st.nextToken());
            }
            Pfeature g = null;
            int index = descr.indexOf(42);
            if (index != -1) {
                f0 = descr.substring(0, index);
                String f1 = descr.substring(index + 1);
                g = new ProductGrid(this, this.getClampedGrid(f0), this.getClampedGrid(f1));
            } else {
                index = descr.indexOf("^2");
                if (index != -1) {
                    f0 = descr.substring(0, index);
                    g = new SquareGrid(this, this.getClampedGrid(f0));
                } else {
                    index = descr.indexOf("^p");
                    if (index != -1) {
                        f0 = descr.substring(0, index);
                        g = new PolyhedralGrid(this, this.getClampedGrid(f0));
                    } else {
                        index = descr.indexOf(61);
                        if (index != -1) {
                            f0 = descr.substring(1, index);
                            double val = Double.parseDouble(descr.substring(index + 1, descr.length() - 1));
                            Grid gg2 = this.getGrid(f0);
                            if (Utils.interrupt) {
                                return null;
                            }
                            g = new BinaryGrid(this, gg2, val);
                        } else {
                            index = descr.indexOf(60);
                            if (index != -1) {
                                f0 = descr.substring(index + 1, descr.length() - 1);
                                double val = Double.parseDouble(descr.substring(1, index));
                                g = new ThresholdGrid(this, this.getGrid(f0), val);
                            } else {
                                index = descr.indexOf(39);
                                if (index != -1) {
                                    f0 = descr.substring(index + 1);
                                    allLambdas.add(new Double(lambda));
                                    gg = new HingeGrid(this.getGrid(f0), min, max);
                                    gg.name = descr;
                                    this.allFeatures.add(gg);
                                } else {
                                    index = descr.indexOf(96);
                                    if (index != -1) {
                                        f0 = descr.substring(index + 1);
                                        allLambdas.add(new Double(lambda));
                                        gg = new HingeGrid(this.revGrid(this.getGrid(f0)), -max, -min);
                                        gg.name = descr;
                                        this.allFeatures.add(gg);
                                    } else if (descr.equals("linearPredictorNormalizer")) {
                                        this.linearPredictorNormalizer = lambda;
                                    } else if (descr.equals("densityNormalizer")) {
                                        this.densityNormalizer = lambda;
                                    } else if (descr.equals("numBackgroundPoints")) {
                                        this.numPointsForNormalizer = (int)lambda;
                                    } else if (descr.equals("entropy")) {
                                        this.entropy = lambda;
                                    } else {
                                        gg = this.getGrid(descr);
                                        if (Utils.interrupt) {
                                            return null;
                                        }
                                        g = new LinearGrid(this, (Grid)gg);
                                        this.clampedGridMap.put(descr, new ClampedGrid((Grid)gg, min, max));
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (g == null) continue;
            gg = new ScaledGrid(g, min, max);
            allLambdas.add(new Double(lambda));
            this.allFeatures.add((Pfeature)gg);
            ((Pfeature)gg).name = descr;
        }
        final Grid[] grids = this.allGrids();
        final Pfeature[] features = this.allFeatures.toArray(new Pfeature[0]);
        final double[] lambdas = new double[features.length];
        double[] abslambdas = new double[features.length];
        for (int i = 0; i < lambdas.length; ++i) {
            lambdas[i] = (Double)allLambdas.get(i);
            abslambdas[i] = Math.abs((Double)allLambdas.get(i));
        }
        GridDimension dim = grids[0].getDimension();
        for (int i = 1; i < grids.length; ++i) {
            if (grids[i].getDimension().equals(dim)) continue;
            throw new IOException("Files " + grids[0].getName() + " and " + grids[i].getName() + " in directory " + gridDir + " have different geographic dimensions");
        }
        final double dN = this.densityNormalizer;
        final double lPN = this.linearPredictorNormalizer;
        final ClampedGrid[] cgrids = this.allClampedGrids();
        Grid outGrid = new Grid(dim, gridname){
            final boolean fade;
            final boolean minclamp;
            final boolean strictClamp;
            {
                super(dim, s);
                if (Project.this.cumulative() && Project.this.raw2cum == null) {
                    Project.this.raw2cum = Project.readCumulativeIndex(Runner.raw2cumfile(lambdaFile));
                }
                this.fade = Project.this.is("fadeByClamping");
                this.minclamp = Project.this.is("minClamping");
                this.strictClamp = !Project.this.is("extrapolate");
            }

            @Override
            public boolean hasData(int r, int c) {
                Project.this.outGridHasData = false;
                for (int i = 0; i < grids.length; ++i) {
                    if (grids[i].hasData(r, c)) continue;
                    return false;
                }
                if (Project.this.priorDistribution != null && !Project.this.priorDistribution.hasData(r, c)) {
                    return false;
                }
                Project.this.outGridHasData = true;
                return true;
            }

            boolean wouldExtrapolate(int r, int c) {
                for (int i = 0; i < cgrids.length; ++i) {
                    if (!cgrids[i].wouldClamp(r, c)) continue;
                    return true;
                }
                return false;
            }

            double plainsum(int r, int c) {
                double sum = 0.0;
                for (int i = 0; i < features.length; ++i) {
                    if (lambdas[i] == 0.0) continue;
                    sum += lambdas[i] * features[i].eval(r, c);
                }
                return sum;
            }

            double pred(int r, int c, boolean complaints) {
                double sum = this.plainsum(r, c);
                if (Project.this.exponent) {
                    return sum - lPN;
                }
                double pred = Math.exp(sum - lPN) / dN;
                if (pred > 1.0) {
                    pred = 1.0;
                }
                if (Project.this.priorDistribution != null) {
                    pred *= (double)Project.this.priorDistribution.eval(r, c);
                }
                if (Project.this.entropy != -1.0 && Project.this.params.logistic()) {
                    pred = Project.this.logistic(pred, Project.this.entropy);
                }
                if (Project.this.entropy != -1.0 && Project.this.params.cloglog()) {
                    pred = Project.cloglog(pred, Project.this.entropy);
                }
                if (Double.isNaN(pred) || Double.isInfinite(pred) || Float.isInfinite((float)pred)) {
                    double newPred;
                    double d = sum > lPN ? (Project.this.cumulative() ? 100.0 : 1.0) : (newPred = 0.0);
                    if (complaints) {
                        Utils.warn("Setting prediction at row " + r + " column " + c + " to " + newPred + ", was " + pred + "; sum=" + sum + " lPN " + lPN + " pred=" + pred + " dN=" + dN + " entropy=" + Project.this.entropy);
                    }
                    pred = newPred;
                }
                if (Project.this.cumulative()) {
                    return Project.interpolateCumulative(Project.this.raw2cum, pred);
                }
                return pred;
            }

            @Override
            public float eval(int r, int c) {
                Project.this.doClamp = Project.this.is("doClamp");
                double pred = Project.this.predclamp = this.pred(r, c, true);
                if (Project.this.doClamp) {
                    Project.this.doClamp = false;
                    Project.this.prednoclamp = this.pred(r, c, false);
                    Project.this.doClamp = true;
                } else {
                    Project.this.prednoclamp = Project.this.predclamp;
                }
                if (Project.this.prednoclamp < pred && this.minclamp) {
                    pred = Project.this.prednoclamp;
                }
                if (this.strictClamp && this.wouldExtrapolate(r, c)) {
                    double d = pred = Project.this.exponent ? -100.0 : 0.0;
                }
                if (this.fade && (pred -= Math.abs(Project.this.predclamp - Project.this.prednoclamp)) < 0.0 && !Project.this.exponent) {
                    pred = 0.0;
                }
                return (float)pred;
            }
        };
        Grid clampGrid = new Grid(dim, "Clamping"){

            @Override
            public boolean hasData(int r, int c) {
                return Project.this.outGridHasData;
            }

            @Override
            public float eval(int r, int c) {
                return (float)Math.abs(Project.this.predclamp - Project.this.prednoclamp);
            }
        };
        return new Grid[]{outGrid, clampGrid};
    }

    double logistic(double raw, double entropy) {
        return Project.logistic(raw, entropy, this.params.getDefaultprevalence());
    }

    static double logistic(double raw, double entropy, double dp) {
        double v = raw * Math.exp(entropy);
        return dp * v / (1.0 - dp + dp * v);
    }

    static double cloglog(double raw, double entropy) {
        return 1.0 - Math.exp(-raw * Math.exp(entropy));
    }

    double occurrenceProbability(double raw, double entropy) {
        return this.params.logistic() ? this.logistic(raw, entropy) : Project.cloglog(raw, entropy);
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage: density.Project lambdaFile gridDir outFile [args]");
            System.exit(0);
        }
        String lambdaFile = args[0];
        String gridDir = args[1];
        String outFile = args[2];
        try {
            Params params = new Params();
            Utils.applyStaticParams(params);
            if (args.length > 3) {
                String[] subargs = new String[args.length - 3];
                for (int i = 0; i < subargs.length; ++i) {
                    subargs[i] = args[i + 3];
                }
                params.readFromArgs(subargs);
            }
            String clampout = params.getboolean("writeClampGrid") ? outFile.substring(0, outFile.length() - 4) + "_clamping" + outFile.substring(outFile.length() - 4) : null;
            Project project = new Project(params);
            project.doProject(lambdaFile, gridDir, outFile, clampout);
        }
        catch (IOException e) {
            System.out.println("Error: " + e.toString());
            System.exit(1);
        }
    }

    public static double[][] readCumulativeIndex(String filename) throws IOException {
        Csv csv;
        final ArrayList raw = new ArrayList();
        final ArrayList cumulative = new ArrayList();
        Csv csv2 = csv = new Csv(filename);
        Objects.requireNonNull(csv2);
        csv.apply(new Csv.Applier(csv2){

            @Override
            public void process() {
                String[] fields = csv.getCurrentRecord();
                raw.add(new Double(Double.parseDouble(fields[0].replaceAll(",", "."))));
                cumulative.add(new Double(Double.parseDouble(fields[1].replaceAll(",", "."))));
            }
        });
        return Project.rawcumaa2raw2cum(raw, cumulative);
    }

    static double[][] rawcumaa2raw2cum(ArrayList raw, ArrayList cumulative) {
        return new double[][]{Utils.doubleArrayList2Array(raw), Utils.doubleArrayList2Array(cumulative)};
    }

    static double interpolateCumulative(double[][] raw2cum, double t) {
        return Project.interpolateCumulative(raw2cum[0], raw2cum[1], t);
    }

    static double interpolateCumulative(double[] raw, double[] cumulative, double t) {
        int index = Arrays.binarySearch(raw, t);
        if (index >= 0) {
            return cumulative[index];
        }
        if ((index = -index - 1) == 0) {
            return t / raw[0] * cumulative[0];
        }
        if (index == raw.length) {
            return cumulative[raw.length - 1];
        }
        double frac = (t - raw[index - 1]) / (raw[index] - raw[index - 1]);
        double result = cumulative[index - 1] + frac * (cumulative[index] - cumulative[index - 1]);
        return result;
    }

    class ClampedGrid
    extends Grid {
        double min;
        double max;
        Grid g;

        public ClampedGrid(Grid g, double min, double max) {
            this.g = g;
            this.min = min;
            this.max = max;
        }

        @Override
        public boolean hasData(int r, int c) {
            return this.g.hasData(r, c);
        }

        public boolean wouldClamp(int r, int c) {
            if (!this.hasData(r, c)) {
                return false;
            }
            float val = this.g.eval(r, c);
            return (double)val < this.min || (double)val > this.max;
        }

        @Override
        public float eval(int r, int c) {
            float val = this.g.eval(r, c);
            if (!Project.this.doClamp) {
                return val;
            }
            if ((double)val < this.min) {
                return (float)this.min;
            }
            if ((double)val > this.max) {
                return (float)this.max;
            }
            return val;
        }
    }

    class ProductGrid
    extends Pfeature {
        Grid g0;
        Grid g1;

        public ProductGrid(Project this$0, Grid g0, Grid g1) {
            super(this$0);
            this.g0 = g0;
            this.g1 = g1;
        }

        @Override
        public double eval(int r, int c) {
            return (double)this.g0.eval(r, c) * (double)this.g1.eval(r, c);
        }
    }

    class SquareGrid
    extends Pfeature {
        Grid g0;

        public SquareGrid(Project this$0, Grid g0) {
            super(this$0);
            this.g0 = g0;
        }

        @Override
        public double eval(int r, int c) {
            double val = this.g0.eval(r, c);
            return val * val;
        }
    }

    class PolyhedralGrid
    extends Pfeature {
        Grid g0;

        public PolyhedralGrid(Project this$0, Grid g0) {
            super(this$0);
            this.g0 = g0;
        }

        @Override
        public double eval(int r, int c) {
            double val = this.g0.eval(r, c);
            return (val - val * val) / 4.0;
        }
    }

    class BinaryGrid
    extends Pfeature {
        Grid g0;
        double val;

        public BinaryGrid(Project this$0, Grid g0, double val) {
            super(this$0);
            this.g0 = g0;
            this.val = val;
        }

        @Override
        public double eval(int r, int c) {
            return (double)this.g0.eval(r, c) == this.val ? 1.0 : 0.0;
        }
    }

    class ThresholdGrid
    extends Pfeature {
        Grid g0;
        double val;

        public ThresholdGrid(Project this$0, Grid g0, double val) {
            super(this$0);
            this.g0 = g0;
            this.val = val;
        }

        @Override
        public double eval(int r, int c) {
            return (double)this.g0.eval(r, c) >= this.val ? 1.0 : 0.0;
        }
    }

    class HingeGrid
    extends Pfeature {
        Grid g0;
        double min;
        double max;

        public HingeGrid(Grid g0, double min, double max) {
            super(Project.this);
            this.g0 = g0;
            this.min = min;
            this.max = max;
        }

        @Override
        public double eval(int r, int c) {
            double val;
            double x = this.g0.eval(r, c);
            double d = val = x <= this.min ? 0.0 : (x - this.min) / (this.max - this.min);
            if (!Project.this.doClamp) {
                return val;
            }
            if (x > this.max) {
                return 1.0;
            }
            return val;
        }
    }

    class LinearGrid
    extends Pfeature {
        Grid g;

        public LinearGrid(Project this$0, Grid g) {
            super(this$0);
            this.g = g;
        }

        @Override
        public double eval(int r, int c) {
            return this.g.eval(r, c);
        }
    }

    class ScaledGrid
    extends Pfeature {
        Pfeature g0;
        double min;
        double max;

        public ScaledGrid(Pfeature g0, double min, double max) {
            super(Project.this);
            this.g0 = g0;
            this.min = min;
            this.max = max;
        }

        @Override
        public double eval(int r, int c) {
            double val = (this.g0.eval(r, c) - this.min) / (this.max - this.min);
            if (!Project.this.doClamp) {
                return val;
            }
            if (val < 0.0) {
                return 0.0;
            }
            if (val > 1.0) {
                return 1.0;
            }
            return val;
        }
    }

    abstract class Pfeature {
        String name;

        Pfeature(Project this$0) {
        }

        abstract double eval(int var1, int var2);
    }
}

