/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Grid;
import density.GridDimension;
import density.GridIO;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;

public class RandomSample2 {
    public static void main(String[] args) {
        int i;
        int index;
        int r;
        int c;
        int i2;
        if (args.length < 3) {
            System.out.println("Usage: RandomSample distributionFile biasFile numSamples");
            System.exit(1);
        }
        String distr = args[0];
        String bias = args[1];
        int numSamples = Integer.parseInt(args[2]);
        Grid grid = null;
        Grid biasGrid = null;
        try {
            grid = GridIO.readGrid(distr);
            biasGrid = GridIO.readGrid(bias);
        }
        catch (IOException e) {
            System.out.println("Error reading files: " + e.toString());
            System.exit(1);
        }
        GridDimension dim = grid.getDimension();
        System.out.println("Species,long,lat");
        Random generator = new Random(System.currentTimeMillis());
        double[] closestDist = new double[numSamples];
        double[] cumulative = new double[numSamples];
        for (i2 = 0; i2 < numSamples; ++i2) {
            closestDist[i2] = 101.0;
        }
        for (i2 = 0; i2 < numSamples; ++i2) {
            cumulative[i2] = generator.nextDouble() * 100.0;
        }
        Arrays.sort(cumulative);
        for (int c2 = 0; c2 < dim.ncols; ++c2) {
            for (int r2 = 0; r2 < dim.nrows; ++r2) {
                int i3;
                if (!grid.hasData(r2, c2)) continue;
                double val = grid.eval(r2, c2);
                int index2 = Arrays.binarySearch(cumulative, val);
                if (index2 < 0) {
                    index2 = -index2 - 1;
                }
                for (i3 = index2; i3 < numSamples && Math.abs(val - cumulative[i3]) < closestDist[i3]; ++i3) {
                    closestDist[i3] = Math.abs(val - cumulative[i3]);
                }
                for (i3 = index2 - 1; i3 >= 0 && Math.abs(val - cumulative[i3]) < closestDist[i3]; --i3) {
                    closestDist[i3] = Math.abs(val - cumulative[i3]);
                }
            }
        }
        int[] cnt = new int[numSamples];
        int[] select = new int[numSamples];
        for (c = 0; c < dim.ncols; ++c) {
            for (r = 0; r < dim.nrows; ++r) {
                if (!grid.hasData(r, c)) continue;
                double val = grid.eval(r, c);
                index = Arrays.binarySearch(cumulative, val);
                if (index < 0) {
                    index = -index - 1;
                }
                i = index;
                while (i < numSamples && Math.abs(val - cumulative[i]) == closestDist[i]) {
                    int n = i++;
                    cnt[n] = cnt[n] + 1;
                }
                i = index - 1;
                while (i >= 0 && Math.abs(val - cumulative[i]) == closestDist[i]) {
                    int n = i--;
                    cnt[n] = cnt[n] + 1;
                }
            }
        }
        for (int i4 = 0; i4 < numSamples; ++i4) {
            select[i4] = (int)(generator.nextDouble() * (double)cnt[i4]);
        }
        for (c = 0; c < dim.ncols; ++c) {
            for (r = 0; r < dim.nrows; ++r) {
                if (!grid.hasData(r, c)) continue;
                double val = grid.eval(r, c);
                index = Arrays.binarySearch(cumulative, val);
                if (index < 0) {
                    index = -index - 1;
                }
                i = index;
                while (i < numSamples && Math.abs(val - cumulative[i]) == closestDist[i]) {
                    if (select[i] == 0 && generator.nextDouble() <= (double)biasGrid.eval(r, c)) {
                        System.out.println("Rnd," + dim.toX(c) + "," + dim.toY(r));
                    }
                    int n = i++;
                    select[n] = select[n] - 1;
                }
                i = index - 1;
                while (i >= 0 && Math.abs(val - cumulative[i]) == closestDist[i]) {
                    if (select[i] == 0 && generator.nextDouble() <= (double)biasGrid.eval(r, c)) {
                        System.out.println("Rnd," + dim.toX(c) + "," + dim.toY(r));
                    }
                    int n = i--;
                    select[n] = select[n] - 1;
                }
            }
        }
    }
}

