/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Params;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Locale;
import javax.imageio.ImageIO;
import ptolemy.plot.MyPlot;

public class ResponsePlot
extends MyPlot {
    void makeplot(double[] x, double[] y, double[] stddev, boolean capstddev, boolean iscategorical, String title) {
        int i;
        if (title != null) {
            this.setTitle(title);
        }
        if (iscategorical) {
            this.setBars(0.5, 0.1);
        }
        for (i = 0; i < x.length; ++i) {
            double xloc = x[i];
            this.addPoint(0, xloc, y[i], !iscategorical);
            if (stddev == null) continue;
            this.addPoint(1, xloc, y[i] < 1.0 - stddev[i] || !capstddev ? y[i] + stddev[i] : 1.0, !iscategorical);
            this.addPoint(iscategorical ? 2 : 1, xloc, y[i] > stddev[i] || !capstddev ? y[i] - stddev[i] : 0.0, !iscategorical);
        }
        if (iscategorical) {
            for (i = 0; i < x.length; ++i) {
                double c = x[i];
                if (c == (double)((int)c)) {
                    this.addXTick("" + (int)c, c);
                    continue;
                }
                this.addXTick("" + c, c);
            }
        }
    }

    void makeplot(double[] x, double[] y, double[] stddev, boolean iscategorical, String var, String title, String ylabel, String outfile, double mmin, double mmax, Params params, boolean exponent, boolean writePlotData) throws IOException {
        this.setSize(600, 400);
        this.setXLabel(var);
        this.setYLabel(ylabel);
        this.makeplot(x, y, stddev, !exponent, iscategorical, title);
        if (writePlotData) {
            PrintWriter plotDataOut = new PrintWriter(new FileOutputStream(outfile + ".dat"));
            plotDataOut.println("variable,x,y");
            for (int i = 0; i < x.length; ++i) {
                plotDataOut.println(var + "," + x[i] + "," + y[i]);
            }
            plotDataOut.close();
        }
        String filename = outfile + ".png";
        String filename2 = outfile + "_thumb.png";
        ImageIO.write((RenderedImage)this.exportImage(), "png", new File(filename));
        this.setSize(210, 140);
        this.setTitle(var);
        this.setXLabel("");
        this.setYLabel("");
        this._topPadding = 5;
        this._bottomPadding = 0;
        this._rightPadding = 0;
        this._leftPadding = 0;
        if (params.occurrenceProbability() && !exponent) {
            this.setYRange(0.0, 1.0);
        }
        if (params.cumulative() && !exponent) {
            this.setYRange(0.0, 100.0);
        }
        this.setTitleFont("Helvetica bold 12");
        this.setLabelFont("Helvetica plain 9");
        this.setSuperscriptFont("Helvetica plain 6");
        if (!iscategorical) {
            NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
            nf.setGroupingUsed(false);
            nf.setMaximumFractionDigits(3);
            this.addXTick(nf.format(mmin), mmin);
            this.addXTick(nf.format(mmax), mmax);
        }
        this.repaint();
        ImageIO.write((RenderedImage)this.exportImage(), "png", new File(filename2));
    }
}

