/*
 * Decompiled with CFR 0.152.
 */
package density;

import com.google.common.collect.Sets;
import density.AvgStderr;
import density.BinaryFeature;
import density.CachedScaledFeature;
import density.ClampedFeature;
import density.Csv;
import density.CsvWriter;
import density.Display;
import density.DoubleIndexSort;
import density.DoubleIterator;
import density.Extractor;
import density.Feature;
import density.FeatureWithSamplesAsPoints;
import density.FeaturedSpace;
import density.GUI;
import density.Grid;
import density.GridDimension;
import density.GridSet;
import density.GridSetFromFile;
import density.HingeGeneratorFeature;
import density.Layer;
import density.LayerFeature;
import density.LazyGrid;
import density.LinearFeature;
import density.ParallelRun;
import density.Parameter;
import density.Params;
import density.PermutationImportance;
import density.PolyhedralFeature;
import density.ProductFeature;
import density.Project;
import density.ResponsePlot;
import density.Sample;
import density.SampleSet;
import density.SampleSet2;
import density.ScaledFeature;
import density.Sequential;
import density.ShrunkGrid;
import density.SquareFeature;
import density.ThrGeneratorFeature;
import density.Threshold;
import density.Utils;
import density.tools.Novel;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import ptolemy.plot.MyPlot;

public class Runner {
    static GridSet gs;
    static SampleSet sampleSet;
    static SampleSet testSampleSet;
    static String[] projectPrefix;
    Params params;
    static CsvWriter results;
    GUI gui = null;
    static String theSpecies;
    NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
    static ArrayList projectedGrids;
    static String writtenGrid;
    static double aucmax;
    static double applyThresholdValue;
    boolean samplesAddedToFeatures;
    static String raw2cumfile;
    static ParallelRun parallelRunner;
    static double[][] coords;
    static HashMap<String, Integer> speciesCount;
    static Layer[] allLayers;
    PrintWriter htmlout;
    static boolean startedPictureHtmlSection;
    static double[] contributions;
    int TAREA = 0;
    int TTRAINO = 1;
    int TTESTO = 2;
    int TCUM = 3;
    int TOCCPROB = 4;
    int TTHRESH = 5;
    double beta_lqp;
    double beta_thr;
    double beta_hge;
    double beta_cat;
    MyPlot plot = null;
    MyPlot plot2 = null;

    boolean is(String s) {
        return this.params.getboolean(s);
    }

    boolean occurrenceProbability() {
        return this.params.occurrenceProbability();
    }

    boolean cumulative() {
        return this.params.cumulative();
    }

    int replicates() {
        return this.params.getint("replicates");
    }

    int replicates(String species) {
        if (speciesCount == null || !this.cv() || !this.spatialCV() || speciesCount.get(species) == null || speciesCount.get(species) > this.replicates()) {
            return this.replicates();
        }
        return speciesCount.get(species);
    }

    int threads() {
        return this.params.getint("threads");
    }

    String outDir() {
        return this.params.getString("outputdirectory");
    }

    String biasFile() {
        return this.params.getString("biasFile");
    }

    String testSamplesFile() {
        return this.params.getString("testSamplesFile");
    }

    String environmentalLayers() {
        return this.params.getString("environmentalLayers");
    }

    String projectionLayers() {
        return this.params.getString("projectionLayers");
    }

    double betaMultiplier() {
        return this.params.getdouble("betaMultiplier");
    }

    String outputFileType() {
        return "." + this.params.getString("outputFileType");
    }

    boolean cv() {
        return this.params.getString("replicatetype").equals("crossvalidate");
    }

    boolean spatialCV() {
        return this.params.getString("replicatetype").equals("spatial crossvalidate");
    }

    boolean bootstrap() {
        return this.params.getString("replicatetype").equals("bootstrap");
    }

    boolean subsample() {
        return this.params.getString("replicatetype").equals("subsample");
    }

    boolean decideOnTestGain() {
        return this.params.getString("decisionParameter").equals("test gain");
    }

    boolean decideOnTestAuc() {
        return this.params.getString("decisionParameter").equals("test auc");
    }

    boolean decideOnAICC() {
        return this.params.getString("decisionParameter").equals("aicc");
    }

    static String raw2cumfile(String lambdafile) {
        return lambdafile.replaceAll(".lambdas$", "_omission.csv");
    }

    public Runner(Params params) {
        this.params = params;
        this.nf.setGroupingUsed(false);
        this.nf.setMinimumFractionDigits(3);
        this.nf.setMaximumFractionDigits(3);
    }

    void popupError(String s, Throwable e) {
        Utils.popupError(s, e);
    }

    void stop() {
        Utils.echoln("Interrupted");
        Utils.interrupt = true;
    }

    Layer[] trueFeatureLayers() {
        ArrayList<Layer> result = new ArrayList<Layer>();
        for (int i = 0; i < allLayers.length; ++i) {
            int type = allLayers[i].getType();
            if (type != 1 && type != 2) continue;
            result.add(allLayers[i]);
        }
        return result.toArray(new Layer[0]);
    }

    boolean isTrueBaseFeature(Feature f) {
        int type = f.type();
        return type == 6 || type == 7;
    }

    Feature[] getTrueBaseFeatures(Feature[] f) {
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < f.length; ++i) {
            if (!this.isTrueBaseFeature(f[i])) continue;
            result.add(f[i]);
        }
        return result.toArray(new Feature[0]);
    }

    boolean gridsFromFile() {
        return new File(this.environmentalLayers()).isFile();
    }

    GridSet initializeGrids() {
        String dir = this.environmentalLayers();
        boolean isFile = this.gridsFromFile();
        String[] layers = this.params.layers;
        String[] layerTypes = this.params.layerTypes;
        GridSet result = null;
        ArrayList<Layer> allLayersList = new ArrayList<Layer>();
        for (int i = 0; i < layers.length; ++i) {
            Layer layer = new Layer(layers[i], layerTypes[i]);
            allLayersList.add(layer);
        }
        try {
            Layer layer;
            ArrayList<String> full = new ArrayList<String>();
            ArrayList<Layer> fileLayersList = new ArrayList<Layer>();
            for (int i = 0; i < layers.length; ++i) {
                layer = new Layer(layers[i], layerTypes[i]);
                fileLayersList.add(layer);
                if (isFile || dir.equals("")) continue;
                full.add(Utils.getGridAbsolutePath(dir, layers[i]));
            }
            if (!this.biasFile().equals("")) {
                File f = new File(this.biasFile());
                if (f.exists()) {
                    layer = new Layer(f, this.params.getint("biasType"));
                    allLayersList.add(layer);
                    full.add(f.getAbsolutePath());
                    fileLayersList.add(layer);
                } else {
                    this.popupError("Error opening bias file " + this.biasFile(), null);
                    return null;
                }
            }
            String[] fileNames = full.toArray(new String[0]);
            Layer[] fileLayers = fileLayersList.toArray(new Layer[0]);
            allLayers = allLayersList.toArray(new Layer[0]);
            String[] selectSpecies = this.params.species;
            if (isFile) {
                result = new GridSetFromFile(dir, allLayers);
                if (!this.params.getString("samplesFile").equals("")) {
                    result.train = new SampleSet2(this.params.getString("samplesFile"), fileLayers, null, this.params);
                    if (!result.train.samplesHaveData) {
                        this.popupError("Samples need to be in SWD format when background data is in SWD format", null);
                        return null;
                    }
                    result.train.params = this.params;
                    result.train.read(selectSpecies);
                    result.train.createMaps();
                }
                if (!this.testSamplesFile().equals("")) {
                    result.test = new SampleSet2(this.testSamplesFile(), fileLayers, null, this.params);
                    if (!result.test.samplesHaveData) {
                        this.popupError("Test samples need to be in SWD format when background data is in SWD format", null);
                        return null;
                    }
                    result.test.params = this.params;
                    result.test.read((String[])(this.replicates() == 0 ? selectSpecies : null));
                    result.test.createMaps();
                }
            } else {
                if (fileNames.length == 0) {
                    return null;
                }
                result = new Extractor();
                Extractor cfr_ignored_0 = (Extractor)result;
                Extractor.params = this.params;
                ((Extractor)result).extractSamples(fileNames, this.params.getint("maximumBackground"), this.params.getString("samplesFile"), this.testSamplesFile(), fileLayers, selectSpecies);
            }
        }
        catch (Exception e) {
            Object msg = "Error reading files";
            if (Extractor.readingFile != null) {
                msg = "Error reading file " + Extractor.readingFile;
            }
            this.popupError((String)msg, e);
            Utils.interrupt = true;
            return null;
        }
        return result;
    }

    public void end() {
        Utils.echoln("Ending");
        if (results != null) {
            results.close();
            results = null;
        }
        if (this.htmlout != null) {
            this.htmlout.close();
            this.htmlout = null;
        }
        Utils.closeLog();
        Utils.disposeProgressMonitor();
    }

    public static void main(String[] args) {
        Params params = new Params();
        params.setOutputdirectory("D:\\maxent\\bradypus\\test\\");
        params.setEnvironmentallayers("D:\\maxentTutorial\\data\\background\\CAN_bg.csv");
        params.setSamplesfile("D:\\maxentTutorial\\data\\samples\\can01\\can01_01\\can01_01_train.csv");
        params.setProjectionlayers("D:\\maxentTutorial\\data\\layers\\");
        params.setThreads(5);
        params.setFinalModel(true);
        params.setOutputgrids(false);
        params.setcvGrids(true);
        params.setWritemess(false);
        params.setDoclamp(false);
        params.setWriteclampgrid(false);
        params.setSelections();
        Runner runner = new Runner(params);
        Utils.applyStaticParams(params);
        if (params.layers == null) {
            params.setSelections();
        }
        if (runner.cv() || runner.spatialCV() && runner.replicates() > 1 && params.getRandomtestpoints() != 0) {
            Utils.warn2("Resetting random test percentage to zero because cross-validation in use", "skippingHoldoutBecauseCV");
            params.setRandomtestpoints(0);
        }
        if (runner.subsample() && runner.replicates() > 1 && params.getint("randomTestPoints") <= 0 && !runner.is("manualReplicates")) {
            runner.popupError("Subsampled replicates require nonzero random test percentage", null);
            return;
        }
        if ((runner.subsample() || runner.bootstrap()) && (params.isFfs() || params.isFvs() || params.isTuneRM())) {
            runner.popupError("Forward Feature Selection, Forward Variable Selection and beta multiplier tuning have to be evaluated with spatial crossvalidation or crossvalidation.", null);
            return;
        }
        if (params.isJackknife() && params.isFvs()) {
            runner.popupError("Using Jackknife and Forward Variable Selection is not possible. Deselect one.", null);
            return;
        }
        if (!(runner.spatialCV() || runner.cv() || runner.replicates() <= 1 || params.getboolean("randomseed") || runner.is("manualReplicates"))) {
            Utils.warn2("Setting randomseed to true so that replicates are not identical", "settingrandomseedtrue");
            params.setValue("randomseed", true);
        }
        if (runner.outDir() == null || runner.outDir().trim().equals("")) {
            runner.popupError("An output directory is needed", null);
            return;
        }
        if (runner.is("allModels") && !new File(runner.outDir()).exists()) {
            runner.popupError("Output directory does not exist", null);
            return;
        }
        if (!runner.biasFile().equals("") && runner.gridsFromFile()) {
            runner.popupError("Bias grid cannot be used with SWD-format background", null);
            return;
        }
        if (runner.is("perSpeciesResults") && runner.replicates() > 1) {
            Utils.warn2("PerSpeciesResults is not supported with replicates>1, setting perSpeciesResults to false", "unsettingPerSpeciesResults");
            params.setValue("perSpeciesResults", false);
        }
        if (runner.is("allModels") && runner.is("allModels")) {
            try {
                Utils.openLog(runner.outDir(), params.getString("logFile"));
            }
            catch (IOException e) {
                runner.popupError("Error opening log file", e);
                return;
            }
        }
        Utils.startTimer();
        Utils.echoln(new Date().toString());
        Utils.echoln("MaxEnt version " + Utils.version);
        Utils.interrupt = false;
        if (runner.threads() > 1) {
            parallelRunner = new ParallelRun(runner.threads());
        }
        Thread.currentThread().setPriority(4);
        if (params.layers == null || params.layers.length == 0) {
            runner.popupError("No environmental layers selected", null);
            return;
        }
        if (params.species.length == 0) {
            runner.popupError("No species selected", null);
            return;
        }
        if (Utils.progressMonitor != null) {
            Utils.progressMonitor.setMaximum(100);
        }
        Utils.generator = new Random(!params.isRandomseed() ? 0L : System.currentTimeMillis());
        gs = runner.initializeGrids();
        if (Utils.interrupt || gs == null) {
            return;
        }
        SampleSet2 sampleSet2 = Runner.gs.train;
        if (runner.projectionLayers().length() > 0) {
            String[] dirs = runner.projectionLayers().trim().split(",");
            projectPrefix = new String[dirs.length];
            for (int i = 0; i < projectPrefix.length; ++i) {
                Runner.projectPrefix[i] = new File(dirs[i].trim()).getPath();
            }
        }
        if (!runner.testSamplesFile().equals("")) {
            testSampleSet = Runner.gs.test;
        }
        if (Utils.interrupt) {
            return;
        }
        if (runner.is("removeDuplicates")) {
            sampleSet2.removeDuplicates(runner.gridsFromFile() ? null : gs.getDimension());
        }
        Feature[] baseFeatures = gs == null ? null : gs.toFeatures();
        coords = Runner.gs.getDimension().coords;
        if (baseFeatures == null || baseFeatures.length == 0 || baseFeatures[0].n == 0) {
            runner.popupError("No background points with data in all layers", null);
            return;
        }
        ArrayList<Sample> bgpArrayList = new ArrayList<Sample>();
        for (int no = 0; no < baseFeatures[0].n; ++no) {
            HashMap<String, Double> featureMap = new HashMap<String, Double>();
            for (int i = 0; i < baseFeatures.length; ++i) {
                featureMap.put(baseFeatures[i].name, baseFeatures[i].eval(no));
            }
            Sample bgp = new Sample(no, featureMap);
            bgpArrayList.add(no, bgp);
        }
        runner.samplesAddedToFeatures = runner.is("addSamplesToBackground") && (sampleSet2.samplesHaveData || gs instanceof Extractor);
        boolean addSamplesToFeatures = runner.samplesAddedToFeatures;
        if (addSamplesToFeatures) {
            Utils.echoln("Adding samples to background in feature space");
        }
        Feature[] features = null;
        if (!addSamplesToFeatures) {
            features = runner.makeFeatures(baseFeatures);
            if (Utils.interrupt) {
                return;
            }
        }
        sampleSet = sampleSet2;
        speciesCount = new HashMap();
        if (runner.spatialCV()) {
            String[] names = sampleSet.getNames();
            String[] species = (String[])Runner.sampleSet.speciesMap.get(names[0]);
            List locations = species.stream().map(Sample::getSpatial).collect(Collectors.toList());
            HashSet locHset = new HashSet(locations);
            ArrayList locArr = new ArrayList(locHset);
            int num = locArr.size();
            Utils.warn2("Resetting replicates to number of distinct locations (replicates: " + num + ") because spatial cross-validation in use", "skippingHoldoutBecauseCV");
            params.setReplicates(num);
        }
        if (runner.replicates() > 1 && !runner.is("manualReplicates")) {
            if (runner.cv()) {
                for (String s : sampleSet.getNames()) {
                    speciesCount.put(s, sampleSet.getSamples(s).length);
                }
                testSampleSet = sampleSet.splitForCV(runner.replicates());
            } else if (runner.spatialCV()) {
                for (String s : sampleSet.getNames()) {
                    speciesCount.put(s, sampleSet.getSamples(s).length);
                }
                testSampleSet = sampleSet.splitForSpatialCV();
            } else {
                sampleSet.replicate(runner.replicates(), runner.bootstrap());
            }
            ArrayList<String> torun = new ArrayList<String>();
            for (String s : sampleSet.getNames()) {
                if (!s.matches(".*_[0-9]+$")) continue;
                torun.add(s);
            }
            params.speciesCV = torun.toArray(new String[0]);
        }
        if (runner.testSamplesFile().equals("") && params.getint("randomTestPoints") != 0) {
            Object train = null;
            if (!runner.is("randomseed")) {
                Utils.generator = new Random(11111L);
            }
            testSampleSet = sampleSet.randomSample(params.getint("randomTestPoints"));
        }
        if (Utils.interrupt) {
            return;
        }
        ArrayList<Double> testGain = new ArrayList<Double>();
        ArrayList<String> bestVariables = new ArrayList<String>();
        ArrayList<String> bestFeatures = new ArrayList<String>();
        if (runner.is("fvs")) {
            ArrayList<String> varNamesAL = new ArrayList<String>();
            varNamesAL.addAll(List.of(params.layers));
            runner.forwardVariableSelectionParallel(varNamesAL, bestVariables, bestFeatures, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
            if (runner.threads() > 1) {
                parallelRunner.clear();
            }
            if (runner.is("ffs")) {
                runner.forwardFeatureSelection(bestVariables, bestFeatures, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                if (runner.is("tuneRM")) {
                    double bestBetaMultiplier = runner.tuneBetaMultiplier(bestVariables, bestFeatures, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                    params.setBetamultiplier(bestBetaMultiplier);
                    params.setAllModels(true);
                    runner.startNew(bestVariables, bestFeatures, testGain, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                    if (runner.is("finalModel")) {
                        runner.startFinalModel(bestVariables, bestFeatures, testGain);
                    }
                    runner.end();
                } else {
                    params.setAllModels(true);
                    runner.startNew(bestVariables, bestFeatures, testGain, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                    if (runner.is("finalModel")) {
                        runner.startFinalModel(bestVariables, bestFeatures, testGain);
                    }
                    runner.end();
                }
            } else if (runner.is("tuneRM")) {
                double bestBetaMultiplier = runner.tuneBetaMultiplier(bestVariables, bestFeatures, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                params.setBetamultiplier(bestBetaMultiplier);
                params.setAllModels(true);
                runner.startNew(bestVariables, bestFeatures, testGain, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                if (runner.is("finalModel")) {
                    runner.startFinalModel(bestVariables, bestFeatures, testGain);
                }
                runner.end();
            } else {
                ArrayList testAuc = new ArrayList();
                params.setAllModels(true);
                runner.startNew(bestVariables, bestFeatures, testGain, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                if (runner.is("finalModel")) {
                    runner.startFinalModel(bestVariables, bestFeatures, testGain);
                }
                runner.end();
            }
        } else {
            bestVariables.addAll(List.of(params.layers));
            if (runner.is("ffs")) {
                runner.forwardFeatureSelection(bestVariables, bestFeatures, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                if (runner.is("tuneRM")) {
                    double bestBetaMultiplier = runner.tuneBetaMultiplier(bestVariables, bestFeatures, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                    params.setBetamultiplier(bestBetaMultiplier);
                    params.setAllModels(true);
                    runner.startNew(bestVariables, bestFeatures, testGain, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                    if (runner.is("finalModel")) {
                        runner.startFinalModel(bestVariables, bestFeatures, testGain);
                    }
                    runner.end();
                } else {
                    params.setAllModels(true);
                    runner.startNew(bestVariables, bestFeatures, testGain, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                    if (runner.is("finalModel")) {
                        runner.startFinalModel(bestVariables, bestFeatures, testGain);
                    }
                    runner.end();
                }
            } else if (runner.is("tuneRM")) {
                double bestBetaMultiplier = runner.tuneBetaMultiplier(bestVariables, bestFeatures, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                params.setBetamultiplier(bestBetaMultiplier);
                params.setAllModels(true);
                runner.startNew(bestVariables, bestFeatures, testGain, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                if (runner.is("finalModel")) {
                    runner.startFinalModel(bestVariables, bestFeatures, testGain);
                }
                runner.end();
            } else {
                params.setAllModels(true);
                runner.startNew(bestVariables, bestFeatures, testGain, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                if (runner.is("finalModel")) {
                    runner.startFinalModel(bestVariables, bestFeatures, testGain);
                }
                runner.end();
            }
        }
        if (runner.threads() > 1) {
            parallelRunner.close();
        }
    }

    void startParallel(String[] bestVariables, ArrayList<String> bestFeatures, Feature[] baseFeatures, boolean addSamplesToFeatures, Double[] testGainFinal, int me) {
        double[] testGainOneModel = new double[this.replicates()];
        for (int sample = 0; sample < this.params.speciesCV.length; ++sample) {
            double testGain;
            int len;
            Sample[] ss;
            String theSpeciesPar = this.params.speciesCV[sample];
            if (this.is("perSpeciesResults")) {
                try {
                    results = new CsvWriter(new File(this.outDir(), theSpeciesPar + "Results.csv"));
                }
                catch (IOException e) {
                    this.popupError("Problem opening " + theSpeciesPar + " results file", e);
                    double testGainAver = this.averageTestGain(testGainOneModel);
                    testGainFinal[me] = testGainAver;
                }
            }
            Sample[] sss = sampleSet.getSamples(theSpeciesPar);
            if (!this.params.allowpartialdata()) {
                sss = this.withAllData(baseFeatures, sss);
            }
            if ((ss = sss).length == 0) {
                Utils.warn2("Skipping " + theSpeciesPar + " because it has 0 training samples", "skippingBecauseNoTrainingSamples");
                continue;
            }
            if (testSampleSet != null && (len = testSampleSet.getSamples(theSpeciesPar).length) == 0) {
                Utils.warn2("Skipping " + theSpeciesPar + " because it has 0 test samples", "skippingBecauseNoTestSamples");
                continue;
            }
            Utils.reportMemory("getSamples");
            if (Utils.interrupt) {
                double testGainAver = this.averageTestGain(testGainOneModel);
                testGainFinal[me] = testGainAver;
            }
            Utils.reportDoing(theSpeciesPar + ": ");
            ArrayList<String> vars = new ArrayList<String>();
            vars.add(bestVariables[0]);
            vars.add(bestVariables[1]);
            Feature[] features = this.makeFeatures(this.variableNoOfFeatures(baseFeatures, vars));
            MaxentRunResults res = this.maxentRun(features, ss, testSampleSet != null ? testSampleSet.getSamples(theSpeciesPar) : null);
            if (res == null) {
                double testGainAver = this.averageTestGain(testGainOneModel);
                testGainFinal[me] = testGainAver;
            }
            FeaturedSpace X = res.X;
            res.removeBiasDistribution();
            DoubleIterator backgroundIterator = null;
            double auc = X.getAUC(backgroundIterator, X.testSamples);
            if (backgroundIterator != null) {
                X.setDensityNormalizer(backgroundIterator);
            }
            double d = testGain = testSampleSet == null ? 0.0 : this.getTestGain(X);
            if (this.decideOnTestGain()) {
                testGainOneModel[sample] = testGain;
            }
            if (!this.decideOnTestAuc()) continue;
            testGainOneModel[sample] = auc;
        }
        double testGainAver = this.averageTestGain(testGainOneModel);
        testGainFinal[me] = testGainAver;
    }

    void startParallel2(String[] bestVariables, ArrayList<String> bestFeatures, Feature[] baseFeatures, boolean addSamplesToFeatures, Double[] testGainFinal, int me) {
        double[] testGainOneModel = new double[this.replicates()];
        for (int sample = 0; sample < this.params.speciesCV.length; ++sample) {
            double testGain;
            int len;
            Sample[] ss;
            String theSpeciesPar = this.params.speciesCV[sample];
            if (this.is("perSpeciesResults")) {
                try {
                    results = new CsvWriter(new File(this.outDir(), theSpeciesPar + "Results.csv"));
                }
                catch (IOException e) {
                    this.popupError("Problem opening " + theSpeciesPar + " results file", e);
                    double testGainAver = this.averageTestGain(testGainOneModel);
                    testGainFinal[me] = testGainAver;
                }
            }
            Sample[] sss = sampleSet.getSamples(theSpeciesPar);
            if (!this.params.allowpartialdata()) {
                sss = this.withAllData(baseFeatures, sss);
            }
            if ((ss = sss).length == 0) {
                Utils.warn2("Skipping " + theSpeciesPar + " because it has 0 training samples", "skippingBecauseNoTrainingSamples");
                continue;
            }
            if (testSampleSet != null && (len = testSampleSet.getSamples(theSpeciesPar).length) == 0) {
                Utils.warn2("Skipping " + theSpeciesPar + " because it has 0 test samples", "skippingBecauseNoTestSamples");
                continue;
            }
            Utils.reportMemory("getSamples");
            if (Utils.interrupt) {
                double testGainAver = this.averageTestGain(testGainOneModel);
                testGainFinal[me] = testGainAver;
            }
            Utils.reportDoing(theSpeciesPar + ": ");
            contributions = null;
            ArrayList<String> vars = new ArrayList<String>();
            Collections.addAll(vars, bestVariables);
            Feature[] features = this.makeFeatures(this.variableNoOfFeatures(baseFeatures, vars));
            MaxentRunResults res = this.maxentRunParallel(features, ss, testSampleSet != null ? testSampleSet.getSamples(theSpeciesPar) : null);
            if (res == null) {
                double testGainAver = this.averageTestGain(testGainOneModel);
                testGainFinal[me] = testGainAver;
            }
            FeaturedSpace X = res.X;
            res.removeBiasDistribution();
            DoubleIterator backgroundIterator = null;
            double auc = X.getAUC(backgroundIterator, X.testSamples);
            aucmax = X.aucmax;
            if (backgroundIterator != null) {
                X.setDensityNormalizer(backgroundIterator);
            }
            double d = testGain = testSampleSet == null ? 0.0 : this.getTestGain(X);
            if (this.decideOnTestGain()) {
                testGainOneModel[sample] = testGain;
            }
            if (!this.decideOnTestAuc()) continue;
            testGainOneModel[sample] = auc;
        }
        double testGainAver = this.averageTestGain(testGainOneModel);
        testGainFinal[me] = testGainAver;
    }

    double averageTestGain(double[] testGainOneModelArr) {
        double sum = 0.0;
        for (double d : testGainOneModelArr) {
            sum += d;
        }
        double testGainAverage = sum / (double)testGainOneModelArr.length;
        return testGainAverage;
    }

    public void runSpatial() {
        Utils.applyStaticParams(this.params);
        if (this.params.layers == null) {
            this.params.setSelections();
        }
        if (this.cv() || this.spatialCV() && this.replicates() > 1 && this.params.getRandomtestpoints() != 0) {
            Utils.warn2("Resetting random test percentage to zero because cross-validation in use", "skippingHoldoutBecauseCV");
            this.params.setRandomtestpoints(0);
        }
        if (this.subsample() && this.replicates() > 1 && this.params.getint("randomTestPoints") <= 0 && !this.is("manualReplicates")) {
            this.popupError("Subsampled replicates require nonzero random test percentage", null);
            return;
        }
        if ((this.subsample() || this.bootstrap()) && (this.params.isFfs() || this.params.isFvs() || this.params.isTuneRM())) {
            this.popupError("Forward Feature Selection, Forward Variable Selection and beta multiplier tuning have to be evaluated with spatial crossvalidation or crossvalidation.", null);
            return;
        }
        if (this.params.isJackknife() && this.params.isFvs()) {
            this.popupError("Using Jackknife and Forward Variable Selection is not possible. Deselect one.", null);
            return;
        }
        if (!(this.spatialCV() || this.cv() || this.replicates() <= 1 || this.params.getboolean("randomseed") || this.is("manualReplicates"))) {
            Utils.warn2("Setting randomseed to true so that replicates are not identical", "settingrandomseedtrue");
            this.params.setValue("randomseed", true);
        }
        if (this.outDir() == null || this.outDir().trim().equals("")) {
            this.popupError("An output directory is needed", null);
            return;
        }
        if (this.is("allModels") && !new File(this.outDir()).exists()) {
            this.popupError("Output directory does not exist", null);
            return;
        }
        if (!this.biasFile().equals("") && this.gridsFromFile()) {
            this.popupError("Bias grid cannot be used with SWD-format background", null);
            return;
        }
        if (this.is("perSpeciesResults") && this.replicates() > 1) {
            Utils.warn2("PerSpeciesResults is not supported with replicates>1, setting perSpeciesResults to false", "unsettingPerSpeciesResults");
            this.params.setValue("perSpeciesResults", false);
        }
        if (this.is("allModels") && this.is("allModels")) {
            try {
                Utils.openLog(this.outDir(), this.params.getString("logFile"));
            }
            catch (IOException e) {
                this.popupError("Error opening log file", e);
                return;
            }
        }
        Utils.startTimer();
        Utils.echoln(new Date().toString());
        Utils.echoln("MaxEnt version " + Utils.version);
        Utils.interrupt = false;
        if (this.threads() > 1) {
            parallelRunner = new ParallelRun(this.threads());
        }
        Thread.currentThread().setPriority(4);
        if (this.params.layers == null || this.params.layers.length == 0) {
            this.popupError("No environmental layers selected", null);
            return;
        }
        if (this.params.species.length == 0) {
            this.popupError("No species selected", null);
            return;
        }
        if (Utils.progressMonitor != null) {
            Utils.progressMonitor.setMaximum(100);
        }
        Utils.generator = new Random(!this.params.isRandomseed() ? 0L : System.currentTimeMillis());
        gs = this.initializeGrids();
        if (Utils.interrupt || gs == null) {
            return;
        }
        SampleSet2 sampleSet2 = Runner.gs.train;
        if (this.projectionLayers().length() > 0) {
            String[] dirs = this.projectionLayers().trim().split(",");
            projectPrefix = new String[dirs.length];
            for (int i = 0; i < projectPrefix.length; ++i) {
                Runner.projectPrefix[i] = new File(dirs[i].trim()).getPath();
            }
        }
        if (!this.testSamplesFile().equals("")) {
            testSampleSet = Runner.gs.test;
        }
        if (Utils.interrupt) {
            return;
        }
        if (this.is("removeDuplicates")) {
            sampleSet2.removeDuplicates(this.gridsFromFile() ? null : gs.getDimension());
        }
        Feature[] baseFeatures = gs == null ? null : gs.toFeatures();
        coords = Runner.gs.getDimension().coords;
        if (baseFeatures == null || baseFeatures.length == 0 || baseFeatures[0].n == 0) {
            this.popupError("No background points with data in all layers", null);
            return;
        }
        ArrayList<Sample> bgpArrayList = new ArrayList<Sample>();
        for (int no = 0; no < baseFeatures[0].n; ++no) {
            HashMap<String, Double> featureMap = new HashMap<String, Double>();
            for (int i = 0; i < baseFeatures.length; ++i) {
                featureMap.put(baseFeatures[i].name, baseFeatures[i].eval(no));
            }
            Sample bgp = new Sample(no, featureMap);
            bgpArrayList.add(no, bgp);
        }
        this.samplesAddedToFeatures = this.is("addSamplesToBackground") && (sampleSet2.samplesHaveData || gs instanceof Extractor);
        boolean addSamplesToFeatures = this.samplesAddedToFeatures;
        if (addSamplesToFeatures) {
            Utils.echoln("Adding samples to background in feature space");
        }
        Feature[] features = null;
        if (!addSamplesToFeatures) {
            features = this.makeFeatures(baseFeatures);
            if (Utils.interrupt) {
                return;
            }
        }
        sampleSet = sampleSet2;
        speciesCount = new HashMap();
        if (this.spatialCV()) {
            String[] names = sampleSet.getNames();
            String[] species = (String[])Runner.sampleSet.speciesMap.get(names[0]);
            List locations = species.stream().map(Sample::getSpatial).collect(Collectors.toList());
            HashSet locHset = new HashSet(locations);
            ArrayList locArr = new ArrayList(locHset);
            int num = locArr.size();
            Utils.warn2("Resetting replicates to number of distinct locations (replicates: " + num + ") because spatial cross-validation in use", "skippingHoldoutBecauseCV");
            this.params.setReplicates(num);
        }
        if (this.replicates() > 1 && !this.is("manualReplicates")) {
            if (this.cv()) {
                for (String s : sampleSet.getNames()) {
                    speciesCount.put(s, sampleSet.getSamples(s).length);
                }
                testSampleSet = sampleSet.splitForCV(this.replicates());
            } else if (this.spatialCV()) {
                for (String s : sampleSet.getNames()) {
                    speciesCount.put(s, sampleSet.getSamples(s).length);
                }
                testSampleSet = sampleSet.splitForSpatialCV();
            } else {
                sampleSet.replicate(this.replicates(), this.bootstrap());
            }
            ArrayList<String> torun = new ArrayList<String>();
            for (String s : sampleSet.getNames()) {
                if (!s.matches(".*_[0-9]+$")) continue;
                torun.add(s);
            }
            this.params.speciesCV = torun.toArray(new String[0]);
        }
        if (this.testSamplesFile().equals("") && this.params.getint("randomTestPoints") != 0) {
            Object train = null;
            if (!this.is("randomseed")) {
                Utils.generator = new Random(11111L);
            }
            testSampleSet = sampleSet.randomSample(this.params.getint("randomTestPoints"));
        }
        if (Utils.interrupt) {
            return;
        }
        ArrayList<Double> testGain = new ArrayList<Double>();
        ArrayList<String> bestVariables = new ArrayList<String>();
        ArrayList<String> bestFeatures = new ArrayList<String>();
        if (this.is("fvs")) {
            ArrayList<String> varNamesAL = new ArrayList<String>();
            varNamesAL.addAll(List.of(this.params.layers));
            this.forwardVariableSelectionParallel(varNamesAL, bestVariables, bestFeatures, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
            if (this.threads() > 1) {
                parallelRunner.clear();
            }
            if (this.is("ffs")) {
                this.forwardFeatureSelection(bestVariables, bestFeatures, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                if (this.is("tuneRM")) {
                    double bestBetaMultiplier = this.tuneBetaMultiplier(bestVariables, bestFeatures, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                    this.params.setBetamultiplier(bestBetaMultiplier);
                    this.params.setAllModels(true);
                    this.startNew(bestVariables, bestFeatures, testGain, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                    if (this.is("finalModel")) {
                        this.startFinalModel(bestVariables, bestFeatures, testGain);
                    }
                    this.end();
                } else {
                    this.params.setAllModels(true);
                    this.startNew(bestVariables, bestFeatures, testGain, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                    if (this.is("finalModel")) {
                        this.startFinalModel(bestVariables, bestFeatures, testGain);
                    }
                    this.end();
                }
            } else if (this.is("tuneRM")) {
                double bestBetaMultiplier = this.tuneBetaMultiplier(bestVariables, bestFeatures, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                this.params.setBetamultiplier(bestBetaMultiplier);
                this.params.setAllModels(true);
                this.startNew(bestVariables, bestFeatures, testGain, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                if (this.is("finalModel")) {
                    this.startFinalModel(bestVariables, bestFeatures, testGain);
                }
                this.end();
            } else {
                ArrayList testAuc = new ArrayList();
                this.params.setAllModels(true);
                this.startNew(bestVariables, bestFeatures, testGain, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                if (this.is("finalModel")) {
                    this.startFinalModel(bestVariables, bestFeatures, testGain);
                }
                this.end();
            }
        } else {
            bestVariables.addAll(List.of(this.params.layers));
            if (this.is("ffs")) {
                this.forwardFeatureSelection(bestVariables, bestFeatures, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                if (this.is("tuneRM")) {
                    double bestBetaMultiplier = this.tuneBetaMultiplier(bestVariables, bestFeatures, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                    this.params.setBetamultiplier(bestBetaMultiplier);
                    this.params.setAllModels(true);
                    this.startNew(bestVariables, bestFeatures, testGain, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                    if (this.is("finalModel")) {
                        this.startFinalModel(bestVariables, bestFeatures, testGain);
                    }
                    this.end();
                } else {
                    this.params.setAllModels(true);
                    this.startNew(bestVariables, bestFeatures, testGain, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                    if (this.is("finalModel")) {
                        this.startFinalModel(bestVariables, bestFeatures, testGain);
                    }
                    this.end();
                }
            } else if (this.is("tuneRM")) {
                double bestBetaMultiplier = this.tuneBetaMultiplier(bestVariables, bestFeatures, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                this.params.setBetamultiplier(bestBetaMultiplier);
                this.params.setAllModels(true);
                this.startNew(bestVariables, bestFeatures, testGain, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                if (this.is("finalModel")) {
                    this.startFinalModel(bestVariables, bestFeatures, testGain);
                }
                this.end();
            } else {
                this.params.setAllModels(true);
                this.startNew(bestVariables, bestFeatures, testGain, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                if (this.is("finalModel")) {
                    this.startFinalModel(bestVariables, bestFeatures, testGain);
                }
                this.end();
            }
        }
        if (this.threads() > 1) {
            parallelRunner.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void startNew(ArrayList<String> bestVariables, ArrayList<String> bestFeatures, ArrayList<Double> testGainOneModel, Feature[] baseFeatures, boolean addSamplesToFeatures, Feature[] features, ArrayList<Sample> bgpArrayList) {
        if (bestFeatures.size() > 0) {
            this.params.setAutofeature(false);
            this.params.setHinge(false);
            this.params.setLinear(false);
            this.params.setProduct(false);
            this.params.setThreshold(false);
            this.params.setQuadratic(false);
            for (x = 0; x < bestFeatures.size(); ++x) {
                if (bestFeatures.get(x) == "linear") {
                    this.params.setLinear(true);
                    continue;
                }
                if (bestFeatures.get(x) == "hinge") {
                    this.params.setHinge(true);
                    continue;
                }
                if (bestFeatures.get(x) == "threshold") {
                    this.params.setThreshold(true);
                    continue;
                }
                if (bestFeatures.get(x) == "quadratic") {
                    this.params.setQuadratic(true);
                    continue;
                }
                if (bestFeatures.get(x) != "product") continue;
                this.params.setProduct(true);
            }
        }
        if (this.is("allModels")) {
            this.writeLog();
            if (!this.is("perSpeciesResults")) {
                try {
                    Runner.results = new CsvWriter(new File(this.outDir(), "maxentResults.csv"), this.is("appendtoresultsfile"));
                }
                catch (IOException e) {
                    this.popupError("Problem opening results file", e);
                    return;
                }
            }
        }
        if (this.replicates() == 1) {
            this.params.speciesCV = this.params.species;
        }
        block24: for (sample = 0; sample < this.params.speciesCV.length; ++sample) {
            Runner.theSpecies = this.params.speciesCV[sample];
            if (Utils.interrupt) {
                return;
            }
            if (this.is("perSpeciesResults")) {
                try {
                    Runner.results = new CsvWriter(new File(this.outDir(), Runner.theSpecies + "Results.csv"));
                }
                catch (IOException e) {
                    this.popupError("Problem opening " + Runner.theSpecies + " results file", e);
                    return;
                }
            }
            suffix = this.outputFileType();
            f = new File(this.outDir(), Runner.theSpecies + suffix);
            lf = new File(this.outDir(), Runner.theSpecies + ".lambdas");
            lambdafile = lf.getAbsolutePath();
            sss = Runner.sampleSet.getSamples(Runner.theSpecies);
            if (!this.params.allowpartialdata()) {
                sss = this.withAllData(baseFeatures, sss);
            }
            if ((ss = sss).length == 0) {
                Utils.warn2("Skipping " + Runner.theSpecies + " because it has 0 training samples", "skippingBecauseNoTrainingSamples");
                continue;
            }
            if (Runner.testSampleSet != null && (len = Runner.testSampleSet.getSamples(Runner.theSpecies).length) == 0) {
                Utils.warn2("Skipping " + Runner.theSpecies + " because it has 0 test samples", "skippingBecauseNoTestSamples");
                continue;
            }
            Utils.reportMemory("getSamples");
            if (!this.is("allModels") || !lf.exists()) ** GOTO lbl-1000
            if (this.is("skipIfExists")) {
                if (!this.is("appendtoresultsfile")) continue;
                this.maybeReplicateHtml(Runner.theSpecies, this.getTrueBaseFeatures(baseFeatures));
                continue;
            }
            if (!this.is("askoverwrite") || Utils.topLevelFrame == null) ** GOTO lbl-1000
            options = new Object[]{"Skip", "Skip all", "Redo", "Redo all"};
            val = JOptionPane.showOptionDialog(Utils.topLevelFrame, "Output file exists for " + Runner.theSpecies, "File already exists", -1, 2, null, options, options[0]);
            switch (val) {
                case 1: {
                    this.params.setValue("skipIfExists", true);
                }
                case 0: {
                    if (!this.is("appendtoresultsfile")) continue block24;
                    this.maybeReplicateHtml(Runner.theSpecies, this.getTrueBaseFeatures(baseFeatures));
                    continue block24;
                }
                case 3: {
                    this.params.setValue("askoverwrite", false);
                }
                default: lbl-1000:
                // 3 sources

                {
                    baseFeaturesWithSamples = baseFeatures;
                    if (addSamplesToFeatures) {
                        features = null;
                        baseFeaturesWithSamples = this.featuresWithSamples(baseFeatures, ss);
                        if (baseFeaturesWithSamples == null) continue block24;
                        features = this.makeFeatures(baseFeaturesWithSamples);
                    }
                    baseFeaturesNoBias = this.getTrueBaseFeatures(baseFeaturesWithSamples);
                    if (Utils.interrupt) {
                        return;
                    }
                    Utils.reportDoing(Runner.theSpecies + ": ");
                    Runner.contributions = null;
                    if (bestVariables.size() > 0) {
                        features = this.makeFeatures(this.variableNoOfFeatures(baseFeatures, bestVariables));
                    }
                    if ((res = this.maxentRun(features, ss, Runner.testSampleSet != null ? Runner.testSampleSet.getSamples(Runner.theSpecies) : null)) == null) {
                        return;
                    }
                    Utils.echoln("Resulting gain: " + res.gain);
                    X = res.X;
                    res.removeBiasDistribution();
                    gsfromfile = Runner.gs instanceof GridSetFromFile;
                    writeRaw2cumfile = true;
                    backgroundIterator = null;
                    auc = X.getAUC(backgroundIterator, X.testSamples);
                    aucSD = X.aucSD;
                    trainauc = X.getAUC(backgroundIterator, X.samples);
                    Runner.aucmax = X.aucmax;
                    nParams = X.countParameters();
                    numberOccuenceLocalities = baseFeatures[0].n + X.samples.length;
                    vals1 = new ArrayList<Double>();
                    for (i = 0; i < X.samples.length; ++i) {
                        raw = X.getDensity(X.samples[i]) / X.densityNormalizer;
                        vals1.add(i, raw);
                    }
                    vals = new ArrayList<Double>();
                    for (i = 0; i < baseFeatures[0].n; ++i) {
                        raw = X.getDensity(bgpArrayList.get(i)) / X.densityNormalizer;
                        vals.add(i, raw);
                    }
                    vals.addAll(vals1);
                    valsLog = new ArrayList<Double>();
                    for (i = 0; i < vals.size(); ++i) {
                        logValue = Math.log((Double)vals.get(i));
                        valsLog.add(logValue);
                    }
                    logLikelihood = 0.0;
                    for (i = 0; i < valsLog.size(); ++i) {
                        logLikelihood += ((Double)valsLog.get(i)).doubleValue();
                    }
                    AICC = 2.0 * nParams - 2.0 * logLikelihood + 2.0 * nParams * (nParams + 1.0) / (numberOccuenceLocalities - nParams - 1.0);
                    if (backgroundIterator != null) {
                        X.setDensityNormalizer(backgroundIterator);
                    }
                    entropy = X.getEntropy();
                    prevalence = X.getPrevalence(this.params);
                    if (this.is("allModels")) {
                        try {
                            X.writeFeatureWeights(lambdafile);
                        }
                        catch (IOException e) {
                            this.popupError("Error writing feature weights file", e);
                            return;
                        }
                    }
                    v0 = testGain = Runner.testSampleSet == null ? 0.0 : this.getTestGain(X);
                    if (this.decideOnTestGain()) {
                        testGainOneModel.add(testGain);
                    }
                    if (this.decideOnTestAuc()) {
                        testGainOneModel.add(auc);
                    }
                    if (this.decideOnAICC()) {
                        testGainOneModel.add(AICC);
                    }
                    if (!this.is("allModels")) continue block24;
                    this.startHtmlPage();
                    if (writeRaw2cumfile) {
                        Runner.raw2cumfile = Runner.raw2cumfile(lambdafile);
                        try {
                            weights = backgroundIterator == null ? X.getWeights() : backgroundIterator.getvals(X.densityNormalizer);
                            this.writeCumulativeIndex(weights, Runner.raw2cumfile, X, auc, trainauc, baseFeaturesNoBias, entropy);
                        }
                        catch (IOException e) {
                            this.popupError("Error writing raw-to-cumulative index file", e);
                            return;
                        }
                    }
                    Runner.writtenGrid = null;
                    if (Utils.interrupt) {
                        return;
                    }
                    explain = true;
                    for (String s : res.featureTypes) {
                        if (!s.equals("product")) continue;
                        explain = false;
                    }
                    Runner.startedPictureHtmlSection = false;
                    if (this.is("outputGrids")) {
                        filename = gsfromfile != false ? new File(this.outDir(), Runner.theSpecies + ".csv").getPath() : f.getPath();
                        try {
                            proj = new Project(this.params);
                            proj.entropy = entropy;
                            if (gsfromfile) {
                                proj.doProject(lambdafile, (GridSetFromFile)Runner.gs, filename);
                            } else {
                                proj.doProject(lambdafile, this.environmentalLayers(), filename, null);
                            }
                            proj.entropy = -1.0;
                            if (Utils.interrupt) {
                                return;
                            }
                            Runner.writtenGrid = filename;
                            if (this.is("pictures") && !gsfromfile) {
                                this.makePicture(f.getPath(), ss, X.testSamples, null);
                            }
                            this.makeExplain(explain, f, lambdafile, Runner.theSpecies + "_explain.bat", new File(this.environmentalLayers()).getAbsolutePath());
                            if (Runner.applyThresholdValue != -1.0 && !gsfromfile) {
                                new Threshold().applyThreshold(f.getPath(), Runner.applyThresholdValue);
                            }
                        }
                        catch (IOException e) {
                            this.popupError("Error writing output file " + new File(filename).getName(), e);
                            return;
                        }
                    }
                    if (Utils.interrupt) {
                        return;
                    }
                    Runner.projectedGrids = new ArrayList<E>();
                    if (Runner.projectPrefix != null && this.is("outputGrids")) {
                        for (i = 0; i < Runner.projectPrefix.length; ++i) {
                            if (Utils.interrupt) {
                                return;
                            }
                            prefix = new File(Runner.projectPrefix[i]).getName();
                            if (prefix.endsWith(".csv")) {
                                prefix = prefix.substring(0, prefix.length() - 4);
                            }
                            isFile = new File(Runner.projectPrefix[i]).isFile();
                            ff = new File(this.outDir(), Runner.theSpecies + "_" + prefix + (isFile != false ? ".csv" : suffix));
                            ffclamp = new File(this.outDir(), Runner.theSpecies + "_" + prefix + "_clamping" + (isFile != false ? ".csv" : suffix));
                            try {
                                proj = new Project(this.params);
                                proj.needLayers = Runner.allLayers;
                                proj.doProject(lambdafile, Runner.projectPrefix[i], ff.getPath(), this.is("writeClampGrid") != false ? ffclamp.getPath() : (String)null);
                                if (Utils.interrupt) {
                                    return;
                                }
                                Runner.projectedGrids.add("<a href = \"" + ff.getName() + "\">The model applied to the environmental layers in " + Runner.projectPrefix[i] + "</a>");
                                if (this.is("pictures") && !isFile) {
                                    this.makePicture(ff.getPath(), ss, X.testSamples, Runner.projectPrefix[i]);
                                    this.makeExplain(explain, ff, lambdafile, Runner.theSpecies + "_" + prefix + "_explain.bat", new File(Runner.projectPrefix[i]).getAbsolutePath());
                                    if (this.is("writeClampGrid")) {
                                        this.makePicture(ffclamp.getPath(), new Sample[0], new Sample[0], Runner.projectPrefix[i], true);
                                    }
                                    this.makeNovel(baseFeaturesNoBias, Runner.projectPrefix[i], new File(this.outDir(), Runner.theSpecies + "_" + prefix + "_novel" + suffix).getPath());
                                }
                                if (Runner.applyThresholdValue == -1.0 || isFile) continue;
                                new Threshold().applyThreshold(ff.getPath(), Runner.applyThresholdValue);
                                continue;
                            }
                            catch (IOException e) {
                                this.popupError("Error projecting", e);
                                return;
                            }
                        }
                    }
                    if (Utils.interrupt) {
                        return;
                    }
                    try {
                        this.writeSampleAverages(baseFeaturesWithSamples, ss);
                    }
                    catch (IOException e) {
                        this.popupError("Error writing file", e);
                        return;
                    }
                    if (this.is("responsecurves")) {
                        try {
                            this.createProfiles(baseFeaturesWithSamples, lambdafile, ss);
                        }
                        catch (IOException e) {
                            this.popupError("Error writing response curves for " + Runner.theSpecies, e);
                            return;
                        }
                    }
                    if (Utils.interrupt) {
                        return;
                    }
                    permcontribs = null;
                    try {
                        permcontribs = new PermutationImportance().go(baseFeatures, ss, lambdafile);
                    }
                    catch (IOException e) {
                        this.popupError("Error computing permutation importance for " + Runner.theSpecies, e);
                        return;
                    }
                    this.writeContributions(new double[][]{Runner.contributions, permcontribs}, "");
                    jackknifeGain = this.is("jackknife") != false && baseFeaturesNoBias.length > 1 ? this.jackknifeGain(baseFeaturesWithSamples, ss, X.testSamples, res.gain, testGain, auc) : null;
                    this.writeSummary(res, testGain, auc, aucSD, trainauc, nParams, AICC, Runner.results, baseFeaturesNoBias, jackknifeGain, entropy, prevalence, permcontribs);
                    this.writeHtmlDetails(res, testGain, auc, aucSD, trainauc, bestVariables);
                    this.htmlout.close();
                    if (!this.is("cvGrids")) continue block24;
                    this.maybeReplicateHtml(Runner.theSpecies, baseFeaturesNoBias);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void startFinalModel(ArrayList<String> bestVariables, ArrayList<String> bestFeatures, ArrayList<Double> testGainOneModel) {
        this.params.setOutputgrids(true);
        this.params.setReplicatetype("crossvalidate");
        this.params.setReplicates(1);
        Runner.testSampleSet = null;
        if (bestFeatures.size() > 0) {
            this.params.setAutofeature(false);
            this.params.setHinge(false);
            this.params.setLinear(false);
            this.params.setProduct(false);
            this.params.setThreshold(false);
            this.params.setQuadratic(false);
            for (x = 0; x < bestFeatures.size(); ++x) {
                if (bestFeatures.get(x) == "linear") {
                    this.params.setLinear(true);
                    continue;
                }
                if (bestFeatures.get(x) == "hinge") {
                    this.params.setHinge(true);
                    continue;
                }
                if (bestFeatures.get(x) == "threshold") {
                    this.params.setThreshold(true);
                    continue;
                }
                if (bestFeatures.get(x) == "quadratic") {
                    this.params.setQuadratic(true);
                    continue;
                }
                if (bestFeatures.get(x) != "product") continue;
                this.params.setProduct(true);
            }
        }
        Utils.startTimer();
        Utils.echoln(new Date().toString());
        Utils.echoln("MaxEnt version " + Utils.version);
        Utils.interrupt = false;
        if (this.threads() > 1) {
            Runner.parallelRunner = new ParallelRun(this.threads());
        }
        Thread.currentThread().setPriority(4);
        if (this.params.layers == null || this.params.layers.length == 0) {
            this.popupError("No environmental layers selected", null);
            return;
        }
        if (this.params.species.length == 0) {
            this.popupError("No species selected", null);
            return;
        }
        if (Utils.progressMonitor != null) {
            Utils.progressMonitor.setMaximum(100);
        }
        Utils.generator = new Random(this.params.isRandomseed() == false ? 0L : System.currentTimeMillis());
        Runner.gs = this.initializeGrids();
        if (Utils.interrupt || Runner.gs == null) {
            return;
        }
        sampleSet2 = Runner.gs.train;
        if (this.projectionLayers().length() > 0) {
            dirs = this.projectionLayers().trim().split(",");
            Runner.projectPrefix = new String[dirs.length];
            for (i = 0; i < Runner.projectPrefix.length; ++i) {
                Runner.projectPrefix[i] = new File(dirs[i].trim()).getPath();
            }
        }
        if (!this.testSamplesFile().equals("")) {
            Runner.testSampleSet = Runner.gs.test;
        }
        if (Utils.interrupt) {
            return;
        }
        if (this.is("removeDuplicates")) {
            sampleSet2.removeDuplicates(this.gridsFromFile() != false ? null : Runner.gs.getDimension());
        }
        baseFeatures = Runner.gs == null ? null : Runner.gs.toFeatures();
        Runner.coords = Runner.gs.getDimension().coords;
        if (baseFeatures == null || baseFeatures.length == 0 || baseFeatures[0].n == 0) {
            this.popupError("No background points with data in all layers", null);
            return;
        }
        bgpArrayList = new ArrayList<Sample>();
        for (no = 0; no < baseFeatures[0].n; ++no) {
            featureMap = new HashMap<String, Double>();
            for (i = 0; i < baseFeatures.length; ++i) {
                featureMap.put(baseFeatures[i].name, baseFeatures[i].eval(no));
            }
            bgp = new Sample(no, featureMap);
            bgpArrayList.add(no, bgp);
        }
        this.samplesAddedToFeatures = this.is("addSamplesToBackground") != false && (sampleSet2.samplesHaveData != false || Runner.gs instanceof Extractor != false);
        addSamplesToFeatures = this.samplesAddedToFeatures;
        if (addSamplesToFeatures) {
            Utils.echoln("Adding samples to background in feature space");
        }
        features = null;
        if (!addSamplesToFeatures) {
            features = this.makeFeatures(baseFeatures);
            if (Utils.interrupt) {
                return;
            }
        }
        Runner.sampleSet = sampleSet2;
        Runner.speciesCount = new HashMap<K, V>();
        if (this.spatialCV()) {
            names = Runner.sampleSet.getNames();
            species = (String[])Runner.sampleSet.speciesMap.get(names[0]);
            locations = species.stream().map((Function<Sample, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getSpatial(), (Ldensity/Sample;)Ljava/lang/Integer;)()).collect(Collectors.toList());
            locHset = new HashSet<T>(locations);
            locArr = new ArrayList<T>(locHset);
            num = locArr.size();
            Utils.warn2("Resetting replicates to number of distinct locations (replicates: " + num + ") because spatial cross-validation in use", "skippingHoldoutBecauseCV");
            this.params.setReplicates(num);
        }
        if (this.replicates() > 1 && !this.is("manualReplicates")) {
            if (this.cv()) {
                for (String s : Runner.sampleSet.getNames()) {
                    Runner.speciesCount.put(s, Runner.sampleSet.getSamples(s).length);
                }
                Runner.testSampleSet = Runner.sampleSet.splitForCV(this.replicates());
            } else if (this.spatialCV()) {
                for (String s : Runner.sampleSet.getNames()) {
                    Runner.speciesCount.put(s, Runner.sampleSet.getSamples(s).length);
                }
                Runner.testSampleSet = Runner.sampleSet.splitForSpatialCV();
            } else {
                Runner.sampleSet.replicate(this.replicates(), this.bootstrap());
            }
            torun = new ArrayList<String>();
            for (String s : Runner.sampleSet.getNames()) {
                if (!s.matches(".*_[0-9]+$")) continue;
                torun.add(s);
            }
            this.params.speciesCV = torun.toArray(new String[0]);
        }
        if (this.testSamplesFile().equals("") && this.params.getint("randomTestPoints") != 0) {
            train = null;
            if (!this.is("randomseed")) {
                Utils.generator = new Random(11111L);
            }
            Runner.testSampleSet = Runner.sampleSet.randomSample(this.params.getint("randomTestPoints"));
        }
        if (Utils.interrupt) {
            return;
        }
        outDirName = "/final/";
        outdirFinal = new File(this.outDir(), outDirName).getPath();
        this.params.setOutputdirectory(outdirFinal);
        new File(outdirFinal).mkdirs();
        if (this.is("allModels")) {
            this.writeLog();
            if (!this.is("perSpeciesResults")) {
                try {
                    Runner.results = new CsvWriter(new File(this.outDir(), "maxentResults.csv"), this.is("appendtoresultsfile"));
                }
                catch (IOException e) {
                    this.popupError("Problem opening results file", e);
                    return;
                }
            }
        }
        if (this.replicates() == 1) {
            this.params.speciesCV = this.params.species;
        }
        block30: for (sample = 0; sample < this.params.species.length; ++sample) {
            Runner.theSpecies = this.params.species[sample];
            if (Utils.interrupt) {
                return;
            }
            if (this.is("perSpeciesResults")) {
                try {
                    Runner.results = new CsvWriter(new File(this.outDir(), Runner.theSpecies + "Results.csv"));
                }
                catch (IOException e) {
                    this.popupError("Problem opening " + Runner.theSpecies + " results file", e);
                    return;
                }
            }
            suffix = this.outputFileType();
            f = new File(this.outDir(), Runner.theSpecies + suffix);
            lf = new File(this.outDir(), Runner.theSpecies + ".lambdas");
            lambdafile = lf.getAbsolutePath();
            sss = Runner.sampleSet.getSamples(Runner.theSpecies);
            if (!this.params.allowpartialdata()) {
                sss = this.withAllData(baseFeatures, sss);
            }
            if ((ss = sss).length == 0) {
                Utils.warn2("Skipping " + Runner.theSpecies + " because it has 0 training samples", "skippingBecauseNoTrainingSamples");
                continue;
            }
            if (Runner.testSampleSet != null && (len = Runner.testSampleSet.getSamples(Runner.theSpecies).length) == 0) {
                Utils.warn2("Skipping " + Runner.theSpecies + " because it has 0 test samples", "skippingBecauseNoTestSamples");
                continue;
            }
            Utils.reportMemory("getSamples");
            if (!this.is("allModels") || !lf.exists()) ** GOTO lbl-1000
            if (this.is("skipIfExists")) {
                if (!this.is("appendtoresultsfile")) continue;
                this.maybeReplicateHtml(Runner.theSpecies, this.getTrueBaseFeatures(baseFeatures));
                continue;
            }
            if (!this.is("askoverwrite") || Utils.topLevelFrame == null) ** GOTO lbl-1000
            options = new Object[]{"Skip", "Skip all", "Redo", "Redo all"};
            val = JOptionPane.showOptionDialog(Utils.topLevelFrame, "Output file exists for " + Runner.theSpecies, "File already exists", -1, 2, null, options, options[0]);
            switch (val) {
                case 1: {
                    this.params.setValue("skipIfExists", true);
                }
                case 0: {
                    if (!this.is("appendtoresultsfile")) continue block30;
                    this.maybeReplicateHtml(Runner.theSpecies, this.getTrueBaseFeatures(baseFeatures));
                    continue block30;
                }
                case 3: {
                    this.params.setValue("askoverwrite", false);
                }
                default: lbl-1000:
                // 3 sources

                {
                    baseFeaturesWithSamples = baseFeatures;
                    if (addSamplesToFeatures) {
                        features = null;
                        baseFeaturesWithSamples = this.featuresWithSamples(baseFeatures, ss);
                        if (baseFeaturesWithSamples == null) continue block30;
                        features = this.makeFeatures(baseFeaturesWithSamples);
                    }
                    baseFeaturesNoBias = this.getTrueBaseFeatures(baseFeaturesWithSamples);
                    if (Utils.interrupt) {
                        return;
                    }
                    Utils.reportDoing(Runner.theSpecies + ": ");
                    Runner.contributions = null;
                    if (bestVariables.size() > 0) {
                        features = this.makeFeatures(this.variableNoOfFeatures(baseFeatures, bestVariables));
                    }
                    if ((res = this.maxentRun(features, ss, Runner.testSampleSet != null ? Runner.testSampleSet.getSamples(Runner.theSpecies) : null)) == null) {
                        return;
                    }
                    Utils.echoln("Resulting gain: " + res.gain);
                    X = res.X;
                    res.removeBiasDistribution();
                    gsfromfile = Runner.gs instanceof GridSetFromFile;
                    writeRaw2cumfile = true;
                    backgroundIterator = null;
                    auc = X.getAUC(backgroundIterator, X.testSamples);
                    aucSD = X.aucSD;
                    trainauc = X.getAUC(backgroundIterator, X.samples);
                    Runner.aucmax = X.aucmax;
                    nParams = X.countParameters();
                    numberOccuenceLocalities = baseFeatures[0].n + X.samples.length;
                    vals1 = new ArrayList<Double>();
                    for (i = 0; i < X.samples.length; ++i) {
                        raw = X.getDensity(X.samples[i]) / X.densityNormalizer;
                        vals1.add(i, raw);
                    }
                    vals = new ArrayList<Double>();
                    for (i = 0; i < baseFeatures[0].n; ++i) {
                        raw = X.getDensity((Sample)bgpArrayList.get(i)) / X.densityNormalizer;
                        vals.add(i, raw);
                    }
                    vals.addAll(vals1);
                    valsLog = new ArrayList<Double>();
                    for (i = 0; i < vals.size(); ++i) {
                        logValue = Math.log((Double)vals.get(i));
                        valsLog.add(logValue);
                    }
                    logLikelihood = 0.0;
                    for (i = 0; i < valsLog.size(); ++i) {
                        logLikelihood += ((Double)valsLog.get(i)).doubleValue();
                    }
                    AICC = 2.0 * nParams - 2.0 * logLikelihood + 2.0 * nParams * (nParams + 1.0) / (numberOccuenceLocalities - nParams - 1.0);
                    if (backgroundIterator != null) {
                        X.setDensityNormalizer(backgroundIterator);
                    }
                    entropy = X.getEntropy();
                    prevalence = X.getPrevalence(this.params);
                    if (this.is("allModels")) {
                        try {
                            X.writeFeatureWeights(lambdafile);
                        }
                        catch (IOException e) {
                            this.popupError("Error writing feature weights file", e);
                            return;
                        }
                    }
                    v0 = testGain = Runner.testSampleSet == null ? 0.0 : this.getTestGain(X);
                    if (this.decideOnTestGain()) {
                        testGainOneModel.add(testGain);
                    }
                    if (this.decideOnTestAuc()) {
                        testGainOneModel.add(auc);
                    }
                    if (this.decideOnAICC()) {
                        testGainOneModel.add(AICC);
                    }
                    if (!this.is("allModels")) continue block30;
                    this.startHtmlPage();
                    if (writeRaw2cumfile) {
                        Runner.raw2cumfile = Runner.raw2cumfile(lambdafile);
                        try {
                            weights = backgroundIterator == null ? X.getWeights() : backgroundIterator.getvals(X.densityNormalizer);
                            this.writeCumulativeIndex(weights, Runner.raw2cumfile, X, auc, trainauc, baseFeaturesNoBias, entropy);
                        }
                        catch (IOException e) {
                            this.popupError("Error writing raw-to-cumulative index file", e);
                            return;
                        }
                    }
                    Runner.writtenGrid = null;
                    if (Utils.interrupt) {
                        return;
                    }
                    explain = true;
                    for (String s : res.featureTypes) {
                        if (!s.equals("product")) continue;
                        explain = false;
                    }
                    Runner.startedPictureHtmlSection = false;
                    if (this.is("outputGrids")) {
                        filename = gsfromfile != false ? new File(this.outDir(), Runner.theSpecies + ".csv").getPath() : f.getPath();
                        try {
                            proj = new Project(this.params);
                            proj.entropy = entropy;
                            if (gsfromfile) {
                                proj.doProject(lambdafile, (GridSetFromFile)Runner.gs, filename);
                            } else {
                                proj.doProject(lambdafile, this.environmentalLayers(), filename, null);
                            }
                            proj.entropy = -1.0;
                            if (Utils.interrupt) {
                                return;
                            }
                            Runner.writtenGrid = filename;
                            if (this.is("pictures") && !gsfromfile) {
                                this.makePicture(f.getPath(), ss, X.testSamples, null);
                            }
                            this.makeExplain(explain, f, lambdafile, Runner.theSpecies + "_explain.bat", new File(this.environmentalLayers()).getAbsolutePath());
                            if (Runner.applyThresholdValue != -1.0 && !gsfromfile) {
                                new Threshold().applyThreshold(f.getPath(), Runner.applyThresholdValue);
                            }
                        }
                        catch (IOException e) {
                            this.popupError("Error writing output file " + new File(filename).getName(), e);
                            return;
                        }
                    }
                    if (Utils.interrupt) {
                        return;
                    }
                    Runner.projectedGrids = new ArrayList<E>();
                    if (Runner.projectPrefix != null && this.is("outputGrids")) {
                        for (i = 0; i < Runner.projectPrefix.length; ++i) {
                            if (Utils.interrupt) {
                                return;
                            }
                            prefix = new File(Runner.projectPrefix[i]).getName();
                            if (prefix.endsWith(".csv")) {
                                prefix = prefix.substring(0, prefix.length() - 4);
                            }
                            isFile = new File(Runner.projectPrefix[i]).isFile();
                            ff = new File(this.outDir(), Runner.theSpecies + "_" + prefix + (isFile != false ? ".csv" : suffix));
                            ffclamp = new File(this.outDir(), Runner.theSpecies + "_" + prefix + "_clamping" + (isFile != false ? ".csv" : suffix));
                            try {
                                proj = new Project(this.params);
                                proj.needLayers = Runner.allLayers;
                                proj.doProject(lambdafile, Runner.projectPrefix[i], ff.getPath(), this.is("writeClampGrid") != false ? ffclamp.getPath() : (String)null);
                                if (Utils.interrupt) {
                                    return;
                                }
                                Runner.projectedGrids.add("<a href = \"" + ff.getName() + "\">The model applied to the environmental layers in " + Runner.projectPrefix[i] + "</a>");
                                if (this.is("pictures") && !isFile) {
                                    this.makePicture(ff.getPath(), ss, X.testSamples, Runner.projectPrefix[i]);
                                    this.makeExplain(explain, ff, lambdafile, Runner.theSpecies + "_" + prefix + "_explain.bat", new File(Runner.projectPrefix[i]).getAbsolutePath());
                                    if (this.is("writeClampGrid")) {
                                        this.makePicture(ffclamp.getPath(), new Sample[0], new Sample[0], Runner.projectPrefix[i], true);
                                    }
                                    this.makeNovel(baseFeaturesNoBias, Runner.projectPrefix[i], new File(this.outDir(), Runner.theSpecies + "_" + prefix + "_novel" + suffix).getPath());
                                }
                                if (Runner.applyThresholdValue == -1.0 || isFile) continue;
                                new Threshold().applyThreshold(ff.getPath(), Runner.applyThresholdValue);
                                continue;
                            }
                            catch (IOException e) {
                                this.popupError("Error projecting", e);
                                return;
                            }
                        }
                    }
                    if (Utils.interrupt) {
                        return;
                    }
                    try {
                        this.writeSampleAverages(baseFeaturesWithSamples, ss);
                    }
                    catch (IOException e) {
                        this.popupError("Error writing file", e);
                        return;
                    }
                    if (this.is("responsecurves")) {
                        try {
                            this.createProfiles(baseFeaturesWithSamples, lambdafile, ss);
                        }
                        catch (IOException e) {
                            this.popupError("Error writing response curves for " + Runner.theSpecies, e);
                            return;
                        }
                    }
                    if (Utils.interrupt) {
                        return;
                    }
                    permcontribs = null;
                    try {
                        permcontribs = new PermutationImportance().go(baseFeatures, ss, lambdafile);
                    }
                    catch (IOException e) {
                        this.popupError("Error computing permutation importance for " + Runner.theSpecies, e);
                        return;
                    }
                    this.writeContributions(new double[][]{Runner.contributions, permcontribs}, "");
                    jackknifeGain = this.is("jackknife") != false && baseFeaturesNoBias.length > 1 ? this.jackknifeGain(baseFeaturesWithSamples, ss, X.testSamples, res.gain, testGain, auc) : null;
                    System.out.println(jackknifeGain);
                    this.writeSummary(res, testGain, auc, aucSD, trainauc, nParams, AICC, Runner.results, baseFeaturesNoBias, jackknifeGain, entropy, prevalence, permcontribs);
                    this.writeHtmlDetails(res, testGain, auc, aucSD, trainauc, bestVariables);
                    this.htmlout.close();
                    this.maybeReplicateHtml(Runner.theSpecies, baseFeaturesNoBias);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void start(ArrayList<Double> testGainOneModel) throws IOException {
        Utils.applyStaticParams(this.params);
        if (this.params.layers == null) {
            this.params.setSelections();
        }
        if (this.cv() || this.spatialCV() && this.replicates() > 1 && this.params.getRandomtestpoints() != 0) {
            Utils.warn2("Resetting random test percentage to zero because cross-validation in use", "skippingHoldoutBecauseCV");
            this.params.setRandomtestpoints(0);
        }
        if (this.subsample() && this.replicates() > 1 && this.params.getint("randomTestPoints") <= 0 && !this.is("manualReplicates")) {
            this.popupError("Subsampled replicates require nonzero random test percentage", null);
            return;
        }
        if (!(this.spatialCV() || this.cv() || this.replicates() <= 1 || this.params.getboolean("randomseed") || this.is("manualReplicates"))) {
            Utils.warn2("Setting randomseed to true so that replicates are not identical", "settingrandomseedtrue");
            this.params.setValue("randomseed", true);
        }
        if (this.outDir() == null || this.outDir().trim().equals("")) {
            this.popupError("An output directory is needed", null);
            return;
        }
        if (this.is("allModels") && !new File(this.outDir()).exists()) {
            this.popupError("Output directory does not exist", null);
            return;
        }
        if (!this.biasFile().equals("") && this.gridsFromFile()) {
            this.popupError("Bias grid cannot be used with SWD-format background", null);
            return;
        }
        if (this.is("perSpeciesResults") && this.replicates() > 1) {
            Utils.warn2("PerSpeciesResults is not supported with replicates>1, setting perSpeciesResults to false", "unsettingPerSpeciesResults");
            this.params.setValue("perSpeciesResults", false);
        }
        if (this.is("allModels")) {
            try {
                Utils.openLog(this.outDir(), this.params.getString("logFile"));
            }
            catch (IOException e) {
                this.popupError("Error opening log file", e);
                return;
            }
        }
        Utils.startTimer();
        Utils.echoln(new Date().toString());
        Utils.echoln("MaxEnt version " + Utils.version);
        Utils.interrupt = false;
        if (this.threads() > 1) {
            Runner.parallelRunner = new ParallelRun(this.threads());
        }
        Thread.currentThread().setPriority(4);
        if (this.params.layers == null || this.params.layers.length == 0) {
            this.popupError("No environmental layers selected", null);
            return;
        }
        if (this.params.species.length == 0) {
            this.popupError("No species selected", null);
            return;
        }
        if (Utils.progressMonitor != null) {
            Utils.progressMonitor.setMaximum(100);
        }
        Utils.generator = new Random(this.params.isRandomseed() == false ? 0L : System.currentTimeMillis());
        Runner.gs = this.initializeGrids();
        if (Utils.interrupt || Runner.gs == null) {
            return;
        }
        sampleSet2 = Runner.gs.train;
        if (this.projectionLayers().length() > 0) {
            dirs = this.projectionLayers().trim().split(",");
            Runner.projectPrefix = new String[dirs.length];
            for (i = 0; i < Runner.projectPrefix.length; ++i) {
                Runner.projectPrefix[i] = new File(dirs[i].trim()).getPath();
            }
        }
        if (!this.testSamplesFile().equals("")) {
            Runner.testSampleSet = Runner.gs.test;
        }
        if (Utils.interrupt) {
            return;
        }
        if (this.is("removeDuplicates")) {
            sampleSet2.removeDuplicates(this.gridsFromFile() != false ? null : Runner.gs.getDimension());
        }
        baseFeatures = Runner.gs == null ? null : Runner.gs.toFeatures();
        Runner.coords = Runner.gs.getDimension().coords;
        if (baseFeatures == null || baseFeatures.length == 0 || baseFeatures[0].n == 0) {
            this.popupError("No background points with data in all layers", null);
            return;
        }
        bgpArrayList = new ArrayList<Sample>();
        for (no = 0; no < baseFeatures[0].n; ++no) {
            featureMap = new HashMap<String, Double>();
            for (i = 0; i < baseFeatures.length; ++i) {
                featureMap.put(baseFeatures[i].name, baseFeatures[i].eval(no));
            }
            bgp = new Sample(no, featureMap);
            bgpArrayList.add(no, bgp);
        }
        backgroundPoints = new SampleSet();
        backgroundPoints.speciesMap.put("backgroundpoints", bgpArrayList);
        this.samplesAddedToFeatures = this.is("addSamplesToBackground") != false && (sampleSet2.samplesHaveData != false || Runner.gs instanceof Extractor != false);
        addSamplesToFeatures = this.samplesAddedToFeatures;
        if (addSamplesToFeatures) {
            Utils.echoln("Adding samples to background in feature space");
        }
        features = null;
        if (!addSamplesToFeatures) {
            features = this.makeFeatures(baseFeatures);
            if (Utils.interrupt) {
                return;
            }
        }
        Runner.sampleSet = sampleSet2;
        Runner.speciesCount = new HashMap<K, V>();
        if (this.spatialCV()) {
            names = Runner.sampleSet.getNames();
            species = (String[])Runner.sampleSet.speciesMap.get(names[0]);
            locations = species.stream().map((Function<Sample, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getSpatial(), (Ldensity/Sample;)Ljava/lang/Integer;)()).collect(Collectors.toList());
            locHset = new HashSet<T>(locations);
            locArr = new ArrayList<T>(locHset);
            num = locArr.size();
            Utils.warn2("Resetting replicates to number of distinct locations (replicates: " + num + ") because spatial cross-validation in use", "skippingHoldoutBecauseCV");
            this.params.setReplicates(num);
        }
        if (this.replicates() > 1 && !this.is("manualReplicates")) {
            if (this.cv()) {
                for (String s : Runner.sampleSet.getNames()) {
                    Runner.speciesCount.put(s, Runner.sampleSet.getSamples(s).length);
                }
                Runner.testSampleSet = Runner.sampleSet.splitForCV(this.replicates());
            } else if (this.spatialCV()) {
                for (String s : Runner.sampleSet.getNames()) {
                    Runner.speciesCount.put(s, Runner.sampleSet.getSamples(s).length);
                }
                Runner.testSampleSet = Runner.sampleSet.splitForSpatialCV();
            } else {
                Runner.sampleSet.replicate(this.replicates(), this.bootstrap());
            }
            torun = new ArrayList<String>();
            for (String s : Runner.sampleSet.getNames()) {
                if (!s.matches(".*_[0-9]+$")) continue;
                torun.add(s);
            }
            this.params.speciesCV = torun.toArray(new String[0]);
        }
        if (this.testSamplesFile().equals("") && this.params.getint("randomTestPoints") != 0) {
            train = null;
            if (!this.is("randomseed")) {
                Utils.generator = new Random(11111L);
            }
            Runner.testSampleSet = Runner.sampleSet.randomSample(this.params.getint("randomTestPoints"));
        }
        if (Utils.interrupt) {
            return;
        }
        if (this.is("allModels")) {
            this.writeLog();
            if (!this.is("perSpeciesResults")) {
                try {
                    Runner.results = new CsvWriter(new File(this.outDir(), "maxentResults.csv"), this.is("appendtoresultsfile"));
                }
                catch (IOException e) {
                    this.popupError("Problem opening results file", e);
                    return;
                }
            }
        }
        block31: for (sample = 0; sample < this.params.speciesCV.length; ++sample) {
            Runner.theSpecies = this.params.speciesCV[sample];
            if (Utils.interrupt) {
                return;
            }
            if (this.is("perSpeciesResults")) {
                try {
                    Runner.results = new CsvWriter(new File(this.outDir(), Runner.theSpecies + "Results.csv"));
                }
                catch (IOException e) {
                    this.popupError("Problem opening " + Runner.theSpecies + " results file", e);
                    return;
                }
            }
            suffix = this.outputFileType();
            f = new File(this.outDir(), Runner.theSpecies + suffix);
            lf = new File(this.outDir(), Runner.theSpecies + ".lambdas");
            lambdafile = lf.getAbsolutePath();
            sss = Runner.sampleSet.getSamples(Runner.theSpecies);
            if (!this.params.allowpartialdata()) {
                sss = this.withAllData(baseFeatures, sss);
            }
            if ((ss = sss).length == 0) {
                Utils.warn2("Skipping " + Runner.theSpecies + " because it has 0 training samples", "skippingBecauseNoTrainingSamples");
                continue;
            }
            if (Runner.testSampleSet != null && (len = Runner.testSampleSet.getSamples(Runner.theSpecies).length) == 0) {
                Utils.warn2("Skipping " + Runner.theSpecies + " because it has 0 test samples", "skippingBecauseNoTestSamples");
                continue;
            }
            Utils.reportMemory("getSamples");
            if (!this.is("allModels") || !lf.exists()) ** GOTO lbl-1000
            if (this.is("skipIfExists")) {
                if (!this.is("appendtoresultsfile")) continue;
                this.maybeReplicateHtml(Runner.theSpecies, this.getTrueBaseFeatures(baseFeatures));
                continue;
            }
            if (!this.is("askoverwrite") || Utils.topLevelFrame == null) ** GOTO lbl-1000
            options = new Object[]{"Skip", "Skip all", "Redo", "Redo all"};
            val = JOptionPane.showOptionDialog(Utils.topLevelFrame, "Output file exists for " + Runner.theSpecies, "File already exists", -1, 2, null, options, options[0]);
            switch (val) {
                case 1: {
                    this.params.setValue("skipIfExists", true);
                }
                case 0: {
                    if (!this.is("appendtoresultsfile")) continue block31;
                    this.maybeReplicateHtml(Runner.theSpecies, this.getTrueBaseFeatures(baseFeatures));
                    continue block31;
                }
                case 3: {
                    this.params.setValue("askoverwrite", false);
                }
                default: lbl-1000:
                // 3 sources

                {
                    baseFeaturesWithSamples = baseFeatures;
                    if (addSamplesToFeatures) {
                        features = null;
                        baseFeaturesWithSamples = this.featuresWithSamples(baseFeatures, ss);
                        if (baseFeaturesWithSamples == null) continue block31;
                        features = this.makeFeatures(baseFeaturesWithSamples);
                    }
                    baseFeaturesNoBias = this.getTrueBaseFeatures(baseFeaturesWithSamples);
                    if (Utils.interrupt) {
                        return;
                    }
                    Utils.reportDoing(Runner.theSpecies + ": ");
                    Runner.contributions = null;
                    res = null;
                    FvsVariables = new ArrayList<String>();
                    res = this.maxentRun(features, ss, Runner.testSampleSet != null ? Runner.testSampleSet.getSamples(Runner.theSpecies) : null);
                    if (res == null) {
                        return;
                    }
                    Utils.echoln("Resulting gain: " + res.gain);
                    X = res.X;
                    res.removeBiasDistribution();
                    gsfromfile = Runner.gs instanceof GridSetFromFile;
                    writeRaw2cumfile = true;
                    backgroundIterator = null;
                    auc = X.getAUC(backgroundIterator, X.testSamples);
                    aucSD = X.aucSD;
                    trainauc = X.getAUC(backgroundIterator, X.samples);
                    Runner.aucmax = X.aucmax;
                    nParams = X.countParameters();
                    numberOccuenceLocalities = baseFeatures[0].n + X.samples.length;
                    vals1 = new ArrayList<Double>();
                    for (i = 0; i < X.samples.length; ++i) {
                        raw = X.getDensity(X.samples[i]) / X.densityNormalizer;
                        vals1.add(i, raw);
                    }
                    vals = new ArrayList<Double>();
                    for (i = 0; i < baseFeatures[0].n; ++i) {
                        raw = X.getDensity((Sample)bgpArrayList.get(i)) / X.densityNormalizer;
                        vals.add(i, raw);
                    }
                    vals.addAll(vals1);
                    System.out.println(vals.size());
                    valsLog = new ArrayList<Double>();
                    for (i = 0; i < vals.size(); ++i) {
                        logValue = Math.log((Double)vals.get(i));
                        valsLog.add(logValue);
                    }
                    logLikelihood = 0.0;
                    for (i = 0; i < valsLog.size(); ++i) {
                        logLikelihood += ((Double)valsLog.get(i)).doubleValue();
                    }
                    System.out.println(logLikelihood);
                    AICC = 2.0 * nParams - 2.0 * logLikelihood + 2.0 * nParams * (nParams + 1.0) / (numberOccuenceLocalities - nParams - 1.0);
                    System.out.println("AICC: " + AICC);
                    if (backgroundIterator != null) {
                        X.setDensityNormalizer(backgroundIterator);
                    }
                    entropy = X.getEntropy();
                    prevalence = X.getPrevalence(this.params);
                    if (this.is("allModels")) {
                        try {
                            X.writeFeatureWeights(lambdafile);
                        }
                        catch (IOException e) {
                            this.popupError("Error writing feature weights file", e);
                            return;
                        }
                    }
                    v0 = testGain = Runner.testSampleSet == null ? 0.0 : this.getTestGain(X);
                    if (this.decideOnTestGain()) {
                        testGainOneModel.add(testGain);
                    }
                    if (this.decideOnTestAuc()) {
                        testGainOneModel.add(auc);
                    }
                    if (!this.is("allModels")) continue block31;
                    this.startHtmlPage();
                    if (writeRaw2cumfile) {
                        Runner.raw2cumfile = Runner.raw2cumfile(lambdafile);
                        try {
                            weights = backgroundIterator == null ? X.getWeights() : backgroundIterator.getvals(X.densityNormalizer);
                            this.writeCumulativeIndex(weights, Runner.raw2cumfile, X, auc, trainauc, baseFeaturesNoBias, entropy);
                        }
                        catch (IOException e) {
                            this.popupError("Error writing raw-to-cumulative index file", e);
                            return;
                        }
                    }
                    Runner.writtenGrid = null;
                    if (Utils.interrupt) {
                        return;
                    }
                    explain = true;
                    for (String s : res.featureTypes) {
                        if (!s.equals("product")) continue;
                        explain = false;
                    }
                    Runner.startedPictureHtmlSection = false;
                    if (this.is("outputGrids")) {
                        filename = gsfromfile != false ? new File(this.outDir(), Runner.theSpecies + ".csv").getPath() : f.getPath();
                        try {
                            proj = new Project(this.params);
                            proj.entropy = entropy;
                            if (gsfromfile) {
                                proj.doProject(lambdafile, (GridSetFromFile)Runner.gs, filename);
                            } else {
                                proj.doProject(lambdafile, this.environmentalLayers(), filename, null);
                            }
                            proj.entropy = -1.0;
                            if (Utils.interrupt) {
                                return;
                            }
                            Runner.writtenGrid = filename;
                            if (this.is("pictures") && !gsfromfile) {
                                this.makePicture(f.getPath(), ss, X.testSamples, null);
                            }
                            this.makeExplain(explain, f, lambdafile, Runner.theSpecies + "_explain.bat", new File(this.environmentalLayers()).getAbsolutePath());
                            if (Runner.applyThresholdValue != -1.0 && !gsfromfile) {
                                new Threshold().applyThreshold(f.getPath(), Runner.applyThresholdValue);
                            }
                        }
                        catch (IOException e) {
                            this.popupError("Error writing output file " + new File(filename).getName(), e);
                            return;
                        }
                    }
                    if (Utils.interrupt) {
                        return;
                    }
                    Runner.projectedGrids = new ArrayList<E>();
                    if (Runner.projectPrefix != null && this.is("outputGrids")) {
                        for (i = 0; i < Runner.projectPrefix.length; ++i) {
                            if (Utils.interrupt) {
                                return;
                            }
                            prefix = new File(Runner.projectPrefix[i]).getName();
                            if (prefix.endsWith(".csv")) {
                                prefix = prefix.substring(0, prefix.length() - 4);
                            }
                            isFile = new File(Runner.projectPrefix[i]).isFile();
                            ff = new File(this.outDir(), Runner.theSpecies + "_" + prefix + (isFile != false ? ".csv" : suffix));
                            ffclamp = new File(this.outDir(), Runner.theSpecies + "_" + prefix + "_clamping" + (isFile != false ? ".csv" : suffix));
                            try {
                                proj = new Project(this.params);
                                proj.needLayers = Runner.allLayers;
                                proj.doProject(lambdafile, Runner.projectPrefix[i], ff.getPath(), this.is("writeClampGrid") != false ? ffclamp.getPath() : (String)null);
                                if (Utils.interrupt) {
                                    return;
                                }
                                Runner.projectedGrids.add("<a href = \"" + ff.getName() + "\">The model applied to the environmental layers in " + Runner.projectPrefix[i] + "</a>");
                                if (this.is("pictures") && !isFile) {
                                    this.makePicture(ff.getPath(), ss, X.testSamples, Runner.projectPrefix[i]);
                                    this.makeExplain(explain, ff, lambdafile, Runner.theSpecies + "_" + prefix + "_explain.bat", new File(Runner.projectPrefix[i]).getAbsolutePath());
                                    if (this.is("writeClampGrid")) {
                                        this.makePicture(ffclamp.getPath(), new Sample[0], new Sample[0], Runner.projectPrefix[i], true);
                                    }
                                    this.makeNovel(baseFeaturesNoBias, Runner.projectPrefix[i], new File(this.outDir(), Runner.theSpecies + "_" + prefix + "_novel" + suffix).getPath());
                                }
                                if (Runner.applyThresholdValue == -1.0 || isFile) continue;
                                new Threshold().applyThreshold(ff.getPath(), Runner.applyThresholdValue);
                                continue;
                            }
                            catch (IOException e) {
                                this.popupError("Error projecting", e);
                                return;
                            }
                        }
                    }
                    if (Utils.interrupt) {
                        return;
                    }
                    try {
                        this.writeSampleAverages(baseFeaturesWithSamples, ss);
                    }
                    catch (IOException e) {
                        this.popupError("Error writing file", e);
                        return;
                    }
                    if (this.is("responsecurves")) {
                        try {
                            this.createProfiles(baseFeaturesWithSamples, lambdafile, ss);
                        }
                        catch (IOException e) {
                            this.popupError("Error writing response curves for " + Runner.theSpecies, e);
                            return;
                        }
                    }
                    if (Utils.interrupt) {
                        return;
                    }
                    permcontribs = null;
                    try {
                        permcontribs = new PermutationImportance().go(baseFeatures, ss, lambdafile);
                    }
                    catch (IOException e) {
                        this.popupError("Error computing permutation importance for " + Runner.theSpecies, e);
                        return;
                    }
                    this.writeContributions(new double[][]{Runner.contributions, permcontribs}, "");
                    jackknifeGain = this.is("jackknife") != false && baseFeaturesNoBias.length > 1 ? this.jackknifeGain(baseFeaturesWithSamples, ss, X.testSamples, res.gain, testGain, auc) : null;
                    System.out.println(jackknifeGain);
                    this.writeSummary(res, testGain, auc, aucSD, trainauc, nParams, AICC, Runner.results, baseFeaturesNoBias, jackknifeGain, entropy, prevalence, permcontribs);
                    this.writeHtmlDetails(res, testGain, auc, aucSD, trainauc, FvsVariables);
                    this.htmlout.close();
                    this.maybeReplicateHtml(Runner.theSpecies, baseFeaturesNoBias);
                }
            }
        }
        this.params.speciesCV = null;
    }

    void makeNovel(Feature[] basefeatures, String projdir, String outfile) throws IOException {
        if (!this.params.isWritemess()) {
            return;
        }
        Novel novel = new Novel();
        novel.setWhiteNonNovel();
        novel.go(basefeatures, projdir, outfile);
        String projname = new File(projdir).getName();
        String layers = new File(this.environmentalLayers()).getName();
        this.htmlout.println("<br>The following two pictures compare the environmental similarity of variables in " + projname + " to the environmental data used for training the model.  In the first picture (MESS), areas in red have one or more environmental variables outside the range present in the training data, so predictions in those areas should be treated with strong caution.  The second picture (MoD) shows the most dissimilar variable, i.e., the one that is furthest outside its training range.  For details, see Elith et al., Methods in Ecology and Evolution, 2010");
        GridDimension dim = new LazyGrid(outfile).getDimension();
        this.htmlout.println("<br>" + this.htmlLink(Utils.pngname(outfile), null, dim.getnrows(), dim.getncols()) + "<br>");
        this.htmlout.println("<br>" + this.htmlLink(Utils.pngname(outfile).replaceAll(".png$", "_limiting.png"), null, dim.getnrows(), dim.getncols()) + "<br>");
    }

    void makeExplain(boolean makeIt, File predfile, String lambdafilename, String batfilename, String predvarsdir) throws IOException {
        if (!makeIt) {
            this.htmlout.println("<br>(A link to the Explain tool was not made for this model.  The model uses product features, while the Explain tool can only be used for additive models.)<br><br>");
            return;
        }
        boolean windows = System.getProperty("os.name").toLowerCase().startsWith("windows");
        File batfile = new File(this.outDir(), batfilename);
        PrintWriter out = new PrintWriter(batfile);
        String jarfile = Utils.getJarfileLocation() == null ? "" : Utils.getJarfileLocation().replaceAll("%20", " ") + System.getProperty("path.separator");
        int mem = (int)(Runtime.getRuntime().maxMemory() / 1024L / 1024L);
        if (mem < 500) {
            mem = 500;
        }
        out.println("java -mx" + mem + "m -cp \"" + jarfile + System.getProperty("java.class.path") + "\" density.Explain -l " + Utils.protectFileName(lambdafilename) + (this.params.cloglog() ? " -c " : " ") + Utils.protectFileName(predfile.getAbsolutePath()) + " " + Utils.protectFileName(predvarsdir));
        if (windows) {
            out.println("@if errorlevel 1 pause");
        }
        out.close();
        this.htmlout.println("<br>Click <a href=" + batfile.getName() + " type=application/bat>here<a> to interactively explore this prediction using the Explain tool.  If clicking from your browser does not succeed in starting the tool, try running the script in " + batfile.getAbsolutePath() + " directly.  This tool requires the environmental grids to be small enough that they all fit in memory.<br><br>");
    }

    void maybeReplicateHtml(String theSpecies, Feature[] baseFeatures) {
        String species = theSpecies.replaceAll("_[0-9]+$", "");
        if (this.replicates() > 1 && theSpecies.endsWith("_" + (this.replicates(species) - 1))) {
            try {
                this.replicateHtmlPage(species, baseFeatures);
            }
            catch (IOException e) {
                Utils.warn2("Error making replicate summary for " + species + ": check maxent.log file for details", "replicateError");
                Utils.logError("Error processing replicated species outputs", e);
                return;
            }
        }
    }

    void makeReplicateGridsAndPics(String species, String project, String projdir) throws IOException {
        final String[] suffix = new String[]{"avg", "stddev", "min", "max", "median", "lowerci"};
        final String[] link = new String[suffix.length];
        String outprefix = species + (String)(project == null ? "" : "_" + project);
        AvgStderr avgstderr = new AvgStderr(this.params, allLayers);
        avgstderr.process(this.outDir(), species, this.replicates(species), projdir, outprefix, new File(projdir).isFile() ? ".csv" : this.outputFileType());
        if (!this.is("pictures") || Utils.interrupt || new File(projdir).isFile()) {
            return;
        }
        if (this.threads() > 1) {
            parallelRunner.clear();
        }
        for (int i = 0; i < suffix.length; ++i) {
            final int me = i;
            final String fn = new File(this.outDir(), outprefix + "_" + suffix[me] + this.outputFileType()).getPath();
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        link[me] = Runner.this.makePNG(fn, me < 2 ? null : suffix[me]);
                    }
                    catch (IOException e) {
                        Runner.this.popupError("Error writing file " + fn, e);
                    }
                }
            };
            if (this.threads() <= 1) {
                task.run();
                continue;
            }
            parallelRunner.add(task, "Make PNG for " + fn);
        }
        if (this.threads() > 1) {
            parallelRunner.runall("Replicate summary pictures", this.is("verbose"));
        }
        this.htmlout.println("The following two pictures show the point-wise mean and standard deviation of the " + this.replicates(species) + (String)(project == null ? " output grids" : " models applied to the environmental layers in " + project) + ".  Other available summary grids are " + link[2] + ", " + link[3] + (link[5] == null ? " and " : ", ") + link[4] + (String)(!avgstderr.wroteLowerci() ? "" : " and 95% confidence level (" + link[5] + ")") + ".<br><br>");
        this.htmlout.println(link[0]);
        this.htmlout.println(link[1]);
        this.htmlout.println("<br>");
    }

    void replicateHtmlPage(String species, Feature[] baseFeatures) throws IOException {
        int i;
        if (Utils.interrupt) {
            return;
        }
        results.print("Species", species + " (average)");
        this.htmlout = Utils.writer(this.outDir(), species + ".html");
        this.htmlout.println("<title>Replicated maxent model for " + species + "</title>");
        this.htmlout.println("<CENTER><H1>Replicated maxent model for " + species + "</H1></CENTER>");
        this.htmlout.print("<br> This page summarizes the results of " + this.replicates(species));
        if (this.cv()) {
            this.htmlout.print("-fold cross-validation");
        } else if (this.spatialCV()) {
            this.htmlout.print("-fold spatial cross-validation");
        } else if (this.bootstrap()) {
            this.htmlout.print(" bootstrap models");
        } else {
            this.htmlout.print(" split-sample models");
        }
        this.htmlout.print(" for " + species + ", created " + new Date().toString() + " using Maxent version " + Utils.version + ".  The individual models are here:");
        for (i = 0; i < this.replicates(species); ++i) {
            this.htmlout.print(" <a href = \"" + species + "_" + i + ".html\">[" + i + "]</a>");
        }
        this.htmlout.println("<br>");
        if (this.is("plots")) {
            this.replicatedROCplot(species);
        }
        if (this.is("pictures")) {
            this.htmlout.println("<br><HR><H2>Pictures of the model</H2>");
        }
        this.makeReplicateGridsAndPics(species, null, this.environmentalLayers());
        if (Utils.interrupt) {
            this.htmlout.close();
            return;
        }
        if (projectPrefix != null) {
            for (i = 0; i < projectPrefix.length; ++i) {
                String prefix = new File(projectPrefix[i]).getName();
                this.makeReplicateGridsAndPics(species, prefix, projectPrefix[i]);
            }
        }
        if (this.is("responsecurves")) {
            this.replicatedProfiles(species, baseFeatures);
        }
        this.writeContributions(this.replicatedContributions(species), "  Values shown are averages over replicate runs.");
        if (this.is("jackknife")) {
            this.replicatedJackknife(this.htmlout, species, baseFeatures);
        }
        this.htmlputs("<br><HR><br>Command line to repeat this species model: " + this.params.commandLine(species));
        this.htmlout.close();
        String[] fields = results.getColumnNames();
        for (int i2 = 0; i2 < fields.length; ++i2) {
            try {
                double val = this.getJackMean(results.filename(), fields[i2], species);
                results.print(fields[i2], val);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        results.println();
    }

    double[][] replicatedContributions(String species) throws IOException {
        results.close();
        String res = results.filename();
        double[] rcont = new double[this.params.layers.length];
        double[] permcont = new double[this.params.layers.length];
        for (int i = 0; i < rcont.length; ++i) {
            rcont[i] = this.getJackMean(res, this.params.layers[i] + " contribution", species);
            permcont[i] = this.getJackMean(res, this.params.layers[i] + " permutation importance", species);
        }
        results.reopen();
        return new double[][]{rcont, permcont};
    }

    double getJackMean(String file, String field, String species) throws IOException {
        int num = this.replicates(species);
        String errstart = "Error calculating replicate summary: ";
        double[] vals = this.getDoubleCol(file, field);
        String[] sp = Csv.getCol(file, "Species");
        if (sp.length < 1) {
            Utils.warn2(errstart + "file " + file + " missing field \"Species\"", "jackMeanMissingSpecies");
            return 0.0;
        }
        if (vals.length < sp.length) {
            Utils.warn2(errstart + "file " + file + " missing values for field \"" + field + "\"", "jackMeanMissingField");
            return 0.0;
        }
        double sum = 0.0;
        int cnt = 0;
        for (int i = 0; i < sp.length; ++i) {
            if (!sp[i].startsWith(species + "_")) continue;
            sum += vals[i];
            ++cnt;
        }
        if (cnt != num) {
            Utils.warn2(errstart + "wrong number of values for \"" + field + "\" for replicates of " + species + " in " + file + ": found " + cnt + ", needed " + num, "jackmeannumvalues");
            return 0.0;
        }
        return sum / (double)num;
    }

    void replicatedJackknife(PrintWriter htmlout, String species, Feature[] baseFeatures) throws IOException {
        int nf = baseFeatures.length;
        results.close();
        String res = results.filename();
        double[] gain = new double[nf * 2];
        double[] testgain = new double[nf * 2];
        double[] auc = new double[nf * 2];
        boolean hastest = new Csv(res).hasField("Test gain without " + baseFeatures[0].name);
        for (int f = 0; f < nf; ++f) {
            String v = baseFeatures[f].name;
            gain[f] = this.getJackMean(res, "Training gain without " + v, species);
            gain[f + nf] = this.getJackMean(res, "Training gain with only " + v, species);
            if (!hastest) continue;
            testgain[f] = this.getJackMean(res, "Test gain without " + v, species);
            testgain[f + nf] = this.getJackMean(res, "Test gain with only " + v, species);
            auc[f] = this.getJackMean(res, "AUC without " + v, species);
            auc[f + nf] = this.getJackMean(res, "AUC with only " + v, species);
        }
        double allGain = this.getJackMean(res, "Regularized training gain", species);
        double allTestGain = 0.0;
        double allauc = 0.0;
        if (hastest) {
            allTestGain = this.getJackMean(res, "Test gain", species);
            allauc = this.getJackMean(res, "Test AUC", species);
        }
        this.makeJackknifePlots(htmlout, species, gain, testgain, auc, baseFeatures, allGain, allTestGain, allauc, hastest, "  Values shown are averages over replicate runs.");
        results.reopen();
    }

    void replicatedProfiles(String species, Feature[] baseFeatures) throws IOException {
        int nr = this.replicates(species);
        int nf = baseFeatures.length;
        int ni = 1001;
        double[][] x = new double[nr][];
        double[][] y = new double[nr][];
        String plotdir = new File(this.outDir(), "plots").getPath();
        boolean exponent = this.is("responseCurvesExponent");
        Utils.reportDoing(species + " average response curves");
        this.htmlout.println("<br><HR><H2>Response curves</H2>");
        this.htmlout.println("<br>These curves show how each environmental variable affects the Maxent prediction.");
        if (exponent) {
            this.htmlout.println("The (raw) Maxent model has the form exp(...)/constant, and the");
        } else {
            this.htmlout.println("The ");
        }
        this.htmlout.println("curves show how the " + (exponent ? "exponent" : "predicted probability of presence") + " changes as each environmental variable is varied, keeping all other environmental variables at their average sample value. Click on a response curve to see a larger version.  Note that the curves can be hard to interpret if you have strongly correlated variables, as the model may depend on the correlations in ways that are not evident in the curves.  In other words, the curves show the marginal effect of changing exactly one variable, whereas the model may take advantage of sets of variables changing together.  The curves show the mean response of the " + nr + " replicate Maxent runs (red) and and the mean +/- one standard deviation (blue, two shades for categorical variables).<br><br>");
        for (int version = 0; version < 2; ++version) {
            if (version == 1) {
                this.htmlout.println("<br><br>In contrast to the above marginal response curves, each of the following curves represents a different model, namely, a Maxent model created using only the corresponding variable.  These plots reflect the dependence of predicted suitability both on the selected variable and on dependencies induced by correlations between the selected variable and other variables.  They may be easier to interpret if there are strong correlations between variables.<br><br>");
            }
            for (int f = 0; f < nf; ++f) {
                Utils.reportProgress((double)((f + version * nf) * 100) / (double)(2 * nf));
                String varname = baseFeatures[f].name;
                for (int r = 0; r < nr; ++r) {
                    String filename = new File(plotdir, species + "_" + r + "_" + varname + (version == 1 ? "_only" : "") + ".dat").getPath();
                    x[r] = this.getDoubleCol(filename, "x");
                    y[r] = this.getDoubleCol(filename, "y");
                }
                double min = x[0][0];
                double max = x[0][x[0].length - 1];
                for (int r = 1; r < nr; ++r) {
                    if (x[r][0] < min) {
                        min = x[r][0];
                    }
                    if (!(x[r][x[r].length - 1] > max)) continue;
                    max = x[r][x[r].length - 1];
                }
                boolean iscategorical = baseFeatures[f].type() == 7;
                double[] xx = iscategorical ? this.unionCategories(x) : this.interpolate(min, max, ni);
                double[][] vals = iscategorical ? this.interpolateCatValues(x, y, xx) : this.interpolateValues(x, y, ni, min, max);
                double[] mean = new double[xx.length];
                double[] stderr = new double[xx.length];
                for (int i = 0; i < xx.length; ++i) {
                    mean[i] = AvgStderr.mean(vals[i]);
                    stderr[i] = AvgStderr.stderr(vals[i]);
                }
                String plotfilename = new File(plotdir, species + "_" + varname + (version == 1 ? "_only" : "")).getPath();
                new ResponsePlot().makeplot(xx, mean, stderr, iscategorical, varname, (exponent ? "Log response" : "Response") + " of " + species + " to " + varname, (String)(exponent ? "Log Contribution to Raw Prediction" : this.params.getString("outputformat") + " output"), plotfilename, min + (max - min) / 12.0, max - (max - min) / 12.0, this.params, exponent, this.is("writePlotData"));
                String fname = new File(plotfilename).getName();
                this.htmlout.println("<a href = \"plots/" + fname + ".png\"> <img src=\"plots/" + fname + "_thumb.png\"></a>");
            }
        }
    }

    double[] interpolate(double min, double max, int ni) {
        double[] result = new double[ni];
        for (int i = 0; i < ni; ++i) {
            result[i] = min + (double)i * (max - min) / (double)(ni - 1);
        }
        return result;
    }

    double[] getDoubleCol(String filename, String field) throws IOException {
        return Csv.getDoubleCol(filename, field);
    }

    double[] getDoubleCol(String filename, String field, double start, double end) throws IOException {
        ArrayList<CallSite> a = new ArrayList<CallSite>();
        a.add((CallSite)((Object)("" + start)));
        Csv.getCol(filename, field, a);
        a.add((CallSite)((Object)("" + end)));
        return Csv.aToDoubles(a);
    }

    void interpolateColsPlot(double[][] indices, double[][] values, String title, String xlab, String ylab, File outFile, String[] legend) throws IOException {
        this.interpolateColsPlot(indices, new double[][][]{values}, title, xlab, ylab, outFile, legend);
    }

    void interpolateColsPlot(double[][] indices, double[][][] values, String title, String xlab, String ylab, File outFile, String[] legend) throws IOException {
        int ni = 1001;
        double min = indices[0][0];
        double max = indices[0][indices[0].length - 1];
        MyPlot plot = new MyPlot();
        plot.setSize(700, 450);
        plot.setTitle(title);
        plot.setXLabel(xlab);
        plot.setYLabel(ylab);
        int nv = values.length;
        Color[] colors = plot.getColors();
        if (nv == 2) {
            plot.setColors(new Color[]{colors[0], colors[1], colors[2], colors[4], Color.black});
        } else if (nv == 1) {
            plot.setColors(new Color[]{colors[0], colors[1], Color.black});
        }
        for (int var = 0; var < nv; ++var) {
            double[][] vals = this.interpolateValues(indices, values[var], ni, min, max);
            double[] x = this.interpolate(min, max, ni);
            for (int i = 0; i < ni; ++i) {
                double mean = AvgStderr.mean(vals[i]);
                double stderr = AvgStderr.stderr(vals[i]);
                plot.addPoint(var * 2, x[i], mean, true);
                plot.addPoint(var * 2 + 1, x[i], mean < stderr ? 0.0 : mean - stderr, true);
                plot.addPoint(var * 2 + 1, x[i], mean > 1.0 - stderr ? 1.0 : mean + stderr, true);
            }
        }
        plot.addPoint(nv * 2, min, values[nv - 1][0][0], true);
        plot.addPoint(nv * 2, max, values[nv - 1][0][values[nv - 1][0].length - 1], true);
        for (int i = 0; i < legend.length; ++i) {
            if (legend[i] == null) continue;
            plot.addLegend(i, legend[i]);
        }
        ImageIO.write((RenderedImage)plot.exportImage(), "png", outFile);
        if (nv == 2 || nv == 1) {
            plot.setColors(colors);
        }
    }

    double[] unionCategories(double[][] indices) {
        int nr = indices.length;
        HashSet<Double> s = new HashSet<Double>();
        for (int r = 0; r < nr; ++r) {
            for (int c = 0; c < indices[r].length; ++c) {
                s.add(new Double(indices[r][c]));
            }
        }
        Double[] cats = s.toArray(new Double[0]);
        double[] categories = new double[cats.length];
        for (int c = 0; c < cats.length; ++c) {
            categories[c] = cats[c];
        }
        Arrays.sort(categories);
        return categories;
    }

    double[][] interpolateCatValues(double[][] indices, double[][] values, double[] categories) {
        int nr = indices.length;
        int nc = categories.length;
        double[][] result = new double[nc][nr];
        for (int r = 0; r < nr; ++r) {
            int cnt = 0;
            for (int c = 0; c < nc; ++c) {
                while (indices[r][cnt] < categories[c]) {
                    ++cnt;
                }
                result[c][r] = values[r][cnt];
            }
        }
        return result;
    }

    double[][] interpolateValues(double[][] indices, double[][] values, int ni, double min, double max) {
        int nr = indices.length;
        int[] current = new int[nr];
        double[][] result = new double[ni][nr];
        for (int i = 0; i < ni; ++i) {
            double x = min + (double)i * (max - min) / (double)(ni - 1);
            for (int r = 0; r < nr; ++r) {
                while (current[r] < indices[r].length - 1 && (min < max && indices[r][current[r]] < x || min > max && indices[r][current[r]] > x)) {
                    int n = r;
                    current[n] = current[n] + 1;
                }
                result[i][r] = current[r] == 0 ? values[r][0] : (i == ni - 1 || current[r] >= indices[r].length ? values[r][indices[r].length - 1] : (indices[r][current[r] - 1] == x ? values[r][current[r] - 1] : values[r][current[r] - 1] + (x - indices[r][current[r] - 1]) / (indices[r][current[r]] - indices[r][current[r] - 1]) * (values[r][current[r]] - values[r][current[r] - 1])));
            }
        }
        return result;
    }

    void replicatedROCplot(String species) throws IOException {
        int nr = this.replicates(species);
        double[][] cumulative = new double[nr][];
        double[][] area = new double[nr][];
        double[][] omission = new double[nr][];
        double[][] sensitivity = new double[nr][];
        String omissionType = this.bootstrap() || !this.cv() && this.params.getint("randomTestPoints") == 0 ? "Training" : "Test";
        for (int i = 0; i < nr; ++i) {
            String filename = new File(this.outDir(), species + "_" + i + "_omission.csv").getPath();
            cumulative[i] = this.getDoubleCol(filename, "Corresponding cumulative value", 0.0, 100.0);
            area[i] = this.getDoubleCol(filename, "Fractional area", 1.0, 0.0);
            omission[i] = this.getDoubleCol(filename, omissionType + " omission", 0.0, 1.0);
            sensitivity[i] = new double[omission[i].length];
            for (int j = 0; j < omission[i].length; ++j) {
                sensitivity[i][j] = 1.0 - omission[i][j];
            }
        }
        double[] aucs = new double[nr];
        for (int i = 0; i < nr; ++i) {
            String line;
            File file = new File(this.outDir(), species + "_" + i + ".html");
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                if (omissionType.equals("Test")) {
                    if (!line.startsWith("Test AUC is ")) continue;
                    aucs[i] = Double.parseDouble(line.replaceAll("Test AUC is ", "").replaceAll(",.*", ""));
                    break;
                }
                if (line.indexOf(", training AUC is") == -1) continue;
                aucs[i] = Double.parseDouble(line.replaceAll(".*, training AUC is ", "").replaceAll(",.*", ""));
            }
            in.close();
        }
        double meanauc = AvgStderr.mean(aucs);
        String plotdir = new File(this.outDir(), "plots").getPath();
        File outFile = new File(plotdir, species + "_roc.png");
        this.interpolateColsPlot((double[][])area, sensitivity, "Average Sensitivity vs. 1 - Specificity for " + species, "1 - Specificity (Fractional Predicted Area)", "Sensitivity (1 - Omission Rate)", outFile, new String[]{"Mean (AUC = " + this.nf.format(meanauc) + ")", "Mean +/- one stddev", "Random Prediction"});
        outFile = new File(plotdir, species + "_omission.png");
        this.interpolateColsPlot((double[][])cumulative, new double[][][]{area, omission}, "Average Omission and Predicted Area for " + species, "Cumulative threshold", "Fractional value", outFile, new String[]{"Mean area", "Mean area +/- one stddev", "Mean omission on " + omissionType.toLowerCase() + " data", "Mean omission +- one stddev", "Predicted omission"});
        this.htmlout.println("<br><HR><H2>Analysis of omission/commission</H2>");
        this.htmlout.print("The following picture shows the " + omissionType.toLowerCase() + " omission rate and predicted area as a function of the cumulative threshold, averaged over the replicate runs.");
        if (omissionType.equals("Test")) {
            this.htmlout.println("  The omission rate should be close to the predicted omission, because of the definition of the cumulative threshold.");
        } else {
            this.htmlout.println("");
        }
        this.htmlout.println("<br><img src=\"" + new File("plots", species + "_omission.png").getPath() + "\"><br>");
        this.htmlout.print("<br> The next picture is the receiver operating characteristic (ROC) curve for the same data, again averaged over the replicate runs.  Note that the specificity is defined using predicted area, rather than true commission (see the paper by Phillips, Anderson and Schapire cited on the help page for discussion of what this means).  ");
        this.htmlout.println("The average " + omissionType.toLowerCase() + " AUC for the replicate runs is " + this.nf.format(meanauc) + ", and the standard deviation is " + this.nf.format(AvgStderr.stderr(aucs)) + ".");
        this.htmlout.println("<br><img src=\"" + new File("plots", species + "_roc.png").getPath() + "\"><br>");
    }

    void startHtmlPage() {
        try {
            this.htmlout = Utils.writer(this.outDir(), theSpecies + ".html");
        }
        catch (IOException e) {
            this.popupError("Can't save html file for " + theSpecies + " in " + this.outDir(), e);
            return;
        }
        this.htmlout.println("<title>Maxent model for " + theSpecies + "</title>");
        this.htmlout.println("<CENTER><H1>Maxent model for " + theSpecies + "</H1></CENTER>");
        this.htmlout.println("<br> This page contains some analysis of the Maxent model for " + theSpecies + ", created " + new Date().toString() + " using Maxent version " + Utils.version + ".  If you would like to do further analyses, the raw data used here is linked to at the end of this page.<br>");
    }

    void htmlputs() {
        this.htmlputs("");
    }

    void htmlputs(String s) {
        this.htmlout.println(s + "<br>");
    }

    void htmlputsn(String s) {
        this.htmlout.print(s);
    }

    void htmlputs(String head, String[] s) {
        this.htmlputsn(head + ":");
        for (int i = 0; i < s.length; ++i) {
            this.htmlputsn(" " + s[i]);
        }
        this.htmlputs();
    }

    void writeHtmlDetails(MaxentRunResults res, double testGain, double auc, double aucSD, double trainauc, ArrayList<String> FvsVariables) {
        int i;
        double gain = res.gain;
        int iters = res.iterations;
        FeaturedSpace X = res.X;
        int time = (int)Math.round(res.time);
        this.htmlputs("<br><HR><H2>Raw data outputs and control parameters</H2>");
        this.htmlputs("The data used in the above analysis is contained in the next links.  Please see the Help button for more information on these.");
        if (writtenGrid != null) {
            String name = new File(writtenGrid).getName();
            this.htmlputs("<a href = \"" + name + "\">The model applied to the training environmental layers</a>");
        }
        if (projectedGrids.size() > 0) {
            for (int i2 = 0; i2 < projectedGrids.size(); ++i2) {
                this.htmlputs((String)projectedGrids.get(i2));
            }
        }
        this.htmlputs("<a href = \"" + theSpecies + ".lambdas\">The coefficients of the model</a>");
        this.htmlputs("<a href = \"" + theSpecies + "_omission.csv\">The omission and predicted area for varying cumulative and raw thresholds</a>");
        this.htmlputs("<a href = \"" + theSpecies + "_samplePredictions.csv\">The prediction strength at the training and (optionally) test presence sites</a>");
        this.htmlputs("<a href = \"maxentResults.csv\">Results for all species modeled in the same Maxent run, with summary statistics and (optionally) jackknife results</a>");
        this.htmlputs("<br>");
        this.htmlputsn("Regularized training gain is " + this.nf.format(gain));
        this.htmlputsn(", training AUC is " + this.nf.format(trainauc));
        this.htmlputs(", unregularized training gain is " + this.nf.format(gain + X.getL1reg()) + ".");
        if (X.numTestSamples != 0) {
            this.htmlputs("Unregularized test gain is " + this.nf.format(testGain) + ".");
            this.htmlputs("Test AUC is " + this.nf.format(auc) + ", standard deviation is " + this.nf.format(aucSD) + " (calculated as in DeLong, DeLong & Clarke-Pearson 1988, equation 2" + (aucSD == -1.0 ? "; a value of -1 indicates that only one test point was used" : "") + ").");
        }
        String termination = iters < this.params.getint("maximumiterations") ? "converged" : "terminated";
        this.htmlputs("Algorithm " + termination + " after " + iters + " iterations (" + time + " seconds).");
        this.htmlputs();
        this.htmlputs("The follow settings were used during the run:");
        this.htmlputsn(X.numSamples + " presence records used for training");
        if (X.numTestSamples != 0) {
            this.htmlputsn(", " + X.numTestSamples + " for testing");
        }
        this.htmlputs(".");
        this.htmlputs(X.numPoints + " points used to determine the Maxent distribution (background points" + (this.samplesAddedToFeatures ? " and presence points" : "") + ").");
        boolean allcont = true;
        for (i = 0; i < this.params.layers.length; ++i) {
            if (!this.params.layerTypes[i].equals("Categorical")) continue;
            allcont = false;
        }
        this.htmlputsn("Environmental layers used" + (allcont ? " (all continuous):" : ":"));
        if (this.is("fvs")) {
            for (i = 0; i < FvsVariables.size(); ++i) {
                this.htmlputsn(" " + FvsVariables.get(i));
            }
        } else {
            for (i = 0; i < this.params.layers.length; ++i) {
                this.htmlputsn(" " + this.params.layers[i] + (this.params.layerTypes[i].equals("Continuous") ? "" : "(categorical)"));
            }
        }
        this.htmlputs();
        this.htmlputs("Regularization values: " + this.regularizationConstants());
        this.htmlputs("Beta multiplier used: " + this.params.getBetamultiplier());
        int numSamples = X.numSamples;
        this.htmlputs("Feature types used", res.featureTypes);
        for (Parameter param : this.params.allParams()) {
            if (!param.changed()) continue;
            this.htmlputs(param.toString());
        }
        this.htmlputs("Command line used: " + this.params.commandLine());
        this.htmlputs();
        if (this.replicates() == 1) {
            this.htmlputs("Command line to repeat this species model: " + this.params.commandLine(theSpecies));
        }
    }

    String regularizationConstants() {
        return "linear/quadratic/product: " + this.nf.format(this.beta_lqp) + ", categorical: " + this.nf.format(this.beta_cat) + ", threshold: " + this.nf.format(this.beta_thr) + ", hinge: " + this.nf.format(this.beta_hge);
    }

    void makePicture(String fileName, Sample[] ss, Sample[] ts, String dir) throws IOException {
        this.makePicture(fileName, ss, ts, dir, false);
    }

    void makePicture(String fileName, Sample[] ss, Sample[] ts, String dir, boolean isClampPicture) throws IOException {
        ShrunkGrid g = new ShrunkGrid(new LazyGrid(fileName), 2000);
        this.makePicture(g, fileName, ss, ts, dir, isClampPicture);
    }

    String makePNG(String fileName, String tag) throws IOException {
        if (!new File(fileName).exists()) {
            return null;
        }
        ShrunkGrid g = new ShrunkGrid(new LazyGrid(fileName), 2000);
        return this.makePNG(g, fileName, null, null, false, tag);
    }

    String makePNG(Grid g, String fileName, Sample[] ss, Sample[] testSamples, boolean forcePlain, String tag) {
        String newFileName = new File(new File(this.outDir(), "plots"), Utils.pngname(fileName)).getPath();
        Display d = new Display(g);
        if (!this.is("logScale") || this.occurrenceProbability() || forcePlain) {
            d.setMode(1);
        } else if (this.cumulative()) {
            d.minval = 1.0E-5;
            d.maxval = 100.0;
        }
        if (this.occurrenceProbability() || forcePlain) {
            d.minval = 0.0;
            d.maxval = 1.0;
        }
        d.visible = false;
        d.setSamples(ss);
        d.setTestSamples(testSamples);
        d.makeLegend = true;
        Utils.reportDoing("Writing " + newFileName);
        d.makeImage();
        d.writeImage(newFileName, 1);
        int nc = d.getCols();
        int nr = d.getRows();
        return this.htmlLink("plots/" + Utils.pngname(fileName), tag, nr, nc);
    }

    String htmlLink(String filename, String tag, int nr, int nc) {
        String restrict = null;
        if (nc > 600) {
            restrict = " width=600";
        }
        if (nr > 600 && nr > nc) {
            restrict = " height=600";
        }
        return "<a href = \"" + filename + "\">" + (String)(tag == null ? " <img src=\"" + filename + "\"" + (restrict == null ? "" : restrict) + ">" : tag) + "</a>";
    }

    void makePicture(Grid g, String fileName, Sample[] ss, Sample[] testSamples, String dir, boolean isClampPicture) {
        String link = this.makePNG(g, fileName, ss, testSamples, isClampPicture, null);
        if (!startedPictureHtmlSection) {
            startedPictureHtmlSection = true;
            this.htmlout.println("<br><HR><H2>Pictures of the model</H2>");
        }
        if (dir == null) {
            this.htmlout.print("This is a representation of the Maxent model for " + theSpecies + ".");
        } else if (isClampPicture) {
            this.htmlout.println("The following picture shows where the prediction is most affected by variables being outside their training range, while projecting the Maxent model onto the environmental variables in " + new File(dir).getAbsolutePath() + ".  The values shown in the picture give the absolute difference in predictions when using vs not using clamping.  (Clamping means that environmental variables and features are restricted to the range of values encountered during training.)  Warmer colors show areas where the treatment of variable values outside their training ranges is likely to have a large effect on predicted suitability.");
        } else {
            this.htmlout.print("This is the projection of the Maxent model for " + theSpecies + " onto the environmental variables in " + dir + ".");
        }
        if (!isClampPicture) {
            this.htmlout.println("  Warmer colors show areas with better predicted conditions.  White dots show the presence locations used for training, while violet dots show test locations.  Click on the image for a full-size version.<br>");
        }
        this.htmlout.println("<br>" + link + "<br>");
    }

    boolean hasAllData(Sample s, Feature[] f) {
        for (int j = 0; j < f.length; ++j) {
            if (f[j].hasData(s)) continue;
            return false;
        }
        return true;
    }

    Sample[] withAllData(Feature[] f, Sample[] ss) {
        ArrayList<Sample> result = new ArrayList<Sample>();
        for (int i = 0; i < ss.length; ++i) {
            if (!this.hasAllData(ss[i], f)) continue;
            result.add(ss[i]);
        }
        return result.toArray(new Sample[0]);
    }

    Feature[] featuresWithSamples(Feature[] f, Sample[] ss) {
        Feature[] result = new Feature[f.length];
        double[] rnd = new double[f.length];
        for (int j = 0; j < rnd.length; ++j) {
            rnd[j] = Utils.generator.nextDouble();
        }
        double[] backgroundHash = new double[f[0].n];
        for (int i = 0; i < f[0].n; ++i) {
            for (int j = 0; j < f.length; ++j) {
                int n = i;
                backgroundHash[n] = backgroundHash[n] + rnd[j] * f[j].eval(i);
            }
        }
        Arrays.sort(backgroundHash);
        ArrayList<Sample> samplesToAdda = new ArrayList<Sample>();
        for (int i = 0; i < ss.length; ++i) {
            double r = 0.0;
            for (int j = 0; j < f.length; ++j) {
                if (!f[j].hasData(ss[i])) continue;
                r += rnd[j] * f[j].eval(ss[i]);
            }
            if (!this.is("addAllSamplesToBackground") && Arrays.binarySearch(backgroundHash, r) >= 0) continue;
            samplesToAdda.add(ss[i]);
        }
        if (samplesToAdda.size() == 0) {
            return f;
        }
        Sample[] sss = samplesToAdda.toArray(new Sample[0]);
        for (int j = 0; j < f.length; ++j) {
            int i;
            ArrayList<Double> a = new ArrayList<Double>();
            for (i = 0; i < sss.length; ++i) {
                if (!f[j].hasData(sss[i])) continue;
                a.add(new Double(f[j].eval(sss[i])));
            }
            if (a.size() == 0) {
                Utils.warn2("Species " + theSpecies + " missing all data for " + f[j].name + ", skipping", "skippingBecauseNoData");
                return null;
            }
            for (i = 0; i < sss.length; ++i) {
                if (f[j].hasData(sss[i])) continue;
                int rndi = Utils.generator.nextInt(a.size());
                sss[i].featureMap.put(f[j].name, a.get(rndi));
            }
            result[j] = new FeatureWithSamplesAsPoints(f[j], sss);
        }
        return result;
    }

    void createProfiles(final Feature[] baseFeatures, String lambdafile, final Sample[] ss) throws IOException {
        this.createProfiles(lambdafile, baseFeatures, ss, null);
        if (!(this.is("linear") || this.is("quadratic") || this.is("threshold") || this.is("hinge"))) {
            Utils.echoln("Skipping 1-var response curves, as only product features are in use");
            return;
        }
        this.htmlout.println("<br>In contrast to the above marginal response curves, each of the following curves represents a different model, namely, a Maxent model created using only the corresponding variable.  These plots reflect the dependence of predicted suitability both on the selected variable and on dependencies induced by correlations between the selected variable and other variables.  They may be easier to interpret if there are strong correlations between variables.<br><br>");
        if (this.threads() > 1) {
            parallelRunner.clear();
        }
        for (int i = 0; i < baseFeatures.length; ++i) {
            if (!this.isTrueBaseFeature(baseFeatures[i])) continue;
            final Feature f = baseFeatures[i];
            String myname = "Response curve: only " + f.name;
            Utils.echoln(myname);
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    Runner.this.oneVarResponseRun(baseFeatures, ss, f);
                }
            };
            String fname = theSpecies + "_" + f.name + "_only";
            this.htmlout.println("<a href = \"plots/" + fname + ".png\"> <img src=\"plots/" + fname + "_thumb.png\"></a>");
            if (this.threads() <= 1) {
                task.run();
                continue;
            }
            parallelRunner.add(task, myname);
        }
        if (this.threads() > 1) {
            parallelRunner.runall("1-var response curves", this.is("verbose"));
        }
        this.htmlout.println("<br>");
    }

    Feature[] onlyOneFeature(Feature[] baseFeatures, Feature feature) {
        ArrayList<Feature> onlya = new ArrayList<Feature>();
        onlya.add(feature);
        for (int i = 0; i < baseFeatures.length; ++i) {
            if (this.isTrueBaseFeature(baseFeatures[i])) continue;
            onlya.add(baseFeatures[i]);
        }
        return onlya.toArray(new Feature[0]);
    }

    Feature[] onlyTwoFeatures(Feature[] baseFeatures, Feature feature1, Feature feature2) {
        ArrayList<Feature> onlya = new ArrayList<Feature>();
        onlya.add(feature1);
        onlya.add(feature2);
        for (int i = 0; i < baseFeatures.length; ++i) {
            if (this.isTrueBaseFeature(baseFeatures[i])) continue;
            onlya.add(baseFeatures[i]);
        }
        return onlya.toArray(new Feature[0]);
    }

    Feature[] variableNoOfFeatures(Feature[] baseFeatures, ArrayList<String> tempSelectedVars) {
        ArrayList<Feature> usedFeatures = new ArrayList<Feature>();
        for (int k = 0; k < tempSelectedVars.size(); ++k) {
            for (int j = 0; j < baseFeatures.length; ++j) {
                if (!baseFeatures[j].name.equals(tempSelectedVars.get(k))) continue;
                usedFeatures.add(baseFeatures[j]);
            }
        }
        return usedFeatures.toArray(new Feature[0]);
    }

    void oneVarResponseRun(Feature[] baseFeatures, Sample[] ss, Feature f) {
        Feature[] only = this.onlyOneFeature(baseFeatures, f);
        Feature[] features = this.makeFeatures(only);
        if (Utils.interrupt) {
            return;
        }
        Utils.reportDoing(theSpecies + " " + f.name + ": ");
        MaxentRunResults res = this.maxentRun(features, ss, new Sample[0]);
        if (res != null) {
            Utils.echoln("Resulting gain: " + res.gain);
            res.removeBiasDistribution();
            try {
                String lambdas = res.X.writeFeatureWeights();
                double[][] raw2cum = this.cumulative() ? this.writeCumulativeIndex(res.X.getWeights(), null, res.X, -1.0, -1.0, features, -1.0) : null;
                this.createProfiles(lambdas, only, null, raw2cum);
            }
            catch (IOException e) {
                this.popupError("Error writing response curve for " + theSpecies + " " + f.name, e);
                return;
            }
        }
    }

    double[] sampleAverages(Feature[] baseFeatures, Sample[] samples, double[][] categories, boolean[] isCategorical) {
        double[] result = new double[baseFeatures.length];
        for (int i = 0; i < baseFeatures.length; ++i) {
            boolean iscat;
            boolean bl = iscat = baseFeatures[i].type() == 7;
            if (isCategorical != null) {
                isCategorical[i] = iscat;
            }
            if (iscat) {
                HashSet<Double> s = new HashSet<Double>();
                for (int j = 0; j < baseFeatures[i].n; ++j) {
                    s.add(new Double(baseFeatures[i].eval(j)));
                }
                Double[] cats = s.toArray(new Double[0]);
                double[] allcats = new double[cats.length];
                for (int j = 0; j < cats.length; ++j) {
                    allcats[j] = cats[j];
                }
                Arrays.sort(allcats);
                if (categories != null) {
                    categories[i] = allcats;
                }
                int[] cnt = new int[allcats.length];
                for (int j = 0; j < samples.length; ++j) {
                    double val;
                    int k;
                    if (!baseFeatures[i].hasData(samples[j]) || (k = Arrays.binarySearch(allcats, val = baseFeatures[i].eval(samples[j]))) < 0) continue;
                    int n = k;
                    cnt[n] = cnt[n] + 1;
                }
                int max = 0;
                int maxj = 0;
                for (int j = 0; j < cnt.length; ++j) {
                    if (cnt[j] <= max) continue;
                    max = cnt[j];
                    maxj = j;
                }
                result[i] = allcats[maxj];
                continue;
            }
            double sum = 0.0;
            int cnt = 0;
            for (int j = 0; j < samples.length; ++j) {
                if (!baseFeatures[i].hasData(samples[j])) continue;
                sum += baseFeatures[i].eval(samples[j]);
                ++cnt;
            }
            result[i] = cnt == 0 ? 0.0 : sum / (double)cnt;
        }
        return result;
    }

    void writeSampleAverages(Feature[] baseFeatures, Sample[] samples) throws IOException {
        boolean[] isCategorical = new boolean[baseFeatures.length];
        double[] averages = this.sampleAverages(baseFeatures, samples, null, isCategorical);
        PrintWriter avgout = Utils.writer(this.outDir(), theSpecies + "_sampleAverages.csv");
        avgout.println("Predictor variable,Categorical,Sample average");
        for (int i = 0; i < baseFeatures.length; ++i) {
            avgout.println(baseFeatures[i].name + "," + isCategorical[i] + "," + averages[i]);
        }
        avgout.close();
    }

    void createProfiles(String lambdafile, Feature[] baseFeatures, Sample[] samples, double[][] raw2cum) throws IOException {
        boolean oneVarProfile = samples == null;
        boolean exponent = this.is("responseCurvesExponent");
        if (oneVarProfile) {
            samples = new Sample[]{};
        }
        Utils.reportDoing(theSpecies + " response curves");
        HashMap<String, Double> map = new HashMap<String, Double>();
        boolean[] isCategorical = new boolean[baseFeatures.length];
        double[][] categories = new double[baseFeatures.length][];
        double[] averages = this.sampleAverages(baseFeatures, samples, categories, isCategorical);
        for (int i = 0; i < baseFeatures.length; ++i) {
            map.put(baseFeatures[i].name, new Double(averages[i]));
        }
        Project proj = new Project(this.params);
        proj.mapping = true;
        proj.varmap = map;
        proj.exponent = exponent;
        proj.raw2cum = raw2cum;
        Grid projgrid = proj.projectGrid(lambdafile, null)[0];
        String plotdir = new File(this.outDir(), "plots").getPath();
        try {
            new File(plotdir).mkdir();
        }
        catch (SecurityException e) {
            this.popupError("Can't create directory in " + this.outDir() + " for plots", e);
            return;
        }
        PrintWriter out = this.htmlout;
        if (!oneVarProfile) {
            out.println("<br><HR><H2>Response curves</H2>");
            out.println("<br>These curves show how each environmental variable affects the Maxent prediction.");
            if (exponent) {
                out.println("The (raw) Maxent model has the form exp(...)/constant, and the");
            } else {
                out.println("The ");
            }
            out.println("curves show how the " + (exponent ? "exponent" : "predicted probability of presence") + " changes as each environmental variable is varied, keeping all other environmental variables at their average sample value. Click on a response curve to see a larger version.  Note that the curves can be hard to interpret if you have strongly correlated variables, as the model may depend on the correlations in ways that are not evident in the curves.  In other words, the curves show the marginal effect of changing exactly one variable, whereas the model may take advantage of sets of variables changing together.<br><br>");
        }
        for (int i = 0; i < baseFeatures.length; ++i) {
            if (!this.isTrueBaseFeature(baseFeatures[i])) continue;
            Utils.reportProgress((double)(i * 100) / (double)baseFeatures.length);
            String name = baseFeatures[i].name;
            double min = 0.0;
            double max = 0.0;
            if (!isCategorical[i]) {
                for (int j = 0; j < baseFeatures[i].n; ++j) {
                    if (j == 0 || baseFeatures[i].eval(j) < min) {
                        min = baseFeatures[i].eval(j);
                    }
                    if (j != 0 && !(baseFeatures[i].eval(j) > max)) continue;
                    max = baseFeatures[i].eval(j);
                }
            }
            double[][] rpd = Runner.responsePlotData(projgrid, map, name, min, max, isCategorical[i] ? categories[i] : null, exponent);
            String plotfilename = new File(plotdir, theSpecies + "_" + name + (oneVarProfile ? "_only" : "")).getPath();
            try {
                new ResponsePlot().makeplot(rpd[0], rpd[1], null, isCategorical[i], name, (exponent ? "Log response" : "Response") + " of " + theSpecies + " to " + name, (String)(exponent ? "Log Contribution to Raw Prediction" : this.params.getString("outputformat") + " output"), plotfilename, min, max, this.params, exponent, this.is("writePlotData") || this.replicates() > 1);
            }
            catch (IOException e) {
                this.popupError("Error plotting response curve", e);
            }
            String fname = new File(plotfilename).getName();
            if (oneVarProfile) continue;
            out.println("<a href = \"plots/" + fname + ".png\"> <img src=\"plots/" + fname + "_thumb.png\"></a>");
        }
        if (!oneVarProfile) {
            out.println("<br>");
        }
    }

    static double[][] responsePlotData(Grid projgrid, HashMap map, String var, double min, double max, double[] categories, boolean exponent) {
        double[] x;
        Object savedMean = map.get(var);
        double minx = min - (max - min) / 10.0;
        double maxx = max + (max - min) / 10.0;
        if (categories != null) {
            x = categories;
        } else {
            if (min == max) {
                minx = min - 0.1;
                maxx = max + 0.1;
            }
            int num = 501;
            x = new double[num];
            for (int j = 0; j < num; ++j) {
                x[j] = minx + (double)j * (maxx - minx) / (double)(num - 1);
            }
        }
        double[] y = new double[x.length];
        map.put(var, new Double(categories != null ? categories[0] - 1.0 : minx));
        double zeropoint = projgrid.eval(0, 0);
        for (int j = 0; j < x.length; ++j) {
            map.put(var, new Double(x[j]));
            y[j] = (double)projgrid.eval(0, 0) - (exponent ? zeropoint : 0.0);
        }
        map.put(var, savedMean);
        return new double[][]{x, y};
    }

    static void dump(HashMap map) {
        for (Object o : map.keySet()) {
            System.out.println("Map " + o + ":" + map.get(o));
        }
    }

    void leaveOneOutRun(Feature[] baseFeatures, Sample[] ss, Sample[] testSamples, int me, double[] gain, double[] testgain, double[] auc, Feature toLeaveOut) {
        boolean hastest = testSamples != null && testSamples.length > 0;
        Feature[] leaveOneOut = new Feature[baseFeatures.length - 1];
        int cnt = 0;
        for (int j = 0; j < baseFeatures.length; ++j) {
            if (baseFeatures[j] == toLeaveOut) continue;
            leaveOneOut[cnt++] = baseFeatures[j];
        }
        Feature[] features = this.makeFeatures(leaveOneOut);
        if (features == null) {
            return;
        }
        if (Utils.interrupt) {
            return;
        }
        Utils.reportDoing(theSpecies + " " + toLeaveOut.name + ": ");
        MaxentRunResults res = this.maxentRun(features, ss, testSamples);
        if (res == null) {
            return;
        }
        res.removeBiasDistribution();
        gain[me] = res.gain;
        if (hastest) {
            DoubleIterator backgroundIterator = null;
            auc[me] = res.X.getAUC(backgroundIterator, testSamples);
            if (backgroundIterator != null) {
                res.X.setDensityNormalizer(backgroundIterator);
            }
            testgain[me] = this.getTestGain(res.X);
        }
    }

    void onlyOneRun(Feature[] baseFeatures, Sample[] ss, Sample[] testSamples, int me, double[] gain, double[] testgain, double[] auc, Feature onlyfeature) {
        int num = this.getTrueBaseFeatures(baseFeatures).length;
        boolean hastest = testSamples != null && testSamples.length > 0;
        Feature[] only = this.onlyOneFeature(baseFeatures, onlyfeature);
        Feature[] features = this.makeFeatures(only);
        if (features == null) {
            return;
        }
        if (Utils.interrupt) {
            return;
        }
        Utils.reportDoing(theSpecies + " " + onlyfeature.name + ": ");
        MaxentRunResults res = this.maxentRun(features, ss, testSamples);
        if (res == null) {
            return;
        }
        Utils.echoln("Res.gain: " + res.gain);
        res.removeBiasDistribution();
        gain[num + me] = res.gain;
        if (hastest) {
            DoubleIterator backgroundIterator = null;
            auc[num + me] = res.X.getAUC(backgroundIterator, testSamples);
            if (backgroundIterator != null) {
                res.X.setDensityNormalizer(backgroundIterator);
            }
            testgain[num + me] = this.getTestGain(res.X);
        }
    }

    void onlyTwoRun(Feature[] baseFeatures, Sample[] ss, Sample[] testSamples, int me, double[] gain, double[] testgain, double[] auc, Feature feature1, Feature feature2, int maxComb) {
        boolean hastest = testSamples != null && testSamples.length > 0;
        Feature[] two = this.onlyTwoFeatures(baseFeatures, feature1, feature2);
        Feature[] features = this.makeFeatures(two);
        if (features == null) {
            return;
        }
        if (Utils.interrupt) {
            return;
        }
        Utils.reportDoing(theSpecies + ": Forward Variable Selection: " + feature1.name + " & " + feature2.name + ": ");
        MaxentRunResults res = this.maxentRun(features, ss, testSamples);
        if (res == null) {
            return;
        }
        Utils.echoln("Res.gain: " + res.gain);
        res.removeBiasDistribution();
        gain[me] = res.gain;
        if (hastest) {
            DoubleIterator backgroundIterator = null;
            auc[me] = res.X.getAUC(backgroundIterator, testSamples);
            if (backgroundIterator != null) {
                res.X.setDensityNormalizer(backgroundIterator);
            }
            testgain[me] = this.getTestGain(res.X);
        }
    }

    public double tuneBetaMultiplier(ArrayList<String> bestVariables, ArrayList<String> FfsFeatures, Feature[] baseFeatures, boolean addSamplesToFeatures, Feature[] features, ArrayList<Sample> bgpArrayList) {
        ArrayList<Double> testGainOneModel = new ArrayList<Double>();
        ArrayList testAucOneModel = new ArrayList();
        ArrayList<Double> testGainTmp = new ArrayList<Double>();
        double bStart = this.params.getRMMin();
        double bEnd = this.params.getRMMax();
        double bStep = this.params.getRMIncrease();
        DoubleStream betaMultiplier = DoubleStream.iterate(bStart, d -> d + bStep).limit((int)(1.0 + (bEnd - bStart) / bStep));
        double[] b = betaMultiplier.toArray();
        for (int beta = 0; beta < b.length; ++beta) {
            String outDirOrg = this.params.getOutputdirectory();
            String outDirName = "\\beta\\betaMultiplier_" + b[beta];
            String outdir = new File(this.outDir(), outDirName).getPath();
            if (this.is("allModels")) {
                new File(outdir).mkdirs();
            }
            this.params.setOutputdirectory(outdir);
            this.params.setBetamultiplier(b[beta]);
            System.out.println("beta multiplier: " + this.betaMultiplier());
            this.startNew(bestVariables, FfsFeatures, testGainOneModel, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
            this.end();
            this.params.setOutputdirectory(outDirOrg);
            double sum = 0.0;
            for (double d2 : testGainOneModel) {
                sum += d2;
            }
            Double testGainAverageBeta = sum / (double)testGainOneModel.size();
            System.out.println("Test gain average is: " + testGainAverageBeta);
            testGainTmp.add(testGainAverageBeta);
            testGainOneModel.clear();
        }
        double currentTestGain = 0.0;
        if (this.decideOnTestGain() | this.decideOnTestAuc()) {
            currentTestGain = (Double)Collections.max(testGainTmp);
        } else if (this.decideOnAICC()) {
            currentTestGain = (Double)Collections.min(testGainTmp);
        }
        int indexTemp = testGainTmp.indexOf(currentTestGain);
        double bestBetaValue = b[indexTemp];
        System.out.println(bestBetaValue);
        testGainTmp.clear();
        this.params.setBetamultiplier(bestBetaValue);
        return bestBetaValue;
    }

    /*
     * Enabled aggressive block sorting
     */
    void forwardFeatureSelection(ArrayList<String> bestVariables, ArrayList<String> FfsFeatures, Feature[] baseFeatures, boolean addSamplesToFeatures, Feature[] features, ArrayList<Sample> bgpArrayList) {
        String[] strs = new String[]{"quadratic", "product", "threshold", "hinge", "linear"};
        ArrayList<String> featureNames = new ArrayList<String>();
        featureNames.addAll(List.of(strs));
        ArrayList<Double> testGainOneModel = new ArrayList<Double>();
        ArrayList<Double> testGainTmp = new ArrayList<Double>();
        double bestTestGain = 0.0;
        double currentTestGain = 0.0;
        ArrayList<String> selectedFeatures = new ArrayList<String>();
        this.params.setAutofeature(false);
        ArrayList<String> tempSelectedFeatures = new ArrayList<String>();
        int noPredictors = featureNames.size();
        int i = 0;
        while (i < noPredictors) {
            for (int k = 0; k < featureNames.size(); ++k) {
                tempSelectedFeatures.addAll(selectedFeatures);
                tempSelectedFeatures.add((String)featureNames.get(k));
                System.out.println("Selected features: " + tempSelectedFeatures);
                int me = k;
                String myname = "Forward Feature Selection: using " + tempSelectedFeatures;
                Utils.echoln(myname);
                System.out.println("Forward Feature Selection: using " + tempSelectedFeatures);
                Utils.reportDoing(theSpecies + ": Forward Feature Selection: " + tempSelectedFeatures + ": ");
                testGainOneModel.clear();
                this.startNew(bestVariables, tempSelectedFeatures, testGainOneModel, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                this.end();
                double sum = 0.0;
                for (double d : testGainOneModel) {
                    sum += d;
                }
                Double testGainAverage = sum / (double)testGainOneModel.size();
                System.out.println("Decision parameter average is: " + testGainAverage);
                testGainTmp.add(testGainAverage);
                testGainOneModel.clear();
                tempSelectedFeatures.clear();
            }
            if (this.decideOnTestAuc() | this.decideOnTestGain()) {
                currentTestGain = (Double)Collections.max(testGainTmp);
            } else if (this.decideOnAICC()) {
                currentTestGain = (Double)Collections.min(testGainTmp);
            }
            int indexTemp = testGainTmp.indexOf(currentTestGain);
            if (i == 0) {
                bestTestGain = currentTestGain;
            }
            if (this.decideOnAICC()) {
                if (!(currentTestGain <= bestTestGain)) {
                    FfsFeatures.addAll(selectedFeatures);
                    System.out.println(FfsFeatures);
                    return;
                }
                bestTestGain = currentTestGain;
                selectedFeatures.add((String)featureNames.get(indexTemp));
                featureNames.remove(indexTemp);
            } else if (this.decideOnTestAuc() | this.decideOnTestGain()) {
                if (!(currentTestGain >= bestTestGain)) {
                    FfsFeatures.addAll(selectedFeatures);
                    System.out.println("Selected features: " + FfsFeatures);
                    return;
                }
                bestTestGain = currentTestGain;
                selectedFeatures.add((String)featureNames.get(indexTemp));
                featureNames.remove(indexTemp);
            }
            testGainTmp.clear();
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void forwardVariableSelectionNew(ArrayList<String> varNames, ArrayList<String> FvsVariables, ArrayList<String> bestFeatures, Feature[] baseFeatures, boolean addSamplesToFeatures, Feature[] features, ArrayList<Sample> bgpArrayList) {
        int num = varNames.size();
        List range = IntStream.rangeClosed(0, num - 1).boxed().collect(Collectors.toList());
        Set comb = Sets.combinations(Sets.newHashSet(range), 2);
        Integer[][] allComb = new Integer[comb.size()][2];
        for (int i = 0; i < comb.size(); ++i) {
            Set arr = (Set)comb.stream().collect(Collectors.toList()).get(i);
            allComb[i][0] = (Integer)arr.stream().collect(Collectors.toList()).get(0);
            allComb[i][1] = (Integer)arr.stream().collect(Collectors.toList()).get(1);
        }
        ArrayList<Double> testGainOneModel = new ArrayList<Double>();
        ArrayList<Double> testGainTmp = new ArrayList<Double>();
        for (int i = 0; i < comb.size(); ++i) {
            int me2 = allComb[i][0];
            int me1 = allComb[i][1];
            int me = i;
            String myname = "Forward Variable Selection: using only " + varNames.get(me1) + " & " + varNames.get(me2);
            Utils.echoln(myname);
            ArrayList<String> twoVarComb = new ArrayList<String>();
            twoVarComb.add(varNames.get(me1));
            twoVarComb.add(varNames.get(me2));
            String outDirOrg = this.params.getOutputdirectory();
            String outDirName = "\\fvs\\2varCombinations\\" + varNames.get(me1) + "___" + varNames.get(me2);
            String outdir = new File(this.outDir(), outDirName).getPath();
            if (this.is("allModels")) {
                new File(outdir).mkdirs();
            }
            this.params.setOutputdirectory(outdir);
            this.startNew(twoVarComb, bestFeatures, testGainOneModel, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
            this.end();
            this.params.setOutputdirectory(outDirOrg);
            double sum = 0.0;
            for (double d : testGainOneModel) {
                sum += d;
            }
            Double testGainAverage = sum / (double)testGainOneModel.size();
            System.out.println("Decision parameter average is: " + testGainAverage);
            testGainTmp.add(testGainAverage);
            testGainOneModel.clear();
            twoVarComb.clear();
        }
        System.out.println("Check here test gain temporary array: " + testGainTmp);
        double bestTestGain = 0.0;
        if (this.decideOnTestAuc() | this.decideOnTestGain()) {
            bestTestGain = (Double)Collections.max(testGainTmp);
        } else if (this.decideOnAICC()) {
            bestTestGain = (Double)Collections.min(testGainTmp);
        }
        System.out.println("Best value two vars: " + bestTestGain);
        int index = testGainTmp.indexOf(bestTestGain);
        testGainTmp.clear();
        int var2 = allComb[index][0];
        int var1 = allComb[index][1];
        ArrayList<String> selectedVars = new ArrayList<String>();
        selectedVars.add(varNames.get(var1));
        selectedVars.add(varNames.get(var2));
        varNames.remove(var1);
        varNames.remove(var2);
        ArrayList<String> tempSelectedVars = new ArrayList<String>();
        int noPredictors = varNames.size();
        int i = 0;
        while (i < noPredictors) {
            for (int k = 0; k < varNames.size(); ++k) {
                tempSelectedVars.addAll(selectedVars);
                tempSelectedVars.add(varNames.get(k));
                int me = k;
                String myname = "Forward Variable Selection: using " + tempSelectedVars;
                Utils.echoln(myname);
                System.out.println("Forward Variable Selection: using " + tempSelectedVars);
                Utils.reportDoing(theSpecies + ": Forward Variable Selection: " + tempSelectedVars + ": ");
                testGainOneModel.clear();
                String outDirOrg = this.params.getOutputdirectory();
                String outDirName = "\\fvs\\" + i + "\\add__" + (String)tempSelectedVars.get(tempSelectedVars.size() - 1);
                String outdir = new File(this.outDir(), outDirName).getPath();
                if (this.is("allModels")) {
                    new File(outdir).mkdirs();
                }
                this.params.setOutputdirectory(outdir);
                this.startNew(tempSelectedVars, bestFeatures, testGainOneModel, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                this.end();
                this.params.setOutputdirectory(outDirOrg);
                double sum = 0.0;
                for (double d : testGainOneModel) {
                    sum += d;
                }
                Double testGainAverage = sum / (double)testGainOneModel.size();
                System.out.println("Decision parameter average is: " + testGainAverage);
                testGainTmp.add(testGainAverage);
                testGainOneModel.clear();
                tempSelectedVars.clear();
            }
            System.out.println(testGainTmp);
            double currentTestGain = 0.0;
            if (this.decideOnTestGain() | this.decideOnTestAuc()) {
                currentTestGain = (Double)Collections.max(testGainTmp);
            } else if (this.decideOnAICC()) {
                currentTestGain = (Double)Collections.min(testGainTmp);
            }
            int indexTemp = testGainTmp.indexOf(currentTestGain);
            if (this.decideOnAICC()) {
                if (!(currentTestGain < bestTestGain)) {
                    FvsVariables.addAll(selectedVars);
                    System.out.println(FvsVariables);
                    return;
                }
                bestTestGain = currentTestGain;
                selectedVars.add(varNames.get(indexTemp));
                varNames.remove(indexTemp);
            } else if (this.decideOnTestGain() | this.decideOnTestAuc()) {
                if (!(currentTestGain > bestTestGain)) {
                    FvsVariables.addAll(selectedVars);
                    System.out.println(FvsVariables);
                    return;
                }
                bestTestGain = currentTestGain;
                selectedVars.add(varNames.get(indexTemp));
                varNames.remove(indexTemp);
            }
            testGainTmp.clear();
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void forwardVariableSelectionParallel2VarCombination(ArrayList<String> varNames, ArrayList<String> FvsVariables, final ArrayList<String> bestFeatures, final Feature[] baseFeatures, final boolean addSamplesToFeatures, Feature[] features, ArrayList<Sample> bgpArrayList) {
        int num = varNames.size();
        List range = IntStream.rangeClosed(0, num - 1).boxed().collect(Collectors.toList());
        final Set comb = Sets.combinations(Sets.newHashSet(range), 2);
        Integer[][] allComb = new Integer[comb.size()][2];
        for (int i = 0; i < comb.size(); ++i) {
            Set arr = (Set)comb.stream().collect(Collectors.toList()).get(i);
            allComb[i][0] = (Integer)arr.stream().collect(Collectors.toList()).get(0);
            allComb[i][1] = (Integer)arr.stream().collect(Collectors.toList()).get(1);
        }
        ArrayList<Double> testGainOneModel = new ArrayList<Double>();
        ArrayList<Double> testGainTmp = new ArrayList<Double>();
        final Double[] testGain2var = new Double[allComb.length];
        if (this.threads() > 1) {
            parallelRunner.clear();
        }
        for (int i = 0; i < comb.size(); ++i) {
            int me2 = allComb[i][0];
            int me1 = allComb[i][1];
            final int me = i;
            String myname = "Forward Variable Selection: using only " + varNames.get(me1) + " & " + varNames.get(me2);
            final String[] twoVarComb = new String[]{varNames.get(me1), varNames.get(me2)};
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    Runner.this.startParallel(twoVarComb, bestFeatures, baseFeatures, addSamplesToFeatures, testGain2var, me);
                    System.out.println(me + " of " + comb.size() + " Variable combinations");
                }
            };
            if (this.threads() <= 1) {
                task.run();
                continue;
            }
            parallelRunner.add(task, myname);
        }
        if (this.threads() > 1) {
            parallelRunner.runall("fvs", this.is("verbose"));
        }
        if (this.threads() > 1) {
            parallelRunner.clear();
        }
        double bestTestGain = 0.0;
        for (int i = 0; i < testGain2var.length; ++i) {
            if (!(testGain2var[i] > bestTestGain)) continue;
            bestTestGain = testGain2var[i];
        }
        System.out.println("Best decision parameter:" + bestTestGain);
        int index = Arrays.asList(testGain2var).indexOf(bestTestGain);
        int var2 = allComb[index][0];
        int var1 = allComb[index][1];
        testGainTmp.clear();
        ArrayList<String> selectedVars = new ArrayList<String>();
        selectedVars.add(varNames.get(var1));
        selectedVars.add(varNames.get(var2));
        System.out.println("Best two var combination: " + selectedVars);
        varNames.remove(var1);
        varNames.remove(var2);
        ArrayList<String> tempSelectedVars = new ArrayList<String>();
        int noPredictors = varNames.size();
        int i = 0;
        while (i < noPredictors) {
            for (int k = 0; k < varNames.size(); ++k) {
                tempSelectedVars.addAll(selectedVars);
                tempSelectedVars.add(varNames.get(k));
                int me = k;
                String myname = "Forward Variable Selection: using " + tempSelectedVars;
                Utils.echoln(myname);
                System.out.println("Forward Variable Selection: using " + tempSelectedVars);
                Utils.reportDoing(theSpecies + ": Forward Variable Selection: " + tempSelectedVars + ": ");
                testGainOneModel.clear();
                this.startNew(tempSelectedVars, bestFeatures, testGainOneModel, baseFeatures, addSamplesToFeatures, features, bgpArrayList);
                this.end();
                double sum = 0.0;
                for (double d : testGainOneModel) {
                    sum += d;
                }
                Double testGainAverage = sum / (double)testGainOneModel.size();
                System.out.println("Decision parameter average is: " + testGainAverage);
                testGainTmp.add(testGainAverage);
                testGainOneModel.clear();
                tempSelectedVars.clear();
            }
            System.out.println(testGainTmp);
            double currentTestGain = 0.0;
            if (this.decideOnTestGain() | this.decideOnTestAuc()) {
                currentTestGain = (Double)Collections.max(testGainTmp);
            } else if (this.decideOnAICC()) {
                currentTestGain = (Double)Collections.min(testGainTmp);
            }
            int indexTemp = testGainTmp.indexOf(currentTestGain);
            if (this.decideOnAICC()) {
                if (!(currentTestGain < bestTestGain)) {
                    FvsVariables.addAll(selectedVars);
                    System.out.println(FvsVariables);
                    return;
                }
                bestTestGain = currentTestGain;
                selectedVars.add(varNames.get(indexTemp));
                varNames.remove(indexTemp);
            } else if (this.decideOnTestGain() | this.decideOnTestAuc()) {
                if (!(currentTestGain > bestTestGain)) {
                    FvsVariables.addAll(selectedVars);
                    System.out.println(FvsVariables);
                    return;
                }
                bestTestGain = currentTestGain;
                selectedVars.add(varNames.get(indexTemp));
                varNames.remove(indexTemp);
            }
            testGainTmp.clear();
            ++i;
        }
    }

    void forwardVariableSelectionParallel(ArrayList<String> varNames, ArrayList<String> FvsVariables, final ArrayList<String> bestFeatures, final Feature[] baseFeatures, final boolean addSamplesToFeatures, Feature[] features, ArrayList<Sample> bgpArrayList) {
        int num = varNames.size();
        List range = IntStream.rangeClosed(0, num - 1).boxed().collect(Collectors.toList());
        final Set comb = Sets.combinations(Sets.newHashSet(range), 2);
        Integer[][] allComb = new Integer[comb.size()][2];
        for (int i = 0; i < comb.size(); ++i) {
            Set arr = (Set)comb.stream().collect(Collectors.toList()).get(i);
            allComb[i][0] = (Integer)arr.stream().collect(Collectors.toList()).get(0);
            allComb[i][1] = (Integer)arr.stream().collect(Collectors.toList()).get(1);
        }
        ArrayList testGainOneModel = new ArrayList();
        final Double[] testGain2var = new Double[allComb.length];
        if (this.threads() > 1) {
            parallelRunner.clear();
        }
        for (int i = 0; i < comb.size(); ++i) {
            int me2 = allComb[i][0];
            int me1 = allComb[i][1];
            final int me = i;
            String myname = "Forward Variable Selection: using only " + varNames.get(me1) + " & " + varNames.get(me2);
            final String[] twoVarComb = new String[]{varNames.get(me1), varNames.get(me2)};
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    Runner.this.startParallel(twoVarComb, bestFeatures, baseFeatures, addSamplesToFeatures, testGain2var, me);
                    System.out.println(me + " of " + comb.size() + " Variable combinations");
                }
            };
            if (this.threads() <= 1) {
                task.run();
                continue;
            }
            parallelRunner.add(task, myname);
        }
        if (this.threads() > 1) {
            parallelRunner.runall("fvs", this.is("verbose"));
        }
        if (this.threads() > 1) {
            parallelRunner.clear();
        }
        double bestTestGain = 0.0;
        for (int i = 0; i < testGain2var.length; ++i) {
            if (!(testGain2var[i] > bestTestGain)) continue;
            bestTestGain = testGain2var[i];
        }
        System.out.println("Best decision parameter:" + bestTestGain);
        int index = Arrays.asList(testGain2var).indexOf(bestTestGain);
        int var2 = allComb[index][0];
        int var1 = allComb[index][1];
        ArrayList<String> selectedVars = new ArrayList<String>();
        selectedVars.add(varNames.get(var1));
        selectedVars.add(varNames.get(var2));
        System.out.println("Best two variable combination: " + selectedVars);
        varNames.remove(var1);
        varNames.remove(var2);
        Object[] testGainTmpArray = new Double[varNames.size()];
        Arrays.fill(testGainTmpArray, (Object)0.0);
        ArrayList<String> tempSelectedVars = new ArrayList<String>();
        int noPredictors = varNames.size();
        for (int i = 0; i < noPredictors; ++i) {
            for (int k = 0; k < varNames.size(); ++k) {
                tempSelectedVars.addAll(selectedVars);
                tempSelectedVars.add(varNames.get(k));
                int me = k;
                String myname = "Forward Variable Selection: using " + tempSelectedVars;
                final String[] tempSelectedVarsArray = (String[])tempSelectedVars.stream().toArray(String[]::new);
                Runnable task = new Runnable(){
                    final /* synthetic */ Double[] val$testGainTmpArray;
                    final /* synthetic */ int val$me;
                    {
                        this.val$testGainTmpArray = doubleArray;
                        this.val$me = n;
                    }

                    @Override
                    public void run() {
                        System.out.println("Forward Variable Selection: using " + Arrays.toString(tempSelectedVarsArray));
                        Runner.this.startParallel2(tempSelectedVarsArray, bestFeatures, baseFeatures, addSamplesToFeatures, this.val$testGainTmpArray, this.val$me);
                    }
                };
                if (this.threads() <= 1) {
                    task.run();
                } else {
                    parallelRunner.add(task, myname);
                }
                testGainOneModel.clear();
                tempSelectedVars.clear();
            }
            if (this.threads() > 1) {
                parallelRunner.runall("fvs part2", this.is("verbose"));
            }
            if (this.threads() > 1) {
                parallelRunner.clear();
            }
            double currentTestGain = 0.0;
            if (this.decideOnTestGain() | this.decideOnTestAuc()) {
                for (int b = 0; b < testGainTmpArray.length; ++b) {
                    if (!((Double)testGainTmpArray[b] > currentTestGain)) continue;
                    currentTestGain = (Double)testGainTmpArray[b];
                }
            } else if (this.decideOnAICC()) {
                // empty if block
            }
            int indexTemp = Arrays.asList(testGainTmpArray).indexOf(currentTestGain);
            System.out.println("Decision parameter: " + currentTestGain);
            if (!this.decideOnAICC() && this.decideOnTestGain() | this.decideOnTestAuc()) {
                if (currentTestGain > bestTestGain) {
                    bestTestGain = currentTestGain;
                    selectedVars.add(varNames.get(indexTemp));
                    varNames.remove(indexTemp);
                } else {
                    FvsVariables.addAll(selectedVars);
                    System.out.println(FvsVariables);
                    break;
                }
            }
            Arrays.fill(testGainTmpArray, (Object)0.0);
        }
    }

    double[][] jackknifeGain(final Feature[] baseFeatures, final Sample[] ss, final Sample[] testSamples, double allGain, double allTestGain, double allauc) {
        Runnable task;
        int me;
        String myname;
        int i;
        boolean hastest;
        final Feature[] features = this.getTrueBaseFeatures(baseFeatures);
        int num = features.length;
        final double[] gain = new double[num * 2];
        final double[] testgain = new double[num * 2];
        final double[] auc = new double[num * 2];
        boolean bl = hastest = testSamples != null && testSamples.length > 0;
        if (this.threads() > 1) {
            parallelRunner.clear();
        }
        for (i = 0; i < num; ++i) {
            if (Utils.interrupt) {
                return null;
            }
            myname = "Jackknife: leave " + features[i].name + " out";
            Utils.echoln(myname);
            me = i;
            task = new Runnable(){

                @Override
                public void run() {
                    Runner.this.leaveOneOutRun(baseFeatures, ss, testSamples, me, gain, testgain, auc, features[me]);
                }
            };
            if (this.threads() <= 1) {
                task.run();
                continue;
            }
            parallelRunner.add(task, myname);
        }
        for (i = 0; i < num; ++i) {
            if (Utils.interrupt) {
                return null;
            }
            myname = "Jackknife: only " + features[i].name;
            Utils.echoln(myname);
            me = i;
            task = new Runnable(){

                @Override
                public void run() {
                    Runner.this.onlyOneRun(baseFeatures, ss, testSamples, me, gain, testgain, auc, features[me]);
                }
            };
            if (this.threads() <= 1) {
                task.run();
                continue;
            }
            parallelRunner.add(task, myname);
        }
        if (this.threads() > 1) {
            parallelRunner.runall("jackknife", this.is("verbose"));
        }
        if (this.is("plots")) {
            this.makeJackknifePlots(this.htmlout, theSpecies, gain, testgain, auc, features, allGain, allTestGain, allauc, hastest, "");
        }
        if (!hastest) {
            return new double[][]{gain};
        }
        return new double[][]{gain, testgain, auc};
    }

    void makeJackknifePlots(PrintWriter htmlout, String theSpecies, double[] gain, double[] testgain, double[] auc, Feature[] baseFeatures, double allGain, double allTestGain, double allauc, boolean hastest, String msg) {
        int num = baseFeatures.length;
        File outfile = new File("plots", theSpecies + "_jacknife.png");
        this.makeJackknifePlot(gain, baseFeatures, "regularized training gain", allGain, new File(this.outDir(), outfile.getPath()), true, theSpecies);
        int bestonlyfeature = 0;
        int bestomitfeature = 0;
        double bestonlygain = 0.0;
        double bestomitgain = 0.0;
        for (int i = 0; i < baseFeatures.length; ++i) {
            if (i == 0 || gain[i] < bestomitgain) {
                bestomitgain = gain[i];
                bestomitfeature = i;
            }
            if (i != 0 && !(gain[num + i] > bestonlygain)) continue;
            bestonlygain = gain[num + i];
            bestonlyfeature = i;
        }
        htmlout.println("The following picture shows the results of the jackknife test of variable importance.  The environmental variable with highest gain when used in isolation is " + baseFeatures[bestonlyfeature].name + ", which therefore appears to have the most useful information by itself.  The environmental variable that decreases the gain the most when it is omitted is " + baseFeatures[bestomitfeature].name + ", which therefore appears to have the most information that isn't present in the other variables." + msg + "<br>");
        htmlout.println("<br><img src=\"" + outfile.getPath() + "\"><br>");
        if (hastest) {
            outfile = new File("plots", theSpecies + "_jacknife_test.png");
            this.makeJackknifePlot(testgain, baseFeatures, "test gain", allTestGain, new File(this.outDir(), outfile.getPath()), true, theSpecies);
            htmlout.println("<br>The next picture shows the same jackknife test, using test gain instead of training gain.  Note that conclusions about which variables are most important can change, now that we're looking at test data.");
            htmlout.println("<br><img src=\"" + outfile.getPath() + "\"><br>");
            outfile = new File("plots", theSpecies + "_jacknife_auc.png");
            this.makeJackknifePlot(auc, baseFeatures, "AUC", allauc, new File(this.outDir(), outfile.getPath()), true, theSpecies);
            htmlout.println("<br>Lastly, we have the same jackknife test, using AUC on test data.");
            htmlout.println("<br><img src=\"" + outfile.getPath() + "\"><br>");
        }
    }

    void makeJackknifePlot(double[] gain, Feature[] features, String what, double allGain, File outfile, boolean reverse, String theSpecies) {
        int num = 0;
        for (int i = 0; i < features.length; ++i) {
            if (!this.isTrueBaseFeature(features[i])) continue;
            ++num;
        }
        MyPlot plot = new MyPlot();
        plot.horizontal = true;
        plot.setSize(700, 24 * features.length + 114);
        plot.setTitle("Jackknife of " + what + " for " + theSpecies);
        plot.setYLabel("Environmental Variable");
        plot.setXLabel(what);
        boolean bestonlyfeature = false;
        boolean bestomitfeature = false;
        double bestonlygain = 0.0;
        double bestomitgain = 0.0;
        int cnt = 0;
        for (int i = 0; i < features.length; ++i) {
            if (!this.isTrueBaseFeature(features[i])) continue;
            plot.addPoint(reverse ? 2 : 1, gain[i], num - cnt, false);
            plot.addYTick(features[i].name, num - cnt);
            plot.addPoint(reverse ? 1 : 2, gain[num + i], num - cnt, false);
            ++cnt;
        }
        plot.addPoint(0, allGain, 0.0, false);
        plot.setBars(0.5, 0.1);
        plot.addLegend(reverse ? 2 : 1, "Without variable");
        plot.addLegend(reverse ? 1 : 2, "With only variable");
        plot.addLegend(0, "With all variables");
        BufferedImage bi = plot.exportImage();
        try {
            ImageIO.write((RenderedImage)bi, "png", outfile);
        }
        catch (IOException e) {
            this.popupError("Error writing jackknife picture", e);
        }
    }

    String recordTypeName(int t) {
        String[] typenames = new String[]{"linear", "quadratic", "product", "threshold", "hinge"};
        int[] types = new int[]{1, 2, 3, 4, 11};
        for (int i = 0; i < types.length; ++i) {
            if (types[i] != t) continue;
            return typenames[i];
        }
        return null;
    }

    MaxentRunResults maxentRun(Feature[] features, Sample[] ss) {
        return this.maxentRun(features, ss, null);
    }

    MaxentRunResults maxentRun(Feature[] features, Sample[] ss, Sample[] testss) {
        int j;
        this.autoSetBeta(features, ss.length);
        for (j = 0; j < features.length; ++j) {
            features[j].setLambda(0.0);
        }
        for (j = 0; j < features.length; ++j) {
            features[j].setActive(true);
        }
        if (this.is("autofeature")) {
            this.autoSetActive(features, ss.length);
        }
        HashSet<String> types = new HashSet<String>();
        for (int j2 = 0; j2 < features.length; ++j2) {
            int type = features[j2].type();
            if (type == 1 && !this.is("linear")) {
                features[j2].setActive(false);
            }
            if (!features[j2].isActive() || this.recordTypeName(type) == null) continue;
            types.add(this.recordTypeName(type));
        }
        int cnt = 0;
        for (int i = 0; i < features.length; ++i) {
            if (!features[i].isActive()) continue;
            ++cnt;
        }
        if (cnt == 0 || cnt == 1 && !this.biasFile().equals("")) {
            this.popupError("No features available: select more feature types or deselect auto features", null);
            Utils.interrupt = true;
            return null;
        }
        FeaturedSpace X = new FeaturedSpace(ss, features, this.params);
        X.setXY(coords);
        if (this.is("biasIsBayesianPrior")) {
            X.biasIsBayesianPrior = true;
        }
        if (testss != null) {
            X.recordTestSamples(testss);
        }
        for (int j3 = 0; j3 < features.length; ++j3) {
            if (!features[j3].isBinary() || features[j3].sampleExpectation != 0.0) continue;
            Utils.echoln("Deactivating " + features[j3].name);
            features[j3].setActive(false);
        }
        Utils.reportMemory("FeaturedSpace");
        Sequential alg = new Sequential(X, this.params);
        alg.setParallelUpdateFrequency(this.params.getint("parallelUpdateFrequency"));
        if (Utils.interrupt) {
            return null;
        }
        double gain = Math.log(X.bNumPoints()) - alg.run();
        this.determineContributions(X);
        if (Utils.interrupt) {
            return null;
        }
        return new MaxentRunResults(gain, alg.iteration, X, alg.getTime(), types.toArray(new String[0]));
    }

    MaxentRunResults maxentRunParallel(Feature[] features, Sample[] ss, Sample[] testss) {
        int j;
        this.autoSetBeta(features, ss.length);
        for (j = 0; j < features.length; ++j) {
            features[j].setLambda(0.0);
        }
        for (j = 0; j < features.length; ++j) {
            features[j].setActive(true);
        }
        if (this.is("autofeature")) {
            this.autoSetActive(features, ss.length);
        }
        HashSet<String> types = new HashSet<String>();
        for (int j2 = 0; j2 < features.length; ++j2) {
            int type = features[j2].type();
            if (type == 1 && !this.is("linear")) {
                features[j2].setActive(false);
            }
            if (!features[j2].isActive() || this.recordTypeName(type) == null) continue;
            types.add(this.recordTypeName(type));
        }
        int cnt = 0;
        for (int i = 0; i < features.length; ++i) {
            if (!features[i].isActive()) continue;
            ++cnt;
        }
        if (cnt == 0 || cnt == 1 && !this.biasFile().equals("")) {
            this.popupError("No features available: select more feature types or deselect auto features", null);
            Utils.interrupt = true;
            return null;
        }
        FeaturedSpace X = new FeaturedSpace(ss, features, this.params);
        X.setXY(coords);
        if (this.is("biasIsBayesianPrior")) {
            X.biasIsBayesianPrior = true;
        }
        if (testss != null) {
            X.recordTestSamples(testss);
        }
        for (int j3 = 0; j3 < features.length; ++j3) {
            if (!features[j3].isBinary() || features[j3].sampleExpectation != 0.0) continue;
            Utils.echoln("Deactivating " + features[j3].name);
            features[j3].setActive(false);
        }
        Utils.reportMemory("FeaturedSpace");
        Sequential alg = new Sequential(X, this.params);
        alg.setParallelUpdateFrequency(this.params.getint("parallelUpdateFrequency"));
        if (Utils.interrupt) {
            return null;
        }
        double gain = Math.log(X.bNumPoints()) - alg.run();
        if (Utils.interrupt) {
            return null;
        }
        return new MaxentRunResults(gain, alg.iteration, X, alg.getTime(), types.toArray(new String[0]));
    }

    void writeContributions(double[][] contributions, String msg) {
        int[] index = DoubleIndexSort.sort(contributions[0]);
        this.htmlputs("<br><HR><H2>Analysis of variable contributions</H2>");
        this.htmlputs("The following table gives estimates of relative contributions of the environmental variables to the Maxent model.  To determine the first estimate, in each iteration of the training algorithm, the increase in regularized gain is added to the contribution of the corresponding variable, or subtracted from it if the change to the absolute value of lambda is negative.  For the second estimate, for each environmental variable in turn, the values of that variable on training presence and background data are randomly permuted.  The model is reevaluated on the permuted data, and the resulting drop in training AUC is shown in the table, normalized to percentages.  As with the variable jackknife, variable contributions should be interpreted with caution when the predictor variables are correlated." + msg);
        this.htmlputsn("<br><table border cols=3>");
        this.htmlputsn("<tr><th>Variable</th><th>Percent contribution</th><th>Permutation importance</th>");
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setMaximumFractionDigits(1);
        for (int i = contributions[0].length - 1; i >= 0; --i) {
            this.htmlputsn("<tr align=right><td>" + this.params.layers[index[i]] + "</td><td>" + nf.format(contributions[0][index[i]]) + "</td><td>" + nf.format(contributions[1][index[i]]) + "</td></tr>");
        }
        this.htmlputs("</table><br>");
    }

    void determineContributions(FeaturedSpace X) {
        int j;
        if (contributions != null) {
            return;
        }
        String[] names = this.params.layers;
        contributions = new double[names.length];
        for (int i = 0; i < X.features.length; ++i) {
            double contrib = X.features[i].contribution;
            if (contrib <= 0.0) continue;
            String featureName = X.features[i].name.replaceFirst("\\(", "").replaceFirst("=.*\\)", "").replaceFirst("\\^2", "").replaceFirst("'", "").replaceFirst("`", "").replaceFirst(".*<", "").replaceFirst("\\)", "").replaceFirst("__rev", "");
            String[] ff = featureName.split("\\*");
            for (int k = 0; k < ff.length; ++k) {
                int j2;
                for (j2 = 0; j2 < names.length; ++j2) {
                    if (!names[j2].equals(ff[k])) continue;
                    int n = j2;
                    contributions[n] = contributions[n] + contrib / (double)ff.length;
                    break;
                }
                if (j2 != names.length) continue;
                Utils.echoln("Contribution not found: " + featureName);
            }
        }
        double sum = 0.0;
        for (j = 0; j < names.length; ++j) {
            sum += contributions[j];
        }
        for (j = 0; j < names.length; ++j) {
            Runner.contributions[j] = sum == 0.0 ? 0.0 : contributions[j] * 100.0 / sum;
        }
    }

    void writeLog(String head, String[] s) {
        Utils.echo(head + ":");
        for (int i = 0; i < s.length; ++i) {
            Utils.echo(" " + s[i]);
        }
        Utils.echoln();
    }

    void writeLog() {
        Utils.echoln("Command line used: " + this.params.commandLine());
        Utils.echoln("Command line to repeat: " + this.params.commandLine(null));
        this.writeLog("Species", this.params.species);
        this.writeLog("Layers", this.params.layers);
        this.writeLog("Layertypes", this.params.layerTypes);
        for (Parameter param : this.params.allParams()) {
            if (!param.changed()) continue;
            Utils.echoln(param.toString());
        }
        Utils.echoln();
    }

    double[][] writeCumulativeIndex(double[] weights, String raw2cumfile, FeaturedSpace X, double auc, double trainauc, Feature[] baseFeatures, double entropy) throws IOException {
        int i;
        int i2;
        double[] origweights = (double[])weights.clone();
        Arrays.sort(weights);
        double[] testvals = new double[X.numTestSamples];
        for (int i3 = 0; i3 < testvals.length; ++i3) {
            testvals[i3] = X.getDensity(X.testSamples[i3]) / X.densityNormalizer;
            if (Double.isNaN(testvals[i3]) || Double.isInfinite(testvals[i3])) {
                testvals[i3] = 1.0;
            }
            if (!(testvals[i3] > 1.0)) continue;
            testvals[i3] = 1.0;
        }
        boolean hastest = testvals.length > 0;
        ArrayList<Double> a = new ArrayList<Double>();
        for (int i4 = 0; i4 < X.numSamples; ++i4) {
            if (!this.hasAllData(X.samples[i4], baseFeatures)) continue;
            a.add(new Double(X.getDensity(X.samples[i4]) / X.densityNormalizer));
        }
        double[] trainvals = new double[a.size()];
        for (int i5 = 0; i5 < trainvals.length; ++i5) {
            trainvals[i5] = (Double)a.get(i5);
            if (Double.isNaN(trainvals[i5]) || Double.isInfinite(trainvals[i5])) {
                trainvals[i5] = 1.0;
            }
            if (!(trainvals[i5] > 1.0)) continue;
            trainvals[i5] = 1.0;
        }
        Arrays.sort(trainvals);
        int num = weights.length + trainvals.length + X.numTestSamples;
        double[] allweights = new double[num];
        int cnt = 0;
        for (i2 = 0; i2 < weights.length; ++i2) {
            allweights[cnt++] = weights[i2];
        }
        for (i2 = 0; i2 < trainvals.length; ++i2) {
            allweights[cnt++] = trainvals[i2];
        }
        for (i2 = 0; i2 < testvals.length; ++i2) {
            allweights[cnt++] = testvals[i2];
        }
        int[] idx = DoubleIndexSort.sort(allweights);
        double[] sweights = new double[num];
        byte[] source = new byte[num];
        double sum = 0.0;
        for (int i6 = 0; i6 < num; ++i6) {
            if (i6 < weights.length) {
                sum += weights[i6];
            }
            sweights[i6] = allweights[idx[i6]];
            source[i6] = idx[i6] < weights.length ? 0 : (idx[i6] < weights.length + a.size() ? 1 : 2);
        }
        double[] cweights = new double[weights.length];
        double tmp = 0.0;
        for (int i7 = 0; i7 < weights.length; ++i7) {
            cweights[i7] = 100.0 * (tmp += weights[i7]) / sum;
        }
        Thresholdinfo[] thresholdinfo = new Thresholdinfo[hastest ? 11 : 9];
        cnt = 0;
        int[] fixed = new int[]{1, 5, 10};
        for (int i8 = 0; i8 < fixed.length; ++i8) {
            this.initThreshold(thresholdinfo, cnt, "Fixed cumulative value " + fixed[i8]);
            thresholdinfo[cnt++].cumulative = fixed[i8];
        }
        this.initThreshold(thresholdinfo, cnt, "Minimum training presence");
        thresholdinfo[cnt++].threshold = trainvals[0];
        this.initThreshold(thresholdinfo, cnt, "10 percentile training presence");
        thresholdinfo[cnt++].threshold = trainvals[trainvals.length / 10];
        this.initThreshold(thresholdinfo, cnt++, "Equal training sensitivity and specificity");
        this.initThreshold(thresholdinfo, cnt++, "Maximum training sensitivity plus specificity");
        if (hastest) {
            this.initThreshold(thresholdinfo, cnt++, "Equal test sensitivity and specificity");
            this.initThreshold(thresholdinfo, cnt++, "Maximum test sensitivity plus specificity");
        }
        this.initThreshold(thresholdinfo, cnt++, "Balance training omission, predicted area and threshold value");
        this.initThreshold(thresholdinfo, cnt++, "Equate entropy of thresholded and original distributions");
        if (this.is("plots")) {
            this.initPlots(hastest, X, auc, trainauc);
        }
        StringWriter outstring = raw2cumfile == null ? new StringWriter() : null;
        PrintWriter out = new PrintWriter(raw2cumfile == null ? outstring : new FileWriter(raw2cumfile));
        out.println("Raw value,Corresponding cumulative value,Corresponding " + this.params.occurrenceProbabilityTransform() + " value,Fractional area,Training omission,Test omission");
        double[] thresh1 = new double[]{1.0E-9, 2.5E-9, 1.0E-8, 2.5E-8, 1.0E-7, 2.5E-7, 1.0E-6, 2.5E-6, 1.0E-5, 2.5E-5, 5.0E-5, 1.0E-4, 2.5E-4, 5.0E-4, 0.001, 0.0025, 0.005, 0.01, 0.025, 0.05, 0.75, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.75};
        double[] thresh = new double[thresh1.length + 393];
        for (i = 0; i < thresh1.length; ++i) {
            thresh[i] = thresh1[i];
        }
        cnt = thresh1.length;
        for (i = 8; i <= 400; ++i) {
            thresh[cnt++] = (double)i / 4.0;
        }
        Arrays.sort(thresh);
        int current = 0;
        int[] count = new int[3];
        double threshold = sweights[0] - 1.0;
        double cumulative = 0.0;
        double occurrenceProbability = 0.0;
        double expent = Math.exp(entropy);
        NumberFormat tnf = NumberFormat.getNumberInstance(Locale.US);
        DecimalFormat df = (DecimalFormat)tnf;
        df.applyPattern("#.#####E0");
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setGroupingUsed(false);
        nf.setMaximumFractionDigits(9);
        ArrayList<Double> rr = new ArrayList<Double>();
        ArrayList<Double> cc = new ArrayList<Double>();
        Project proj = new Project(this.params);
        for (int i9 = 0; i9 < sweights.length; ++i9) {
            if (sweights[i9] != threshold) {
                int j;
                threshold = sweights[i9];
                double area = 1.0 - (double)count[0] / (double)weights.length;
                double trainomission = (double)count[1] / (double)a.size();
                double testomission = hastest ? (double)count[2] / (double)testvals.length : 0.0;
                cumulative = this.interpolate(sweights[i9], count[0], weights, cweights);
                occurrenceProbability = proj.occurrenceProbability(threshold, entropy);
                double[] attrs = new double[]{area, trainomission, testomission, cumulative, occurrenceProbability, threshold};
                for (j = 0; j < fixed.length; ++j) {
                    this.recordThreshold(thresholdinfo[j], cumulative >= thresholdinfo[j].cumulative ? 0.0 : 1.0, attrs, false);
                }
                for (j = 3; j < 5; ++j) {
                    this.recordThreshold(thresholdinfo[j], threshold == thresholdinfo[j].threshold ? 0.0 : 1.0, attrs, false);
                }
                this.recordThreshold(thresholdinfo[5], Math.abs(trainomission - area), attrs);
                this.recordThreshold(thresholdinfo[6], trainomission + area, attrs);
                this.recordThreshold(thresholdinfo[hastest ? 9 : 7], 6.0 * trainomission + cumulative / 25.0 + area * 1.6, attrs);
                this.recordThreshold(thresholdinfo[hastest ? 10 : 8], area < expent / (double)weights.length ? 0.0 : 1.0, attrs, false);
                if (hastest) {
                    this.recordThreshold(thresholdinfo[7], Math.abs(testomission - area), attrs);
                    this.recordThreshold(thresholdinfo[8], testomission + area, attrs);
                }
                if (this.is("plots")) {
                    this.addPlotPoints(cumulative, area, trainomission, testomission, hastest);
                }
                if (current < thresh.length && cumulative >= thresh[current]) {
                    out.println(this.quotedCsv(new String[]{df.format(sweights[i9]).replaceAll(",", "."), nf.format(cumulative), nf.format(occurrenceProbability), nf.format(area), nf.format(trainomission), nf.format(testomission)}));
                    rr.add(sweights[i9]);
                    cc.add(cumulative);
                    while (current < thresh.length && cumulative > thresh[current]) {
                        ++current;
                    }
                }
            }
            byte by = source[i9];
            count[by] = count[by] + 1;
            while (i9 < sweights.length - 1 && sweights[i9 + 1] == sweights[i9]) {
                byte by2 = source[++i9];
                count[by2] = count[by2] + 1;
            }
        }
        out.close();
        if (raw2cumfile == null) {
            double[][] res = new double[2][rr.size()];
            for (int i10 = 0; i10 < rr.size(); ++i10) {
                res[0][i10] = (Double)rr.get(i10);
                res[1][i10] = (Double)cc.get(i10);
            }
            return res;
        }
        if (this.is("writeBackgroundPredictions")) {
            PrintWriter bgout = Utils.writer(raw2cumfile.replaceAll("omission.csv$", "backgroundPredictions.csv"));
            bgout.println("x,y,raw,cumulative," + this.params.occurrenceProbabilityTransform());
            for (int i11 = 0; i11 < origweights.length && i11 < X.numCoords(); ++i11) {
                cumulative = this.interpolate(origweights[i11], -1, weights, cweights);
                occurrenceProbability = proj.occurrenceProbability(origweights[i11], entropy);
                bgout.println(this.quotedCsv(new String[]{"" + X.getX(i11), "" + X.getY(i11), df.format(origweights[i11]).replaceAll(",", "."), nf.format(cumulative), nf.format(occurrenceProbability)}));
            }
            bgout.close();
        }
        if (this.is("plots")) {
            this.addPlotPoints(100.0, 0.0, 1.0, 1.0, hastest);
            this.writePlots();
        }
        for (int j = 0; j < fixed.length; ++j) {
            thresholdinfo[j].cumulative = fixed[j];
        }
        this.writeThresholds(thresholdinfo, testvals.length);
        File file = new File(this.outDir(), theSpecies + "_samplePredictions.csv");
        try {
            int i12;
            double[][] raw2cum = Project.readCumulativeIndex(raw2cumfile);
            PrintWriter sout = Utils.writer(file);
            sout.println("X,Y,Test or train,Raw prediction,Cumulative prediction," + this.params.occurrenceProbabilityTransform() + " prediction");
            for (i12 = 0; i12 < X.numSamples; ++i12) {
                if (!this.hasAllData(X.samples[i12], baseFeatures)) continue;
                double raw = X.getDensity(X.samples[i12]) / X.densityNormalizer;
                sout.println(X.samples[i12].lon + "," + X.samples[i12].lat + ",train," + raw + "," + Project.interpolateCumulative(raw2cum, raw) + "," + proj.occurrenceProbability(raw, entropy));
            }
            for (i12 = 0; i12 < testvals.length; ++i12) {
                sout.println(X.testSamples[i12].lon + "," + X.testSamples[i12].lat + ",test," + testvals[i12] + "," + Project.interpolateCumulative(raw2cum, testvals[i12]) + "," + proj.occurrenceProbability(testvals[i12], entropy));
            }
            sout.close();
        }
        catch (IOException e) {
            this.popupError("Error writing sample predictions file", e);
        }
        return null;
    }

    String quote(String s) {
        if (s.indexOf(",") == -1) {
            return s;
        }
        return "\"" + s + "\"";
    }

    String quotedCsv(String[] s) {
        if (s == null || s.length == 0) {
            return "";
        }
        Object result = this.quote(s[0]);
        for (int i = 1; i < s.length; ++i) {
            result = (String)result + "," + this.quote(s[i]);
        }
        return result;
    }

    double interpolate(double x, int i, double[] raw, double[] cum) {
        if (i == -1) {
            i = Arrays.binarySearch(raw, x);
            if (i >= 0) {
                while (i < raw.length && raw[i] == x) {
                    ++i;
                }
            }
            if (i < 0) {
                i = -i - 1;
            }
        }
        if (i < raw.length && raw[i] == x) {
            return cum[i];
        }
        if (i == 0) {
            return 0.0;
        }
        if (i == raw.length) {
            return cum[cum.length - 1];
        }
        return cum[i - 1] + (x - raw[i - 1]) / (raw[i] - raw[i - 1]) * (cum[i] - cum[i - 1]);
    }

    double omissionrate(double[] a, double t) {
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] >= t)) continue;
            return (double)i / (double)a.length;
        }
        return 1.0;
    }

    void initThreshold(Thresholdinfo[] thresholdinfo, int i, String meaning) {
        thresholdinfo[i] = new Thresholdinfo(this, meaning);
    }

    void recordThreshold(Thresholdinfo thr, double val, double[] attrs) {
        this.recordThreshold(thr, val, attrs, true);
    }

    void recordThreshold(Thresholdinfo thr, double val, double[] attrs, boolean init) {
        if (init && !thr.started || val < thr.value) {
            thr.value = val;
            thr.threshold = attrs[this.TTHRESH];
            thr.area = attrs[this.TAREA];
            thr.trainomission = attrs[this.TTRAINO];
            thr.testomission = attrs[this.TTESTO];
            thr.cumulative = attrs[this.TCUM];
            thr.occurrenceProbability = attrs[this.TOCCPROB];
            thr.started = true;
        }
    }

    void writeThresholds(Thresholdinfo[] thresholdinfo, int numTestSamples) {
        boolean hastest = numTestSamples > 0;
        this.htmlputs("Some common thresholds and corresponding omission rates are as follows.  If test data are available, binomial probabilities are calculated exactly if the number of test samples is at most 25, otherwise using a normal approximation to the binomial.  These are 1-sided p-values for the null hypothesis that test points are predicted no better than by a random prediction with the same fractional predicted area.  The \"Balance\" threshold minimizes 6 * training omission rate + .04 * cumulative threshold + 1.6 * fractional predicted area.");
        this.htmlputsn("<br><table border cols=" + (hastest ? 6 : 4) + " cellpadding=3>");
        this.htmlputsn("<tr><th>Cumulative threshold</th><th>" + this.params.occurrenceProbabilityTransform() + " threshold</th><th>Description</th><th>Fractional predicted area</th><th>Training omission rate</th>" + (hastest ? "<th>Test omission rate</th><th>P-value</th>" : ""));
        NumberFormat tnf = NumberFormat.getNumberInstance(Locale.US);
        DecimalFormat df = (DecimalFormat)tnf;
        df.applyPattern("#.###E0");
        applyThresholdValue = -1.0;
        for (int i = 0; i < thresholdinfo.length; ++i) {
            Thresholdinfo t = thresholdinfo[i];
            Object name = t.meaning;
            if (((String)name).equals("Fixed cumulative value")) {
                name = (String)name + " " + t.cumulative;
            }
            if (t.threshold == -1.0) {
                Utils.echoln("Leaving out " + t.meaning + " from threshold table, as uninitialized");
                for (String s : new String[]{"cumulative threshold", this.params.occurrenceProbabilityTransform() + " threshold", "area", "training omission"}) {
                    results.print((String)name + " " + s, "na");
                }
                if (!hastest) continue;
                for (String s : new String[]{"test omission", "binomial probability"}) {
                    results.print((String)name + " " + s, "na");
                }
                continue;
            }
            double testbinomial = 0.0;
            if (hastest) {
                testbinomial = numTestSamples > 25 ? this.binomial(numTestSamples, t.area, 1.0 - t.testomission) : this.exactBinomial((int)Math.round((1.0 - t.testomission) * (double)numTestSamples), numTestSamples, t.area);
            }
            this.htmlputsn("<tr align=center><td>" + this.nf.format(t.cumulative) + "</td><td>" + this.nf.format(t.occurrenceProbability) + "</td><td>" + t.meaning + "</td><td>" + this.nf.format(t.area) + "</td><td>" + this.nf.format(t.trainomission) + "</td>" + (String)(hastest ? "<td>" + this.nf.format(t.testomission) + "</td><td>" + df.format(testbinomial) + "</td>" : ""));
            results.print((String)name + " cumulative threshold", t.cumulative);
            results.print((String)name + " " + this.params.occurrenceProbabilityTransform() + " threshold", t.occurrenceProbability);
            results.print((String)name + " area", t.area);
            results.print((String)name + " training omission", t.trainomission);
            if (hastest) {
                results.print((String)name + " test omission", t.testomission);
                results.print((String)name + " binomial probability", df.format(testbinomial));
            }
            if (!t.meaning.toLowerCase().equals(this.params.getString("applyThresholdRule"))) continue;
            applyThresholdValue = this.occurrenceProbability() ? t.occurrenceProbability : (this.cumulative() ? t.cumulative : -1.0);
        }
        if (applyThresholdValue == -1.0 && !this.params.getString("applyThresholdRule").equals("")) {
            this.popupError("Threshold rule " + this.params.getString("applyThresholdRule") + " not recognized", null);
        }
        results.resetInsertionIndex();
        this.htmlputs("</table>");
    }

    double exactBinomial(int success, int n, double p) {
        double prob = 0.0;
        for (int i = success; i <= n; ++i) {
            int j;
            long fac = 1L;
            int ii = i >= n / 2 ? i : n - i;
            for (j = ii + 1; j <= n; ++j) {
                fac *= (long)j;
            }
            for (j = 1; j <= n - ii; ++j) {
                fac /= (long)j;
            }
            prob += (double)fac * Math.pow(p, i) * Math.pow(1.0 - p, n - i);
        }
        return prob;
    }

    double binomial(int n, double p, double successrate) {
        double mean = (double)n * p;
        double sd = Math.sqrt((double)n * p * (1.0 - p));
        if (sd == 0.0) {
            return n > 0 && p != successrate ? 0.0 : 1.0;
        }
        double z = ((double)n * successrate - mean) / sd;
        return this.cPhi(z);
    }

    double cPhi(double x) {
        int j = (int)(0.5 * (Math.abs(x) + 1.0));
        double[] R = new double[]{1.2533141373155003, 0.4213692292880545, 0.23665238291356067, 0.16237766089686745, 0.1231319632579323, 0.09902859647173193, 0.08276628650136918, 0.07106958053885211, 0.0622586659950262};
        if (j >= R.length) {
            return 0.0;
        }
        double pwr = 1.0;
        double a = R[j];
        double z = 2 * j;
        double b = a * z - 1.0;
        double h = Math.abs(x) - z;
        double s = a + h * b;
        double t = a;
        double q = h * h;
        int i = 2;
        while (s != t) {
            a = (a + z * b) / (double)i;
            b = (b + z * a) / (double)(i + 1);
            t = s;
            s = t + (pwr *= q) * (a + h * b);
            i += 2;
        }
        s *= Math.exp(-0.5 * x * x - 0.9189385332046728);
        if (x >= 0.0) {
            return s;
        }
        return 1.0 - s;
    }

    Feature[] makeFeatures(Feature[] f1) {
        return this.makeFeatures(f1, this.is("cacheFeatures"), true);
    }

    Feature[] makeFeatures(Feature[] f1, boolean doCache, boolean doReport) {
        int j;
        int i;
        boolean cnt = false;
        int len = f1.length;
        ArrayList<Feature> features = new ArrayList<Feature>();
        ArrayList<Feature> contList = new ArrayList<Feature>();
        if (doReport) {
            Utils.reportDoing("Making features");
        }
        String[] names = new String[len];
        int[] types = new int[len];
        for (i = 0; i < len; ++i) {
            names[i] = f1[i].name;
            types[i] = f1[i].type();
        }
        block6: for (i = 0; i < len; ++i) {
            switch (types[i]) {
                case 8: 
                case 9: {
                    features.add(f1[i]);
                    continue block6;
                }
                case 7: {
                    BinaryFeature[] tmp = BinaryFeature.makeAll(f1[i], names[i]);
                    for (j = 0; j < tmp.length; ++j) {
                        features.add(tmp[j]);
                    }
                    continue block6;
                }
                case 6: {
                    contList.add(this.is("doClamp") ? this.naturallyClamped(f1[i], names[i]) : f1[i]);
                    continue block6;
                }
                default: {
                    Utils.fatalException("makeFeatures: Cannot process feature of type " + types[i], null);
                }
            }
        }
        Feature[] cont = contList.toArray(new Feature[0]);
        for (i = 0; i < cont.length; ++i) {
            features.add(new LinearFeature(cont[i], cont[i].name));
        }
        if (this.is("quadratic")) {
            for (i = 0; i < cont.length; ++i) {
                features.add(new SquareFeature(cont[i], cont[i].name));
                if (!this.is("polyhedral")) continue;
                features.add(new PolyhedralFeature(cont[i], cont[i].name));
            }
        }
        if (this.is("product")) {
            for (i = 0; i < cont.length; ++i) {
                for (j = i + 1; j < cont.length; ++j) {
                    if (cont[i].isMask() || cont[j].isMask()) continue;
                    features.add(new ProductFeature(cont[i], cont[i].name, cont[j], cont[j].name));
                }
            }
        }
        if (this.is("threshold")) {
            for (i = 0; i < cont.length; ++i) {
                features.add(new ThrGeneratorFeature(cont[i], cont[i].name));
            }
        }
        if (this.is("hinge")) {
            for (i = 0; i < cont.length; ++i) {
                features.add(new HingeGeneratorFeature(cont[i], cont[i].name));
                features.add(new HingeGeneratorFeature(Runner.revFeature(cont[i]), cont[i].name + "__rev"));
            }
        }
        int n = features.size();
        Feature[] result = new Feature[n];
        for (i = 0; i < n; ++i) {
            if (doReport) {
                Utils.reportProgress((double)(i * 100) / (double)n);
            }
            if (Utils.interrupt) {
                return null;
            }
            Feature ff = (Feature)features.get(i);
            if (!(ff instanceof LayerFeature || ff.type() == 8 || ff.type() == 9 || ff instanceof BinaryFeature || ff instanceof ThrGeneratorFeature || ff instanceof HingeGeneratorFeature)) {
                ff = this.is("doClamp") ? this.naturallyClamped(ff, ff.name) : ff;
                ff = doCache ? new CachedScaledFeature(ff) : new ScaledFeature(ff);
            }
            result[i] = ff;
        }
        if (doReport) {
            Utils.reportMemory("makeFeatures");
        }
        return result;
    }

    static Feature revFeature(final Feature f) {
        return new Feature(f.n, f.name + "__rev"){

            @Override
            public double eval(Sample s) {
                return -f.eval(s);
            }

            @Override
            public double eval(int p) {
                return -f.eval(p);
            }

            @Override
            public boolean hasData(Sample s) {
                return f.hasData(s);
            }
        };
    }

    Feature naturallyClamped(Feature f, String s) {
        double min = f.eval(0);
        double max = f.eval(0);
        for (int i = 1; i < f.n; ++i) {
            double val = f.eval(i);
            if (val > max) {
                max = val;
                continue;
            }
            if (!(val < min)) continue;
            min = val;
        }
        ClampedFeature result = new ClampedFeature(f, min, max);
        result.name = s;
        return result;
    }

    static double interpolate(int[] x, double[] y, int xx) {
        int i;
        for (i = 0; i < x.length && xx > x[i]; ++i) {
        }
        if (i == 0) {
            return y[0];
        }
        if (i == x.length) {
            return y[x.length - 1];
        }
        return y[i - 1] + (y[i] - y[i - 1]) * (double)(xx - x[i - 1]) / (double)(x[i] - x[i - 1]);
    }

    void autoSetBeta(Feature[] features, int numSamples) {
        int[] thresholds = null;
        double[] betas = null;
        if (this.is("product") && (!this.is("autofeature") || numSamples >= this.params.getint("lq2lqptThreshold"))) {
            thresholds = new int[]{0, 10, 17, 30, 100};
            betas = new double[]{2.6, 1.6, 0.9, 0.55, 0.05};
        } else if (this.is("quadratic") && (!this.is("autofeature") || numSamples >= this.params.getint("l2lqThreshold"))) {
            thresholds = new int[]{0, 10, 17, 30, 100};
            betas = new double[]{1.3, 0.8, 0.5, 0.25, 0.05};
        } else {
            thresholds = new int[]{10, 30, 100};
            betas = new double[]{1.0, 0.2, 0.05};
        }
        this.beta_lqp = Runner.interpolate(thresholds, betas, numSamples);
        this.beta_thr = Runner.interpolate(new int[]{0, 100}, new double[]{2.0, 1.0}, numSamples);
        this.beta_hge = 0.5;
        if (this.is("doSqrtCat")) {
            this.beta_cat = Runner.interpolate(new int[]{10, 17, 30}, new double[]{0.2, 0.1, 0.05}, numSamples);
            this.beta_cat = Math.sqrt(this.beta_lqp * this.beta_cat);
        } else {
            this.beta_cat = Runner.interpolate(new int[]{0, 10, 17}, new double[]{0.65, 0.5, 0.25}, numSamples);
        }
        if (this.params.getdouble("beta_categorical") >= 0.0) {
            this.beta_cat = this.params.getdouble("beta_categorical");
        }
        if (this.params.getdouble("beta_threshold") >= 0.0) {
            this.beta_thr = this.params.getdouble("beta_threshold");
        }
        if (this.params.getdouble("beta_hinge") >= 0.0) {
            this.beta_hge = this.params.getdouble("beta_hinge");
        }
        if (this.params.getdouble("beta_lqp") >= 0.0) {
            this.beta_lqp = this.params.getdouble("beta_lqp");
        }
        for (int i = 0; i < features.length; ++i) {
            String sval;
            if (features[i] instanceof BinaryFeature) {
                features[i].setBeta(this.beta_cat * this.betaMultiplier());
                continue;
            }
            if (features[i] instanceof ThrGeneratorFeature) {
                features[i].setBeta(this.beta_thr * this.betaMultiplier());
                continue;
            }
            if (features[i] instanceof HingeGeneratorFeature) {
                features[i].setBeta(this.beta_hge * this.betaMultiplier());
                continue;
            }
            features[i].setBeta(this.beta_lqp * this.betaMultiplier());
            if (this.params.betaMap == null || (sval = (String)this.params.betaMap.get(features[i].name)) == null) continue;
            features[i].setBeta(Double.parseDouble(sval));
            Utils.echoln("Setting beta for " + features[i].name + " to " + sval);
        }
        Utils.echoln("Regularization values: " + this.regularizationConstants());
    }

    void autoSetActive(Feature[] features, int numSamples) {
        block6: for (int i = 0; i < features.length; ++i) {
            switch (features[i].type()) {
                case 4: {
                    if (numSamples >= this.params.getint("lq2lqptThreshold")) continue block6;
                    features[i].setActive(false);
                    continue block6;
                }
                case 11: {
                    if (numSamples >= this.params.getint("hingeThreshold")) continue block6;
                    features[i].setActive(false);
                    continue block6;
                }
                case 3: {
                    if (numSamples >= this.params.getint("lq2lqptThreshold")) continue block6;
                    features[i].setActive(false);
                    continue block6;
                }
                case 2: {
                    if (numSamples >= this.params.getint("l2lqThreshold")) continue block6;
                    features[i].setActive(false);
                    continue block6;
                }
            }
        }
    }

    void writeSummary(MaxentRunResults res, double testGain, double auc, double aucSD, double trainauc, double nParams, double AICC, CsvWriter writer, Feature[] baseFeatures, double[][] jackknifeGain, double entropy, double prevalence, double[] permcontribs) {
        int i;
        double gain = res.gain;
        int iters = res.iterations;
        FeaturedSpace X = res.X;
        writer.print("Species", theSpecies);
        writer.print("#Training samples", X.numSamples);
        writer.print("Regularized training gain", gain);
        writer.print("Unregularized training gain", gain + X.getL1reg());
        writer.print("Iterations", iters);
        writer.print("Training AUC", trainauc);
        writer.print("Number Parameters", nParams);
        writer.print("AICC", AICC);
        if (X.numTestSamples != 0) {
            writer.print("#Test samples", X.numTestSamples);
            writer.print("Test gain", testGain);
            writer.print("Test AUC", auc);
            writer.print("AUC Standard Deviation", aucSD);
        }
        writer.print("#Background points", X.numPoints);
        for (i = 0; i < this.params.layers.length; ++i) {
            writer.print(this.params.layers[i] + " contribution", contributions[i]);
        }
        for (i = 0; i < this.params.layers.length; ++i) {
            writer.print(this.params.layers[i] + " permutation importance", permcontribs[i]);
        }
        if (jackknifeGain != null) {
            String[] labels = new String[]{"Training gain", "Test gain", "AUC"};
            for (int j = 0; j < jackknifeGain.length; ++j) {
                int i2;
                if (jackknifeGain[j] == null) continue;
                int ii = 0;
                for (i2 = 0; i2 < baseFeatures.length; ++i2) {
                    writer.print(labels[j] + " without " + baseFeatures[i2].name, jackknifeGain[j][ii]);
                    ++ii;
                }
                for (i2 = 0; i2 < baseFeatures.length; ++i2) {
                    writer.print(labels[j] + " with only " + baseFeatures[i2].name, jackknifeGain[j][ii]);
                    ++ii;
                }
            }
        }
        writer.print("Entropy", entropy);
        writer.print("Prevalence (average probability of presence over background sites)", prevalence);
        writer.println();
    }

    double getTestGain(FeaturedSpace X) {
        return Math.log(X.numPointsForNormalizer) - X.getTestLoss();
    }

    void initPlots(boolean hastest, FeaturedSpace X, double auc, double trainauc) {
        this.plot = new MyPlot();
        this.plot.setSize(700, 450);
        this.plot.setTitle("Omission and Predicted Area for " + theSpecies);
        this.plot.setYLabel("Fractional value");
        this.plot.setXLabel("Cumulative threshold");
        this.plot2 = new MyPlot();
        this.plot2.setSize(700, 450);
        this.plot2.setTitle("Sensitivity vs. 1 - Specificity for " + theSpecies);
        this.plot2.setYLabel("Sensitivity  (1 - Omission Rate)");
        this.plot2.setXLabel("1 - Specificity  (Fractional Predicted Area)");
        this.plot.addPoint(0, 0.0, 1.0, true);
        this.plot.addPoint(1, 0.0, 0.0, true);
        if (hastest) {
            this.plot.addPoint(2, 0.0, 0.0, true);
        }
        this.plot2.addPoint(0, 1.0, 1.0, true);
        if (hastest) {
            this.plot2.addPoint(1, 1.0, 1.0, true);
        }
        for (int i = 0; i <= 100; i += 10) {
            this.plot.addXTick("" + i, i);
        }
        this.plot.addLegend(0, "Fraction of background predicted");
        this.plot.addLegend(1, "Omission on training samples");
        this.plot2.addLegend(0, "Training data (AUC = " + this.nf.format(trainauc) + ")");
        if (hastest) {
            this.plot.addLegend(2, "Omission on test samples");
            this.plot2.addLegend(1, "Test data (AUC = " + this.nf.format(auc) + ")");
        }
        int rndplt = 3;
        this.plot.addPoint(rndplt, 0.0, 0.0, true);
        this.plot.addPoint(rndplt, 100.0, 1.0, true);
        this.plot.addLegend(rndplt, "Predicted omission");
        this.plot2.addPoint(rndplt, 0.0, 0.0, true);
        this.plot2.addPoint(rndplt, 1.0, 1.0, true);
        this.plot2.addLegend(rndplt, "Random Prediction (AUC = 0.5)");
    }

    void addPlotPoints(double cumulative, double predarea, double trainomission, double testomission, boolean hastest) {
        this.plot.addPoint(0, cumulative, predarea, true);
        this.plot.addPoint(1, cumulative, trainomission, true);
        this.plot2.addPoint(0, predarea, 1.0 - trainomission, true);
        if (hastest) {
            this.plot.addPoint(2, cumulative, testomission, true);
            this.plot2.addPoint(1, predarea, 1.0 - testomission, true);
        }
    }

    void writePlots() {
        File dir = new File(this.outDir(), "plots");
        try {
            dir.mkdir();
        }
        catch (SecurityException e) {
            this.popupError("Can't create directory in " + this.outDir() + " for plots", e);
            return;
        }
        File file1 = new File(dir, theSpecies + "_omission.png");
        File file2 = new File(dir, theSpecies + "_roc.png");
        try {
            ImageIO.write((RenderedImage)this.plot.exportImage(), "png", file1);
        }
        catch (IOException e) {
            this.popupError("Error writing omission picture", e);
        }
        try {
            ImageIO.write((RenderedImage)this.plot2.exportImage(), "png", file2);
        }
        catch (IOException e) {
            this.popupError("Error writing ROC picture", e);
        }
        this.htmlout.println("<br><HR><H2>Analysis of omission/commission</H2>");
        this.htmlout.println("The following picture shows the omission rate and predicted area as a function of the cumulative threshold.  The omission rate is is calculated both on the training presence records, and (if test data are used) on the test records.  The omission rate should be close to the predicted omission, because of the definition of the cumulative threshold.");
        this.htmlout.println("<br><img src=\"" + new File("plots", file1.getName()).getPath() + "\"><br>");
        this.htmlout.print("<br> The next picture is the receiver operating characteristic (ROC) curve for the same data.  Note that the specificity is defined using predicted area, rather than true commission (see the paper by Phillips, Anderson and Schapire cited on the help page for discussion of what this means).");
        if (this.is("giveMaxAUCEstimate")) {
            this.htmlout.print("  This implies that the maximum achievable AUC is less than 1.  If test data is drawn from the Maxent distribution itself, then the maximum possible test AUC would be " + this.nf.format(aucmax) + " rather than 1; in practice the test AUC may exceed this bound.");
        }
        this.htmlout.println();
        this.htmlout.println("<br><img src=\"" + new File("plots", file2.getName()).getPath() + "\"><br>");
        this.htmlputs();
        this.htmlputs();
    }

    static {
        testSampleSet = null;
        projectPrefix = null;
        raw2cumfile = null;
        allLayers = null;
        startedPictureHtmlSection = false;
    }

    public static class MaxentRunResults {
        double gain;
        double time;
        int iterations;
        FeaturedSpace X;
        String[] featureTypes;

        void removeBiasDistribution() {
            if (this.X.biasDist != null) {
                this.X.setBiasDist(null);
            }
        }

        MaxentRunResults(double gain, int iter, FeaturedSpace X, double time, String[] types) {
            this.gain = gain;
            this.iterations = iter;
            this.X = X;
            this.time = time;
            this.featureTypes = types;
        }
    }

    class Thresholdinfo {
        String meaning;
        double threshold = -1.0;
        double value = 1.0;
        double area = -1.0;
        double trainomission = -1.0;
        double testomission = -1.0;
        double cumulative = -1.0;
        double occurrenceProbability = -1.0;
        boolean started = false;

        public Thresholdinfo(Runner this$0, String m) {
            this.meaning = m;
        }

        public Thresholdinfo(Runner this$0, String m, double t, double v, double a, double traino, double testo, double c) {
            this.meaning = m;
            this.threshold = t;
            this.value = v;
            this.area = 0.0;
            this.trainomission = traino;
            this.testomission = testo;
            this.cumulative = c;
        }
    }
}

