/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.DoubleIndexSort;
import density.Grid;
import density.GridByte;
import density.GridDimension;
import density.Sample;
import density.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class SampleSet {
    GridDimension dimension;
    HashMap speciesMap = new HashMap();
    public static int speciesIndex = 0;
    public static int xIndex = 1;
    public static int yIndex = 2;
    public static int spatialIndex = 3;
    public static int firstEnvVar = 4;
    public static int necessaryFields = 4;
    public static int NODATA_value = -9999;
    public String header;

    public static void setNCEAS_FORMAT() {
        speciesIndex = 1;
        xIndex = 4;
        yIndex = 5;
        firstEnvVar = 7;
        necessaryFields = 6;
    }

    static IOException necessaryFieldsException() {
        return new IOException("Sample file needs four columns: species (column " + (speciesIndex + 1) + "), longitude (column " + xIndex + "), latitude (column " + xIndex + "), spatial (column " + (spatialIndex + 1));
    }

    public SampleSet() {
    }

    public void write(String fileName) throws IOException {
        int i;
        PrintWriter out = Utils.writer(fileName);
        Sample[] s = this.getSamples();
        String[] env = s.length == 0 || s[0].featureMap == null ? new String[]{} : s[0].featureMap.keySet().toArray(new String[0]);
        out.print("Species,Longitude,Latitude");
        for (i = 0; i < env.length; ++i) {
            out.print("," + env[i]);
        }
        out.println();
        for (i = 0; i < s.length; ++i) {
            out.print(s[i].name + "," + s[i].lon + "," + s[i].lat);
            for (int j = 0; j < env.length; ++j) {
                out.print("," + s[i].featureMap.get(env[j]));
            }
            out.println();
        }
        out.close();
    }

    public String[] getNames() {
        String[] result = this.speciesMap.keySet().toArray(new String[0]);
        Arrays.sort(result, new Comparator<String>(this){

            @Override
            public int compare(String s1, String s2) {
                String sp2;
                if (s1.indexOf("_") == -1 || s2.indexOf("_") == -1) {
                    return s1.compareTo(s2);
                }
                int loc1 = s1.lastIndexOf("_");
                int loc2 = s2.lastIndexOf("_");
                String sp1 = s1.substring(0, loc1);
                int c = sp1.compareTo(sp2 = s2.substring(0, loc2));
                if (c != 0) {
                    return c;
                }
                try {
                    int n1 = Integer.parseInt(s1.substring(loc1 + 1));
                    int n2 = Integer.parseInt(s2.substring(loc2 + 1));
                    return n1 < n2 ? -1 : (n1 > n2 ? 1 : 0);
                }
                catch (NumberFormatException e) {
                    return s1.compareTo(s2);
                }
            }
        });
        return result;
    }

    public Sample[] getSamples(String s) {
        if (s == null) {
            return this.getSamples();
        }
        ArrayList a = (ArrayList)this.speciesMap.get(SampleSet.sanitizeSpeciesName(s));
        return a == null ? new Sample[]{} : a.toArray(new Sample[0]);
    }

    Grid toGrid(String name) {
        final boolean[][] hasData = new boolean[this.dimension.nrows][this.dimension.ncols];
        Sample[] ss = this.getSamples();
        for (int i = 0; i < ss.length; ++i) {
            hasData[ss[i].row][ss[i].col] = true;
        }
        return new GridByte(this, this.dimension, name){
            {
                super(dim, s);
                this.NODATA_value = -1.0;
            }

            @Override
            public byte evalByte(int r, int c) {
                return 1;
            }

            @Override
            public boolean hasData(int r, int c) {
                return hasData[r][c];
            }
        };
    }

    public Sample[] getSamples() {
        ArrayList union = new ArrayList();
        Object[] names = this.getNames();
        Arrays.sort(names);
        for (int j = 0; j < names.length; ++j) {
            ArrayList a = (ArrayList)this.speciesMap.get(names[j]);
            for (int i = 0; i < a.size(); ++i) {
                union.add(a.get(i));
            }
        }
        return union.toArray(new Sample[0]);
    }

    static String sanitizeSpeciesName(String s) {
        s = s.trim().replace(' ', '_');
        s = s.replace('?', '_');
        s = s.replace('!', '_');
        s = s.replace('~', '_');
        s = s.replaceAll("\"", "");
        s = s.replace('\'', '_');
        s = s.replace('\\', '_');
        s = s.replace('/', '_');
        s = s.replace('{', '_');
        s = s.replace('}', '_');
        s = s.replace('(', '_');
        s = s.replace(')', '_');
        return s;
    }

    public void removeDuplicates(GridDimension dim) {
        for (String speciesName : this.speciesMap.keySet()) {
            HashSet<Object> points = new HashSet<Object>();
            ArrayList newa = new ArrayList();
            ArrayList olda = (ArrayList)this.speciesMap.get(speciesName);
            for (int i = 0; i < olda.size(); ++i) {
                Object o;
                Sample s = (Sample)olda.get(i);
                Object object = o = dim == null ? "" + s.getLat() + s.getLon() : new Integer(s.getRow() * dim.ncols + s.getCol());
                if (points.contains(o)) continue;
                points.add(o);
                newa.add(olda.get(i));
            }
            this.speciesMap.put(speciesName, newa);
        }
    }

    public SampleSet(GridDimension dim, HashMap speciesMap) {
        this.dimension = dim;
        this.speciesMap = speciesMap;
    }

    void removeSample(Sample s) {
        ArrayList a = (ArrayList)this.speciesMap.get(s.getName());
        if (!a.contains(s)) {
            Utils.warn("SampleSet: removing non-existent sample");
        }
        a.remove(s);
    }

    static int[] randomPermutation(int ns) {
        double[] rnd = new double[ns];
        for (int j = 0; j < ns; ++j) {
            rnd[j] = Utils.generator.nextDouble();
        }
        return DoubleIndexSort.sort(rnd);
    }

    SampleSet splitForCV(int n) {
        String[] names = this.getNames();
        SampleSet testss = new SampleSet();
        for (int i = 0; i < names.length; ++i) {
            int j;
            ArrayList old = (ArrayList)this.speciesMap.get(names[i]);
            int[] order = SampleSet.randomPermutation(old.size());
            int num = old.size() < n ? old.size() : n;
            ArrayList[] train = new ArrayList[num];
            ArrayList[] test = new ArrayList[num];
            for (j = 0; j < num; ++j) {
                train[j] = new ArrayList();
                test[j] = new ArrayList();
            }
            for (int k = 0; k < old.size(); ++k) {
                int fold = order[k] % num;
                test[fold].add(old.get(k));
                for (int j2 = 0; j2 < num; ++j2) {
                    if (j2 == fold) continue;
                    train[j2].add(old.get(k));
                }
            }
            for (j = 0; j < num; ++j) {
                this.speciesMap.put(names[i] + "_" + j, train[j]);
                testss.speciesMap.put(names[i] + "_" + j, test[j]);
            }
        }
        return testss;
    }

    SampleSet splitForSpatialCV() {
        String[] names = this.getNames();
        SampleSet testss = new SampleSet();
        for (int i = 0; i < names.length; ++i) {
            int j;
            List species = (List)this.speciesMap.get(names[i]);
            List locations = species.stream().map(Sample::getSpatial).collect(Collectors.toList());
            ArrayList locationsArrList = (ArrayList)locations;
            HashSet locHset = new HashSet(locations);
            ArrayList locArr = new ArrayList(locHset);
            ArrayList old = (ArrayList)this.speciesMap.get(names[i]);
            ArrayList<Integer> positions = new ArrayList<Integer>();
            for (int p = 0; p < locArr.size(); ++p) {
                positions.add(p);
            }
            int num = Math.min(old.size(), locArr.size());
            ArrayList[] train = new ArrayList[num];
            ArrayList[] test = new ArrayList[num];
            for (j = 0; j < num; ++j) {
                train[j] = new ArrayList();
                test[j] = new ArrayList();
            }
            for (int k = 0; k < old.size(); ++k) {
                int value = (Integer)locationsArrList.get(k);
                int index = locArr.indexOf(value);
                int fold = (Integer)positions.get(index);
                test[fold].add(old.get(k));
                for (int j2 = 0; j2 < num; ++j2) {
                    if (j2 == fold) continue;
                    train[j2].add(old.get(k));
                }
            }
            for (j = 0; j < num; ++j) {
                this.speciesMap.put(names[i] + "_" + j, train[j]);
                testss.speciesMap.put(names[i] + "_" + j, test[j]);
            }
        }
        return testss;
    }

    void replicate(int n, boolean bootstrap) {
        String[] names = this.getNames();
        for (int i = 0; i < names.length; ++i) {
            ArrayList old = (ArrayList)this.speciesMap.get(names[i]);
            for (int j = 0; j < n; ++j) {
                ArrayList a = new ArrayList();
                for (int k = 0; k < old.size(); ++k) {
                    a.add(old.get(bootstrap ? Utils.generator.nextInt(old.size()) : k));
                }
                this.speciesMap.put(names[i] + "_" + j, a);
            }
        }
    }

    SampleSet randomSample(int percentTestPointsPerSpecies) {
        HashMap rnd = new HashMap();
        String[] names = this.getNames();
        for (int i = 0; i < names.length; ++i) {
            ArrayList old = (ArrayList)this.speciesMap.get(names[i]);
            ArrayList a = new ArrayList();
            int toRemove = (int)((double)(percentTestPointsPerSpecies * old.size()) / 100.0);
            for (int j = 0; j < toRemove; ++j) {
                if (old.size() == 0) continue;
                int sel = (int)(Utils.generator.nextDouble() * (double)old.size());
                a.add(old.get(sel));
                old.remove(sel);
            }
            if (old.size() == 0) continue;
            rnd.put(names[i], a);
        }
        return new SampleSet(this.dimension, rnd);
    }

    public SampleSet spatialFilter(double mindist) {
        HashMap filtered = new HashMap();
        String[] names = this.getNames();
        for (int i = 0; i < names.length; ++i) {
            ArrayList old = (ArrayList)this.speciesMap.get(names[i]);
            int[] order = SampleSet.randomPermutation(old.size());
            ArrayList<Sample> a = new ArrayList<Sample>();
            for (int j = 0; j < old.size(); ++j) {
                boolean close = false;
                Sample s = (Sample)old.get(order[j]);
                for (int k = 0; k < a.size(); ++k) {
                    if (!(this.dist(s, (Sample)a.get(k)) < mindist)) continue;
                    close = true;
                    break;
                }
                if (close) continue;
                a.add(s);
            }
            filtered.put(names[i], a);
        }
        return new SampleSet(this.dimension, filtered);
    }

    double dist(Sample s1, Sample s2) {
        double dlat = s1.getLat() - s2.getLat();
        double dlon = s1.getLon() - s2.getLon();
        return Math.sqrt(dlat * dlat + dlon * dlon);
    }
}

