/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Csv;
import density.GridDimension;
import density.Layer;
import density.Params;
import density.Sample;
import density.SampleSet;
import density.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;

public class SampleSet2
extends SampleSet {
    Layer[] layers;
    int n;
    int[] layerToColumn;
    boolean samplesHaveData = false;
    HashMap datamap = new HashMap();
    String sampleFile;
    GridDimension dim;
    Params params;

    boolean missingFields() {
        for (int i = 0; i < this.layerToColumn.length; ++i) {
            if (this.layerToColumn[i] != -1) continue;
            return true;
        }
        return false;
    }

    String missingField() {
        for (int i = 0; i < this.layerToColumn.length; ++i) {
            if (this.layerToColumn[i] != -1) continue;
            return this.layers[i].name;
        }
        return null;
    }

    int numSamples() {
        return this.datamap.keySet().size();
    }

    static String[] featureNames(String sampleFile) throws IOException {
        Csv csv = new Csv(sampleFile);
        String[] fields = csv.headers();
        if (fields.length < necessaryFields) {
            throw SampleSet2.necessaryFieldsException();
        }
        if (fields.length < SampleSet.firstEnvVar + 1) {
            return new String[0];
        }
        String[] result = new String[fields.length - SampleSet.firstEnvVar];
        for (int i = 0; i < result.length; ++i) {
            result[i] = fields[SampleSet.firstEnvVar + i];
        }
        return result;
    }

    public SampleSet2(String sampleFile, GridDimension dim, Params p) throws IOException {
        this(sampleFile, new Layer[0], dim, p);
        this.read(null);
    }

    public SampleSet2(String sampleFile, Layer[] layers, GridDimension dim, Params p) throws IOException {
        this.layers = layers;
        this.n = layers.length;
        this.sampleFile = sampleFile;
        this.dim = dim;
        this.params = p == null ? new Params() : p;
        this.checkHeaders();
    }

    void checkHeaders() throws IOException {
        String sampleFileName = new File(this.sampleFile).getName();
        String[] featureNames = SampleSet2.featureNames(this.sampleFile);
        boolean[] used = new boolean[featureNames.length];
        block0: for (int j = 0; j < this.n; ++j) {
            String name = this.layers[j].getName();
            for (int i = 0; i < featureNames.length; ++i) {
                if (!name.equals(featureNames[i])) continue;
                this.samplesHaveData = true;
                used[i] = true;
                continue block0;
            }
        }
        for (int i = 0; i < featureNames.length; ++i) {
            if (used[i]) continue;
            boolean unselected = false;
            if (this.params != null && this.params.unusedLayers != null) {
                for (int j = 0; j < this.params.unusedLayers.length; ++j) {
                    if (!this.params.unusedLayers[j].equals(featureNames[i])) continue;
                    unselected = true;
                }
            }
            if (unselected) continue;
            Utils.warn2("Unused field " + featureNames[i] + " in " + sampleFileName, "unusedsamplefilefield");
        }
    }

    public void read(String[] species) throws IOException {
        boolean longFirst;
        HashSet<String> speciesSet;
        final String sampleFileName = new File(this.sampleFile).getName();
        Utils.reportDoing("Reading samples from " + sampleFileName);
        Utils.reportMemory("Read samples");
        String[] featureNames = SampleSet2.featureNames(this.sampleFile);
        this.layerToColumn = new int[this.n];
        block0: for (int j = 0; j < this.n; ++j) {
            String name = this.layers[j].getName();
            this.layerToColumn[j] = -1;
            for (int i = 0; i < featureNames.length; ++i) {
                if (!name.equals(featureNames[i])) continue;
                this.layerToColumn[j] = i;
                continue block0;
            }
        }
        HashSet<String> hashSet = speciesSet = species == null ? null : new HashSet<String>();
        if (species != null) {
            for (int i = 0; i < species.length; ++i) {
                speciesSet.add(species[i]);
            }
        }
        final Csv csv = new Csv(this.sampleFile);
        String[] fields = csv.headers();
        this.header = csv.headerString();
        String c2 = fields[xIndex];
        String c3 = fields[yIndex];
        boolean bl = longFirst = c2.toLowerCase().indexOf("lat") == -1 || c3.toLowerCase().indexOf("lat") != -1;
        if (!longFirst) {
            Utils.warn("interpreting " + c2 + " column of sample file as latitude");
        }
        Csv csv2 = csv;
        Objects.requireNonNull(csv2);
        csv.apply(new Csv.Applier(csv2){

            @Override
            public void process() {
                String[] fields = csv.getCurrentRecord();
                String spid = SampleSet.sanitizeSpeciesName(fields[SampleSet.speciesIndex].replaceAll("\"", ""));
                if (speciesSet != null && !speciesSet.contains(spid)) {
                    return;
                }
                double x = 0.0;
                double y = 0.0;
                int r = -1;
                int c = -1;
                int spatialCol = Integer.parseInt(fields[SampleSet.spatialIndex]);
                try {
                    x = Double.parseDouble(fields[SampleSet.xIndex]);
                    y = Double.parseDouble(fields[SampleSet.yIndex]);
                    if (!longFirst) {
                        double tmp = x;
                        x = y;
                        y = tmp;
                    }
                    if (SampleSet2.this.dim != null) {
                        int[] rc = SampleSet2.this.dim.toRowCol(new double[]{x, y});
                        r = rc[0];
                        c = rc[1];
                    }
                }
                catch (NumberFormatException e) {
                    x = 0.0;
                    y = 0.0;
                }
                Sample s = new Sample(-1, r, c, y, x, spid, spatialCol);
                int goodvals = 0;
                double[] data = new double[SampleSet2.this.n];
                for (int j = 0; j < SampleSet2.this.n; ++j) {
                    int idx = SampleSet2.this.layerToColumn[j];
                    data[j] = SampleSet.NODATA_value;
                    if (idx != -1 && idx < fields.length && !fields[SampleSet.firstEnvVar + idx].trim().equals("")) {
                        data[j] = Double.parseDouble(fields[SampleSet.firstEnvVar + idx]);
                    }
                    if (data[j] == (double)SampleSet.NODATA_value && idx != -1) {
                        SampleSet2.warnPartialData(x, y, sampleFileName, SampleSet2.this.layers[j].name);
                        if (!SampleSet2.this.params.allowpartialdata()) {
                            return;
                        }
                    }
                    if (data[j] == (double)SampleSet.NODATA_value) continue;
                    ++goodvals;
                }
                if (SampleSet2.this.missingFields() && (SampleSet2.this.dim == null || !SampleSet2.this.dim.inBounds(r, c))) {
                    Utils.warn2("Sample at " + x + ", " + y + " in " + sampleFileName + (String)(SampleSet2.this.samplesHaveData ? " is missing a value for " + SampleSet2.this.missingField() + ", skipping" : " is outside the bounding box of environmental data, skipping"), "sampleoutofbounds");
                    return;
                }
                SampleSet2.this.datamap.put(s, data);
                if (!SampleSet2.this.speciesMap.containsKey(spid)) {
                    SampleSet2.this.speciesMap.put(spid, new ArrayList());
                }
                ((ArrayList)SampleSet2.this.speciesMap.get(spid)).add(s);
            }
        });
    }

    static void warnPartialData(double x, double y, String sampleFileName, String field) {
        Utils.warn2("Sample at " + x + ", " + y + " in " + sampleFileName + " is missing some environmental data (e.g. " + field + ")", "samplemissingsomedata");
    }

    public void createMaps() {
        Sample[] s = this.getSamples();
        for (int i = 0; i < s.length; ++i) {
            double[] data = (double[])this.datamap.get(s[i]);
            HashMap<String, Double> map = new HashMap<String, Double>();
            for (int j = 0; j < this.n; ++j) {
                map.put(this.layers[j].getName(), data[j] == (double)SampleSet.NODATA_value ? null : new Double(data[j]));
            }
            s[i].featureMap = map;
        }
    }
}

