/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Feature;
import density.Sample;
import java.text.NumberFormat;

public class ScaledFeature
extends Feature {
    public double min;
    public double max;
    public double scale;
    Feature f;

    ScaledFeature(Feature f, double min, double max) {
        super(f.n, f.name);
        this.f = f;
        this.min = min;
        this.max = max;
        this.scale = max - min;
    }

    public ScaledFeature(Feature f) {
        super(f.n, f.name);
        this.f = f;
        this.min = this.max = f.eval(0);
        for (int i = 1; i < f.n; ++i) {
            double val = f.eval(i);
            if (val < this.min) {
                this.min = val;
            }
            if (!(val > this.max)) continue;
            this.max = val;
        }
        this.scale = this.max - this.min;
        if (this.scale == 0.0) {
            this.scale = 1.0;
        }
    }

    @Override
    public double eval(int p) {
        return (this.f.eval(p) - this.min) / this.scale;
    }

    @Override
    public double eval(Sample s) {
        return (this.f.eval(s) - this.min) / this.scale;
    }

    @Override
    public boolean hasData(Sample s) {
        return this.f.hasData(s);
    }

    @Override
    String description() {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMinimumFractionDigits(4);
        return this.name + ": lambda = " + nf.format(this.lambda) + " min = " + nf.format(this.min) + " max = " + nf.format(this.max);
    }
}

