/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.GridDimension;
import density.LazyGrid;
import java.io.IOException;

public class ShrunkGrid
extends LazyGrid {
    int keepEvery = 1;
    LazyGrid grid;

    public ShrunkGrid(LazyGrid g, int maxRowsAndCols) throws IOException {
        this.grid = g;
        GridDimension dim = this.grid.getDimension();
        if (maxRowsAndCols != -1 && dim.ncols > maxRowsAndCols && dim.nrows > maxRowsAndCols) {
            double mr = (double)dim.nrows / (double)maxRowsAndCols;
            double mc = (double)dim.ncols / (double)maxRowsAndCols;
            this.keepEvery = (int)(mr < mc ? Math.ceil(mr) : Math.ceil(mc));
        }
        this.setDimension(new GridDimension(dim.getxllcorner(), dim.getyllcorner(), dim.getcellsize() * (double)this.keepEvery, dim.getnrows() / this.keepEvery, dim.getncols() / this.keepEvery));
    }

    @Override
    public float eval(int r, int c) {
        return this.grid.eval(r * this.keepEvery, c * this.keepEvery);
    }

    @Override
    public boolean hasData(int r, int c) {
        return this.grid.hasData(r * this.keepEvery, c * this.keepEvery);
    }

    @Override
    public void initialize() throws IOException {
        this.grid.initialize();
    }

    @Override
    public void close() throws IOException {
        this.grid.close();
    }
}

