/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Grid;
import density.GridByte;
import density.GridWriter;
import density.LazyGrid;
import java.io.IOException;

public class Threshold {
    long dcnt;
    long pcnt;

    public static void main(String[] args) {
        String usage = "Usage: density.Threshold infile threshold outfile";
        if (args.length < 2) {
            System.out.println(usage);
            return;
        }
        try {
            new Threshold().applyThreshold(args[0], Double.parseDouble(args[1]), args[2]);
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
    }

    double applyThreshold(String infile, final double threshold, String outfile) throws IOException {
        final LazyGrid g = new LazyGrid(infile);
        GridByte out = new GridByte(g.getDimension(), g.getName()){
            {
                super(dim, s);
                Threshold.this.dcnt = 0L;
                Threshold.this.pcnt = 0L;
                this.NODATA_value = 2.0;
            }

            @Override
            public byte evalByte(int r, int c) {
                ++Threshold.this.dcnt;
                if ((double)g.eval(r, c) < threshold) {
                    return 0;
                }
                ++Threshold.this.pcnt;
                return 1;
            }

            @Override
            public boolean hasData(int r, int c) {
                return g.hasData(r, c);
            }
        };
        new GridWriter((Grid)out, outfile).writeAll();
        return this.dcnt == 0L ? 0.0 : (double)this.pcnt / (double)this.dcnt;
    }

    double applyThreshold(String infile, double threshold) throws IOException {
        String pre = infile.substring(0, infile.length() - 4);
        String suf = infile.substring(infile.length() - 4, infile.length());
        String outfile = pre + "_thresholded" + suf;
        return this.applyThreshold(infile, threshold, outfile);
    }
}

