/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.DirectorySelect;
import density.Display;
import density.Grid;
import density.GridWriter;
import density.MyProgressMonitor;
import density.Params;
import density.SampleSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Random;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class Utils {
    static String version = "3.4.4";
    static boolean interrupt = false;
    static boolean warnings = true;
    public static boolean verbose = false;
    public static boolean visible = true;
    static JFrame topLevelFrame = null;
    public static Random generator;
    private static Preferences userPrefs;
    static String[] inputFileTypes;
    public static FilenameFilter filenameFilter;
    public static FileFilter fileFilter;
    static PrintStream logOut;
    static long startTime;
    static long lastReportedTime;
    static long lastMem;
    static MyProgressMonitor progressMonitor;
    static double lastProgress;
    static String progressMsg;
    static ArrayList suppressedWarnings;
    static HashMap chosenWarnOptions;

    public static String getVersion() {
        return version;
    }

    public static String[] getArgs(String[] allargs, int optind) {
        String[] args = new String[allargs.length - optind];
        for (int i = 0; i < args.length; ++i) {
            args[i] = allargs[i + optind];
        }
        return args;
    }

    public static String getJarfileLocation() {
        String lookFor;
        String classLocation = Utils.class.getName().replace('.', '/') + ".class";
        ClassLoader loader = Utils.class.getClassLoader();
        if (loader == null) {
            return null;
        }
        String location = loader.getResource(classLocation).toString();
        if (location.indexOf(lookFor = "jar:file:") == -1) {
            return null;
        }
        return location.substring(location.indexOf(lookFor) + 9, location.indexOf("Utils.class") - 10);
    }

    static void applyStaticParams(Params params) {
        GridWriter.scientificPattern = params.getString("scientificPattern").toUpperCase(Locale.US);
        verbose = params.getboolean("verbose");
        warnings = params.getboolean("warnings");
        visible = params.getboolean("visible");
        DirectorySelect.prefixes = params.getboolean("prefixes");
        Grid.defaultNODATA_value = SampleSet.NODATA_value = params.getint("nodata");
        if (params.getBoolean("nceas").booleanValue()) {
            SampleSet.setNCEAS_FORMAT();
        }
        Display.adjustSampleRadius = params.getint("adjustsampleradius");
    }

    public static String getGridAbsolutePath(String dir, String gridName) {
        for (int j = 0; j < inputFileTypes.length; ++j) {
            File f = new File(dir, gridName + inputFileTypes[j]);
            if (f.exists()) {
                return f.getAbsolutePath();
            }
            f = new File(dir, gridName + inputFileTypes[j].toUpperCase(Locale.US));
            if (!f.exists()) continue;
            return f.getAbsolutePath();
        }
        Utils.popupError("Layer " + gridName + " is missing from " + dir, null);
        return null;
    }

    public static String fileToLayer(String s) {
        return Utils.fileToLayer(new File(s));
    }

    public static String fileToLayer(File f) {
        String name = f.getName();
        for (int j = 0; j < inputFileTypes.length; ++j) {
            if (!name.toLowerCase().endsWith(inputFileTypes[j])) continue;
            return name.substring(0, name.length() - inputFileTypes[j].length());
        }
        return name;
    }

    public static String[] gridFileNames(String dir) throws IOException {
        return Utils.gridFileNames(dir, null);
    }

    public static String[] gridFileNames(String dir, HashSet<String> keep) throws IOException {
        File[] files = new File(dir).listFiles(filenameFilter);
        ArrayList<String> a = new ArrayList<String>();
        HashSet<String> used = new HashSet<String>();
        for (int i = 0; i < files.length; ++i) {
            String name = Utils.fileToLayer(files[i].getName());
            if (keep != null && !keep.contains(name)) continue;
            a.add(files[i].getPath());
            used.add(name);
        }
        if (keep != null && a.size() != keep.size()) {
            for (String s : keep) {
                if (used.contains(s)) continue;
                throw new IOException("Directory " + dir + " is missing environmental layer " + s);
            }
        }
        Object[] names = a.toArray(new String[0]);
        Arrays.sort(names);
        return names;
    }

    static void openLog(String dir, String logfile) throws IOException {
        if (logOut == null && logfile != null && dir != null) {
            logOut = new PrintStream(new FileOutputStream(new File(dir, logfile), false));
        }
    }

    static void closeLog() {
        if (logOut != null) {
            logOut.close();
        }
        logOut = null;
    }

    static void echo(String s) {
        if (logOut != null) {
            logOut.print(s);
        }
    }

    static void startTimer() {
        lastReportedTime = startTime = System.currentTimeMillis();
    }

    static void echoln() {
        Utils.echoln("");
    }

    static void echoln(String s) {
        if (logOut != null) {
            long time = System.currentTimeMillis();
            if (time > lastReportedTime + 1000L) {
                logOut.println("Time since start: " + (double)(time - startTime) / 1000.0);
                lastReportedTime = time;
            }
            logOut.println(s);
            logOut.flush();
        }
    }

    public static void reportMemory(String s) {
        Runtime runtime = Runtime.getRuntime();
        long tot = runtime.totalMemory();
        long free = runtime.freeMemory();
        long max = runtime.maxMemory();
        Utils.echoln(s + ": max memory " + max + ", total allocated " + tot + ", free " + free + ", used " + (tot - free) + ", increment " + (tot - free - lastMem));
        lastMem = tot - free;
    }

    static String protectFileName(String s) {
        return s.indexOf(" ") == -1 ? s : "\"" + s + "\"";
    }

    static void reportDoing(String s) {
        Utils.echoln(s);
        progressMsg = s;
        lastProgress = -1.0;
        Utils.reportProgress(0.0);
        lastProgress = -1.0;
    }

    static void reportProgress(double x, String suffix) {
        Utils.reportProgress(progressMsg + suffix, x);
    }

    static void reportProgress(double x) {
        Utils.reportProgress(progressMsg, x);
    }

    static void reportProgress(String s, double x) {
        if (progressMonitor != null && x - lastProgress >= 0.005) {
            progressMonitor.setProgress((int)x);
            progressMonitor.setNote(s);
            lastProgress = x;
        }
    }

    static String logError(String s, Throwable e) {
        String msg = s + (String)(e == null ? "" : ": " + e.toString());
        Utils.echoln(msg);
        if (e != null) {
            if (verbose) {
                e.printStackTrace(System.out);
            }
            if (logOut != null) {
                e.printStackTrace(logOut);
                logOut.flush();
            }
        } else if (logOut != null) {
            new Exception().printStackTrace(logOut);
        }
        return msg;
    }

    static void popupError(String s, Throwable e) {
        System.err.println("Error: " + s);
        String msg = Utils.logError(s, e);
        if (visible) {
            JOptionPane.showMessageDialog(topLevelFrame, msg, "Error", 0);
        }
    }

    static void disposeProgressMonitor() {
        if (progressMonitor == null) {
            return;
        }
        progressMonitor.dispose();
        progressMonitor = null;
    }

    static void warn(String s) {
        System.err.println("Warning: " + s);
        if (logOut != null) {
            logOut.println("Warning: " + s);
        }
    }

    static void warn2(String s, String warntype) {
        boolean warn2doPopup;
        Utils.warn(s);
        boolean bl = warn2doPopup = warnings && !suppressedWarnings.contains(warntype);
        if (warn2doPopup && topLevelFrame != null) {
            Object[] options = new Object[]{"OK", "Suppress similar visual warnings"};
            int val = JOptionPane.showOptionDialog(topLevelFrame, s, "", -1, 2, null, options, options[0]);
            switch (val) {
                case 1: {
                    suppressedWarnings.add(warntype);
                }
            }
        }
    }

    public static void fatalException(String s, Throwable e) {
        System.err.println(s + (String)(e == null ? "" : ": " + e.toString()));
        Utils.popupError(s, e);
        System.exit(1);
    }

    public static boolean testMemory(long bytesToTest) {
        int count;
        System.gc();
        if (System.getProperties().getProperty("os.name").startsWith("Windows")) {
            Runtime r = Runtime.getRuntime();
            long avail = r.maxMemory() - r.totalMemory() + r.freeMemory();
            return avail >= bytesToTest;
        }
        int MEGABYTE = 0x100000;
        int maximumMeg = (int)Math.ceil((double)bytesToTest / (double)MEGABYTE);
        Object[] memoryHolder = new Object[maximumMeg];
        boolean result = false;
        try {
            for (count = 0; count < memoryHolder.length; ++count) {
                memoryHolder[count] = new byte[MEGABYTE];
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        result = count == memoryHolder.length;
        memoryHolder = null;
        return result;
    }

    public static PrintWriter writer(File f, boolean append) throws IOException {
        return new PrintWriter(new FileOutputStream(f, append));
    }

    public static PrintWriter writer(File f) throws IOException {
        return Utils.writer(f, false);
    }

    public static PrintWriter writer(String file) throws IOException {
        return Utils.writer(new File(file));
    }

    public static PrintWriter writer(String dir, String file) throws IOException {
        return Utils.writer(new File(dir, file));
    }

    static double[] doubleArrayList2Array(ArrayList a) {
        int num = a.size();
        double[] result = new double[num];
        for (int i = 0; i < num; ++i) {
            result[i] = (Double)a.get(i);
        }
        return result;
    }

    public static String capitalize(String s) {
        if (s.length() == 0) {
            return s;
        }
        return s.substring(0, 1).toUpperCase(Locale.US) + s.substring(1).toLowerCase();
    }

    public static String pngname(String fileName) {
        return Utils.pngname(fileName, false);
    }

    public static String pngname(String fileName, boolean includePath) {
        File f = new File(fileName.substring(0, fileName.length() - 4));
        return (includePath ? f.getPath() : f.getName()) + ".png";
    }

    static {
        userPrefs = Preferences.userNodeForPackage(Utils.class);
        inputFileTypes = new String[]{".mxe", ".asc", ".grd", ".bil"};
        filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File f, String name) {
                for (int j = 0; j < inputFileTypes.length; ++j) {
                    if (!name.toLowerCase().endsWith(inputFileTypes[j])) continue;
                    return true;
                }
                return false;
            }
        };
        fileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                for (int j = 0; j < inputFileTypes.length; ++j) {
                    if (!f.getName().toLowerCase().endsWith(inputFileTypes[j])) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                Object types = "";
                for (int i = 0; i < inputFileTypes.length; ++i) {
                    types = (String)types + (i == 0 ? "" : "/") + inputFileTypes[i];
                }
                return (String)types + " files";
            }
        };
        logOut = null;
        lastMem = 0L;
        suppressedWarnings = new ArrayList();
        chosenWarnOptions = new HashMap();
    }
}

