/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.Csv;
import density.GridDimension;
import density.LazyGrid;
import density.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Objects;

public class Checkerboard {
    int blocksperrow;
    int blockspercol;
    int maxtest = 100000;
    int maxtrain = 100000;
    double offset = 0.0;
    double excludeEdgeWidth = 0.15;

    public static void main(String[] args) {
        try {
            new Checkerboard().go(args);
        }
        catch (IOException e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    boolean isTrain(double x, double y, GridDimension dim) {
        int cb;
        int r = dim.toRow(y);
        int c = dim.toCol(x);
        int rb = (int)((double)(r * this.blockspercol) / (double)dim.getnrows() + this.offset);
        return (rb + (cb = (int)((double)(c * this.blocksperrow) / (double)dim.getncols() + this.offset))) % 2 == 0;
    }

    boolean isExcludedEdge(double x, double y, GridDimension dim) {
        int r = dim.toRow(y);
        int c = dim.toCol(x);
        double rb = (double)(r * this.blockspercol) / (double)dim.getnrows() + this.offset;
        double cb = (double)(c * this.blocksperrow) / (double)dim.getncols() + this.offset;
        return rb - (double)((int)rb) > 1.0 - this.excludeEdgeWidth || cb - (double)((int)cb) > 1.0 - this.excludeEdgeWidth;
    }

    void go(String[] args) throws IOException {
        String usage = "Usage: density.Checkerboard samplesFile blocksPerRow blocksPerColumn offset outSuffix envlayer";
        if (args.length < 6) {
            System.out.println(usage);
            System.exit(0);
        }
        String samplesFile = args[0];
        String outsuffix = args[4];
        String grid = args[5];
        this.blocksperrow = Integer.parseInt(args[1]);
        this.blockspercol = Integer.parseInt(args[2]);
        this.offset = Double.parseDouble(args[3]);
        final PrintWriter train = Utils.writer(outsuffix + "_train.csv");
        final PrintWriter test = Utils.writer(outsuffix + "_test.csv");
        final Csv csv = new Csv(samplesFile);
        final GridDimension dim = new LazyGrid(grid).getDimension();
        train.println(csv.headerString());
        test.println(csv.headerString());
        Csv csv2 = csv;
        Objects.requireNonNull(csv2);
        csv.apply(new Csv.Applier(csv2){
            double ntest = 0.0;
            double ntrain = 0.0;

            @Override
            public void process() {
                PrintWriter out;
                double y;
                double x = this.getDouble(1);
                if (Checkerboard.this.isExcludedEdge(x, y = this.getDouble(2), dim)) {
                    return;
                }
                PrintWriter printWriter = out = Checkerboard.this.isTrain(x, y, dim) ? train : test;
                if (Checkerboard.this.isTrain(x, y, dim)) {
                    double d = this.ntrain;
                    this.ntrain = d + 1.0;
                    if (d < (double)Checkerboard.this.maxtrain) {
                        train.println(Csv.toCsvFormat(csv.getCurrentRecord()));
                    }
                } else {
                    double d = this.ntest;
                    this.ntest = d + 1.0;
                    if (d < (double)Checkerboard.this.maxtest) {
                        test.println(Csv.toCsvFormat(csv.getCurrentRecord()));
                    }
                }
            }
        });
        train.close();
        test.close();
    }
}

