/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.Grid;
import density.GridDimension;
import density.GridIO;
import density.GridWriter;
import java.io.File;
import java.io.IOException;

public class Coarsen {
    public static void main(String[] args) {
        try {
            new Coarsen().go(args);
        }
        catch (IOException e) {
            System.out.println("Error: " + e.toString());
            System.exit(0);
        }
    }

    void go(String[] args) throws IOException {
        if (args.length < 3) {
            System.out.println("Usage: Coarsen radius outdir file1 file2...");
            System.exit(0);
        }
        int radius = Integer.parseInt(args[0]);
        final int reduce = 2 * radius + 1;
        String outdir = args[1];
        for (int i = 2; i < args.length; ++i) {
            String infile = args[i];
            String name = new File(infile).getName();
            System.out.println(name);
            final Grid old = GridIO.readGrid(infile);
            GridDimension dim = old.getDimension();
            int rr = (int)Math.ceil((double)dim.getnrows() / (double)reduce);
            int cc = (int)Math.ceil((double)dim.getncols() / (double)reduce);
            GridDimension newdim = new GridDimension(dim.getxllcorner(), dim.getyllcorner(), dim.getcellsize() * (double)reduce, rr, cc);
            Grid newg = new Grid(this, newdim, "Coarsened"){

                @Override
                public boolean hasData(int r, int c) {
                    for (int rr = r * reduce; rr < (r + 1) * reduce; ++rr) {
                        for (int cc = c * reduce; cc < (c + 1) * reduce; ++cc) {
                            if (!old.hasData(rr, cc)) continue;
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public float eval(int r, int c) {
                    double sum = 0.0;
                    for (int rr = r * reduce; rr < (r + 1) * reduce; ++rr) {
                        for (int cc = c * reduce; cc < (c + 1) * reduce; ++cc) {
                            if (!old.hasData(rr, cc)) continue;
                            sum += (double)old.eval(rr, cc);
                        }
                    }
                    return (float)sum;
                }
            };
            new GridWriter(newg, new File(outdir, name)).writeAll();
        }
    }
}

