/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.Grid;
import density.GridDimension;
import density.GridIO;
import density.tools.Stats;
import java.io.IOException;

public class Correlation {
    public static void main(String[] args) {
        String usage = "Usage: Correlation gridfile1 gridfile2";
        if (args.length < 2) {
            System.out.println(usage);
            System.exit(0);
        }
        try {
            new Correlation().go(args[0], args[1]);
        }
        catch (IOException e) {
            System.out.println(e.toString());
            System.exit(1);
        }
    }

    void go(String gridfile1, String gridfile2) throws IOException {
        Grid[] grid = new Grid[]{GridIO.readGrid(gridfile1), GridIO.readGrid(gridfile2)};
        GridDimension dim = grid[0].getDimension();
        int nrows = dim.getnrows();
        int ncols = dim.getncols();
        int max = nrows * ncols;
        double[][] pred = new double[2][max];
        int cnt = 0;
        for (int r = 0; r < nrows; ++r) {
            for (int c = 0; c < ncols; ++c) {
                if (!grid[0].hasData(r, c) || !grid[1].hasData(r, c)) continue;
                pred[0][cnt] = grid[0].eval(r, c);
                pred[1][cnt++] = grid[1].eval(r, c);
            }
        }
        double[][] predd = new double[2][cnt];
        for (int i = 0; i < cnt; ++i) {
            for (int j = 0; j < 2; ++j) {
                predd[j][i] = pred[j][i];
            }
        }
        System.out.println(Stats.correlation(predd[0], predd[1]));
    }
}

