/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.Grid;
import density.GridDimension;
import density.GridWriter;
import density.LazyGrid;
import density.tools.CsvOnePass;
import gnu.getopt.Getopt;
import java.io.IOException;

public class Csv2Grid {
    public static void main(String[] args) {
        try {
            new Csv2Grid().go(args);
        }
        catch (IOException e) {
            System.out.println("Error: " + e.toString());
            System.exit(1);
        }
    }

    void go(String[] args) throws IOException {
        int c;
        String usage = "Usage: Csv2Grid [-r rowname] [-c colname] templateGrid csvFile convertColName outFile";
        String row = "row";
        String col = "column";
        boolean geographic = false;
        Getopt g = new Getopt("FromBRTFormat", args, "r:c:x:y:");
        block6: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 114: {
                    row = g.getOptarg();
                    continue block6;
                }
                case 99: {
                    col = g.getOptarg();
                    continue block6;
                }
                case 120: {
                    col = g.getOptarg();
                    geographic = true;
                    continue block6;
                }
                case 121: {
                    row = g.getOptarg();
                    geographic = true;
                    continue block6;
                }
            }
            System.out.println(usage);
            System.exit(0);
        }
        if (args.length - g.getOptind() < 4) {
            System.out.println(usage);
            System.exit(0);
        }
        String templateGrid = args[g.getOptind()];
        String csvfile = args[g.getOptind() + 1];
        final String convertColName = args[g.getOptind() + 2];
        String outfile = args[g.getOptind() + 3];
        final GridDimension dim = new LazyGrid(templateGrid).getDimension();
        int nrows = dim.getnrows();
        int ncols = dim.getncols();
        final CsvOnePass csv = new CsvOnePass(csvfile);
        final int rowi = csv.fieldIndex(row);
        final int coli = csv.fieldIndex(col);
        final boolean convertGeographic = geographic;
        Grid grid = new Grid(this, dim, "fromCsv"){
            int lastr;
            int lastc;
            float lastVal;
            {
                super(dim2, s);
                this.lastr = -1;
                this.lastc = -1;
                this.lastVal = -1.0f;
            }

            void readFromCsv(int r, int c) {
                if (this.lastr > r || this.lastr == r && this.lastc >= c) {
                    return;
                }
                if (csv.getRecord() == null) {
                    this.lastc = Integer.MAX_VALUE;
                    this.lastr = Integer.MAX_VALUE;
                } else {
                    if (convertGeographic) {
                        double x = csv.getDouble(coli);
                        double y = csv.getDouble(rowi);
                        this.lastr = dim.toRow(y);
                        this.lastc = dim.toCol(x);
                    } else {
                        this.lastr = Integer.parseInt(csv.get(rowi));
                        this.lastc = Integer.parseInt(csv.get(coli));
                    }
                    this.lastVal = (float)csv.getDouble(convertColName);
                }
            }

            @Override
            public float eval(int r, int c) {
                this.readFromCsv(r, c);
                return this.lastVal;
            }

            @Override
            public boolean hasData(int r, int c) {
                this.readFromCsv(r, c);
                return this.lastr == r && this.lastc == c;
            }
        };
        new GridWriter(grid, outfile).writeAll();
    }
}

