/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

class CsvOnePass {
    String[] headers;
    HashMap headerMap = new HashMap();
    String fileName;
    String[] currentRecord;
    BufferedReader in;
    String myseparator = ",";
    static String separator = ",";
    static boolean allowQuote = true;

    static String[] getTokens(BufferedReader in, String where) throws IOException {
        return CsvOnePass.getTokens(in, where, separator);
    }

    static String[] getTokens(BufferedReader in, String where, String separator) throws IOException {
        ArrayList records = new ArrayList();
        Object token = "";
        boolean inQuote = false;
        ArrayList<Object> tokens = new ArrayList<Object>();
        while (true) {
            String s;
            if ((s = in.readLine()) == null && tokens.size() == 0) {
                return null;
            }
            if (s == null) {
                throw new IOException("End of file reached while parsing " + where);
            }
            StringTokenizer st = new StringTokenizer(s, separator + "\"", true);
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (tok.equals("\"") && allowQuote) {
                    inQuote = !inQuote;
                    continue;
                }
                if (tok.equals(separator) && !inQuote) {
                    tokens.add(token);
                    token = "";
                    continue;
                }
                token = (String)token + tok;
            }
            if (!inQuote) break;
            token = (String)token + System.getProperty("line.separator");
        }
        tokens.add(token);
        if (tokens.size() == 0 || tokens.size() == 1 && tokens.get(0).equals("")) {
            return null;
        }
        return tokens.toArray(new String[0]);
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            System.out.println("Error closing " + this.fileName + ": " + e.toString());
            System.exit(1);
        }
    }

    public CsvOnePass(String fileName) {
        this(fileName, true, separator);
    }

    public CsvOnePass(String fileName, String mysep) {
        this(fileName, true, mysep);
    }

    public CsvOnePass(String fileName, boolean firstLineFieldNames) {
        this(fileName, firstLineFieldNames, separator);
    }

    public CsvOnePass(String fileName, boolean firstLineFieldNames, String mysep) {
        this.myseparator = mysep;
        this.fileName = fileName;
        if (!(fileName.endsWith(".csv") || fileName.endsWith(".CSV") || new File(fileName).exists())) {
            this.fileName = fileName + ".csv";
        }
        if (fileName.endsWith(".tab") || fileName.endsWith(".TAB")) {
            this.myseparator = "\t";
        }
        try {
            this.in = new BufferedReader(new FileReader(this.fileName));
            if (firstLineFieldNames) {
                this.processHeader(CsvOnePass.getTokens(this.in, fileName, this.myseparator));
            }
        }
        catch (IOException e) {
            System.out.println(e.toString());
            System.exit(1);
        }
    }

    void processHeader(String[] headers) {
        this.headers = headers;
        for (int i = 0; i < headers.length; ++i) {
            headers[i] = headers[i].toLowerCase().trim();
            this.headerMap.put(headers[i], new Integer(i));
        }
    }

    String[] getRecord() {
        try {
            this.currentRecord = CsvOnePass.getTokens(this.in, this.fileName, this.myseparator);
        }
        catch (IOException e) {
            System.out.println("Error reading from " + this.fileName + ": " + e.toString());
            System.exit(1);
        }
        return this.currentRecord;
    }

    String[] getCurrentRecord() {
        return this.currentRecord;
    }

    boolean hasField(String s) {
        return this.headerMap.containsKey(s.toLowerCase());
    }

    int fieldIndex(String s) {
        Integer i = (Integer)this.headerMap.get(s.toLowerCase());
        if (i == null) {
            System.err.println("Field " + s + " not found in " + this.fileName);
        }
        return i == null ? -1 : i;
    }

    public double getDouble(String field) {
        return Double.parseDouble(this.get(field).replaceAll(",", ""));
    }

    public double getDouble(int i) {
        return Double.parseDouble(this.get(i).replaceAll(",", ""));
    }

    String get(int i) {
        return this.currentRecord[i];
    }

    String get(String field) {
        int i = this.fieldIndex(field);
        return i == -1 || i >= this.currentRecord.length ? null : this.currentRecord[i];
    }

    String[] headers() {
        return this.headers;
    }

    String headerString() {
        Object result = "";
        int i = 0;
        while (i < this.headers.length) {
            result = (String)result + this.headers[i++];
        }
        return result;
    }

    void apply(Applier applier) {
        while (this.getRecord() != null) {
            applier.process();
        }
    }

    public abstract class Applier {
        String get(String field) {
            return CsvOnePass.this.get(field);
        }

        String get(int i) {
            return CsvOnePass.this.get(i);
        }

        public abstract void process();
    }
}

