/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.Csv;
import density.Grid;
import density.GridDimension;
import density.GridIO;
import density.GridWriter;
import java.io.IOException;
import java.util.Objects;

public class CsvToGrid {
    public static void main(String[] args) {
        String usage = "Usage: CsvToGrid csvFile xcol ycol gridFileForDimension outFile";
        if (args.length < 5) {
            System.out.println(usage);
            System.exit(0);
        }
        String csvFile = args[0];
        String gridFile = args[3];
        String outfile = args[4];
        final String xcol = args[1];
        final String ycol = args[2];
        try {
            final GridDimension dim = GridIO.readGrid(gridFile).getDimension();
            Csv csv = new Csv(csvFile);
            int nr = dim.getnrows();
            int nc = dim.getncols();
            final boolean[][] vals = new boolean[nr][nc];
            Csv csv2 = csv;
            Objects.requireNonNull(csv2);
            csv.apply(new Csv.Applier(csv2){

                @Override
                public void process() {
                    double y;
                    double x = Double.parseDouble(this.get(xcol));
                    if (dim.inBounds(x, y = Double.parseDouble(this.get(ycol)))) {
                        vals[dim.toRow((double)y)][dim.toCol((double)x)] = true;
                    }
                }
            });
            Grid out = new Grid(dim, "grid"){

                @Override
                public float eval(int r, int c) {
                    return vals[r][c] ? 1.0f : 0.0f;
                }

                @Override
                public boolean hasData(int r, int c) {
                    return true;
                }
            };
            new GridWriter(out, outfile).writeAll();
        }
        catch (IOException e) {
            System.out.println("Error: " + e);
            System.exit(0);
        }
    }
}

