/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.tools.CsvOnePass;
import density.tools.Stats;
import density.tools.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;

public class Eval {
    static boolean debug = false;
    static boolean doMaxCorrelation = false;
    static HashMap presenceMap = new HashMap();
    static HashMap absenceMap = new HashMap();
    static String species;
    static String fileName;
    static boolean warp;
    static String[] presenceSites;
    static String[] absenceSites;

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: Eval resultsdir evalFileLocations.csv");
            System.exit(1);
        }
        String resultsDir = args[0];
        String evalLocations = args[1];
        final String expt = args.length > 2 ? args[2] : null;
        Utils.readEvalFiles(evalLocations, null, presenceMap, absenceMap);
        File results = new File(resultsDir);
        Object[] csvFiles = results.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (expt != null && name.indexOf(expt) == -1) {
                    return false;
                }
                return name.endsWith(".csv");
            }
        });
        Arrays.sort(csvFiles);
        System.out.println("region, species, expr, AUC, Correlation, Square error, Prevalence, Max Kappa, Threshold for Max Kappa,Logloss,PresenceLoss,AbsenceLoss,Misclassification");
        for (int i = 0; i < csvFiles.length; ++i) {
            String[] foo = ((String)csvFiles[i]).substring(0, ((String)csvFiles[i]).length() - 4).split("_");
            String region = foo[0];
            species = foo[foo.length - 1].toLowerCase();
            String expr1 = foo[1];
            String expr = foo.length == 3 ? foo[1] : foo[1] + "_" + foo[2];
            fileName = new File(results, (String)csvFiles[i]).getPath();
            try {
                HashMap map = Eval.readPrediction(species, fileName, expr1, region);
                double auc = Eval.computeAUC(map);
                System.out.println(region + "," + species + "," + expr + "," + auc + "," + Eval.computeCorrelation(map) + "," + Eval.computeSquareError(map) + "," + (double)presenceSites.length / (double)(presenceSites.length + absenceSites.length) + "," + Stats.maxKappa + "," + Stats.maxKappaThresh + "," + Eval.computeLogloss(map, 2) + "," + Eval.computeLogloss(map, 0) + "," + Eval.computeLogloss(map, 1) + "," + Eval.computeMisClassification(map));
                continue;
            }
            catch (Exception e) {
                System.out.println("Error: " + region + " " + species + "  " + expr + " " + e.toString());
                e.printStackTrace();
            }
        }
    }

    static String warp(String s) {
        return "" + Eval.warp2(Double.parseDouble(s));
    }

    static double warp2(double x) {
        return 10.0 * Math.sqrt(x);
    }

    static HashMap readPrediction(String species, String predictionFile, String experiment, String region) {
        String[] fields;
        CsvOnePass csv = new CsvOnePass(predictionFile);
        HashMap<String, String> map = new HashMap<String, String>();
        while ((fields = csv.getRecord()) != null) {
            map.put(fields[1], warp ? Eval.warp(fields[2]) : fields[2]);
        }
        Object sitename = experiment.equals("error") ? "_" + experiment + "sites" : "_sites";
        presenceSites = (String[])presenceMap.get(species + (String)sitename);
        absenceSites = (String[])absenceMap.get(species + "_sites");
        return map;
    }

    static double getDouble(HashMap map, String key) {
        if (map.get(key) == null) {
            key = key.toLowerCase();
        }
        return Double.parseDouble((String)map.get(key));
    }

    static double max(double x, double y) {
        return x < y ? y : x;
    }

    static double computeLogloss(HashMap map, int which) {
        double prob;
        int i;
        double error = 0.0;
        int cnt = 0;
        if (which == 0 || which == 2) {
            for (i = 0; i < presenceSites.length; ++i) {
                prob = Eval.max(Eval.getDouble(map, presenceSites[i]), Math.exp(-20.0));
                error += Math.log(prob);
                ++cnt;
            }
        }
        if (which == 1 || which == 2) {
            for (i = 0; i < absenceSites.length; ++i) {
                prob = Eval.max(1.0 - Eval.getDouble(map, absenceSites[i]), Math.exp(-20.0));
                error += Math.log(prob);
                ++cnt;
            }
        }
        return -error / (double)cnt;
    }

    static double computeMisClassification(HashMap map) {
        int i;
        double error = 0.0;
        for (i = 0; i < presenceSites.length; ++i) {
            if (!(Eval.getDouble(map, presenceSites[i]) < 0.5)) continue;
            error += 1.0;
        }
        for (i = 0; i < absenceSites.length; ++i) {
            if (!(Eval.getDouble(map, absenceSites[i]) >= 0.5)) continue;
            error += 1.0;
        }
        return error / (double)(presenceSites.length + absenceSites.length);
    }

    static double computeSquareError(HashMap map) {
        int i;
        double error = 0.0;
        for (i = 0; i < presenceSites.length; ++i) {
            error += (1.0 - Eval.getDouble(map, presenceSites[i])) * (1.0 - Eval.getDouble(map, presenceSites[i]));
        }
        for (i = 0; i < absenceSites.length; ++i) {
            error += Eval.getDouble(map, absenceSites[i]) * Eval.getDouble(map, absenceSites[i]);
        }
        return error / (double)(presenceSites.length + absenceSites.length);
    }

    static double computeAUC(HashMap map) {
        int i;
        double[] presence = new double[presenceSites.length];
        double[] absence = new double[absenceSites.length];
        for (i = 0; i < presence.length; ++i) {
            try {
                presence[i] = Eval.getDouble(map, presenceSites[i]);
                continue;
            }
            catch (NullPointerException e) {
                System.out.println("Error reading prediction: site = " + presenceSites[i] + ", file is " + fileName);
            }
        }
        for (i = 0; i < absence.length; ++i) {
            absence[i] = Eval.getDouble(map, absenceSites[i]);
        }
        return Stats.auc(presence, absence);
    }

    static double computeCorrelation(HashMap map) throws IOException {
        int i;
        double[] pred = new double[presenceSites.length + absenceSites.length];
        double[] truth = new double[pred.length];
        PrintWriter out = null;
        if (debug) {
            out = new PrintWriter(new FileOutputStream(species + ".csv"));
            out.println("site,truth,prediction");
        }
        for (i = 0; i < presenceSites.length; ++i) {
            pred[i] = Eval.getDouble(map, presenceSites[i]);
            if (debug) {
                out.println(presenceSites[i] + ",1," + pred[i]);
            }
            truth[i] = 1.0;
        }
        for (i = 0; i < absenceSites.length; ++i) {
            pred[i + Eval.presenceSites.length] = Eval.getDouble(map, absenceSites[i]);
            if (debug) {
                out.println(absenceSites[i] + ",0," + pred[i + presenceSites.length]);
            }
            truth[i + Eval.presenceSites.length] = 0.0;
        }
        if (debug) {
            out.close();
        }
        return doMaxCorrelation ? Stats.maxCorrelation(pred, truth) : Stats.correlation(pred, truth);
    }

    static {
        warp = false;
    }
}

