/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.Grid;
import density.GridDimension;
import density.GridWriter;
import density.LazyGrid;
import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class FromBRTFormat {
    public static void main(String[] args) {
        try {
            new FromBRTFormat().go(args);
        }
        catch (IOException e) {
            System.out.println("Error: " + e.toString());
            System.exit(1);
        }
    }

    void go(String[] args) throws IOException {
        int c;
        String usage = "Usage: FromBRTFormat [-p prefix]";
        String prefix = "brt";
        String outputType = "asc";
        Object predictionsfile = null;
        Object outfile = null;
        Getopt g = new Getopt("FromBRTFormat", args, "p:t:TP:o:h");
        boolean useTheoMap = false;
        boolean firstLineHeader = true;
        final int[] theoMap = new int[]{0, 9, 10, 17, 18, 15, 11, 12, 14, 13, 16};
        block8: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 112: {
                    prefix = g.getOptarg();
                    continue block8;
                }
                case 116: {
                    outputType = g.getOptarg();
                    continue block8;
                }
                case 84: {
                    useTheoMap = true;
                    firstLineHeader = false;
                    continue block8;
                }
                case 104: {
                    firstLineHeader = false;
                    continue block8;
                }
                case 80: {
                    predictionsfile = g.getOptarg();
                    continue block8;
                }
                case 111: {
                    outfile = g.getOptarg();
                    continue block8;
                }
            }
            System.out.println(usage);
            System.exit(0);
        }
        String index = prefix + "_index.mxe";
        if (predictionsfile == null) {
            predictionsfile = prefix + ".predictions";
        }
        if (outfile == null) {
            outfile = prefix + "." + outputType;
        }
        final LazyGrid indexGrid = new LazyGrid(index);
        GridDimension dim = indexGrid.getDimension();
        int nrows = dim.getnrows();
        int ncols = dim.getncols();
        final BufferedReader predin = new BufferedReader(new FileReader((String)predictionsfile));
        if (firstLineHeader) {
            predin.readLine();
        }
        final boolean useMap = useTheoMap;
        Grid grid = new Grid(this, dim, "BRT_prediction"){
            int lastr;
            int lastc;
            float lastVal;
            {
                super(dim, s);
                this.lastr = -1;
                this.lastc = -1;
                this.lastVal = -1.0f;
            }

            @Override
            public float eval(int r, int c) {
                if (r != this.lastr || c != this.lastc) {
                    try {
                        String[] fields;
                        String pred = predin.readLine();
                        this.lastVal = useMap ? (float)theoMap[Integer.parseInt(pred)] : Float.parseFloat((fields = pred.split(" ")).length > 1 ? fields[1] : pred);
                        this.lastr = r;
                        this.lastc = c;
                    }
                    catch (IOException e) {
                        System.out.println("Error: " + e.toString());
                        System.exit(1);
                    }
                }
                return this.lastVal;
            }

            @Override
            public boolean hasData(int r, int c) {
                return indexGrid.hasData(r, c);
            }
        };
        new GridWriter(grid, (String)outfile).writeAll();
    }
}

