/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.Csv;
import density.Grid;
import density.GridIO;
import density.Utils;
import gnu.getopt.Getopt;
import java.io.IOException;
import java.util.Objects;
import java.util.Random;

public class Jiggle {
    double percent = 5.0;
    int replicates = 100;

    public static void main(String[] args) {
        try {
            new Jiggle().go(args);
        }
        catch (IOException e) {
            System.out.println("Error: " + e);
            System.exit(0);
        }
    }

    void go(String[] args) throws IOException {
        int i;
        int cc;
        Object predfile = null;
        Object occfile = null;
        String biasfile = null;
        Object species = null;
        Getopt g = new Getopt("Jiggle", args, "p:r:b:");
        String usage = "Usage: Jiggle [-p percent] [-r replicates] [-b bias]";
        block5: while ((cc = g.getopt()) != -1) {
            switch (cc) {
                case 112: {
                    this.percent = Double.parseDouble(g.getOptarg());
                    continue block5;
                }
                case 114: {
                    this.replicates = Integer.parseInt(g.getOptarg());
                    continue block5;
                }
                case 98: {
                    biasfile = g.getOptarg();
                    continue block5;
                }
            }
            System.out.println(usage);
            System.exit(0);
        }
        if (args.length == 0) {
            System.out.println(usage);
            System.exit(0);
        }
        final Grid bias = biasfile == null ? null : GridIO.readGrid(biasfile);
        final float[] minmax = bias == null ? null : bias.minmax();
        String csvfile = args[g.getOptind()];
        Csv csv = new Csv(csvfile);
        final int nlayers = csv.headers().length - 3;
        final double[] min = new double[nlayers];
        final double[] max = new double[nlayers];
        for (i = 0; i < nlayers; ++i) {
            min[i] = 1000000.0;
            max[i] = -1000000.0;
        }
        Csv csv2 = csv;
        Objects.requireNonNull(csv2);
        csv.apply(new Csv.Applier(this, csv2){

            @Override
            public void process() {
                for (int i = 0; i < nlayers; ++i) {
                    double v = Double.parseDouble(this.get(i + 3));
                    if (v < min[i]) {
                        min[i] = v;
                    }
                    if (!(v > max[i])) continue;
                    max[i] = v;
                }
            }
        });
        for (i = 0; i < nlayers + 3; ++i) {
            System.out.print((i == 0 ? "" : ",") + csv.headers()[i]);
        }
        System.out.println();
        Utils.generator = new Random(System.currentTimeMillis());
        i = 0;
        while (i < this.replicates) {
            final int me = i++;
            Csv csv3 = csv = new Csv(csvfile);
            Objects.requireNonNull(csv3);
            csv.apply(new Csv.Applier(csv3){

                @Override
                public void process() {
                    System.out.print(this.get(0) + "_" + me + "," + this.get(1) + "," + this.get(2));
                    double r = 1.0;
                    if (bias != null) {
                        double b = bias.eval(new double[]{Double.parseDouble(this.get(1)), Double.parseDouble(this.get(2))});
                        r = ((double)minmax[1] - b) / (double)(minmax[1] - minmax[0]);
                    }
                    if (r < 0.0) {
                        System.out.println("Error: bias < 0: " + r);
                    }
                    for (int i = 0; i < nlayers; ++i) {
                        double v = Double.parseDouble(this.get(i + 3));
                        System.out.print("," + (v += 2.0 * (Utils.generator.nextDouble() - 0.5) * Jiggle.this.percent * (max[i] - min[i]) * r / 100.0));
                    }
                    System.out.println();
                }
            });
        }
    }
}

