/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.Csv;
import density.Display;
import density.Grid;
import density.GridWriter;
import density.LazyGrid;
import density.Params;
import density.Project;
import density.tools.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;

public class LimitingFactor {
    String colors = "230|159|0 86|180|233 0|158|115 240|228|66 0|114|178 213|94|0 204|121|167 255|255|240 240|128|128 0|0|0";
    boolean debug = false;

    public static void main(String[] args) {
        try {
            new LimitingFactor().go(args);
        }
        catch (IOException e) {
            System.err.println(e.toString());
            e.printStackTrace();
        }
    }

    void go(String[] args) throws IOException {
        String usage = "Usage: density.tools.LimitingFactor lambdafile projectiondirectory outfile ";
        if (args.length < 3) {
            System.out.println(usage);
            return;
        }
        String lambdafile = args[0];
        String samplefile = args[1];
        String projdir = args[1];
        String outfile = args[2];
        String root = lambdafile.replaceAll(".lambdas$", "");
        Csv meancsv = new Csv(root + "_sampleAverages.csv");
        meancsv.indexAll();
        for (int i = 0; i < 2; ++i) {
            Utils.checkExists(args[i]);
        }
        final HashMap map = new HashMap();
        Project proj = new Project(new Params());
        proj.mapping = true;
        proj.varmap = map;
        final Grid projgrid = proj.projectGrid(lambdafile, null)[0];
        HashSet usedGrids = proj.gridNames();
        String[] gridfilename = density.Utils.gridFileNames(projdir, usedGrids);
        int ng = gridfilename.length;
        final LazyGrid[] grid = new LazyGrid[ng];
        final double[] mean = new double[ng];
        final String[] gridname = new String[ng];
        for (int i = 0; i < ng; ++i) {
            grid[i] = new LazyGrid(gridfilename[i]);
            gridname[i] = density.Utils.fileToLayer(gridfilename[i]);
            mean[i] = meancsv.getDoubleVal(gridname[i], "Sample average");
        }
        Grid result = new Grid(grid[0].getDimension(), "limiting"){

            @Override
            public boolean hasData(int r, int c) {
                for (int i = 0; i < grid.length; ++i) {
                    if (grid[i].hasData(r, c)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public float eval(int r, int c) {
                int i;
                for (int i2 = 0; i2 < grid.length; ++i2) {
                    map.put(gridname[i2], Double.valueOf(grid[i2].eval(r, c)));
                }
                double max = -1.0;
                int var = -1;
                double v = projgrid.eval(0, 0);
                for (i = 0; i < grid.length; ++i) {
                    map.put(gridname[i], mean[i]);
                    double diff = (double)projgrid.eval(0, 0) - v;
                    if (diff > max) {
                        max = diff;
                        var = i;
                    }
                    map.put(gridname[i], Double.valueOf(grid[i].eval(r, c)));
                }
                if (max == 0.0 && LimitingFactor.this.debug) {
                    System.out.println("Row " + r + " column " + c + ": prediction is " + v + ", change when setting each variable to its sample mean is: ");
                    for (i = 0; i < grid.length; ++i) {
                        map.put(gridname[i], mean[i]);
                        System.out.println("  " + gridname[i] + " " + ((double)projgrid.eval(0, 0) - v));
                        map.put(gridname[i], Double.valueOf(grid[i].eval(r, c)));
                    }
                    System.out.println();
                }
                return var;
            }
        };
        new GridWriter(result, outfile).writeAll();
        System.out.println("Index to output grid: ");
        for (int i = 0; i < gridname.length; ++i) {
            System.out.println(i + " " + gridname[i]);
        }
        Display d = new Display(new LazyGrid(outfile));
        d.setMode(2);
        d.setClassNames(gridname);
        density.Utils.generator = new Random(System.currentTimeMillis());
        while (this.colors.split(" ").length < gridname.length) {
            this.colors = this.colors + " " + density.Utils.generator.nextInt(256) + "|" + density.Utils.generator.nextInt(256) + "|" + density.Utils.generator.nextInt(256);
        }
        d.setColorClasses(this.colors);
        d.visible = false;
        d.makeLegend = true;
        d.makeImage();
        d.writeImage(density.Utils.pngname(outfile, true));
    }
}

