/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.tools.Node;

class NodePriorityQueue {
    Node[] heap;
    Node[] nodes;
    int numElements = 0;

    NodePriorityQueue(Node[] nds) {
        this.heap = new Node[nds.length];
        this.nodes = nds;
    }

    void initialize() {
        this.numElements = 0;
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i].heapIndex = -1;
        }
    }

    void heapSet(int i, Node nd) {
        this.heap[i] = nd;
        nd.heapIndex = i;
    }

    void reducedWeight(Node nd) {
        int i = nd.heapIndex;
        while (i > 0 && this.heap[(i - 1) / 2].qweight > nd.qweight) {
            this.heapSet(i, this.heap[(i - 1) / 2]);
            i = (i - 1) / 2;
        }
        this.heapSet(i, nd);
    }

    void insert(Node nd) {
        int i = this.numElements++;
        this.heapSet(i, nd);
        this.reducedWeight(nd);
    }

    boolean alreadyDeleted(Node nd) {
        return nd.heapIndex == 0 && this.heap[0] != nd;
    }

    boolean contains(Node nd) {
        return nd.heapIndex != -1;
    }

    boolean isEmpty() {
        return this.numElements == 0;
    }

    void dump() {
        System.out.println("Heap:");
        for (int i = 0; i < this.numElements; ++i) {
            System.out.println(i + " " + this.heap[i].r + " " + this.heap[i].c + " " + this.heap[i].qweight);
        }
    }

    Node deleteMin() {
        if (this.numElements == 0) {
            throw new RuntimeException("Cannot deleteMin from empty priority queue");
        }
        Node result = this.heap[0];
        Node target = this.heap[--this.numElements];
        int i = 0;
        while (2 * i + 2 < this.numElements) {
            Node c1 = this.heap[2 * i + 1];
            Node c2 = this.heap[2 * i + 2];
            if (c1.qweight >= target.qweight && c2.qweight >= target.qweight) break;
            if (c1.qweight < c2.qweight) {
                this.heapSet(i, c1);
                i = 2 * i + 1;
                continue;
            }
            this.heapSet(i, c2);
            i = 2 * i + 2;
        }
        if (2 * i + 2 == this.numElements && this.heap[2 * i + 1].qweight < target.qweight) {
            this.heapSet(i, this.heap[2 * i + 1]);
            i = 2 * i + 1;
        }
        this.heapSet(i, target);
        return result;
    }
}

