/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.Display;
import density.Extractor;
import density.Feature;
import density.Grid;
import density.GridIO;
import density.GridWriter;
import density.LazyGrid;
import density.tools.Utils;
import gnu.getopt.Getopt;
import java.io.IOException;
import java.util.Random;

public class Novel {
    String[] gridnames;
    float[][] minmax;
    double[][] histogram;
    double[][] centrality;
    Grid[] proj;
    int nf;
    int nbins = 100000;
    boolean makeNovelPicture = true;
    boolean whiteNonNovel = false;
    String maskfile;
    String colors = "230|159|0 86|180|233 0|158|115 240|228|66 0|114|178 213|94|0 204|121|167 240|128|128 0|0|0";
    int limitingLayer;

    public void setWhiteNonNovel() {
        this.whiteNonNovel = true;
    }

    double similarity(int r, int c) {
        double minc = 200.0;
        int mini = -1;
        for (int i = 0; i < this.nf; ++i) {
            double val = this.proj[i].eval(r, c);
            double min = this.minmax[i][0];
            double max = this.minmax[i][1];
            double cent = 0.0;
            if (val < min) {
                cent = 100.0 * (val - min) / (max - min);
            } else if (val > max) {
                cent = 100.0 * (max - val) / (max - min);
            } else {
                int bin = Grid.getbin(val, min, max, this.nbins);
                cent = this.centrality[i][bin] * 200.0;
            }
            if (!(cent < minc)) continue;
            mini = i;
            minc = cent;
        }
        this.limitingLayer = mini;
        if (minc >= 0.0 && this.whiteNonNovel) {
            this.limitingLayer = this.nf;
        }
        return minc;
    }

    public void go(String[] args) throws IOException {
        int c;
        Getopt g = new Getopt("Novel", args, "c:m:w");
        if (args.length < 3) {
            System.out.println("Usage: Novel [-m basemask] [-c colors] [-w] basedir projdir outfile");
            System.exit(0);
        }
        while ((c = g.getopt()) != -1) {
            switch (c) {
                case 99: {
                    this.colors = g.getOptarg();
                    break;
                }
                case 109: {
                    this.maskfile = g.getOptarg();
                    break;
                }
                case 119: {
                    this.whiteNonNovel = true;
                }
            }
        }
        String basedir = args[g.getOptind()];
        String projdir = args[g.getOptind() + 1];
        Object outfile = args[g.getOptind() + 2];
        Utils.checkExists(basedir);
        if (!((String)outfile).matches(".*\\....$")) {
            outfile = (String)outfile + ".asc";
        }
        String[] filenames = density.Utils.gridFileNames(basedir);
        this.makeHistograms(filenames);
        this.makeNovel(projdir, (String)outfile);
    }

    public void go(Feature[] basefeatures, String projdir, String outfile) throws IOException {
        this.makeHistograms(basefeatures);
        this.makeNovel(projdir, outfile);
    }

    void makeNovel(String projdir, String outfile) throws IOException {
        Display d;
        Utils.checkExists(projdir);
        for (int i = 0; i < this.nf; ++i) {
            this.proj[i] = new LazyGrid(Extractor.CachedGridFilename(density.Utils.getGridAbsolutePath(projdir, this.gridnames[i]), true));
        }
        if (this.whiteNonNovel) {
            this.gridnames[this.nf] = "none";
        }
        Grid result = new Grid(this.proj[0].getDimension(), "Novel"){

            @Override
            public boolean hasData(int r, int c) {
                for (int i = 0; i < Novel.this.nf; ++i) {
                    if (Novel.this.proj[i].hasData(r, c)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public float eval(int r, int c) {
                return (float)Novel.this.similarity(r, c);
            }
        };
        Grid limiting = new Grid(this.proj[0].getDimension(), "Limiting"){

            @Override
            public boolean hasData(int r, int c) {
                for (int i = 0; i < Novel.this.nf; ++i) {
                    if (Novel.this.proj[i].hasData(r, c)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public float eval(int r, int c) {
                return Novel.this.limitingLayer;
            }
        };
        int index = outfile.lastIndexOf(46);
        String limitingfile = outfile.substring(0, index) + "_limiting" + outfile.substring(index);
        GridWriter.writeGrids(new Grid[]{result, limiting}, new String[]{outfile, limitingfile}, false);
        if (this.makeNovelPicture) {
            d = new Display(new LazyGrid(outfile));
            d.visible = false;
            d.makeLegend = true;
            d.dichromatic = true;
            float[] minmax = new LazyGrid(outfile).minmax();
            d.breakpoint = 0.0;
            d.setMinval(minmax[0]);
            d.setMaxval(minmax[1]);
            d.setMode(1);
            d.makeImage();
            d.writeImage(density.Utils.pngname(outfile, true));
        }
        if (this.colors != null) {
            d = new Display(new LazyGrid(limitingfile));
            d.setMode(2);
            d.setClassNames(this.gridnames);
            density.Utils.generator = new Random(System.currentTimeMillis());
            while (this.colors.split(" ").length < this.nf) {
                this.colors = this.colors + " " + density.Utils.generator.nextInt(256) + "|" + density.Utils.generator.nextInt(256) + "|" + density.Utils.generator.nextInt(256);
            }
            if (this.whiteNonNovel) {
                this.colors = this.colors + " 255|255|255";
            }
            d.setColorClasses(this.colors);
            d.visible = false;
            d.makeLegend = true;
            d.makeImage();
            d.writeImage(density.Utils.pngname(limitingfile, true));
        }
    }

    void initializeHistograms(int num) {
        this.nf = num;
        this.minmax = new float[this.nf][];
        this.histogram = new double[this.nf][];
        this.centrality = new double[this.nf][];
        this.proj = new Grid[this.nf];
        this.gridnames = new String[this.whiteNonNovel ? this.nf + 1 : this.nf];
    }

    void makeHistograms(Feature[] features) {
        this.initializeHistograms(features.length);
        for (int i = 0; i < this.nf; ++i) {
            this.gridnames[i] = features[i].name;
            Grid g = features[i].toGrid();
            this.makeHistogram(g, i);
        }
    }

    void makeHistograms(String[] filenames) throws IOException {
        int i;
        this.initializeHistograms(filenames.length);
        for (i = 0; i < this.nf; ++i) {
            this.gridnames[i] = density.Utils.fileToLayer(filenames[i]);
        }
        for (i = 0; i < this.nf; ++i) {
            Grid mask;
            Grid grid;
            Grid gg = grid = GridIO.readGrid(filenames[i]);
            Grid grid2 = mask = this.maskfile == null ? null : GridIO.readGrid(this.maskfile);
            if (mask != null) {
                gg = new Grid(this, grid.getDimension(), "masked"){

                    @Override
                    public boolean hasData(int r, int c) {
                        return grid.hasData(r, c) && mask.hasData(r, c);
                    }

                    @Override
                    public float eval(int r, int c) {
                        return grid.eval(r, c);
                    }
                };
            }
            this.makeHistogram(gg, i);
        }
    }

    void makeHistogram(Grid g, int i) {
        int j;
        this.minmax[i] = g.minmax();
        this.histogram[i] = g.histogram(this.minmax[i][0], this.minmax[i][1], this.nbins);
        this.centrality[i] = new double[this.nbins];
        double sum = 0.0;
        for (j = 0; j < this.nbins; ++j) {
            this.centrality[i][j] = sum += this.histogram[i][j];
        }
        sum = 0.0;
        for (j = this.nbins - 1; j >= 0; --j) {
            if (!((sum += this.histogram[i][j]) < this.centrality[i][j])) continue;
            this.centrality[i][j] = sum;
        }
    }

    public static void main(String[] args) {
        try {
            new Novel().go(args);
        }
        catch (IOException e) {
            System.out.println("Error: " + e);
            System.exit(0);
        }
    }
}

