/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.Grid;
import density.GridDimension;
import density.GridIO;
import density.Utils;
import java.io.File;
import java.io.IOException;
import java.util.Random;

public class RandomSample3 {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: RandomSample3 numSamples layer1 layer2 ...");
            System.exit(1);
        }
        try {
            new RandomSample3().go(args);
        }
        catch (IOException e) {
            System.out.println("Error in RandomSample: " + e.toString());
            System.exit(1);
        }
    }

    void go(String[] args) throws IOException {
        int i;
        int ngrids = args.length - 1;
        String[] fileNames = new String[ngrids];
        int numSamples = Integer.parseInt(args[0]);
        Grid[] g = new Grid[ngrids];
        for (int i2 = 0; i2 < ngrids; ++i2) {
            fileNames[i2] = args[i2 + 1];
            g[i2] = GridIO.readGrid(fileNames[i2]);
        }
        GridDimension dim = g[0].getDimension();
        Utils.generator = new Random(0L);
        System.out.print("species,x,y");
        for (i = 0; i < ngrids; ++i) {
            System.out.print("," + new File(fileNames[i]).getName());
        }
        System.out.println();
        for (i = 0; i < numSamples; ++i) {
            int c;
            int r;
            boolean success;
            do {
                success = true;
                r = Utils.generator.nextInt(dim.getnrows());
                c = Utils.generator.nextInt(dim.getncols());
                for (int j = 0; j < ngrids; ++j) {
                    if (g[j].hasData(r, c)) continue;
                    success = false;
                }
            } while (!success);
            System.out.print("sample," + dim.toX(c) + "," + dim.toY(r));
            for (int j = 0; j < ngrids; ++j) {
                System.out.print("," + g[j].eval(r, c));
            }
            System.out.println();
        }
    }
}

