/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.Grid;
import density.GridDimension;
import density.GridIO;
import density.GridWriter;
import density.Utils;
import gnu.getopt.Getopt;
import java.io.File;
import java.io.IOException;

public class Reproject {
    public static void main(String[] args) {
        int c;
        double xll = 0.0;
        double yll = 0.0;
        double cellsize = 0.0;
        int nr = 0;
        int nc = 0;
        Getopt g = new Getopt("Show", args, "f:x:y:r:c:s:");
        String usage = "Usage: Reproject [-xyrcs] outdir infile1 infile2 ...";
        GridDimension dimension = null;
        block12: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 120: {
                    xll = Double.parseDouble(g.getOptarg());
                    continue block12;
                }
                case 121: {
                    yll = Double.parseDouble(g.getOptarg());
                    continue block12;
                }
                case 114: {
                    nr = Integer.parseInt(g.getOptarg());
                    continue block12;
                }
                case 99: {
                    nc = Integer.parseInt(g.getOptarg());
                    continue block12;
                }
                case 115: {
                    cellsize = Double.parseDouble(g.getOptarg());
                    continue block12;
                }
                case 102: {
                    try {
                        Grid grid = GridIO.readGrid(g.getOptarg());
                        dimension = grid.getDimension();
                    }
                    catch (IOException e) {
                        System.out.println(e.toString());
                        System.exit(1);
                    }
                    continue block12;
                }
            }
            System.out.println(usage);
            System.exit(0);
        }
        if ((args = Utils.getArgs(args, g.getOptind())).length < 2) {
            System.out.println(usage);
            System.exit(0);
        }
        String[] files = new String[args.length - 1];
        for (int f = 0; f < files.length; ++f) {
            files[f] = args[f + 1];
        }
        String outdir = args[0];
        for (int f = 0; f < files.length; ++f) {
            String infile = files[f];
            System.out.println(infile);
            String outfile = new File(outdir, new File(infile).getName()).getPath();
            try {
                final Grid grid = GridIO.readGrid(infile);
                GridDimension dim = grid.getDimension();
                final GridDimension dim2 = dimension == null ? new GridDimension(xll, yll, cellsize, nr, nc) : dimension;
                Grid gg = new Grid(dim2, "tmp"){

                    @Override
                    public boolean hasData(int r, int c) {
                        return grid.hasData(dim2.toXY(r, c));
                    }

                    @Override
                    public float eval(int r, int c) {
                        return grid.eval(dim2.toXY(r, c));
                    }
                };
                new GridWriter(gg, outfile).writeAll();
                continue;
            }
            catch (IOException e) {
                System.out.println("Error: " + e);
                System.exit(0);
            }
        }
    }
}

