/*
 * Decompiled with CFR 0.152.
 */
package density.tools;

import density.Convert;
import density.Grid;
import density.GridByte;
import density.GridDimension;
import density.GridDouble;
import density.GridInt;
import density.GridShort;
import density.GridUbyte;
import density.GridWriter;
import density.Utils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public class SubSample {
    public static void main(String[] args) {
        String usage = "Usage: SubSample indir outdir interval outputtype";
        if (args.length < 4) {
            System.out.println(usage);
            System.exit(0);
        }
        String indir = args[0];
        String outdir = args[1];
        String outputtype = args[3];
        int interval = Integer.parseInt(args[2]);
        try {
            new SubSample().go(indir, outdir, interval, outputtype);
        }
        catch (IOException e) {
            System.out.println(e.toString());
            System.exit(1);
        }
    }

    void go(String indir, String outdir, final int interval, String outputtype) throws IOException {
        Object[] layerFiles = new File(indir).listFiles(Utils.filenameFilter);
        Arrays.sort(layerFiles);
        for (int i = 0; i < layerFiles.length; ++i) {
            System.out.println("Processing " + (File)layerFiles[i]);
            String inFile = ((File)layerFiles[i]).getPath();
            final Grid grid = Convert.readEfficient(inFile);
            GridDimension dim = grid.getDimension();
            Grid g = null;
            int nrows = (int)Math.ceil((double)dim.getnrows() / (double)interval);
            int ncols = (int)Math.ceil((double)dim.getncols() / (double)interval);
            GridDimension dim2 = new GridDimension(dim.getxllcorner(), dim.getyllcorner(), dim.getcellsize() * (double)interval, nrows, ncols);
            g = grid instanceof GridByte ? new GridByte(this, dim2, grid.getName()){

                @Override
                public byte evalByte(int r, int c) {
                    return ((GridByte)grid).evalByte(r * interval, c * interval);
                }

                @Override
                public boolean hasData(int r, int c) {
                    return grid.hasData(r * interval, c * interval);
                }
            } : (grid instanceof GridShort ? new GridShort(this, dim2, grid.getName()){

                @Override
                public short evalShort(int r, int c) {
                    return ((GridShort)grid).evalShort(r * interval, c * interval);
                }

                @Override
                public boolean hasData(int r, int c) {
                    return grid.hasData(r * interval, c * interval);
                }
            } : (grid instanceof GridInt ? new GridInt(this, dim2, grid.getName()){

                @Override
                public int evalInt(int r, int c) {
                    return ((GridInt)grid).evalInt(r * interval, c * interval);
                }

                @Override
                public boolean hasData(int r, int c) {
                    return grid.hasData(r * interval, c * interval);
                }
            } : (grid instanceof GridDouble ? new GridDouble(this, dim2, grid.getName()){

                @Override
                public double evalDouble(int r, int c) {
                    return ((GridDouble)grid).evalDouble(r * interval, c * interval);
                }

                @Override
                public boolean hasData(int r, int c) {
                    return grid.hasData(r * interval, c * interval);
                }
            } : (grid instanceof GridUbyte ? new GridUbyte(this, dim2, grid.getName()){

                @Override
                public short evalUbyte(int r, int c) {
                    return ((GridUbyte)grid).evalUbyte(r * interval, c * interval);
                }

                @Override
                public boolean hasData(int r, int c) {
                    return grid.hasData(r * interval, c * interval);
                }
            } : new Grid(this, dim2, grid.getName()){

                @Override
                public float eval(int r, int c) {
                    return grid.eval(r * interval, c * interval);
                }

                @Override
                public boolean hasData(int r, int c) {
                    return grid.hasData(r * interval, c * interval);
                }
            }))));
            g.setNODATA_value(grid.getNODATA_value());
            File outputFile = new File(outdir, grid.getName() + "." + outputtype);
            new GridWriter(g, outputFile).writeAll();
        }
    }
}

