/*
 * Decompiled with CFR 0.152.
 */
package gui.layouts;

import gui.layouts.BoundableInterface;
import java.awt.Component;
import java.awt.Dimension;

public class AspectBoundable
implements BoundableInterface {
    @Override
    public void setBounds(Component c, int x, int y, int w, int h) {
        Dimension wantedSize = new Dimension(w, h);
        Dimension d = c.getPreferredSize();
        d = this.scale(d, wantedSize);
        c.setBounds(x, y, d.width, d.height);
    }

    public Dimension scale(Dimension imageDimension, Dimension availableSize) {
        double ar = (double)imageDimension.width / ((double)imageDimension.height * 1.0);
        double availableAr = (double)availableSize.width / ((double)availableSize.height * 1.0);
        int newHeight = (int)((double)availableSize.width / ar);
        int newWidth = (int)((double)availableSize.height * ar);
        if (availableAr < ar) {
            return new Dimension(availableSize.width, newHeight);
        }
        return new Dimension(newWidth, availableSize.height);
    }

    public Dimension scaleWidth(Dimension d1, Dimension d2) {
        double scaleFactor = (double)d2.width / ((double)d1.width * 1.0);
        return this.scale(d1, scaleFactor);
    }

    private Dimension scale(Dimension d1, double scaleFactor) {
        return new Dimension((int)((double)d1.width * scaleFactor), (int)((double)d1.height * scaleFactor));
    }

    public Dimension scaleHeight(Dimension d1, Dimension d2) {
        double scaleFactor = (double)d2.height / ((double)d1.height * 1.0);
        return this.scale(d1, scaleFactor);
    }
}

