/*
 * Decompiled with CFR 0.152.
 */
package gui.layouts;

import gui.layouts.BoundableInterface;
import gui.layouts.PreferredBoundable;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Insets;

public class PreferredSizeGridLayout
extends GridLayout {
    private BoundableInterface boundableInterface = new PreferredBoundable();

    public PreferredSizeGridLayout() {
        this(1, 0, 0, 0);
    }

    public PreferredSizeGridLayout(int rows, int cols) {
        this(rows, cols, 0, 0);
    }

    public PreferredSizeGridLayout(int rows, int cols, int hgap, int vgap) {
        super(rows, cols, hgap, vgap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = this.getRows();
            int ncols = this.getColumns();
            if (ncomponents == 0) {
                return;
            }
            if (nrows > 0) {
                ncols = (ncomponents + nrows - 1) / nrows;
            } else {
                nrows = (ncomponents + ncols - 1) / ncols;
            }
            int w = parent.getWidth() - (insets.left + insets.right);
            int h = parent.getHeight() - (insets.top + insets.bottom);
            w = (w - (ncols - 1) * this.getHgap()) / ncols;
            h = (h - (nrows - 1) * this.getVgap()) / nrows;
            int c = 0;
            int x = insets.left;
            while (c < ncols) {
                int r = 0;
                int y = insets.top;
                while (r < nrows) {
                    int i = r * ncols + c;
                    if (i < ncomponents) {
                        this.boundableInterface.setBounds(parent.getComponent(i), x, y, w, h);
                    }
                    ++r;
                    y += h + this.getVgap();
                }
                ++c;
                x += w + this.getHgap();
            }
        }
    }

    public BoundableInterface getBoundableInterface() {
        return this.boundableInterface;
    }

    public void setBoundableInterface(BoundableInterface boundableInterface) {
        this.boundableInterface = boundableInterface;
    }
}

