/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.Graphics;
import ptolemy.plot.Plot;

public class MyPlot
extends Plot {
    private double barWidth = 0.5;
    private double _barOffset = 0.05;
    public boolean horizontal = false;

    public double plotXtoX(int plotX) {
        return this._xMin + (double)(plotX - this._ulx) / this._xscale;
    }

    @Override
    public synchronized void setBars(double width, double offset) {
        super.setBars(width, offset);
        this.barWidth = width;
        this._barOffset = offset;
    }

    @Override
    protected void _drawBar(Graphics graphics, int dataset, long xpos, long ypos, boolean clip) {
        if (this.horizontal) {
            this._drawBarHorizontal(graphics, dataset, xpos, ypos, clip);
        } else {
            super._drawBar(graphics, dataset, xpos, ypos, clip);
        }
    }

    protected void _drawBarHorizontal(Graphics graphics, int dataset, long xpos, long ypos, boolean clip) {
        if (clip) {
            if (xpos < (long)this._ulx) {
                xpos = this._ulx;
            }
            if (xpos > (long)this._lrx) {
                xpos = this._lrx;
            }
        }
        if (xpos <= (long)this._lrx && ypos <= (long)this._lry && ypos >= (long)this._uly) {
            long zeroxpos;
            int barly = (int)((double)ypos - this.barWidth * this._yscale / 2.0 + (double)dataset * this._barOffset * this._yscale);
            int barry = (int)((double)barly + this.barWidth * this._yscale);
            if (barly < this._uly) {
                barly = this._uly;
            }
            if (barry > this._lry) {
                barry = this._lry;
            }
            if (barly >= barry) {
                barry = barly + 1;
            }
            if ((long)this._lrx < (zeroxpos = (long)this._ulx + (long)((0.0 - this._xMin) * this._xscale))) {
                zeroxpos = this._lrx;
            }
            if ((long)this._ulx > zeroxpos) {
                zeroxpos = this._ulx;
            }
            if (xpos <= zeroxpos) {
                graphics.fillRect((int)xpos, barly, (int)(zeroxpos - xpos), barry - barly);
            } else {
                graphics.fillRect((int)zeroxpos, barly, (int)(xpos - zeroxpos), barry - barly);
            }
        }
    }

    @Override
    public synchronized void addPoint(int dataset, double x, double y, boolean connected) {
        this._addPoint(dataset, x, y, 0.0, 0.0, connected, false);
    }
}

