/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Feature;
import density.Sample;

public class BinaryFeature
extends Feature {
    Feature f;
    float target;
    boolean isFirstCategory = false;

    public BinaryFeature(Feature f, float target, String s) {
        super(f.n, "(" + s + "=" + target + ")");
        this.f = f;
        this.target = target;
    }

    @Override
    public double eval(int i) {
        if (this.f.eval(i) == (double)this.target) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public double eval(Sample s) {
        return this.f.eval(s, this.target);
    }

    @Override
    public boolean hasData(Sample s) {
        return this.f.hasData(s);
    }

    @Override
    boolean isBinary() {
        return true;
    }

    public static BinaryFeature[] makeAll(Feature f, String s) {
        double[] allvals = f.distinctVals();
        BinaryFeature[] result = new BinaryFeature[allvals.length];
        for (int i = 0; i < allvals.length; ++i) {
            result[i] = new BinaryFeature(f, (float)allvals[i], s);
        }
        if (allvals.length > 0) {
            result[0].isFirstCategory = true;
        }
        return result;
    }
}

